// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: server/diagnosticspb/diagnostics.proto

package diagnosticspb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import build "github.com/cockroachdb/cockroach/pkg/build"
import config "github.com/cockroachdb/cockroach/pkg/config"
import roachpb "github.com/cockroachdb/cockroach/pkg/roachpb"
import sqlbase "github.com/cockroachdb/cockroach/pkg/sql/sqlbase"

import github_com_cockroachdb_cockroach_pkg_roachpb "github.com/cockroachdb/cockroach/pkg/roachpb"

import github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
import encoding_binary "encoding/binary"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type DiagnosticReport struct {
	Node                      NodeInfo                               `protobuf:"bytes,1,opt,name=node,proto3" json:"node"`
	Stores                    []StoreInfo                            `protobuf:"bytes,2,rep,name=stores,proto3" json:"stores"`
	Schema                    []sqlbase.TableDescriptor              `protobuf:"bytes,3,rep,name=schema,proto3" json:"schema"`
	SqlStats                  []roachpb.CollectedStatementStatistics `protobuf:"bytes,4,rep,name=sql_stats,json=sqlStats,proto3" json:"sql_stats"`
	AlteredSettings           map[string]string                      `protobuf:"bytes,6,rep,name=altered_settings,json=alteredSettings,proto3" json:"altered_settings,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	ZoneConfigs               map[int64]config.ZoneConfig            `protobuf:"bytes,8,rep,name=zone_configs,json=zoneConfigs,proto3" json:"zone_configs" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	FeatureUsage              map[string]int32                       `protobuf:"bytes,9,rep,name=feature_usage,json=featureUsage,proto3" json:"feature_usage" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	LegacyUnimplementedErrors map[string]int64                       `protobuf:"bytes,5,rep,name=legacy_unimplemented_errors,json=legacyUnimplementedErrors,proto3" json:"legacy_unimplemented_errors,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	LegacyErrorCounts         map[string]int64                       `protobuf:"bytes,7,rep,name=legacy_error_counts,json=legacyErrorCounts,proto3" json:"legacy_error_counts,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral      struct{}                               `json:"-"`
	XXX_sizecache             int32                                  `json:"-"`
}

func (m *DiagnosticReport) Reset()         { *m = DiagnosticReport{} }
func (m *DiagnosticReport) String() string { return proto.CompactTextString(m) }
func (*DiagnosticReport) ProtoMessage()    {}
func (*DiagnosticReport) Descriptor() ([]byte, []int) {
	return fileDescriptor_diagnostics_7c4e4cf4277b337a, []int{0}
}
func (m *DiagnosticReport) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DiagnosticReport) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *DiagnosticReport) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DiagnosticReport.Merge(dst, src)
}
func (m *DiagnosticReport) XXX_Size() int {
	return m.Size()
}
func (m *DiagnosticReport) XXX_DiscardUnknown() {
	xxx_messageInfo_DiagnosticReport.DiscardUnknown(m)
}

var xxx_messageInfo_DiagnosticReport proto.InternalMessageInfo

type NodeInfo struct {
	NodeID               github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,1,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
	Bytes                int64                                               `protobuf:"varint,2,opt,name=bytes,proto3" json:"bytes,omitempty"`
	KeyCount             int64                                               `protobuf:"varint,3,opt,name=key_count,json=keyCount,proto3" json:"key_count,omitempty"`
	RangeCount           int64                                               `protobuf:"varint,4,opt,name=range_count,json=rangeCount,proto3" json:"range_count,omitempty"`
	Locality             roachpb.Locality                                    `protobuf:"bytes,5,opt,name=locality,proto3" json:"locality"`
	Hardware             HardwareInfo                                        `protobuf:"bytes,6,opt,name=hardware,proto3" json:"hardware"`
	Os                   OSInfo                                              `protobuf:"bytes,7,opt,name=os,proto3" json:"os"`
	Build                build.Info                                          `protobuf:"bytes,8,opt,name=build,proto3" json:"build"`
	Uptime               int64                                               `protobuf:"varint,9,opt,name=uptime,proto3" json:"uptime,omitempty"`
	LicenseType          string                                              `protobuf:"bytes,10,opt,name=license_type,json=licenseType,proto3" json:"license_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                            `json:"-"`
	XXX_sizecache        int32                                               `json:"-"`
}

func (m *NodeInfo) Reset()         { *m = NodeInfo{} }
func (m *NodeInfo) String() string { return proto.CompactTextString(m) }
func (*NodeInfo) ProtoMessage()    {}
func (*NodeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_diagnostics_7c4e4cf4277b337a, []int{1}
}
func (m *NodeInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NodeInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *NodeInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeInfo.Merge(dst, src)
}
func (m *NodeInfo) XXX_Size() int {
	return m.Size()
}
func (m *NodeInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeInfo.DiscardUnknown(m)
}

var xxx_messageInfo_NodeInfo proto.InternalMessageInfo

type StoreInfo struct {
	NodeID               github_com_cockroachdb_cockroach_pkg_roachpb.NodeID  `protobuf:"varint,1,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
	StoreID              github_com_cockroachdb_cockroach_pkg_roachpb.StoreID `protobuf:"varint,2,opt,name=store_id,json=storeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.StoreID" json:"store_id,omitempty"`
	Bytes                int64                                                `protobuf:"varint,3,opt,name=bytes,proto3" json:"bytes,omitempty"`
	KeyCount             int64                                                `protobuf:"varint,4,opt,name=key_count,json=keyCount,proto3" json:"key_count,omitempty"`
	RangeCount           int64                                                `protobuf:"varint,5,opt,name=range_count,json=rangeCount,proto3" json:"range_count,omitempty"`
	Capacity             int64                                                `protobuf:"varint,6,opt,name=capacity,proto3" json:"capacity,omitempty"`
	Available            int64                                                `protobuf:"varint,7,opt,name=available,proto3" json:"available,omitempty"`
	Used                 int64                                                `protobuf:"varint,8,opt,name=used,proto3" json:"used,omitempty"`
	EncryptionAlgorithm  int64                                                `protobuf:"varint,9,opt,name=encryption_algorithm,json=encryptionAlgorithm,proto3" json:"encryption_algorithm,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                             `json:"-"`
	XXX_sizecache        int32                                                `json:"-"`
}

func (m *StoreInfo) Reset()         { *m = StoreInfo{} }
func (m *StoreInfo) String() string { return proto.CompactTextString(m) }
func (*StoreInfo) ProtoMessage()    {}
func (*StoreInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_diagnostics_7c4e4cf4277b337a, []int{2}
}
func (m *StoreInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StoreInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *StoreInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StoreInfo.Merge(dst, src)
}
func (m *StoreInfo) XXX_Size() int {
	return m.Size()
}
func (m *StoreInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_StoreInfo.DiscardUnknown(m)
}

var xxx_messageInfo_StoreInfo proto.InternalMessageInfo

type CPUInfo struct {
	Numcpu               int32    `protobuf:"varint,1,opt,name=numcpu,proto3" json:"numcpu,omitempty"`
	Sockets              int32    `protobuf:"varint,2,opt,name=sockets,proto3" json:"sockets,omitempty"`
	Cores                int32    `protobuf:"varint,3,opt,name=cores,proto3" json:"cores,omitempty"`
	Model                string   `protobuf:"bytes,4,opt,name=model,proto3" json:"model,omitempty"`
	Mhz                  float32  `protobuf:"fixed32,5,opt,name=mhz,proto3" json:"mhz,omitempty"`
	Features             []string `protobuf:"bytes,6,rep,name=features,proto3" json:"features,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CPUInfo) Reset()         { *m = CPUInfo{} }
func (m *CPUInfo) String() string { return proto.CompactTextString(m) }
func (*CPUInfo) ProtoMessage()    {}
func (*CPUInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_diagnostics_7c4e4cf4277b337a, []int{3}
}
func (m *CPUInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CPUInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *CPUInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CPUInfo.Merge(dst, src)
}
func (m *CPUInfo) XXX_Size() int {
	return m.Size()
}
func (m *CPUInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_CPUInfo.DiscardUnknown(m)
}

var xxx_messageInfo_CPUInfo proto.InternalMessageInfo

type HardwareInfo struct {
	Virtualization       string   `protobuf:"bytes,1,opt,name=virtualization,proto3" json:"virtualization,omitempty"`
	Cpu                  CPUInfo  `protobuf:"bytes,2,opt,name=cpu,proto3" json:"cpu"`
	Mem                  MemInfo  `protobuf:"bytes,3,opt,name=mem,proto3" json:"mem"`
	Loadavg15            float32  `protobuf:"fixed32,4,opt,name=loadavg15,proto3" json:"loadavg15,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HardwareInfo) Reset()         { *m = HardwareInfo{} }
func (m *HardwareInfo) String() string { return proto.CompactTextString(m) }
func (*HardwareInfo) ProtoMessage()    {}
func (*HardwareInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_diagnostics_7c4e4cf4277b337a, []int{4}
}
func (m *HardwareInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HardwareInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *HardwareInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HardwareInfo.Merge(dst, src)
}
func (m *HardwareInfo) XXX_Size() int {
	return m.Size()
}
func (m *HardwareInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_HardwareInfo.DiscardUnknown(m)
}

var xxx_messageInfo_HardwareInfo proto.InternalMessageInfo

type OSInfo struct {
	Family               string   `protobuf:"bytes,1,opt,name=family,proto3" json:"family,omitempty"`
	Platform             string   `protobuf:"bytes,2,opt,name=platform,proto3" json:"platform,omitempty"`
	Version              string   `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OSInfo) Reset()         { *m = OSInfo{} }
func (m *OSInfo) String() string { return proto.CompactTextString(m) }
func (*OSInfo) ProtoMessage()    {}
func (*OSInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_diagnostics_7c4e4cf4277b337a, []int{5}
}
func (m *OSInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OSInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *OSInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OSInfo.Merge(dst, src)
}
func (m *OSInfo) XXX_Size() int {
	return m.Size()
}
func (m *OSInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_OSInfo.DiscardUnknown(m)
}

var xxx_messageInfo_OSInfo proto.InternalMessageInfo

type MemInfo struct {
	Total                uint64   `protobuf:"varint,1,opt,name=total,proto3" json:"total,omitempty"`
	Available            uint64   `protobuf:"varint,2,opt,name=available,proto3" json:"available,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MemInfo) Reset()         { *m = MemInfo{} }
func (m *MemInfo) String() string { return proto.CompactTextString(m) }
func (*MemInfo) ProtoMessage()    {}
func (*MemInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_diagnostics_7c4e4cf4277b337a, []int{6}
}
func (m *MemInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MemInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *MemInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MemInfo.Merge(dst, src)
}
func (m *MemInfo) XXX_Size() int {
	return m.Size()
}
func (m *MemInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_MemInfo.DiscardUnknown(m)
}

var xxx_messageInfo_MemInfo proto.InternalMessageInfo

func init() {
	proto.RegisterType((*DiagnosticReport)(nil), "cockroach.server.diagnosticspb.DiagnosticReport")
	proto.RegisterMapType((map[string]string)(nil), "cockroach.server.diagnosticspb.DiagnosticReport.AlteredSettingsEntry")
	proto.RegisterMapType((map[string]int32)(nil), "cockroach.server.diagnosticspb.DiagnosticReport.FeatureUsageEntry")
	proto.RegisterMapType((map[string]int64)(nil), "cockroach.server.diagnosticspb.DiagnosticReport.LegacyErrorCountsEntry")
	proto.RegisterMapType((map[string]int64)(nil), "cockroach.server.diagnosticspb.DiagnosticReport.LegacyUnimplementedErrorsEntry")
	proto.RegisterMapType((map[int64]config.ZoneConfig)(nil), "cockroach.server.diagnosticspb.DiagnosticReport.ZoneConfigsEntry")
	proto.RegisterType((*NodeInfo)(nil), "cockroach.server.diagnosticspb.NodeInfo")
	proto.RegisterType((*StoreInfo)(nil), "cockroach.server.diagnosticspb.StoreInfo")
	proto.RegisterType((*CPUInfo)(nil), "cockroach.server.diagnosticspb.CPUInfo")
	proto.RegisterType((*HardwareInfo)(nil), "cockroach.server.diagnosticspb.HardwareInfo")
	proto.RegisterType((*OSInfo)(nil), "cockroach.server.diagnosticspb.OSInfo")
	proto.RegisterType((*MemInfo)(nil), "cockroach.server.diagnosticspb.MemInfo")
}
func (m *DiagnosticReport) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DiagnosticReport) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintDiagnostics(dAtA, i, uint64(m.Node.Size()))
	n1, err := m.Node.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	if len(m.Stores) > 0 {
		for _, msg := range m.Stores {
			dAtA[i] = 0x12
			i++
			i = encodeVarintDiagnostics(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Schema) > 0 {
		for _, msg := range m.Schema {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintDiagnostics(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.SqlStats) > 0 {
		for _, msg := range m.SqlStats {
			dAtA[i] = 0x22
			i++
			i = encodeVarintDiagnostics(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.LegacyUnimplementedErrors) > 0 {
		keysForLegacyUnimplementedErrors := make([]string, 0, len(m.LegacyUnimplementedErrors))
		for k := range m.LegacyUnimplementedErrors {
			keysForLegacyUnimplementedErrors = append(keysForLegacyUnimplementedErrors, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForLegacyUnimplementedErrors)
		for _, k := range keysForLegacyUnimplementedErrors {
			dAtA[i] = 0x2a
			i++
			v := m.LegacyUnimplementedErrors[string(k)]
			mapSize := 1 + len(k) + sovDiagnostics(uint64(len(k))) + 1 + sovDiagnostics(uint64(v))
			i = encodeVarintDiagnostics(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintDiagnostics(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x10
			i++
			i = encodeVarintDiagnostics(dAtA, i, uint64(v))
		}
	}
	if len(m.AlteredSettings) > 0 {
		keysForAlteredSettings := make([]string, 0, len(m.AlteredSettings))
		for k := range m.AlteredSettings {
			keysForAlteredSettings = append(keysForAlteredSettings, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForAlteredSettings)
		for _, k := range keysForAlteredSettings {
			dAtA[i] = 0x32
			i++
			v := m.AlteredSettings[string(k)]
			mapSize := 1 + len(k) + sovDiagnostics(uint64(len(k))) + 1 + len(v) + sovDiagnostics(uint64(len(v)))
			i = encodeVarintDiagnostics(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintDiagnostics(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintDiagnostics(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if len(m.LegacyErrorCounts) > 0 {
		keysForLegacyErrorCounts := make([]string, 0, len(m.LegacyErrorCounts))
		for k := range m.LegacyErrorCounts {
			keysForLegacyErrorCounts = append(keysForLegacyErrorCounts, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForLegacyErrorCounts)
		for _, k := range keysForLegacyErrorCounts {
			dAtA[i] = 0x3a
			i++
			v := m.LegacyErrorCounts[string(k)]
			mapSize := 1 + len(k) + sovDiagnostics(uint64(len(k))) + 1 + sovDiagnostics(uint64(v))
			i = encodeVarintDiagnostics(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintDiagnostics(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x10
			i++
			i = encodeVarintDiagnostics(dAtA, i, uint64(v))
		}
	}
	if len(m.ZoneConfigs) > 0 {
		keysForZoneConfigs := make([]int64, 0, len(m.ZoneConfigs))
		for k := range m.ZoneConfigs {
			keysForZoneConfigs = append(keysForZoneConfigs, int64(k))
		}
		github_com_gogo_protobuf_sortkeys.Int64s(keysForZoneConfigs)
		for _, k := range keysForZoneConfigs {
			dAtA[i] = 0x42
			i++
			v := m.ZoneConfigs[int64(k)]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovDiagnostics(uint64(msgSize))
			}
			mapSize := 1 + sovDiagnostics(uint64(k)) + msgSize
			i = encodeVarintDiagnostics(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintDiagnostics(dAtA, i, uint64(k))
			dAtA[i] = 0x12
			i++
			i = encodeVarintDiagnostics(dAtA, i, uint64((&v).Size()))
			n2, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n2
		}
	}
	if len(m.FeatureUsage) > 0 {
		keysForFeatureUsage := make([]string, 0, len(m.FeatureUsage))
		for k := range m.FeatureUsage {
			keysForFeatureUsage = append(keysForFeatureUsage, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForFeatureUsage)
		for _, k := range keysForFeatureUsage {
			dAtA[i] = 0x4a
			i++
			v := m.FeatureUsage[string(k)]
			mapSize := 1 + len(k) + sovDiagnostics(uint64(len(k))) + 1 + sovDiagnostics(uint64(v))
			i = encodeVarintDiagnostics(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintDiagnostics(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x10
			i++
			i = encodeVarintDiagnostics(dAtA, i, uint64(v))
		}
	}
	return i, nil
}

func (m *NodeInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintDiagnostics(dAtA, i, uint64(m.NodeID))
	}
	if m.Bytes != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintDiagnostics(dAtA, i, uint64(m.Bytes))
	}
	if m.KeyCount != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintDiagnostics(dAtA, i, uint64(m.KeyCount))
	}
	if m.RangeCount != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintDiagnostics(dAtA, i, uint64(m.RangeCount))
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintDiagnostics(dAtA, i, uint64(m.Locality.Size()))
	n3, err := m.Locality.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	dAtA[i] = 0x32
	i++
	i = encodeVarintDiagnostics(dAtA, i, uint64(m.Hardware.Size()))
	n4, err := m.Hardware.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n4
	dAtA[i] = 0x3a
	i++
	i = encodeVarintDiagnostics(dAtA, i, uint64(m.Os.Size()))
	n5, err := m.Os.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	dAtA[i] = 0x42
	i++
	i = encodeVarintDiagnostics(dAtA, i, uint64(m.Build.Size()))
	n6, err := m.Build.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	if m.Uptime != 0 {
		dAtA[i] = 0x48
		i++
		i = encodeVarintDiagnostics(dAtA, i, uint64(m.Uptime))
	}
	if len(m.LicenseType) > 0 {
		dAtA[i] = 0x52
		i++
		i = encodeVarintDiagnostics(dAtA, i, uint64(len(m.LicenseType)))
		i += copy(dAtA[i:], m.LicenseType)
	}
	return i, nil
}

func (m *StoreInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StoreInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintDiagnostics(dAtA, i, uint64(m.NodeID))
	}
	if m.StoreID != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintDiagnostics(dAtA, i, uint64(m.StoreID))
	}
	if m.Bytes != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintDiagnostics(dAtA, i, uint64(m.Bytes))
	}
	if m.KeyCount != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintDiagnostics(dAtA, i, uint64(m.KeyCount))
	}
	if m.RangeCount != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintDiagnostics(dAtA, i, uint64(m.RangeCount))
	}
	if m.Capacity != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintDiagnostics(dAtA, i, uint64(m.Capacity))
	}
	if m.Available != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintDiagnostics(dAtA, i, uint64(m.Available))
	}
	if m.Used != 0 {
		dAtA[i] = 0x40
		i++
		i = encodeVarintDiagnostics(dAtA, i, uint64(m.Used))
	}
	if m.EncryptionAlgorithm != 0 {
		dAtA[i] = 0x48
		i++
		i = encodeVarintDiagnostics(dAtA, i, uint64(m.EncryptionAlgorithm))
	}
	return i, nil
}

func (m *CPUInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CPUInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Numcpu != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintDiagnostics(dAtA, i, uint64(m.Numcpu))
	}
	if m.Sockets != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintDiagnostics(dAtA, i, uint64(m.Sockets))
	}
	if m.Cores != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintDiagnostics(dAtA, i, uint64(m.Cores))
	}
	if len(m.Model) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintDiagnostics(dAtA, i, uint64(len(m.Model)))
		i += copy(dAtA[i:], m.Model)
	}
	if m.Mhz != 0 {
		dAtA[i] = 0x2d
		i++
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.Mhz))))
		i += 4
	}
	if len(m.Features) > 0 {
		for _, s := range m.Features {
			dAtA[i] = 0x32
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *HardwareInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HardwareInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Virtualization) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintDiagnostics(dAtA, i, uint64(len(m.Virtualization)))
		i += copy(dAtA[i:], m.Virtualization)
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintDiagnostics(dAtA, i, uint64(m.Cpu.Size()))
	n7, err := m.Cpu.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n7
	dAtA[i] = 0x1a
	i++
	i = encodeVarintDiagnostics(dAtA, i, uint64(m.Mem.Size()))
	n8, err := m.Mem.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n8
	if m.Loadavg15 != 0 {
		dAtA[i] = 0x25
		i++
		encoding_binary.LittleEndian.PutUint32(dAtA[i:], uint32(math.Float32bits(float32(m.Loadavg15))))
		i += 4
	}
	return i, nil
}

func (m *OSInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OSInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Family) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintDiagnostics(dAtA, i, uint64(len(m.Family)))
		i += copy(dAtA[i:], m.Family)
	}
	if len(m.Platform) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintDiagnostics(dAtA, i, uint64(len(m.Platform)))
		i += copy(dAtA[i:], m.Platform)
	}
	if len(m.Version) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintDiagnostics(dAtA, i, uint64(len(m.Version)))
		i += copy(dAtA[i:], m.Version)
	}
	return i, nil
}

func (m *MemInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MemInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Total != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintDiagnostics(dAtA, i, uint64(m.Total))
	}
	if m.Available != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintDiagnostics(dAtA, i, uint64(m.Available))
	}
	return i, nil
}

func encodeVarintDiagnostics(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *DiagnosticReport) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Node.Size()
	n += 1 + l + sovDiagnostics(uint64(l))
	if len(m.Stores) > 0 {
		for _, e := range m.Stores {
			l = e.Size()
			n += 1 + l + sovDiagnostics(uint64(l))
		}
	}
	if len(m.Schema) > 0 {
		for _, e := range m.Schema {
			l = e.Size()
			n += 1 + l + sovDiagnostics(uint64(l))
		}
	}
	if len(m.SqlStats) > 0 {
		for _, e := range m.SqlStats {
			l = e.Size()
			n += 1 + l + sovDiagnostics(uint64(l))
		}
	}
	if len(m.LegacyUnimplementedErrors) > 0 {
		for k, v := range m.LegacyUnimplementedErrors {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovDiagnostics(uint64(len(k))) + 1 + sovDiagnostics(uint64(v))
			n += mapEntrySize + 1 + sovDiagnostics(uint64(mapEntrySize))
		}
	}
	if len(m.AlteredSettings) > 0 {
		for k, v := range m.AlteredSettings {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovDiagnostics(uint64(len(k))) + 1 + len(v) + sovDiagnostics(uint64(len(v)))
			n += mapEntrySize + 1 + sovDiagnostics(uint64(mapEntrySize))
		}
	}
	if len(m.LegacyErrorCounts) > 0 {
		for k, v := range m.LegacyErrorCounts {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovDiagnostics(uint64(len(k))) + 1 + sovDiagnostics(uint64(v))
			n += mapEntrySize + 1 + sovDiagnostics(uint64(mapEntrySize))
		}
	}
	if len(m.ZoneConfigs) > 0 {
		for k, v := range m.ZoneConfigs {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + sovDiagnostics(uint64(k)) + 1 + l + sovDiagnostics(uint64(l))
			n += mapEntrySize + 1 + sovDiagnostics(uint64(mapEntrySize))
		}
	}
	if len(m.FeatureUsage) > 0 {
		for k, v := range m.FeatureUsage {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovDiagnostics(uint64(len(k))) + 1 + sovDiagnostics(uint64(v))
			n += mapEntrySize + 1 + sovDiagnostics(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *NodeInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NodeID != 0 {
		n += 1 + sovDiagnostics(uint64(m.NodeID))
	}
	if m.Bytes != 0 {
		n += 1 + sovDiagnostics(uint64(m.Bytes))
	}
	if m.KeyCount != 0 {
		n += 1 + sovDiagnostics(uint64(m.KeyCount))
	}
	if m.RangeCount != 0 {
		n += 1 + sovDiagnostics(uint64(m.RangeCount))
	}
	l = m.Locality.Size()
	n += 1 + l + sovDiagnostics(uint64(l))
	l = m.Hardware.Size()
	n += 1 + l + sovDiagnostics(uint64(l))
	l = m.Os.Size()
	n += 1 + l + sovDiagnostics(uint64(l))
	l = m.Build.Size()
	n += 1 + l + sovDiagnostics(uint64(l))
	if m.Uptime != 0 {
		n += 1 + sovDiagnostics(uint64(m.Uptime))
	}
	l = len(m.LicenseType)
	if l > 0 {
		n += 1 + l + sovDiagnostics(uint64(l))
	}
	return n
}

func (m *StoreInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NodeID != 0 {
		n += 1 + sovDiagnostics(uint64(m.NodeID))
	}
	if m.StoreID != 0 {
		n += 1 + sovDiagnostics(uint64(m.StoreID))
	}
	if m.Bytes != 0 {
		n += 1 + sovDiagnostics(uint64(m.Bytes))
	}
	if m.KeyCount != 0 {
		n += 1 + sovDiagnostics(uint64(m.KeyCount))
	}
	if m.RangeCount != 0 {
		n += 1 + sovDiagnostics(uint64(m.RangeCount))
	}
	if m.Capacity != 0 {
		n += 1 + sovDiagnostics(uint64(m.Capacity))
	}
	if m.Available != 0 {
		n += 1 + sovDiagnostics(uint64(m.Available))
	}
	if m.Used != 0 {
		n += 1 + sovDiagnostics(uint64(m.Used))
	}
	if m.EncryptionAlgorithm != 0 {
		n += 1 + sovDiagnostics(uint64(m.EncryptionAlgorithm))
	}
	return n
}

func (m *CPUInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Numcpu != 0 {
		n += 1 + sovDiagnostics(uint64(m.Numcpu))
	}
	if m.Sockets != 0 {
		n += 1 + sovDiagnostics(uint64(m.Sockets))
	}
	if m.Cores != 0 {
		n += 1 + sovDiagnostics(uint64(m.Cores))
	}
	l = len(m.Model)
	if l > 0 {
		n += 1 + l + sovDiagnostics(uint64(l))
	}
	if m.Mhz != 0 {
		n += 5
	}
	if len(m.Features) > 0 {
		for _, s := range m.Features {
			l = len(s)
			n += 1 + l + sovDiagnostics(uint64(l))
		}
	}
	return n
}

func (m *HardwareInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Virtualization)
	if l > 0 {
		n += 1 + l + sovDiagnostics(uint64(l))
	}
	l = m.Cpu.Size()
	n += 1 + l + sovDiagnostics(uint64(l))
	l = m.Mem.Size()
	n += 1 + l + sovDiagnostics(uint64(l))
	if m.Loadavg15 != 0 {
		n += 5
	}
	return n
}

func (m *OSInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Family)
	if l > 0 {
		n += 1 + l + sovDiagnostics(uint64(l))
	}
	l = len(m.Platform)
	if l > 0 {
		n += 1 + l + sovDiagnostics(uint64(l))
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovDiagnostics(uint64(l))
	}
	return n
}

func (m *MemInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Total != 0 {
		n += 1 + sovDiagnostics(uint64(m.Total))
	}
	if m.Available != 0 {
		n += 1 + sovDiagnostics(uint64(m.Available))
	}
	return n
}

func sovDiagnostics(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozDiagnostics(x uint64) (n int) {
	return sovDiagnostics(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *DiagnosticReport) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDiagnostics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DiagnosticReport: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DiagnosticReport: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Node", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDiagnostics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Node.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stores", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDiagnostics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Stores = append(m.Stores, StoreInfo{})
			if err := m.Stores[len(m.Stores)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Schema", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDiagnostics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Schema = append(m.Schema, sqlbase.TableDescriptor{})
			if err := m.Schema[len(m.Schema)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SqlStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDiagnostics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SqlStats = append(m.SqlStats, roachpb.CollectedStatementStatistics{})
			if err := m.SqlStats[len(m.SqlStats)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LegacyUnimplementedErrors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDiagnostics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LegacyUnimplementedErrors == nil {
				m.LegacyUnimplementedErrors = make(map[string]int64)
			}
			var mapkey string
			var mapvalue int64
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowDiagnostics
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowDiagnostics
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthDiagnostics
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowDiagnostics
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= (int64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipDiagnostics(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthDiagnostics
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.LegacyUnimplementedErrors[mapkey] = mapvalue
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AlteredSettings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDiagnostics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AlteredSettings == nil {
				m.AlteredSettings = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowDiagnostics
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowDiagnostics
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthDiagnostics
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowDiagnostics
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthDiagnostics
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipDiagnostics(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthDiagnostics
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.AlteredSettings[mapkey] = mapvalue
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LegacyErrorCounts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDiagnostics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LegacyErrorCounts == nil {
				m.LegacyErrorCounts = make(map[string]int64)
			}
			var mapkey string
			var mapvalue int64
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowDiagnostics
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowDiagnostics
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthDiagnostics
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowDiagnostics
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= (int64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipDiagnostics(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthDiagnostics
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.LegacyErrorCounts[mapkey] = mapvalue
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ZoneConfigs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDiagnostics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ZoneConfigs == nil {
				m.ZoneConfigs = make(map[int64]config.ZoneConfig)
			}
			var mapkey int64
			mapvalue := &config.ZoneConfig{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowDiagnostics
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowDiagnostics
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= (int64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowDiagnostics
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthDiagnostics
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthDiagnostics
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &config.ZoneConfig{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipDiagnostics(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthDiagnostics
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.ZoneConfigs[mapkey] = *mapvalue
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FeatureUsage", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDiagnostics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FeatureUsage == nil {
				m.FeatureUsage = make(map[string]int32)
			}
			var mapkey string
			var mapvalue int32
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowDiagnostics
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowDiagnostics
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthDiagnostics
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowDiagnostics
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipDiagnostics(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthDiagnostics
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.FeatureUsage[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDiagnostics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDiagnostics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodeInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDiagnostics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bytes", wireType)
			}
			m.Bytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Bytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyCount", wireType)
			}
			m.KeyCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KeyCount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeCount", wireType)
			}
			m.RangeCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeCount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Locality", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDiagnostics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Locality.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hardware", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDiagnostics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Hardware.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Os", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDiagnostics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Os.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Build", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDiagnostics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Build.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uptime", wireType)
			}
			m.Uptime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Uptime |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LicenseType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDiagnostics
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LicenseType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDiagnostics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDiagnostics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StoreInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDiagnostics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StoreInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StoreInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreID", wireType)
			}
			m.StoreID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StoreID |= (github_com_cockroachdb_cockroach_pkg_roachpb.StoreID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bytes", wireType)
			}
			m.Bytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Bytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyCount", wireType)
			}
			m.KeyCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KeyCount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeCount", wireType)
			}
			m.RangeCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeCount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Capacity", wireType)
			}
			m.Capacity = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Capacity |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Available", wireType)
			}
			m.Available = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Available |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Used", wireType)
			}
			m.Used = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Used |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EncryptionAlgorithm", wireType)
			}
			m.EncryptionAlgorithm = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EncryptionAlgorithm |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipDiagnostics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDiagnostics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CPUInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDiagnostics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CPUInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CPUInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Numcpu", wireType)
			}
			m.Numcpu = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Numcpu |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sockets", wireType)
			}
			m.Sockets = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Sockets |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cores", wireType)
			}
			m.Cores = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Cores |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Model", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDiagnostics
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Model = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mhz", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.Mhz = float32(math.Float32frombits(v))
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Features", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDiagnostics
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Features = append(m.Features, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDiagnostics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDiagnostics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HardwareInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDiagnostics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HardwareInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HardwareInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Virtualization", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDiagnostics
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Virtualization = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cpu", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDiagnostics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Cpu.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mem", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDiagnostics
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Mem.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 5 {
				return fmt.Errorf("proto: wrong wireType = %d for field Loadavg15", wireType)
			}
			var v uint32
			if (iNdEx + 4) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint32(encoding_binary.LittleEndian.Uint32(dAtA[iNdEx:]))
			iNdEx += 4
			m.Loadavg15 = float32(math.Float32frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipDiagnostics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDiagnostics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OSInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDiagnostics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OSInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OSInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Family", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDiagnostics
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Family = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Platform", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDiagnostics
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Platform = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDiagnostics
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDiagnostics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDiagnostics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MemInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDiagnostics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MemInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MemInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Total", wireType)
			}
			m.Total = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Total |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Available", wireType)
			}
			m.Available = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Available |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipDiagnostics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDiagnostics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipDiagnostics(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowDiagnostics
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowDiagnostics
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthDiagnostics
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowDiagnostics
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipDiagnostics(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthDiagnostics = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowDiagnostics   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("server/diagnosticspb/diagnostics.proto", fileDescriptor_diagnostics_7c4e4cf4277b337a)
}

var fileDescriptor_diagnostics_7c4e4cf4277b337a = []byte{
	// 1172 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x56, 0xcf, 0x6f, 0x1b, 0xc5,
	0x17, 0xaf, 0xbd, 0xfe, 0x39, 0x4e, 0xbf, 0xdf, 0x74, 0x1a, 0xc2, 0xe2, 0x56, 0x4e, 0xf1, 0xa1,
	0x2d, 0x02, 0xd9, 0x6a, 0x0a, 0x12, 0x42, 0x54, 0x55, 0x1c, 0x87, 0x52, 0x29, 0xa4, 0x68, 0xd3,
	0x70, 0x88, 0x10, 0xd6, 0x78, 0x77, 0xbc, 0x5e, 0x3c, 0xbb, 0xb3, 0xd9, 0x99, 0x75, 0xe5, 0x9c,
	0xb9, 0xc3, 0x85, 0x1b, 0x7f, 0x50, 0x8e, 0x9c, 0x10, 0xa7, 0x08, 0xcc, 0xdf, 0xc0, 0x85, 0x13,
	0x9a, 0x37, 0x63, 0x7b, 0xe3, 0xa6, 0x31, 0x41, 0xe2, 0x36, 0xef, 0xbd, 0x7d, 0x9f, 0x37, 0x9f,
	0xf7, 0x6b, 0x16, 0xdd, 0x17, 0x34, 0x19, 0xd3, 0xa4, 0xed, 0x05, 0xc4, 0x8f, 0xb8, 0x90, 0x81,
	0x2b, 0xe2, 0x7e, 0x56, 0x6a, 0xc5, 0x09, 0x97, 0x1c, 0x37, 0x5c, 0xee, 0x8e, 0x12, 0x4e, 0xdc,
	0x61, 0x4b, 0x7b, 0xb4, 0x2e, 0x78, 0xd4, 0xd7, 0xfb, 0x69, 0xc0, 0xbc, 0x76, 0x10, 0x0d, 0xb8,
	0xf6, 0xa8, 0xdf, 0x72, 0x79, 0x34, 0x08, 0xfc, 0xf6, 0x29, 0x8f, 0xa8, 0x51, 0x6d, 0xf8, 0xdc,
	0xe7, 0x70, 0x6c, 0xab, 0x93, 0xd1, 0xbe, 0x0d, 0xb0, 0x71, 0xbf, 0x4d, 0xe2, 0xb8, 0x27, 0x24,
	0x91, 0x26, 0x66, 0xfd, 0xae, 0x38, 0x61, 0x6d, 0x71, 0xc2, 0xfa, 0x44, 0xd0, 0xb6, 0x90, 0x49,
	0xea, 0xca, 0x34, 0xa1, 0x9e, 0xb1, 0x6e, 0xce, 0xdc, 0x42, 0x2a, 0x89, 0x47, 0x24, 0xd1, 0xfa,
	0xe6, 0x77, 0x08, 0xad, 0x77, 0xe7, 0x77, 0x73, 0x68, 0xcc, 0x13, 0x89, 0x3b, 0xa8, 0x10, 0x71,
	0x8f, 0xda, 0xb9, 0x7b, 0xb9, 0x87, 0xb5, 0xed, 0x87, 0xad, 0xab, 0xd9, 0xb4, 0x0e, 0xb8, 0x47,
	0x9f, 0x47, 0x03, 0xde, 0x29, 0x9c, 0x9d, 0x6f, 0xdd, 0x70, 0xc0, 0x17, 0x3f, 0x43, 0x25, 0x21,
	0x79, 0x42, 0x85, 0x9d, 0xbf, 0x67, 0x3d, 0xac, 0x6d, 0xbf, 0xb7, 0x0a, 0xe5, 0x50, 0x7d, 0x9d,
	0x81, 0x31, 0xee, 0xb8, 0x8b, 0x4a, 0xc2, 0x1d, 0xd2, 0x90, 0xd8, 0x16, 0x00, 0xdd, 0xcf, 0x02,
	0x9d, 0xb0, 0x96, 0xa1, 0xdc, 0x7a, 0x49, 0xfa, 0x8c, 0x76, 0xa9, 0x70, 0x93, 0x20, 0x96, 0x3c,
	0x99, 0xa3, 0x80, 0x2f, 0x3e, 0x40, 0x55, 0x71, 0xc2, 0x74, 0xc2, 0xec, 0x02, 0x00, 0xbd, 0xbf,
	0x04, 0xb4, 0xcb, 0x19, 0xa3, 0xae, 0xa4, 0xde, 0xa1, 0x24, 0x92, 0x86, 0x34, 0x92, 0xea, 0x10,
	0xc0, 0xfd, 0x0c, 0x5a, 0x45, 0x9c, 0x30, 0xa5, 0x14, 0xf8, 0xfb, 0x1c, 0xba, 0xc3, 0xa8, 0x4f,
	0xdc, 0x49, 0x2f, 0x8d, 0x82, 0x30, 0x66, 0xe0, 0x40, 0xbd, 0x1e, 0x4d, 0x12, 0x9e, 0x08, 0xbb,
	0x08, 0x21, 0x5e, 0xac, 0x22, 0xbd, 0x9c, 0xfa, 0xd6, 0x3e, 0x60, 0x1e, 0x65, 0x21, 0xf7, 0x00,
	0x71, 0x2f, 0x92, 0xc9, 0xc4, 0x79, 0x87, 0xbd, 0xc9, 0x8e, 0x63, 0xb4, 0x4e, 0x98, 0xa4, 0x09,
	0xf5, 0x7a, 0x82, 0x4a, 0x19, 0x44, 0xbe, 0xb0, 0x4b, 0x70, 0x8b, 0xbd, 0x6b, 0xdf, 0x62, 0x47,
	0x03, 0x1d, 0x1a, 0x1c, 0x1d, 0xfb, 0xff, 0xe4, 0xa2, 0x16, 0xbf, 0x42, 0xb7, 0x4d, 0x0a, 0x80,
	0x74, 0xcf, 0xe5, 0x69, 0x24, 0x85, 0x5d, 0x86, 0xa0, 0xcf, 0xfe, 0x25, 0x75, 0x60, 0xb3, 0x0b,
	0x48, 0x3a, 0xec, 0x2d, 0xb6, 0xac, 0xc7, 0xdf, 0xa2, 0x35, 0x35, 0x27, 0x3d, 0x3d, 0x33, 0xc2,
	0xae, 0x40, 0xc4, 0x9d, 0x6b, 0x47, 0x3c, 0xe6, 0x11, 0xdd, 0xd5, 0x18, 0x10, 0xcb, 0x54, 0xb9,
	0x76, 0xba, 0xd0, 0xe3, 0x10, 0xdd, 0x1c, 0x50, 0xa2, 0x46, 0xa9, 0x97, 0x0a, 0xe2, 0x53, 0xbb,
	0x0a, 0xc1, 0x3a, 0xd7, 0x0e, 0xf6, 0x99, 0x46, 0x39, 0x52, 0x20, 0xd9, 0x68, 0x6b, 0x83, 0x8c,
	0xa1, 0xde, 0x41, 0x1b, 0x97, 0x25, 0x1f, 0xaf, 0x23, 0x6b, 0x44, 0x27, 0x30, 0x91, 0x55, 0x47,
	0x1d, 0xf1, 0x06, 0x2a, 0x8e, 0x09, 0x4b, 0xa9, 0x9d, 0x07, 0x9d, 0x16, 0x3e, 0xc9, 0x7f, 0x9c,
	0xab, 0x7f, 0x8d, 0xd6, 0x97, 0x99, 0x65, 0xfd, 0x2d, 0xed, 0xbf, 0x9d, 0xf5, 0xaf, 0x6d, 0xdf,
	0xcd, 0x10, 0xd2, 0x79, 0xcd, 0xa4, 0x27, 0x8b, 0xfe, 0x14, 0xdd, 0x7a, 0x8d, 0xca, 0xaa, 0xeb,
	0x15, 0xb3, 0x00, 0xfb, 0xa8, 0x71, 0x75, 0x97, 0xaf, 0x42, 0xb3, 0xb2, 0x68, 0x5d, 0xb4, 0x79,
	0x79, 0xe3, 0x5c, 0x07, 0xa5, 0xf9, 0xa7, 0x85, 0x2a, 0xb3, 0x35, 0x86, 0x8f, 0x51, 0x59, 0xad,
	0xb0, 0x5e, 0xe0, 0x81, 0x73, 0xb1, 0xb3, 0x33, 0x3d, 0xdf, 0x2a, 0x81, 0xb9, 0xfb, 0xd7, 0xf9,
	0xd6, 0x63, 0x3f, 0x90, 0xc3, 0xb4, 0xdf, 0x72, 0x79, 0xd8, 0x9e, 0xe7, 0xcc, 0xeb, 0x2f, 0xce,
	0xed, 0x78, 0xe4, 0xb7, 0xcd, 0xbe, 0xd5, 0xcb, 0xb1, 0xeb, 0x94, 0x14, 0xe2, 0x73, 0x4f, 0x5d,
	0xa1, 0x3f, 0x91, 0xb0, 0x15, 0xe1, 0x0a, 0x20, 0xe0, 0x3b, 0xa8, 0x3a, 0xa2, 0x13, 0x3d, 0x40,
	0xb6, 0x05, 0x96, 0xca, 0x88, 0x4e, 0x80, 0x0d, 0xde, 0x42, 0xb5, 0x84, 0x44, 0x3e, 0x35, 0xe6,
	0x02, 0x98, 0x11, 0xa8, 0xf4, 0x07, 0x4f, 0x50, 0x85, 0x71, 0x97, 0xb0, 0x40, 0x4e, 0xec, 0x22,
	0x14, 0xf3, 0x4e, 0xa6, 0x98, 0xb3, 0x8b, 0xec, 0x9b, 0x4f, 0x66, 0xab, 0x6c, 0xe6, 0x82, 0x0f,
	0x50, 0x65, 0x48, 0x12, 0xef, 0x15, 0x49, 0xa8, 0x5d, 0x02, 0xf7, 0x0f, 0x56, 0x35, 0xf7, 0xe7,
	0xe6, 0xfb, 0xcc, 0xba, 0x9e, 0x63, 0xe0, 0x4f, 0x51, 0x9e, 0xab, 0x2d, 0x90, 0x5b, 0x5e, 0xd6,
	0x97, 0x21, 0xbd, 0x38, 0xcc, 0x60, 0xe4, 0xb9, 0xc0, 0x8f, 0x50, 0x11, 0x1e, 0x47, 0xbb, 0x02,
	0x00, 0x6f, 0x65, 0x00, 0x40, 0xdf, 0xca, 0x7c, 0xaf, 0xbf, 0xc4, 0x9b, 0xa8, 0x94, 0xc6, 0x32,
	0x08, 0xd5, 0x6c, 0xaa, 0xdc, 0x18, 0x09, 0xbf, 0x8b, 0xd6, 0x58, 0xe0, 0xd2, 0x48, 0xd0, 0x9e,
	0x9c, 0xc4, 0xd4, 0x46, 0xd0, 0x09, 0x35, 0xa3, 0x7b, 0x39, 0x89, 0x69, 0xf3, 0x27, 0x0b, 0x55,
	0xe7, 0x0f, 0xcf, 0x7f, 0x5a, 0xf8, 0x6f, 0x50, 0x05, 0x1e, 0x34, 0x05, 0x0e, 0x23, 0xd1, 0xd9,
	0x9d, 0x9e, 0x6f, 0x95, 0x75, 0x70, 0x85, 0xfe, 0xe1, 0xb5, 0xd0, 0x8d, 0x9f, 0x53, 0x06, 0xd0,
	0x6c, 0x63, 0x59, 0x6f, 0x6c, 0xac, 0xc2, 0xd5, 0x8d, 0x55, 0x7c, 0xad, 0xb1, 0xea, 0xa8, 0xe2,
	0x92, 0x98, 0xb8, 0xaa, 0xb1, 0x4a, 0xda, 0x79, 0x26, 0xe3, 0xbb, 0xa8, 0x4a, 0xc6, 0x24, 0x60,
	0xea, 0xd5, 0x85, 0x62, 0x5b, 0xce, 0x42, 0x81, 0x31, 0x2a, 0xa4, 0x82, 0xea, 0x22, 0x5a, 0x0e,
	0x9c, 0xf1, 0x23, 0xb4, 0x41, 0x23, 0x37, 0x99, 0xc4, 0x32, 0xe0, 0x51, 0x8f, 0x30, 0x9f, 0x27,
	0x81, 0x1c, 0x86, 0xa6, 0x68, 0xb7, 0x17, 0xb6, 0x9d, 0x99, 0xa9, 0xf9, 0x63, 0x0e, 0x95, 0x77,
	0xbf, 0x3c, 0x82, 0xe2, 0x6c, 0xa2, 0x52, 0x94, 0x86, 0x6e, 0x9c, 0xea, 0xda, 0x38, 0x46, 0xc2,
	0x36, 0x2a, 0x0b, 0xee, 0x8e, 0xa8, 0x14, 0x66, 0xd5, 0xcc, 0x44, 0x95, 0x12, 0x17, 0xfe, 0x40,
	0x2c, 0xbd, 0x82, 0x40, 0x50, 0xda, 0x90, 0x7b, 0x94, 0x41, 0x3a, 0xaa, 0x8e, 0x16, 0xd4, 0xb2,
	0x08, 0x87, 0xa7, 0x90, 0x83, 0xbc, 0xa3, 0x8e, 0x8a, 0xbc, 0xd9, 0xcc, 0xfa, 0x1d, 0xad, 0x3a,
	0x73, 0xb9, 0xf9, 0x4b, 0x0e, 0xad, 0x65, 0x67, 0x00, 0xdf, 0x47, 0xff, 0x1b, 0x07, 0x89, 0x4c,
	0x09, 0x0b, 0x4e, 0x89, 0xe2, 0x60, 0xd6, 0xce, 0x92, 0x16, 0x3f, 0x45, 0x96, 0x62, 0xa0, 0x57,
	0xee, 0x83, 0x55, 0xc3, 0x61, 0xa8, 0x9b, 0x6e, 0x57, 0x9e, 0x0a, 0x20, 0xa4, 0x21, 0x30, 0xfa,
	0x07, 0x00, 0x5f, 0xd0, 0x30, 0x0b, 0x10, 0xd2, 0x50, 0xd5, 0x8d, 0x71, 0xe2, 0x91, 0xb1, 0xff,
	0xe8, 0x23, 0x48, 0x41, 0xde, 0x59, 0x28, 0x9a, 0x5f, 0xa1, 0x92, 0x9e, 0x48, 0x95, 0xee, 0x01,
	0x09, 0x03, 0x36, 0x5b, 0xa0, 0x46, 0x52, 0x69, 0x89, 0x19, 0x91, 0x03, 0x9e, 0x84, 0xe6, 0xe5,
	0x99, 0xcb, 0xaa, 0x14, 0x63, 0x9a, 0x08, 0x45, 0xdf, 0x02, 0xd3, 0x4c, 0x6c, 0x3e, 0x41, 0x65,
	0x73, 0x17, 0x95, 0x7f, 0xc9, 0x25, 0x61, 0x80, 0x5b, 0x70, 0xb4, 0x70, 0xb1, 0x9d, 0xf2, 0x60,
	0x59, 0x28, 0x3a, 0x0f, 0xce, 0x7e, 0x6f, 0xdc, 0x38, 0x9b, 0x36, 0x72, 0x3f, 0x4f, 0x1b, 0xb9,
	0x5f, 0xa7, 0x8d, 0xdc, 0x6f, 0xd3, 0x46, 0xee, 0x87, 0x3f, 0x1a, 0x37, 0x8e, 0x6f, 0x5e, 0x20,
	0xdc, 0x2f, 0xc1, 0x5f, 0xed, 0xe3, 0xbf, 0x03, 0x00, 0x00, 0xff, 0xff, 0xa6, 0x05, 0xe5, 0x35,
	0xa9, 0x0b, 0x00, 0x00,
}
