// Code generated by execgen; DO NOT EDIT.
// Copyright 2018 The Cockroach Authors.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//     http://www.apache.org/licenses/LICENSE-2.0
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
// implied. See the License for the specific language governing
// permissions and limitations under the License.

package exec

import (
	"github.com/cockroachdb/apd"
	"github.com/cockroachdb/cockroach/pkg/sql/exec/coldata"
	"github.com/cockroachdb/cockroach/pkg/sql/exec/types"
	"github.com/pkg/errors"
)

func newAnyNotNullAgg(t types.T) (aggregateFunc, error) {
	switch t {
	case types.Bool:
		return &anyNotNullBoolAgg{}, nil
	case types.Bytes:
		return &anyNotNullBytesAgg{}, nil
	case types.Decimal:
		return &anyNotNullDecimalAgg{}, nil
	case types.Int8:
		return &anyNotNullInt8Agg{}, nil
	case types.Int16:
		return &anyNotNullInt16Agg{}, nil
	case types.Int32:
		return &anyNotNullInt32Agg{}, nil
	case types.Int64:
		return &anyNotNullInt64Agg{}, nil
	case types.Float32:
		return &anyNotNullFloat32Agg{}, nil
	case types.Float64:
		return &anyNotNullFloat64Agg{}, nil
	default:
		return nil, errors.Errorf("unsupported any not null agg type %s", t)
	}
}

// anyNotNullBoolAgg implements the ANY_NOT_NULL aggregate, returning the
// first non-null value in the input column.
// TODO(jordan): this needs to have null handling when it's added!
type anyNotNullBoolAgg struct {
	done   bool
	groups []bool
	vec    []bool
	curIdx int
}

func (a *anyNotNullBoolAgg) Init(groups []bool, vec coldata.Vec) {
	a.groups = groups
	a.vec = vec.Bool()
	a.Reset()
}

func (a *anyNotNullBoolAgg) Reset() {
	a.curIdx = -1
}

func (a *anyNotNullBoolAgg) CurrentOutputIndex() int {
	return a.curIdx
}

func (a *anyNotNullBoolAgg) SetOutputIndex(idx int) {
	if a.curIdx != -1 {
		a.curIdx = idx
	}
}

func (a *anyNotNullBoolAgg) Compute(b coldata.Batch, inputIdxs []uint32) {
	if a.done {
		return
	}
	inputLen := b.Length()
	if inputLen == 0 {
		a.curIdx++
		a.done = true
		return
	}
	col, sel := b.ColVec(int(inputIdxs[0])).Bool(), b.Selection()
	if sel != nil {
		sel = sel[:inputLen]
		for _, i := range sel {
			if a.groups[i] {
				a.curIdx++
				a.vec[a.curIdx] = col[i]
			}
		}
	} else {
		col = col[:inputLen]
		for i := range col {
			if a.groups[i] {
				a.curIdx++
				a.vec[a.curIdx] = col[i]
			}
		}
	}
}

// anyNotNullBytesAgg implements the ANY_NOT_NULL aggregate, returning the
// first non-null value in the input column.
// TODO(jordan): this needs to have null handling when it's added!
type anyNotNullBytesAgg struct {
	done   bool
	groups []bool
	vec    [][]byte
	curIdx int
}

func (a *anyNotNullBytesAgg) Init(groups []bool, vec coldata.Vec) {
	a.groups = groups
	a.vec = vec.Bytes()
	a.Reset()
}

func (a *anyNotNullBytesAgg) Reset() {
	a.curIdx = -1
}

func (a *anyNotNullBytesAgg) CurrentOutputIndex() int {
	return a.curIdx
}

func (a *anyNotNullBytesAgg) SetOutputIndex(idx int) {
	if a.curIdx != -1 {
		a.curIdx = idx
	}
}

func (a *anyNotNullBytesAgg) Compute(b coldata.Batch, inputIdxs []uint32) {
	if a.done {
		return
	}
	inputLen := b.Length()
	if inputLen == 0 {
		a.curIdx++
		a.done = true
		return
	}
	col, sel := b.ColVec(int(inputIdxs[0])).Bytes(), b.Selection()
	if sel != nil {
		sel = sel[:inputLen]
		for _, i := range sel {
			if a.groups[i] {
				a.curIdx++
				a.vec[a.curIdx] = col[i]
			}
		}
	} else {
		col = col[:inputLen]
		for i := range col {
			if a.groups[i] {
				a.curIdx++
				a.vec[a.curIdx] = col[i]
			}
		}
	}
}

// anyNotNullDecimalAgg implements the ANY_NOT_NULL aggregate, returning the
// first non-null value in the input column.
// TODO(jordan): this needs to have null handling when it's added!
type anyNotNullDecimalAgg struct {
	done   bool
	groups []bool
	vec    []apd.Decimal
	curIdx int
}

func (a *anyNotNullDecimalAgg) Init(groups []bool, vec coldata.Vec) {
	a.groups = groups
	a.vec = vec.Decimal()
	a.Reset()
}

func (a *anyNotNullDecimalAgg) Reset() {
	a.curIdx = -1
}

func (a *anyNotNullDecimalAgg) CurrentOutputIndex() int {
	return a.curIdx
}

func (a *anyNotNullDecimalAgg) SetOutputIndex(idx int) {
	if a.curIdx != -1 {
		a.curIdx = idx
	}
}

func (a *anyNotNullDecimalAgg) Compute(b coldata.Batch, inputIdxs []uint32) {
	if a.done {
		return
	}
	inputLen := b.Length()
	if inputLen == 0 {
		a.curIdx++
		a.done = true
		return
	}
	col, sel := b.ColVec(int(inputIdxs[0])).Decimal(), b.Selection()
	if sel != nil {
		sel = sel[:inputLen]
		for _, i := range sel {
			if a.groups[i] {
				a.curIdx++
				a.vec[a.curIdx] = col[i]
			}
		}
	} else {
		col = col[:inputLen]
		for i := range col {
			if a.groups[i] {
				a.curIdx++
				a.vec[a.curIdx] = col[i]
			}
		}
	}
}

// anyNotNullInt8Agg implements the ANY_NOT_NULL aggregate, returning the
// first non-null value in the input column.
// TODO(jordan): this needs to have null handling when it's added!
type anyNotNullInt8Agg struct {
	done   bool
	groups []bool
	vec    []int8
	curIdx int
}

func (a *anyNotNullInt8Agg) Init(groups []bool, vec coldata.Vec) {
	a.groups = groups
	a.vec = vec.Int8()
	a.Reset()
}

func (a *anyNotNullInt8Agg) Reset() {
	a.curIdx = -1
}

func (a *anyNotNullInt8Agg) CurrentOutputIndex() int {
	return a.curIdx
}

func (a *anyNotNullInt8Agg) SetOutputIndex(idx int) {
	if a.curIdx != -1 {
		a.curIdx = idx
	}
}

func (a *anyNotNullInt8Agg) Compute(b coldata.Batch, inputIdxs []uint32) {
	if a.done {
		return
	}
	inputLen := b.Length()
	if inputLen == 0 {
		a.curIdx++
		a.done = true
		return
	}
	col, sel := b.ColVec(int(inputIdxs[0])).Int8(), b.Selection()
	if sel != nil {
		sel = sel[:inputLen]
		for _, i := range sel {
			if a.groups[i] {
				a.curIdx++
				a.vec[a.curIdx] = col[i]
			}
		}
	} else {
		col = col[:inputLen]
		for i := range col {
			if a.groups[i] {
				a.curIdx++
				a.vec[a.curIdx] = col[i]
			}
		}
	}
}

// anyNotNullInt16Agg implements the ANY_NOT_NULL aggregate, returning the
// first non-null value in the input column.
// TODO(jordan): this needs to have null handling when it's added!
type anyNotNullInt16Agg struct {
	done   bool
	groups []bool
	vec    []int16
	curIdx int
}

func (a *anyNotNullInt16Agg) Init(groups []bool, vec coldata.Vec) {
	a.groups = groups
	a.vec = vec.Int16()
	a.Reset()
}

func (a *anyNotNullInt16Agg) Reset() {
	a.curIdx = -1
}

func (a *anyNotNullInt16Agg) CurrentOutputIndex() int {
	return a.curIdx
}

func (a *anyNotNullInt16Agg) SetOutputIndex(idx int) {
	if a.curIdx != -1 {
		a.curIdx = idx
	}
}

func (a *anyNotNullInt16Agg) Compute(b coldata.Batch, inputIdxs []uint32) {
	if a.done {
		return
	}
	inputLen := b.Length()
	if inputLen == 0 {
		a.curIdx++
		a.done = true
		return
	}
	col, sel := b.ColVec(int(inputIdxs[0])).Int16(), b.Selection()
	if sel != nil {
		sel = sel[:inputLen]
		for _, i := range sel {
			if a.groups[i] {
				a.curIdx++
				a.vec[a.curIdx] = col[i]
			}
		}
	} else {
		col = col[:inputLen]
		for i := range col {
			if a.groups[i] {
				a.curIdx++
				a.vec[a.curIdx] = col[i]
			}
		}
	}
}

// anyNotNullInt32Agg implements the ANY_NOT_NULL aggregate, returning the
// first non-null value in the input column.
// TODO(jordan): this needs to have null handling when it's added!
type anyNotNullInt32Agg struct {
	done   bool
	groups []bool
	vec    []int32
	curIdx int
}

func (a *anyNotNullInt32Agg) Init(groups []bool, vec coldata.Vec) {
	a.groups = groups
	a.vec = vec.Int32()
	a.Reset()
}

func (a *anyNotNullInt32Agg) Reset() {
	a.curIdx = -1
}

func (a *anyNotNullInt32Agg) CurrentOutputIndex() int {
	return a.curIdx
}

func (a *anyNotNullInt32Agg) SetOutputIndex(idx int) {
	if a.curIdx != -1 {
		a.curIdx = idx
	}
}

func (a *anyNotNullInt32Agg) Compute(b coldata.Batch, inputIdxs []uint32) {
	if a.done {
		return
	}
	inputLen := b.Length()
	if inputLen == 0 {
		a.curIdx++
		a.done = true
		return
	}
	col, sel := b.ColVec(int(inputIdxs[0])).Int32(), b.Selection()
	if sel != nil {
		sel = sel[:inputLen]
		for _, i := range sel {
			if a.groups[i] {
				a.curIdx++
				a.vec[a.curIdx] = col[i]
			}
		}
	} else {
		col = col[:inputLen]
		for i := range col {
			if a.groups[i] {
				a.curIdx++
				a.vec[a.curIdx] = col[i]
			}
		}
	}
}

// anyNotNullInt64Agg implements the ANY_NOT_NULL aggregate, returning the
// first non-null value in the input column.
// TODO(jordan): this needs to have null handling when it's added!
type anyNotNullInt64Agg struct {
	done   bool
	groups []bool
	vec    []int64
	curIdx int
}

func (a *anyNotNullInt64Agg) Init(groups []bool, vec coldata.Vec) {
	a.groups = groups
	a.vec = vec.Int64()
	a.Reset()
}

func (a *anyNotNullInt64Agg) Reset() {
	a.curIdx = -1
}

func (a *anyNotNullInt64Agg) CurrentOutputIndex() int {
	return a.curIdx
}

func (a *anyNotNullInt64Agg) SetOutputIndex(idx int) {
	if a.curIdx != -1 {
		a.curIdx = idx
	}
}

func (a *anyNotNullInt64Agg) Compute(b coldata.Batch, inputIdxs []uint32) {
	if a.done {
		return
	}
	inputLen := b.Length()
	if inputLen == 0 {
		a.curIdx++
		a.done = true
		return
	}
	col, sel := b.ColVec(int(inputIdxs[0])).Int64(), b.Selection()
	if sel != nil {
		sel = sel[:inputLen]
		for _, i := range sel {
			if a.groups[i] {
				a.curIdx++
				a.vec[a.curIdx] = col[i]
			}
		}
	} else {
		col = col[:inputLen]
		for i := range col {
			if a.groups[i] {
				a.curIdx++
				a.vec[a.curIdx] = col[i]
			}
		}
	}
}

// anyNotNullFloat32Agg implements the ANY_NOT_NULL aggregate, returning the
// first non-null value in the input column.
// TODO(jordan): this needs to have null handling when it's added!
type anyNotNullFloat32Agg struct {
	done   bool
	groups []bool
	vec    []float32
	curIdx int
}

func (a *anyNotNullFloat32Agg) Init(groups []bool, vec coldata.Vec) {
	a.groups = groups
	a.vec = vec.Float32()
	a.Reset()
}

func (a *anyNotNullFloat32Agg) Reset() {
	a.curIdx = -1
}

func (a *anyNotNullFloat32Agg) CurrentOutputIndex() int {
	return a.curIdx
}

func (a *anyNotNullFloat32Agg) SetOutputIndex(idx int) {
	if a.curIdx != -1 {
		a.curIdx = idx
	}
}

func (a *anyNotNullFloat32Agg) Compute(b coldata.Batch, inputIdxs []uint32) {
	if a.done {
		return
	}
	inputLen := b.Length()
	if inputLen == 0 {
		a.curIdx++
		a.done = true
		return
	}
	col, sel := b.ColVec(int(inputIdxs[0])).Float32(), b.Selection()
	if sel != nil {
		sel = sel[:inputLen]
		for _, i := range sel {
			if a.groups[i] {
				a.curIdx++
				a.vec[a.curIdx] = col[i]
			}
		}
	} else {
		col = col[:inputLen]
		for i := range col {
			if a.groups[i] {
				a.curIdx++
				a.vec[a.curIdx] = col[i]
			}
		}
	}
}

// anyNotNullFloat64Agg implements the ANY_NOT_NULL aggregate, returning the
// first non-null value in the input column.
// TODO(jordan): this needs to have null handling when it's added!
type anyNotNullFloat64Agg struct {
	done   bool
	groups []bool
	vec    []float64
	curIdx int
}

func (a *anyNotNullFloat64Agg) Init(groups []bool, vec coldata.Vec) {
	a.groups = groups
	a.vec = vec.Float64()
	a.Reset()
}

func (a *anyNotNullFloat64Agg) Reset() {
	a.curIdx = -1
}

func (a *anyNotNullFloat64Agg) CurrentOutputIndex() int {
	return a.curIdx
}

func (a *anyNotNullFloat64Agg) SetOutputIndex(idx int) {
	if a.curIdx != -1 {
		a.curIdx = idx
	}
}

func (a *anyNotNullFloat64Agg) Compute(b coldata.Batch, inputIdxs []uint32) {
	if a.done {
		return
	}
	inputLen := b.Length()
	if inputLen == 0 {
		a.curIdx++
		a.done = true
		return
	}
	col, sel := b.ColVec(int(inputIdxs[0])).Float64(), b.Selection()
	if sel != nil {
		sel = sel[:inputLen]
		for _, i := range sel {
			if a.groups[i] {
				a.curIdx++
				a.vec[a.curIdx] = col[i]
			}
		}
	} else {
		col = col[:inputLen]
		for i := range col {
			if a.groups[i] {
				a.curIdx++
				a.vec[a.curIdx] = col[i]
			}
		}
	}
}
