#!/bin/csh

# gen-Logging_gruntwork.csh by Woody Zenfell, III
# csh can execute this script to generate the file aleph/Source_Files/Misc/Logging_gruntwork.h,
# which is #included by Logging.h.  Logging_gruntwork.h is a whole bunch of similar macros that
# cannot be simplified, really, in any way that's portable to all our compilers and still retains
# ease-of-use for Logging users.
#
# This file spews to stdout currently, so you need to redirect the stream to actually generate the file.
# Although Logging_gruntwork.h can be completely generated by this file, I'm committing both to cvs so that
# people without csh can still build.  (I doubt the file will change all that often anyway......)
#
# Created by Woody Zenfell on July 13, 2003

echo "// This file is automatically generated by aleph/tools/gen-Logging_gruntwork.csh"
echo "// Make changes to that script, not to this file."
echo " "

@ max_nargs = 5
set levels = (Fatal Error Warning Anomaly Note Summary Trace Dump)

set batch_desc = ("// Straight main-thread logging convenience macros" "// Analogues to the above, but use these when you might be running in a non-main thread")

foreach batch ("" NMT)
	echo $batch_desc[1]

	@ nargs = 0
	while($nargs <= $max_nargs)
		if($nargs == 0) then
			set nargs_str = 
		else
			set nargs_str = $nargs
		endif

		foreach level ($levels)
			printf "#define log$level$batch$nargs_str(message"

			@ nargs1 = 1
			while($nargs1 <= $nargs)
				printf ", arg$nargs1"
				@ nargs1++
			end

			printf ")\t(GetCurrentLogger()->logMessage$batch(logDomain, log${level}Level, __FILE__, __LINE__, (message)"

			@ nargs1 = 1
			while($nargs1 <= $nargs)
				printf ", (arg$nargs1)"
				@ nargs1++
			end

			printf "))\n"
		end

		printf "\n"

		@ nargs++
	end

	echo " "
	shift batch_desc
end



set batch_desc = ("// Main-thread log context convenience macros" "// Non-main-thread analogues to the above")
set method_arg = (false true)

foreach batch ("" NMT)
	echo $batch_desc[1]
	
	@ nargs = 0
	while($nargs <= $max_nargs)
		if($nargs == 0) then
			set nargs_str = 
		else
			set nargs_str = $nargs
		endif

		printf "#define logContext$batch$nargs_str(context"

		@ nargs1 = 1
		while($nargs1 <= $nargs)
			printf ", arg$nargs1"
			@ nargs1++
		end

		printf ")\tLogContext makeUniqueIdentifier(_theLogContext,__LINE__)($method_arg[1], __FILE__, __LINE__, (context)"

		@ nargs1 = 1
		while($nargs1 <= $nargs)
			printf ", (arg$nargs1)"
			@ nargs1++
		end

		printf ")\n"

		@ nargs++
	end
	
	echo " "
	
	shift method_arg
	shift batch_desc
end
