// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0-devel
// 	protoc        v3.12.2
// source: google/maps/routes/v1/compute_custom_routes_request.proto

package routes

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// ComputeCustomRoutes request message.
type ComputeCustomRoutesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Origin waypoint.
	Origin *Waypoint `protobuf:"bytes,1,opt,name=origin,proto3" json:"origin,omitempty"`
	// Required. Destination waypoint.
	Destination *Waypoint `protobuf:"bytes,2,opt,name=destination,proto3" json:"destination,omitempty"`
	// Optional. A set of waypoints along the route (excluding terminal points), for either
	// stopping at or passing by. Up to 25 intermediate waypoints are supported.
	// Intermediates are not supported in ComputeCustomRoutes Alpha.
	Intermediates []*Waypoint `protobuf:"bytes,3,rep,name=intermediates,proto3" json:"intermediates,omitempty"`
	// Optional. Specifies the mode of transportation. Only DRIVE is supported in
	// ComputeCustomRoutes Alpha.
	TravelMode RouteTravelMode `protobuf:"varint,4,opt,name=travel_mode,json=travelMode,proto3,enum=google.maps.routes.v1.RouteTravelMode" json:"travel_mode,omitempty"`
	// Optional. Specifies how to compute the route. The server attempts to use the selected
	// routing preference to compute the route. If the routing preference results
	// in an error or an extra long latency, then an error is returned. In the
	// future, we might implement a fallback mechanism to use a different option
	// when the preferred option does not give a valid result. You can specify
	// this option only when the `travel_mode` is `DRIVE` or `TWO_WHEELER`,
	// otherwise the request fails.
	RoutingPreference RoutingPreference `protobuf:"varint,5,opt,name=routing_preference,json=routingPreference,proto3,enum=google.maps.routes.v1.RoutingPreference" json:"routing_preference,omitempty"`
	// Optional. Specifies your preference for the quality of the polyline.
	PolylineQuality PolylineQuality `protobuf:"varint,6,opt,name=polyline_quality,json=polylineQuality,proto3,enum=google.maps.routes.v1.PolylineQuality" json:"polyline_quality,omitempty"`
	// Optional. Specifies the preferred encoding for the polyline.
	PolylineEncoding PolylineEncoding `protobuf:"varint,13,opt,name=polyline_encoding,json=polylineEncoding,proto3,enum=google.maps.routes.v1.PolylineEncoding" json:"polyline_encoding,omitempty"`
	// Optional. The departure time. If you don't set this value, then this value
	// defaults to the time that you made the request. If you set this value to a
	// time that has already occurred, then the request fails.
	DepartureTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=departure_time,json=departureTime,proto3" json:"departure_time,omitempty"`
	// Optional. A set of conditions to satisfy that affect the way routes are calculated.
	RouteModifiers *RouteModifiers `protobuf:"bytes,11,opt,name=route_modifiers,json=routeModifiers,proto3" json:"route_modifiers,omitempty"`
	// Required. A route objective to optimize for.
	RouteObjective *RouteObjective `protobuf:"bytes,12,opt,name=route_objective,json=routeObjective,proto3" json:"route_objective,omitempty"`
	// Optional. The BCP-47 language code, such as "en-US" or "sr-Latn". For more
	// information, see
	// http://www.unicode.org/reports/tr35/#Unicode_locale_identifier. See
	// [Language Support](https://developers.google.com/maps/faq#languagesupport)
	// for the list of supported languages. When you don't provide this value, the
	// display language is inferred from the location of the route request.
	LanguageCode string `protobuf:"bytes,9,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. Specifies the units of measure for the display fields. This includes the
	// `instruction` field in `NavigationInstruction`. The units of measure used
	// for the route, leg, step distance, and duration are not affected by this
	// value. If you don't provide this value, then the display units are inferred
	// from the location of the request.
	Units Units `protobuf:"varint,10,opt,name=units,proto3,enum=google.maps.routes.v1.Units" json:"units,omitempty"`
}

func (x *ComputeCustomRoutesRequest) Reset() {
	*x = ComputeCustomRoutesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_routes_v1_compute_custom_routes_request_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputeCustomRoutesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeCustomRoutesRequest) ProtoMessage() {}

func (x *ComputeCustomRoutesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_routes_v1_compute_custom_routes_request_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeCustomRoutesRequest.ProtoReflect.Descriptor instead.
func (*ComputeCustomRoutesRequest) Descriptor() ([]byte, []int) {
	return file_google_maps_routes_v1_compute_custom_routes_request_proto_rawDescGZIP(), []int{0}
}

func (x *ComputeCustomRoutesRequest) GetOrigin() *Waypoint {
	if x != nil {
		return x.Origin
	}
	return nil
}

func (x *ComputeCustomRoutesRequest) GetDestination() *Waypoint {
	if x != nil {
		return x.Destination
	}
	return nil
}

func (x *ComputeCustomRoutesRequest) GetIntermediates() []*Waypoint {
	if x != nil {
		return x.Intermediates
	}
	return nil
}

func (x *ComputeCustomRoutesRequest) GetTravelMode() RouteTravelMode {
	if x != nil {
		return x.TravelMode
	}
	return RouteTravelMode_TRAVEL_MODE_UNSPECIFIED
}

func (x *ComputeCustomRoutesRequest) GetRoutingPreference() RoutingPreference {
	if x != nil {
		return x.RoutingPreference
	}
	return RoutingPreference_ROUTING_PREFERENCE_UNSPECIFIED
}

func (x *ComputeCustomRoutesRequest) GetPolylineQuality() PolylineQuality {
	if x != nil {
		return x.PolylineQuality
	}
	return PolylineQuality_POLYLINE_QUALITY_UNSPECIFIED
}

func (x *ComputeCustomRoutesRequest) GetPolylineEncoding() PolylineEncoding {
	if x != nil {
		return x.PolylineEncoding
	}
	return PolylineEncoding_POLYLINE_ENCODING_UNSPECIFIED
}

func (x *ComputeCustomRoutesRequest) GetDepartureTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DepartureTime
	}
	return nil
}

func (x *ComputeCustomRoutesRequest) GetRouteModifiers() *RouteModifiers {
	if x != nil {
		return x.RouteModifiers
	}
	return nil
}

func (x *ComputeCustomRoutesRequest) GetRouteObjective() *RouteObjective {
	if x != nil {
		return x.RouteObjective
	}
	return nil
}

func (x *ComputeCustomRoutesRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *ComputeCustomRoutesRequest) GetUnits() Units {
	if x != nil {
		return x.Units
	}
	return Units_UNITS_UNSPECIFIED
}

// Encapsulates an objective to optimize for by ComputeCustomRoutes.
type RouteObjective struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The route objective.
	//
	// Types that are assignable to Objective:
	//	*RouteObjective_RateCard_
	Objective isRouteObjective_Objective `protobuf_oneof:"objective"`
}

func (x *RouteObjective) Reset() {
	*x = RouteObjective{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_routes_v1_compute_custom_routes_request_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouteObjective) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteObjective) ProtoMessage() {}

func (x *RouteObjective) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_routes_v1_compute_custom_routes_request_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteObjective.ProtoReflect.Descriptor instead.
func (*RouteObjective) Descriptor() ([]byte, []int) {
	return file_google_maps_routes_v1_compute_custom_routes_request_proto_rawDescGZIP(), []int{1}
}

func (m *RouteObjective) GetObjective() isRouteObjective_Objective {
	if m != nil {
		return m.Objective
	}
	return nil
}

func (x *RouteObjective) GetRateCard() *RouteObjective_RateCard {
	if x, ok := x.GetObjective().(*RouteObjective_RateCard_); ok {
		return x.RateCard
	}
	return nil
}

type isRouteObjective_Objective interface {
	isRouteObjective_Objective()
}

type RouteObjective_RateCard_ struct {
	// The RateCard objective.
	RateCard *RouteObjective_RateCard `protobuf:"bytes,1,opt,name=rate_card,json=rateCard,proto3,oneof"`
}

func (*RouteObjective_RateCard_) isRouteObjective_Objective() {}

// Encapsulates a RateCard route objective.
type RouteObjective_RateCard struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Cost per minute.
	CostPerMinute *RouteObjective_RateCard_MonetaryCost `protobuf:"bytes,2,opt,name=cost_per_minute,json=costPerMinute,proto3" json:"cost_per_minute,omitempty"`
	// Optional. Cost per kilometer.
	CostPerKm *RouteObjective_RateCard_MonetaryCost `protobuf:"bytes,3,opt,name=cost_per_km,json=costPerKm,proto3" json:"cost_per_km,omitempty"`
	// Optional. Whether to include toll cost in the overall cost.
	IncludeTolls bool `protobuf:"varint,4,opt,name=include_tolls,json=includeTolls,proto3" json:"include_tolls,omitempty"`
}

func (x *RouteObjective_RateCard) Reset() {
	*x = RouteObjective_RateCard{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_routes_v1_compute_custom_routes_request_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouteObjective_RateCard) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteObjective_RateCard) ProtoMessage() {}

func (x *RouteObjective_RateCard) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_routes_v1_compute_custom_routes_request_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteObjective_RateCard.ProtoReflect.Descriptor instead.
func (*RouteObjective_RateCard) Descriptor() ([]byte, []int) {
	return file_google_maps_routes_v1_compute_custom_routes_request_proto_rawDescGZIP(), []int{1, 0}
}

func (x *RouteObjective_RateCard) GetCostPerMinute() *RouteObjective_RateCard_MonetaryCost {
	if x != nil {
		return x.CostPerMinute
	}
	return nil
}

func (x *RouteObjective_RateCard) GetCostPerKm() *RouteObjective_RateCard_MonetaryCost {
	if x != nil {
		return x.CostPerKm
	}
	return nil
}

func (x *RouteObjective_RateCard) GetIncludeTolls() bool {
	if x != nil {
		return x.IncludeTolls
	}
	return false
}

// Encapsulates the cost used in the rate card.
type RouteObjective_RateCard_MonetaryCost struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The cost value in local currency inferred from the request.
	Value float64 `protobuf:"fixed64,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *RouteObjective_RateCard_MonetaryCost) Reset() {
	*x = RouteObjective_RateCard_MonetaryCost{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_routes_v1_compute_custom_routes_request_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RouteObjective_RateCard_MonetaryCost) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RouteObjective_RateCard_MonetaryCost) ProtoMessage() {}

func (x *RouteObjective_RateCard_MonetaryCost) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_routes_v1_compute_custom_routes_request_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RouteObjective_RateCard_MonetaryCost.ProtoReflect.Descriptor instead.
func (*RouteObjective_RateCard_MonetaryCost) Descriptor() ([]byte, []int) {
	return file_google_maps_routes_v1_compute_custom_routes_request_proto_rawDescGZIP(), []int{1, 0, 0}
}

func (x *RouteObjective_RateCard_MonetaryCost) GetValue() float64 {
	if x != nil {
		return x.Value
	}
	return 0
}

var File_google_maps_routes_v1_compute_custom_routes_request_proto protoreflect.FileDescriptor

var file_google_maps_routes_v1_compute_custom_routes_request_proto_rawDesc = []byte{
	0x0a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x72, 0x6f,
	0x75, 0x74, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x5f, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x15, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73,
	0x2f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x65, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x6d, 0x61, 0x70, 0x73, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x70,
	0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x24, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x65,
	0x73, 0x2f, 0x76, 0x31, 0x2f, 0x77, 0x61, 0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa2, 0x07, 0x0a, 0x1a, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x06, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70,
	0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x61, 0x79, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x6f, 0x72, 0x69, 0x67, 0x69,
	0x6e, 0x12, 0x46, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x57,
	0x61, 0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4a, 0x0a, 0x0d, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72,
	0x6f, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x61, 0x79, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x65, 0x64,
	0x69, 0x61, 0x74, 0x65, 0x73, 0x12, 0x4c, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x5f,
	0x6d, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x54, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x4d, 0x6f,
	0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x4d,
	0x6f, 0x64, 0x65, 0x12, 0x5c, 0x0a, 0x12, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x70,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f,
	0x75, 0x74, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11,
	0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x12, 0x56, 0x0a, 0x10, 0x70, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x71, 0x75,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x51, 0x75, 0x61, 0x6c,
	0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x70, 0x6f, 0x6c, 0x79, 0x6c, 0x69,
	0x6e, 0x65, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x59, 0x0a, 0x11, 0x70, 0x6f, 0x6c,
	0x79, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61,
	0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c,
	0x79, 0x6c, 0x69, 0x6e, 0x65, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x10, 0x70, 0x6f, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x65, 0x45, 0x6e, 0x63, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x12, 0x46, 0x0a, 0x0e, 0x64, 0x65, 0x70, 0x61, 0x72, 0x74, 0x75, 0x72,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x64,
	0x65, 0x70, 0x61, 0x72, 0x74, 0x75, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x53, 0x0a, 0x0f,
	0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d,
	0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0e, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x73, 0x12, 0x53, 0x0a, 0x0f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65,
	0x12, 0x37, 0x0a, 0x05, 0x75, 0x6e, 0x69, 0x74, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f,
	0x75, 0x74, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x6e, 0x69, 0x74, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x05, 0x75, 0x6e, 0x69, 0x74, 0x73, 0x22, 0x9a, 0x03, 0x0a, 0x0e, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x12, 0x4d, 0x0a, 0x09,
	0x72, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x61, 0x72, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f,
	0x75, 0x74, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x2e, 0x52, 0x61, 0x74, 0x65, 0x43, 0x61, 0x72, 0x64, 0x48,
	0x00, 0x52, 0x08, 0x72, 0x61, 0x74, 0x65, 0x43, 0x61, 0x72, 0x64, 0x1a, 0xab, 0x02, 0x0a, 0x08,
	0x52, 0x61, 0x74, 0x65, 0x43, 0x61, 0x72, 0x64, 0x12, 0x68, 0x0a, 0x0f, 0x63, 0x6f, 0x73, 0x74,
	0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e,
	0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x2e, 0x52, 0x61, 0x74, 0x65, 0x43, 0x61, 0x72,
	0x64, 0x2e, 0x4d, 0x6f, 0x6e, 0x65, 0x74, 0x61, 0x72, 0x79, 0x43, 0x6f, 0x73, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0d, 0x63, 0x6f, 0x73, 0x74, 0x50, 0x65, 0x72, 0x4d, 0x69, 0x6e, 0x75,
	0x74, 0x65, 0x12, 0x60, 0x0a, 0x0b, 0x63, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6b,
	0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x2e, 0x52,
	0x61, 0x74, 0x65, 0x43, 0x61, 0x72, 0x64, 0x2e, 0x4d, 0x6f, 0x6e, 0x65, 0x74, 0x61, 0x72, 0x79,
	0x43, 0x6f, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x63, 0x6f, 0x73, 0x74, 0x50,
	0x65, 0x72, 0x4b, 0x6d, 0x12, 0x28, 0x0a, 0x0d, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f,
	0x74, 0x6f, 0x6c, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x54, 0x6f, 0x6c, 0x6c, 0x73, 0x1a, 0x29,
	0x0a, 0x0c, 0x4d, 0x6f, 0x6e, 0x65, 0x74, 0x61, 0x72, 0x79, 0x43, 0x6f, 0x73, 0x74, 0x12, 0x19,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x0b, 0x0a, 0x09, 0x6f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x42, 0xb5, 0x01, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x42, 0x1f, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x6d,
	0x61, 0x70, 0x73, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x3b, 0x72, 0x6f,
	0x75, 0x74, 0x65, 0x73, 0xf8, 0x01, 0x01, 0xa2, 0x02, 0x04, 0x47, 0x4d, 0x52, 0x53, 0xaa, 0x02,
	0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x4d, 0x61, 0x70, 0x73, 0x2e, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x73, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c,
	0x4d, 0x61, 0x70, 0x73, 0x5c, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x5c, 0x56, 0x31, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_maps_routes_v1_compute_custom_routes_request_proto_rawDescOnce sync.Once
	file_google_maps_routes_v1_compute_custom_routes_request_proto_rawDescData = file_google_maps_routes_v1_compute_custom_routes_request_proto_rawDesc
)

func file_google_maps_routes_v1_compute_custom_routes_request_proto_rawDescGZIP() []byte {
	file_google_maps_routes_v1_compute_custom_routes_request_proto_rawDescOnce.Do(func() {
		file_google_maps_routes_v1_compute_custom_routes_request_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_maps_routes_v1_compute_custom_routes_request_proto_rawDescData)
	})
	return file_google_maps_routes_v1_compute_custom_routes_request_proto_rawDescData
}

var file_google_maps_routes_v1_compute_custom_routes_request_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_maps_routes_v1_compute_custom_routes_request_proto_goTypes = []interface{}{
	(*ComputeCustomRoutesRequest)(nil),           // 0: google.maps.routes.v1.ComputeCustomRoutesRequest
	(*RouteObjective)(nil),                       // 1: google.maps.routes.v1.RouteObjective
	(*RouteObjective_RateCard)(nil),              // 2: google.maps.routes.v1.RouteObjective.RateCard
	(*RouteObjective_RateCard_MonetaryCost)(nil), // 3: google.maps.routes.v1.RouteObjective.RateCard.MonetaryCost
	(*Waypoint)(nil),                             // 4: google.maps.routes.v1.Waypoint
	(RouteTravelMode)(0),                         // 5: google.maps.routes.v1.RouteTravelMode
	(RoutingPreference)(0),                       // 6: google.maps.routes.v1.RoutingPreference
	(PolylineQuality)(0),                         // 7: google.maps.routes.v1.PolylineQuality
	(PolylineEncoding)(0),                        // 8: google.maps.routes.v1.PolylineEncoding
	(*timestamppb.Timestamp)(nil),                // 9: google.protobuf.Timestamp
	(*RouteModifiers)(nil),                       // 10: google.maps.routes.v1.RouteModifiers
	(Units)(0),                                   // 11: google.maps.routes.v1.Units
}
var file_google_maps_routes_v1_compute_custom_routes_request_proto_depIdxs = []int32{
	4,  // 0: google.maps.routes.v1.ComputeCustomRoutesRequest.origin:type_name -> google.maps.routes.v1.Waypoint
	4,  // 1: google.maps.routes.v1.ComputeCustomRoutesRequest.destination:type_name -> google.maps.routes.v1.Waypoint
	4,  // 2: google.maps.routes.v1.ComputeCustomRoutesRequest.intermediates:type_name -> google.maps.routes.v1.Waypoint
	5,  // 3: google.maps.routes.v1.ComputeCustomRoutesRequest.travel_mode:type_name -> google.maps.routes.v1.RouteTravelMode
	6,  // 4: google.maps.routes.v1.ComputeCustomRoutesRequest.routing_preference:type_name -> google.maps.routes.v1.RoutingPreference
	7,  // 5: google.maps.routes.v1.ComputeCustomRoutesRequest.polyline_quality:type_name -> google.maps.routes.v1.PolylineQuality
	8,  // 6: google.maps.routes.v1.ComputeCustomRoutesRequest.polyline_encoding:type_name -> google.maps.routes.v1.PolylineEncoding
	9,  // 7: google.maps.routes.v1.ComputeCustomRoutesRequest.departure_time:type_name -> google.protobuf.Timestamp
	10, // 8: google.maps.routes.v1.ComputeCustomRoutesRequest.route_modifiers:type_name -> google.maps.routes.v1.RouteModifiers
	1,  // 9: google.maps.routes.v1.ComputeCustomRoutesRequest.route_objective:type_name -> google.maps.routes.v1.RouteObjective
	11, // 10: google.maps.routes.v1.ComputeCustomRoutesRequest.units:type_name -> google.maps.routes.v1.Units
	2,  // 11: google.maps.routes.v1.RouteObjective.rate_card:type_name -> google.maps.routes.v1.RouteObjective.RateCard
	3,  // 12: google.maps.routes.v1.RouteObjective.RateCard.cost_per_minute:type_name -> google.maps.routes.v1.RouteObjective.RateCard.MonetaryCost
	3,  // 13: google.maps.routes.v1.RouteObjective.RateCard.cost_per_km:type_name -> google.maps.routes.v1.RouteObjective.RateCard.MonetaryCost
	14, // [14:14] is the sub-list for method output_type
	14, // [14:14] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_google_maps_routes_v1_compute_custom_routes_request_proto_init() }
func file_google_maps_routes_v1_compute_custom_routes_request_proto_init() {
	if File_google_maps_routes_v1_compute_custom_routes_request_proto != nil {
		return
	}
	file_google_maps_routes_v1_compute_routes_request_proto_init()
	file_google_maps_routes_v1_polyline_proto_init()
	file_google_maps_routes_v1_waypoint_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_maps_routes_v1_compute_custom_routes_request_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputeCustomRoutesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_routes_v1_compute_custom_routes_request_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RouteObjective); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_routes_v1_compute_custom_routes_request_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RouteObjective_RateCard); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_routes_v1_compute_custom_routes_request_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RouteObjective_RateCard_MonetaryCost); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_maps_routes_v1_compute_custom_routes_request_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*RouteObjective_RateCard_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_maps_routes_v1_compute_custom_routes_request_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_maps_routes_v1_compute_custom_routes_request_proto_goTypes,
		DependencyIndexes: file_google_maps_routes_v1_compute_custom_routes_request_proto_depIdxs,
		MessageInfos:      file_google_maps_routes_v1_compute_custom_routes_request_proto_msgTypes,
	}.Build()
	File_google_maps_routes_v1_compute_custom_routes_request_proto = out.File
	file_google_maps_routes_v1_compute_custom_routes_request_proto_rawDesc = nil
	file_google_maps_routes_v1_compute_custom_routes_request_proto_goTypes = nil
	file_google_maps_routes_v1_compute_custom_routes_request_proto_depIdxs = nil
}
