/* $Id$ */
#if !defined COMMON_H
#define COMMON_H

#if defined HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>

#if defined STDC_HEADERS
#include <stdlib.h>
#include <string.h>
#elif defined HAVE_STRING_H
#include <string.h>
#endif /* STDC_HEADERS */

#if !defined EXIT_SUCCESS
#define EXIT_SUCCESS 0
#define EXIT_FAILURE !0
#endif /* !EXIT_SUCCESS */

#if !defined TRUE
#define TRUE !0
#define FALSE 0
#endif /* !TRUE */

#if defined __cplusplus
#define BEGIN_C_DECLS extern "C" {
#define END_C_DECLS   }
#else
#define BEGIN_C_DECLS
#define END_C_DECLS
#endif /* __cplusplus */

#if defined DEBUG
#define DEBUG_PRINT(...) do { fprintf(stdout, "%s:%d: ", __FILE__, __LINE__); fprintf(stdout, __VA_ARGS__); } while(0)
#else
#define DEBUG_PRINT(...)
#endif /* DEBUG */

#define XCALLOC(type, num) ((type *)xcalloc((num), sizeof(type)))
#define XMALLOC(type, num) ((type *)xmalloc((num)*sizeof(type)))
#define XREALLOC(type, p, num) ((type *)xrealloc((p), (num)*sizeof(type)))
#define XFREE(stale) do { if (stale != NULL) { free(stale); stale = NULL; } } while(0)

BEGIN_C_DECLS

extern void *xcalloc(size_t num, size_t size);
extern void *xmalloc(size_t num);
extern void *xrealloc(void *p, size_t num);

END_C_DECLS

#endif /* !COMMON_H */
