// Windows NT service support module

#include <windows.h>
#include <winsvc.h>
#include "winnt_service.h"

#include <string>
#include <iostream>

using namespace std;

LPTSTR ServiceName = "ndsad";

static service_mode = false;
static SERVICE_STATUS status;
static SERVICE_STATUS_HANDLE status_handle;

int is_service_mode() { return service_mode; }

void ReportErrorEvent(LPCTSTR *szMsg)
{
    HANDLE h; 
 
    h = RegisterEventSource(NULL,  // uses local computer 
             ServiceName);    // source name 
    if (h == NULL) 
        return;
 
    if (!ReportEvent(h,           // event log handle 
            EVENTLOG_ERROR_TYPE,  // event type 
            0,                    // category zero 
            0,        // event identifier 
            NULL,                 // no user security identifier 
            1,                    // one substitution string 
            0,                    // no data 
            szMsg,                // pointer to string array 
            NULL))                // pointer to data 
        return;
 
    DeregisterEventSource(h); 
}


VOID WINAPI ServiceCtrlHandler(DWORD control)
{
	if (control == SERVICE_CONTROL_SHUTDOWN || 
		control == SERVICE_CONTROL_STOP)
	{
	 	//shutdown_system(0);
		status.dwCurrentState = SERVICE_STOPPED;
		status.dwServiceSpecificExitCode = 0;
		SetServiceStatus(status_handle,&status);
	}
}

void WINAPI ServiceMain(DWORD argc, LPTSTR argv[])
{
	status.dwServiceType = SERVICE_WIN32_OWN_PROCESS;
	status.dwCurrentState = SERVICE_START_PENDING;
	status.dwControlsAccepted = SERVICE_ACCEPT_STOP | SERVICE_ACCEPT_SHUTDOWN;

	status_handle = RegisterServiceCtrlHandler(ServiceName,
		ServiceCtrlHandler);
	SetServiceStatus(status_handle,&status);
  
	int result;
	if ((result = start_system(argc,argv)) != 0)
	{
	/*	if (result == 1)
		{
			LPCSTR msg = "Error opening configuration file";
			ReportErrorEvent(&msg);
		}
	*/
		status.dwCurrentState = SERVICE_STOPPED;
		status.dwWin32ExitCode = ERROR_SERVICE_SPECIFIC_ERROR;
		status.dwServiceSpecificExitCode = result;
		SetServiceStatus(status_handle,&status);
	}
}

void service_started()
{
	status.dwCurrentState = SERVICE_RUNNING;
	SetServiceStatus(status_handle,&status);
}

extern char* get_working_path();


void install_utm5_ndsad_service(string binname)
{ 
	SC_HANDLE schSCManager = OpenSCManager(
		0,
		SERVICES_ACTIVE_DATABASE,
		SC_MANAGER_ALL_ACCESS
		);
	if (schSCManager == 0)
	{
		cerr << "Unable to open Service Control Manager database: error " << GetLastError() << "\n";
		exit(1);
	}

	char* path = get_working_path();
	if (!path) 
	{
		cerr << "Could not get working path from the registry\n";
		exit(1);
	}

	string fullpath = "\"" + string(path) + "\\ndsad.exe\" --service";
    LPCTSTR lpszBinaryPathName = fullpath.c_str();
    SC_HANDLE schService = CreateService( 
        schSCManager,              // SCManager database 
        ServiceName,              // name of service 
        "Netup NDSAD Service",           // service name to display 
        SERVICE_ALL_ACCESS,        // desired access 
        SERVICE_WIN32_OWN_PROCESS, // service type 
        SERVICE_AUTO_START,      // start type 
        SERVICE_ERROR_NORMAL,      // error control type 
        lpszBinaryPathName,        // service's binary 
        NULL,                      // no load ordering group 
        NULL,                      // no tag identifier 
        NULL,                      // no dependencies 
        NULL,                      // LocalSystem account 
        NULL);                     // no password 
 
    if (schService == NULL) 
	{
		cerr << "Error creating " << ServiceName << " service: error " << GetLastError() << "\n";
		exit(1);
	}
    else 
        cerr << "Successfully created " << ServiceName << " service\n";
	
	HMODULE lib = LoadLibrary("ADVAPI32");
	if (lib == 0)
	{
		cerr << "Error loading ADVAPI32 library\n";
		exit(1);
	}

	typedef BOOL (*tChangeServiceConfig2)(SC_HANDLE hService,DWORD dwInfoLevel,LPVOID lpInfo);
	
	tChangeServiceConfig2 funcChangeServiceConfig2 = 
		(tChangeServiceConfig2)GetProcAddress(lib,"ChangeServiceConfig2W");
	if (funcChangeServiceConfig2)
	{
		SC_ACTION actions[1];
		actions[0].Type = SC_ACTION_RESTART;
		actions[0].Delay = 1000;
	
		SERVICE_FAILURE_ACTIONS failure_actions;
		failure_actions.dwResetPeriod = 3600;
		failure_actions.lpRebootMsg = 0;
		failure_actions.lpCommand = 0;
		failure_actions.cActions = 1;
		failure_actions.lpsaActions = actions;
		if (ChangeServiceConfig2(schService,SERVICE_CONFIG_FAILURE_ACTIONS,&failure_actions) == 0)
		{
			cerr << "Error configuring service restart actions!\n";
		}
	}
	FreeLibrary(lib);

    CloseServiceHandle(schService); 
	CloseServiceHandle(schSCManager);
}

void uninstall_utm5_ndsad_service()
{
	SC_HANDLE schSCManager = OpenSCManager(
		0,
		SERVICES_ACTIVE_DATABASE,
		SC_MANAGER_ALL_ACCESS
		);
	if (schSCManager == 0)
	{
		cerr << "Unable to open Service Control Manager database: error " << GetLastError() << "\n";
		exit(1);
	}
	SC_HANDLE schService = OpenService(
		schSCManager,
		ServiceName,
		SC_MANAGER_ALL_ACCESS);
	if (schService == 0)
	{
		cerr << "Unable to open " << ServiceName << "service: error " << GetLastError() << "\n";
		exit(1);
	}

	if (DeleteService(schService) == 0)
	{
		cerr << "Unable to delete " << ServiceName << "service: error " << GetLastError() << "\n";
		exit(1);
	}
	else
	{
        cerr << "Successfully deleted " << ServiceName  << " service\n";
	}
	CloseServiceHandle(schService); 

	CloseServiceHandle(schSCManager);
}


VOID main(int argc, LPTSTR argv[])
{
	SERVICE_TABLE_ENTRY DispatchTable[] =
	{
		{ ServiceName, ServiceMain },
		{ NULL, NULL }
	};
	for (int i=1;i<argc;i++) 
	{
		if (strcmpi(argv[i],"--service") == 0) 
		{
			service_mode = true;
			//start as a service
			StartServiceCtrlDispatcher(DispatchTable);
			return;
		}
		if (strcmpi(argv[i],"--install") == 0)
		{
			install_utm5_ndsad_service(argv[0]);
			return;
		}
		if (strcmpi(argv[i],"--uninstall") == 0)
		{
			uninstall_utm5_ndsad_service();
			return;
		}
	}
	
	{
		//otherwise it's a plain console APP
		start_system(argc,argv);
	}
	  
	return;
}



