/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.intellij.codeWithMe.ClientId;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.indexing.shared.download.DownloadTaskContext;
import com.intellij.indexing.shared.download.IndexDownloadConsentDecision;
import com.intellij.indexing.shared.download.IndexDownloadConsentDecisionKey;
import com.intellij.indexing.shared.download.IndexDownloadConsentService;
import com.intellij.indexing.shared.download.SharedIndexAuthKt;
import com.intellij.indexing.shared.download.SharedIndexAuthLifetimeHolder;
import com.intellij.indexing.shared.download.SharedIndexConsentStoreKt;
import com.intellij.indexing.shared.download.SharedIndexDownloadConsentStore;
import com.intellij.indexing.shared.download.SharedIndexDownloadExecutor;
import com.intellij.indexing.shared.download.SharedIndexDownloadExecutorKt;
import com.intellij.indexing.shared.download.SharedIndexDownloadHistoryStore;
import com.intellij.indexing.shared.download.SharedIndexDownloadInfo;
import com.intellij.indexing.shared.download.SharedIndexDownloadLoggerKt;
import com.intellij.indexing.shared.download.SharedIndexDownloadNotifications;
import com.intellij.indexing.shared.download.SharedIndexDownloadServiceKt;
import com.intellij.indexing.shared.download.SharedIndexId;
import com.intellij.indexing.shared.download.SharedIndexLookup;
import com.intellij.indexing.shared.download.SharedIndexLookupRequest;
import com.intellij.indexing.shared.download.SharedIndexLookupResult;
import com.intellij.indexing.shared.download.SharedIndexLookupResultKt;
import com.intellij.indexing.shared.download.SharedIndexPerProjectTaskExpiration;
import com.intellij.indexing.shared.download.SharedIndexSuggestion;
import com.intellij.indexing.shared.download.SharedIndexSuggestionService;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.platform.api.ChunkDescriptor;
import com.intellij.indexing.shared.platform.api.SharedIndexInfrastructureVersion;
import com.intellij.indexing.shared.platform.impl.ChunkStorageOption;
import com.intellij.indexing.shared.platform.impl.DownloadIndexResult;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorForCollections;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001-B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010\u0018\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ(\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0007J\u0018\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a*\b\u0012\u0004\u0012\u00020\u001b0 H\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J$\u0010\"\u001a\u00020\u0013*\u00020#2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J0\u0010$\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020&0%0\u001a2\u0006\u0010'\u001a\u00020(2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002JB\u0010)\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010'\u001a\u00020(2\u0018\u0010*\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020&0%0\u001a2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00130,H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R@\u0010\n\u001a2\u0012\u000e\u0012\f0\f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000e \u0010*\u0017\u0012\u000e\u0012\f0\f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000e0\u000f\u00a2\u0006\u0002\b\r0\u000b\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006."}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexDownloadService;", "", "<init>", "()V", "executor", "Lcom/intellij/indexing/shared/download/SharedIndexDownloadExecutor;", "getExecutor", "()Lcom/intellij/indexing/shared/download/SharedIndexDownloadExecutor;", "rescanningCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "pendingSharedIndexes", "", "Lcom/intellij/indexing/shared/download/SharedIndexId;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "kotlin.jvm.PlatformType", "Ljava/util/Set;", "waitRescanningCalmDown", "", "waitRescanningCalmDown$intellij_indexing_shared", "rescanNow", "project", "Lcom/intellij/openapi/project/Project;", "applySuggestions", "suggestions", "", "Lcom/intellij/indexing/shared/download/SharedIndexSuggestion;", "suggestIndexes", "enableConsent", "", "mergeSameSuggestions", "", "collectSuggestionsSuitableForDownload", "processSuggestions", "Lcom/intellij/indexing/shared/download/DownloadTaskContext;", "collectRequests", "Lkotlin/Pair;", "Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "resolveAndDownloadAndInstallIndexes", "requests", "makeIndicatorVisible", "Lkotlin/Function0;", "LookupChunkDescriptor", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nSharedIndexDownloadService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexDownloadService.kt\ncom/intellij/indexing/shared/download/SharedIndexDownloadService\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 ProgressIndicatorEx.kt\ncom/intellij/openapi/progress/ProgressIndicatorForCollections\n+ 7 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,314:1\n40#2,3:315\n40#2,3:321\n40#2,3:330\n40#2,3:401\n40#2,3:426\n40#2,3:441\n40#2,3:448\n40#2,3:455\n774#3:318\n865#3,2:319\n1202#3,2:324\n1230#3,4:326\n1485#3:335\n1510#3,3:336\n1513#3,3:346\n1498#3:387\n1528#3,3:388\n1531#3,3:398\n1557#3:429\n1628#3,3:430\n1557#3:451\n1628#3,3:452\n31#4,2:333\n31#4,2:446\n381#5,7:339\n381#5,7:391\n55#6,3:349\n28#6:352\n13#6,4:353\n29#6,14:357\n58#6,2:371\n44#6,5:373\n19#6,2:378\n49#6:380\n60#6,2:381\n13#6,4:383\n28#6:404\n13#6,4:405\n29#6,14:409\n44#6,5:433\n19#6,2:438\n49#6:440\n19#6,2:444\n29#7,3:423\n*S KotlinDebug\n*F\n+ 1 SharedIndexDownloadService.kt\ncom/intellij/indexing/shared/download/SharedIndexDownloadService\n*L\n55#1:315,3\n168#1:321,3\n191#1:330,3\n259#1:401,3\n284#1:426,3\n298#1:441,3\n124#1:448,3\n180#1:455,3\n144#1:318\n144#1:319,2\n187#1:324,2\n187#1:326,4\n197#1:335\n197#1:336,3\n197#1:346,3\n257#1:387\n257#1:388,3\n257#1:398,3\n285#1:429\n285#1:430,3\n151#1:451\n151#1:452,3\n195#1:333,2\n120#1:446,2\n197#1:339,7\n257#1:391,7\n233#1:349,3\n233#1:352\n233#1:353,4\n233#1:357,14\n233#1:371,2\n233#1:373,5\n233#1:378,2\n233#1:380\n233#1:381,2\n252#1:383,4\n262#1:404\n262#1:405,4\n262#1:409,14\n262#1:433,5\n262#1:438,2\n262#1:440\n252#1:444,2\n275#1:423,3\n*E\n"})
public final class SharedIndexDownloadService {
    @NotNull
    private final AtomicInteger rescanningCounter = new AtomicInteger();
    @NotNull
    private final Set<SharedIndexId> pendingSharedIndexes;

    public SharedIndexDownloadService() {
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.pendingSharedIndexes = set;
    }

    private final SharedIndexDownloadExecutor getExecutor() {
        boolean $i$f$service = false;
        Class<SharedIndexDownloadExecutor> serviceClass$iv = SharedIndexDownloadExecutor.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return (SharedIndexDownloadExecutor)object;
    }

    public final void waitRescanningCalmDown$intellij_indexing_shared() {
        int checkFrequencyInSec = SystemProperties.getIntProperty((String)"shared.index.check.frequency", (int)-1);
        int waitLimitInSec = SystemProperties.getIntProperty((String)"shared.index.wait.limit", (int)-1);
        int lastRescanningCount = -1;
        if (waitLimitInSec == -1 || checkFrequencyInSec == -1) {
            return;
        }
        long globalStart = System.nanoTime();
        do {
            int currentRescanningCount;
            if (lastRescanningCount == (currentRescanningCount = this.rescanningCounter.get())) {
                return;
            }
            lastRescanningCount = currentRescanningCount;
            long start = System.nanoTime();
            ProgressIndicatorUtils.awaitWithCheckCanceled(() -> SharedIndexDownloadService.waitRescanningCalmDown$lambda$0(start, checkFrequencyInSec));
        } while (System.nanoTime() - globalStart <= TimeUnit.SECONDS.toNanos(waitLimitInSec));
        throw new Error("Rescanning calm down waiting limit (" + waitLimitInSec + " secs) exceeded");
    }

    public final void rescanNow(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!SharedIndexDownloadServiceKt.access$isEnabled()) {
            return;
        }
        SharedIndexDownloadLoggerKt.getDownloadLogger().debug("Rescan");
        this.rescanningCounter.incrementAndGet();
        SharedIndexPerProjectTaskExpiration.Token expiration = SharedIndexPerProjectTaskExpiration.Companion.registerNewTask(project);
        this.getExecutor().submitPreProgressSync(project, (Function1<? super DownloadTaskContext, Unit>)((Function1)arg_0 -> SharedIndexDownloadService.rescanNow$lambda$2(expiration, this, project, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    public final void applySuggestions(@Nullable Project project, @NotNull List<? extends SharedIndexSuggestion> suggestions) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        if (!SharedIndexDownloadServiceKt.access$isEnabled() || suggestions.isEmpty()) {
            return;
        }
        Iterable $this$filter$iv = suggestions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SharedIndexSuggestion it = (SharedIndexSuggestion)element$iv$iv;
            boolean bl = false;
            if (!this.pendingSharedIndexes.add(it.getSharedIndexId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List onlyNewSuggestions = (List)destination$iv$iv;
        this.getExecutor().submitPreProgressSync(project, (Function1<? super DownloadTaskContext, Unit>)((Function1)arg_0 -> SharedIndexDownloadService.applySuggestions$lambda$5(this, project, onlyNewSuggestions, arg_0)));
    }

    @JvmOverloads
    public final void suggestIndexes(@NotNull Project project, @NotNull List<? extends SharedIndexSuggestion> suggestions, boolean enableConsent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        if (suggestions.isEmpty()) {
            return;
        }
        SharedIndexDownloadLoggerKt.getDownloadLogger().info("Got suggestion to download shared indexes " + CollectionsKt.joinToString$default((Iterable)suggestions, null, null, null, (int)0, null, null, (int)63, null) + ".");
        if (enableConsent) {
            boolean $i$f$service = false;
            Class<SharedIndexDownloadConsentStore> clazz = SharedIndexDownloadConsentStore.class;
            Object object = ApplicationManager.getApplication().getService(clazz);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + clazz.getName() + " (classloader=" + clazz.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            SharedIndexDownloadConsentStore consentStore = (SharedIndexDownloadConsentStore)((Object)object);
            for (SharedIndexSuggestion sharedIndexSuggestion : suggestions) {
                IndexDownloadConsentDecisionKey key = SharedIndexConsentStoreKt.toKey(sharedIndexSuggestion);
                if (consentStore.decisionFor(key, project) == IndexDownloadConsentDecision.DENIED) continue;
                consentStore.setDecisionFor(key, IndexDownloadConsentDecision.ALLOWED);
            }
        }
        this.getExecutor().submitPreProgressSync(project, (Function1<? super DownloadTaskContext, Unit>)((Function1)arg_0 -> SharedIndexDownloadService.suggestIndexes$lambda$7(suggestions, project, this, arg_0)));
    }

    public static /* synthetic */ void suggestIndexes$default(SharedIndexDownloadService sharedIndexDownloadService, Project project, List list, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        sharedIndexDownloadService.suggestIndexes(project, list, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final List<SharedIndexSuggestion> mergeSameSuggestions(Collection<? extends SharedIndexSuggestion> $this$mergeSameSuggestions) {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = $this$mergeSameSuggestions;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            SharedIndexSuggestion sharedIndexSuggestion = (SharedIndexSuggestion)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getSharedIndexId(), element$iv$iv);
        }
        return CollectionsKt.toList((Iterable)destination$iv$iv.values());
    }

    /*
     * WARNING - void declaration
     */
    private final List<SharedIndexSuggestion> collectSuggestionsSuitableForDownload(Project project) {
        List list;
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Iterable $this$service$iv;
        boolean $i$f$service = false;
        ComponentManager serviceClass$iv = SharedIndexDownloadHistoryStore.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        SharedIndexDownloadHistoryStore history = (SharedIndexDownloadHistoryStore)((Object)object);
        serviceClass$iv = (ComponentManager)project;
        boolean $i$f$service2 = false;
        Class<SharedIndexSuggestionService> serviceClass$iv2 = SharedIndexSuggestionService.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv2);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv2);
        }
        $this$service$iv = ((SharedIndexSuggestionService)object2).resolveSuggestions();
        boolean $i$f$groupBy = false;
        serviceClass$iv2 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object3;
            SharedIndexSuggestion it = (SharedIndexSuggestion)element$iv$iv;
            boolean bl = false;
            Boolean key$iv$iv = SharedIndexDownloadHistoryStore.isDownloadMakeSenseFor$default(history, it.getSharedIndexId(), false, 2, null);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            list$iv$iv.add(element$iv$iv);
        }
        Map allSuggestions = destination$iv$iv;
        List list2 = (List)allSuggestions.get(false);
        if (list2 != null) {
            List it = list2;
            boolean bl = false;
            String message = "There is no need to download shared indexes for " + CollectionsKt.joinToString$default((Iterable)it, null, null, null, (int)0, null, null, (int)63, null) + ". Similar compatible shared indexes are available locally.";
            if (SharedIndexDownloadLoggerKt.getDownloadLogger().isDebugEnabled()) {
                SharedIndexDownloadLoggerKt.getDownloadLogger().debug(message);
            } else {
                SharedIndexDownloadLoggerKt.getDownloadLogger().info(StringUtil.first((String)message, (int)300, (boolean)true));
            }
        }
        if ((list = (List)allSuggestions.get(true)) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final void processSuggestions(DownloadTaskContext $this$processSuggestions, Project project, List<? extends SharedIndexSuggestion> suggestions) {
        List<Pair<SharedIndexSuggestion, SharedIndexLookupRequest>> requests = this.collectRequests($this$processSuggestions.getIndicator(), suggestions);
        if (requests.isEmpty()) {
            return;
        }
        SharedIndexAuthKt.initiateAuthIfNeeded(requests, $this$processSuggestions.getIndicator(), SharedIndexAuthLifetimeHolder.Companion.getNextDisposable(project), (Function1<? super List<? extends Pair<? extends SharedIndexSuggestion, ? extends SharedIndexLookupRequest>>, Unit>)((Function1)arg_0 -> SharedIndexDownloadService.processSuggestions$lambda$14($this$processSuggestions, this, project, arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<Pair<SharedIndexSuggestion, SharedIndexLookupRequest>> collectRequests(ProgressIndicator indicator, List<? extends SharedIndexSuggestion> suggestions) {
        indicator.setText(SharedIndexesBundle.message("progress.text.resolving.shared.indexes.requests", new Object[0]));
        Collection $this$mapWithProgress$iv = suggestions;
        boolean $i$f$mapWithProgress = false;
        indicator.checkCanceled();
        List result$iv = new ArrayList();
        Collection $this$forEachWithProgress$iv$iv = $this$mapWithProgress$iv;
        boolean $i$f$forEachWithProgress = false;
        ProgressIndicator $this$withPushPop$iv$iv$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv$iv$iv = $this$withPushPop$iv$iv$iv.isIndeterminate();
        $this$withPushPop$iv$iv$iv.pushState();
        try {
            boolean bl = false;
            indicator.setIndeterminate(false);
            indicator.checkCanceled();
            double size$iv$iv = $this$forEachWithProgress$iv$iv.size();
            Iterator iterator = ((Iterable)$this$forEachWithProgress$iv$iv).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Pair pair;
                Collection collection;
                String prevText2$iv$iv;
                String prevText$iv$iv;
                block8: {
                    Pair pair2;
                    void it;
                    void it$iv;
                    int i$iv$iv = n++;
                    Object y$iv$iv = iterator.next();
                    indicator.checkCanceled();
                    double lowerBound$iv$iv = (double)i$iv$iv / size$iv$iv;
                    double upperBound$iv$iv = (double)(i$iv$iv + 1) / size$iv$iv;
                    indicator.setFraction(lowerBound$iv$iv);
                    prevText$iv$iv = indicator.getText();
                    prevText2$iv$iv = indicator.getText2();
                    ProgressIndicator progressIndicator = ProgressIndicatorForCollections.scaleFraction((ProgressIndicator)indicator, (double)lowerBound$iv$iv, (double)upperBound$iv$iv);
                    Object y$iv = y$iv$iv;
                    boolean bl2 = false;
                    void var27_25 = it$iv;
                    SharedIndexSuggestion sharedIndexSuggestion = (SharedIndexSuggestion)y$iv;
                    collection = result$iv;
                    boolean bl3 = false;
                    try {
                        void subIndicator;
                        SharedIndexLookupRequest request = it.resolveRequest((ProgressIndicator)subIndicator);
                        if (request == null) {
                            pair = null;
                            break block8;
                        }
                        pair2 = TuplesKt.to((Object)it, (Object)request);
                    }
                    catch (Throwable e) {
                        if (e instanceof ControlFlowException) {
                            throw e;
                        }
                        SharedIndexDownloadLoggerKt.getDownloadLogger().warn("Failed to create for shared index request for " + (SharedIndexSuggestion)it + ". " + e.getMessage(), e);
                        pair2 = null;
                    }
                    pair = pair2;
                }
                collection.add(pair);
                indicator.setText(prevText$iv$iv);
                indicator.setText2(prevText2$iv$iv);
            }
            indicator.setFraction(1.0);
        }
        finally {
            $this$withPushPop$iv$iv$iv.setIndeterminate(wasIndeterminate$iv$iv$iv);
            $this$withPushPop$iv$iv$iv.popState();
        }
        indicator.checkCanceled();
        return CollectionsKt.filterNotNull((Iterable)CollectionsKt.toList((Iterable)result$iv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void resolveAndDownloadAndInstallIndexes(Project project, ProgressIndicator indicator, List<? extends Pair<? extends SharedIndexSuggestion, ? extends SharedIndexLookupRequest>> requests, Function0<Unit> makeIndicatorVisible) {
        ProgressIndicator $this$withPushPop$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv = $this$withPushPop$iv.isIndeterminate();
        $this$withPushPop$iv.pushState();
        try {
            void $this$groupByTo$iv$iv;
            void $this$groupBy$iv;
            boolean bl = false;
            SharedIndexInfrastructureVersion sharedIndexInfrastructureVersion = SharedIndexInfrastructureVersion.getIdeVersion();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)sharedIndexInfrastructureVersion), (String)"getIdeVersion(...)");
            SharedIndexInfrastructureVersion ideVersion = sharedIndexInfrastructureVersion;
            Iterable iterable = requests;
            boolean $i$f$groupBy = false;
            void var12_13 = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                void it;
                Object object;
                Pair it2 = (Pair)element$iv$iv;
                boolean $i$a$-groupBy-SharedIndexDownloadService$resolveAndDownloadAndInstallIndexes$1$uniqueRequests$32 = false;
                SharedIndexLookupRequest key$iv$iv = (SharedIndexLookupRequest)it2.getSecond();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                Pair $i$a$-groupBy-SharedIndexDownloadService$resolveAndDownloadAndInstallIndexes$1$uniqueRequests$32 = (Pair)element$iv$iv;
                List list = list$iv$iv;
                boolean bl3 = false;
                list.add((SharedIndexSuggestion)it.getFirst());
            }
            Set uniqueRequests = destination$iv$iv.entrySet();
            boolean $i$f$service = false;
            Class<SharedIndexLookup> serviceClass$iv = SharedIndexLookup.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            SharedIndexLookup indexLookup = (SharedIndexLookup)object;
            List infos = new ArrayList();
            Collection $this$forEachWithProgress$iv = uniqueRequests;
            boolean $i$f$forEachWithProgress = false;
            ProgressIndicator $this$withPushPop$iv$iv = indicator;
            boolean $i$f$withPushPop2 = false;
            boolean wasIndeterminate$iv$iv = $this$withPushPop$iv$iv.isIndeterminate();
            $this$withPushPop$iv$iv.pushState();
            try {
                boolean bl4 = false;
                indicator.setIndeterminate(false);
                indicator.checkCanceled();
                double size$iv = $this$forEachWithProgress$iv.size();
                Iterator iterator = ((Iterable)$this$forEachWithProgress$iv).iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    String prevText2$iv;
                    String prevText$iv;
                    block21: {
                        SharedIndexLookupResult sharedIndexLookupResult;
                        void subIndicator;
                        int i$iv = n++;
                        Object y$iv = iterator.next();
                        indicator.checkCanceled();
                        double lowerBound$iv = (double)i$iv / size$iv;
                        double upperBound$iv = (double)(i$iv + 1) / size$iv;
                        indicator.setFraction(lowerBound$iv);
                        prevText$iv = indicator.getText();
                        prevText2$iv = indicator.getText2();
                        ProgressIndicator progressIndicator = ProgressIndicatorForCollections.scaleFraction((ProgressIndicator)indicator, (double)lowerBound$iv, (double)upperBound$iv);
                        Map.Entry entry = (Map.Entry)y$iv;
                        boolean bl5 = false;
                        SharedIndexLookupRequest lookupRequest = (SharedIndexLookupRequest)entry.getKey();
                        List suggestions = (List)entry.getValue();
                        try {
                            if (indexLookup.lookupSharedIndex(lookupRequest, ideVersion, (ProgressIndicator)subIndicator) == null) break block21;
                        }
                        catch (Throwable e) {
                            if (e instanceof ControlFlowException) {
                                throw e;
                            }
                            SharedIndexDownloadLoggerKt.getDownloadLogger().warn("Failed to lookup for shared index " + lookupRequest + " (" + suggestions + "). " + e.getMessage(), e);
                            break block21;
                        }
                        SharedIndexLookupResult lookupResult = sharedIndexLookupResult;
                        makeIndicatorVisible.invoke();
                        try {
                            DownloadIndexResult hadDownloadedSomething;
                            boolean $i$f$measureTimeMillis = false;
                            long start$iv = System.currentTimeMillis();
                            boolean bl6 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)((Object)SharedIndexChunkConfiguration.getInstance().downloadChunk(new LookupChunkDescriptor(lookupResult), project, (ProgressIndicator)subIndicator)), (String)"downloadChunk(...)");
                            if (hadDownloadedSomething == DownloadIndexResult.JUST_DOWNLOADED) {
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                long downloadTime = System.currentTimeMillis() - start$iv;
                                boolean $i$f$service22 = false;
                                Class<SharedIndexDownloadHistoryStore> serviceClass$iv2 = SharedIndexDownloadHistoryStore.class;
                                Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv2);
                                if (object2 == null) {
                                    throw new RuntimeException("Cannot find service " + serviceClass$iv2.getName() + " (classloader=" + serviceClass$iv2.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                                }
                                Iterable $i$f$service22 = suggestions;
                                SharedIndexDownloadHistoryStore sharedIndexDownloadHistoryStore = (SharedIndexDownloadHistoryStore)((Object)object2);
                                boolean $i$f$map = false;
                                void var52_64 = $this$map$iv;
                                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                    void it;
                                    SharedIndexSuggestion sharedIndexSuggestion = (SharedIndexSuggestion)item$iv$iv;
                                    Collection collection = destination$iv$iv2;
                                    boolean bl7 = false;
                                    collection.add(it.getSharedIndexId());
                                }
                                sharedIndexDownloadHistoryStore.updateLastDownload((List)destination$iv$iv2, lookupResult.getChunkUniqueId(), lookupResult.getSize());
                                ((Collection)infos).add(new SharedIndexDownloadInfo(suggestions, lookupResult.getSize(), downloadTime));
                            }
                        }
                        catch (Throwable e) {
                            if (e instanceof ControlFlowException) {
                                throw e;
                            }
                            SharedIndexDownloadLoggerKt.getDownloadLogger().warn("Failed to download shared index " + lookupResult + " (" + suggestions + "). " + e.getMessage(), e);
                        }
                    }
                    indicator.setText(prevText$iv);
                    indicator.setText2(prevText2$iv);
                }
                indicator.setFraction(1.0);
            }
            finally {
                $this$withPushPop$iv$iv.setIndeterminate(wasIndeterminate$iv$iv);
                $this$withPushPop$iv$iv.popState();
            }
            boolean $i$f$service2 = false;
            Class<SharedIndexDownloadNotifications> serviceClass$iv3 = SharedIndexDownloadNotifications.class;
            Object object3 = ApplicationManager.getApplication().getService(serviceClass$iv3);
            if (object3 == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv3.getName() + " (classloader=" + serviceClass$iv3.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((SharedIndexDownloadNotifications)object3).notifySharedIndexInstalled(project, infos);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$withPushPop$iv.setIndeterminate(wasIndeterminate$iv);
            $this$withPushPop$iv.popState();
        }
    }

    @JvmOverloads
    public final void suggestIndexes(@NotNull Project project, @NotNull List<? extends SharedIndexSuggestion> suggestions) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        SharedIndexDownloadService.suggestIndexes$default(this, project, suggestions, false, 4, null);
    }

    private static final Boolean waitRescanningCalmDown$lambda$0(long $start, int $checkFrequencyInSec) {
        return System.nanoTime() - $start > TimeUnit.SECONDS.toNanos($checkFrequencyInSec);
    }

    private static final Unit rescanNow$lambda$2$lambda$1(SharedIndexDownloadService this$0, Project $project, List $allowedSuggestions) {
        this$0.applySuggestions($project, $allowedSuggestions);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit rescanNow$lambda$2(SharedIndexPerProjectTaskExpiration.Token $expiration, SharedIndexDownloadService this$0, Project $project, DownloadTaskContext $this$submitPreProgressSync) {
        Class serviceClass$iv;
        boolean $i$f$service;
        List<SharedIndexSuggestion> list;
        SharedIndexDownloadService sharedIndexDownloadService;
        Intrinsics.checkNotNullParameter((Object)$this$submitPreProgressSync, (String)"$this$submitPreProgressSync");
        if ($expiration.isExpired()) {
            SharedIndexDownloadLoggerKt.getDownloadLogger().debug("Expired");
            return Unit.INSTANCE;
        }
        SharedIndexDownloadService sharedIndexDownloadService2 = this$0;
        try {
            sharedIndexDownloadService = sharedIndexDownloadService2;
            list = this$0.collectSuggestionsSuitableForDownload($project);
        }
        catch (Throwable throwable) {
            void t;
            SharedIndexDownloadService sharedIndexDownloadService3 = sharedIndexDownloadService2;
            if (t instanceof ControlFlowException) {
                throw t;
            }
            SharedIndexDownloadLoggerKt.getDownloadLogger().warn("Failed to collect suggested shared indexes. " + t.getMessage(), (Throwable)t);
            return Unit.INSTANCE;
        }
        List<SharedIndexSuggestion> suggestions = sharedIndexDownloadService.mergeSameSuggestions((Collection<? extends SharedIndexSuggestion>)list);
        SharedIndexDownloadLoggerKt.getDownloadLogger().trace("All project suggestions: [" + suggestions + "]");
        if (suggestions.isEmpty()) {
            return Unit.INSTANCE;
        }
        if (!ProjectUtil.isNotificationSilentMode((Project)$project)) {
            ComponentManager $this$service$iv = (ComponentManager)$project;
            $i$f$service = false;
            serviceClass$iv = IndexDownloadConsentService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((IndexDownloadConsentService)object).askForMoreDownloads(suggestions, $project);
        }
        $i$f$service = false;
        serviceClass$iv = SharedIndexDownloadConsentStore.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        List<SharedIndexSuggestion> allowedSuggestions = ((SharedIndexDownloadConsentStore)((Object)object)).filterAllowed(suggestions, $project);
        if (allowedSuggestions.isEmpty()) {
            SharedIndexDownloadLoggerKt.getDownloadLogger().debug("All suggestions are not allowed");
            return Unit.INSTANCE;
        }
        SharedIndexDownloadLoggerKt.getDownloadLogger().debug("Allowed suggestion: [" + suggestions + "]");
        $this$submitPreProgressSync.queueChildTask((Function0<Unit>)((Function0)() -> SharedIndexDownloadService.rescanNow$lambda$2$lambda$1(this$0, $project, allowedSuggestions)));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit applySuggestions$lambda$5(SharedIndexDownloadService this$0, Project $project, List $onlyNewSuggestions, DownloadTaskContext $this$submitPreProgressSync) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$submitPreProgressSync, (String)"$this$submitPreProgressSync");
        try {
            this$0.processSuggestions($this$submitPreProgressSync, $project, $onlyNewSuggestions);
        }
        catch (Throwable throwable) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Iterable $i$f$map = $onlyNewSuggestions;
            Set<SharedIndexId> set = this$0.pendingSharedIndexes;
            boolean $i$f$map2 = false;
            void destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                SharedIndexSuggestion sharedIndexSuggestion2 = (SharedIndexSuggestion)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean $i$a$-map-SharedIndexDownloadService$applySuggestions$1$2 = false;
                collection.add(it.getSharedIndexId());
            }
            set.removeAll(CollectionsKt.toSet((Iterable)((List)destination$iv$iv2)));
            throw throwable;
        }
        Iterable iterable = $onlyNewSuggestions;
        Set<SharedIndexId> set = this$0.pendingSharedIndexes;
        boolean $i$f$map = false;
        void var6_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SharedIndexSuggestion sharedIndexSuggestion = (SharedIndexSuggestion)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean sharedIndexSuggestion2 = false;
            collection.add(it.getSharedIndexId());
        }
        set.removeAll(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        return Unit.INSTANCE;
    }

    private static final Unit suggestIndexes$lambda$7$lambda$6(List $suggestions, Project $project, SharedIndexDownloadService this$0) {
        boolean $i$f$service = false;
        Class<SharedIndexDownloadConsentStore> serviceClass$iv = SharedIndexDownloadConsentStore.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        List<SharedIndexSuggestion> actualSuggestions = ((SharedIndexDownloadConsentStore)((Object)object)).filterAllowed($suggestions, $project);
        this$0.applySuggestions($project, actualSuggestions);
        return Unit.INSTANCE;
    }

    private static final Unit suggestIndexes$lambda$7(List $suggestions, Project $project, SharedIndexDownloadService this$0, DownloadTaskContext $this$submitPreProgressSync) {
        Intrinsics.checkNotNullParameter((Object)$this$submitPreProgressSync, (String)"$this$submitPreProgressSync");
        $this$submitPreProgressSync.queueChildTask((Function0<Unit>)((Function0)() -> SharedIndexDownloadService.suggestIndexes$lambda$7$lambda$6($suggestions, $project, this$0)));
        return Unit.INSTANCE;
    }

    private static final Unit processSuggestions$lambda$14$lambda$13$lambda$12$lambda$11(SharedIndexDownloadService this$0, Project $project, DownloadTaskContext $this_submitPreProgressSync, List $authRequests) {
        this$0.resolveAndDownloadAndInstallIndexes($project, $this_submitPreProgressSync.getIndicator(), $authRequests, (Function0<Unit>)((Function0)new Function0<Unit>((Object)$this_submitPreProgressSync){

            public final void invoke() {
                ((DownloadTaskContext)this.receiver).ensureBackgroundableProgressShown();
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit processSuggestions$lambda$14$lambda$13$lambda$12(Project $project, SharedIndexDownloadService this$0, List $authRequests, DownloadTaskContext $this$submitPreProgressSync) {
        Intrinsics.checkNotNullParameter((Object)$this$submitPreProgressSync, (String)"$this$submitPreProgressSync");
        SharedIndexDownloadExecutorKt.suspendIndexingIfNeededWhileDownloading($project, () -> SharedIndexDownloadService.processSuggestions$lambda$14$lambda$13$lambda$12$lambda$11(this$0, $project, $this$submitPreProgressSync, $authRequests));
        return Unit.INSTANCE;
    }

    private static final Unit processSuggestions$lambda$14$lambda$13(SharedIndexDownloadService this$0, Project $project, List $authRequests) {
        this$0.getExecutor().submitPreProgressSync($project, (Function1<? super DownloadTaskContext, Unit>)((Function1)arg_0 -> SharedIndexDownloadService.processSuggestions$lambda$14$lambda$13$lambda$12($project, this$0, $authRequests, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit processSuggestions$lambda$14(DownloadTaskContext $this_processSuggestions, SharedIndexDownloadService this$0, Project $project, List authRequests) {
        Intrinsics.checkNotNullParameter((Object)authRequests, (String)"authRequests");
        $this_processSuggestions.queueChildTask((Function0<Unit>)((Function0)() -> SharedIndexDownloadService.processSuggestions$lambda$14$lambda$13(this$0, $project, authRequests)));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexDownloadService$LookupChunkDescriptor;", "Lcom/intellij/indexing/shared/platform/api/ChunkDescriptor;", "lookupResult", "Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;", "<init>", "(Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;)V", "chunkUniqueId", "", "getChunkUniqueId", "()Ljava/lang/String;", "kind", "getKind", "downloadChunk", "", "targetFile", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "chunkStorageOption", "Lcom/intellij/indexing/shared/platform/impl/ChunkStorageOption;", "getChunkStorageOption", "()Lcom/intellij/indexing/shared/platform/impl/ChunkStorageOption;", "toString", "intellij.indexing.shared"})
    private static final class LookupChunkDescriptor
    implements ChunkDescriptor {
        @NotNull
        private final SharedIndexLookupResult lookupResult;
        @NotNull
        private final String chunkUniqueId;
        @NotNull
        private final String kind;
        @NotNull
        private final ChunkStorageOption chunkStorageOption;

        public LookupChunkDescriptor(@NotNull SharedIndexLookupResult lookupResult) {
            Intrinsics.checkNotNullParameter((Object)lookupResult, (String)"lookupResult");
            this.lookupResult = lookupResult;
            this.chunkUniqueId = this.lookupResult.getChunkUniqueId();
            this.kind = this.lookupResult.getRequest().getKind();
            this.chunkStorageOption = ChunkStorageOption.APPENDABLE;
        }

        @Override
        @NotNull
        public String getChunkUniqueId() {
            return this.chunkUniqueId;
        }

        @Override
        @NotNull
        public String getKind() {
            return this.kind;
        }

        @Override
        public boolean downloadChunk(@NotNull Path targetFile, @Nullable Project project, @NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            return SharedIndexLookupResultKt.downloadChunk(this.lookupResult, targetFile, project, indicator);
        }

        @Override
        @NotNull
        public ChunkStorageOption getChunkStorageOption() {
            return this.chunkStorageOption;
        }

        @NotNull
        public String toString() {
            return this.getChunkUniqueId();
        }
    }
}

