/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedNameResolver;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSConstStatusOwner;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCastExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptStringLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSBigIntLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSExoticStringLiteralType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTaggedLiteralKeyTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeKeyTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUniqueSymbolTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.TripleFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptLiteralKeyUtil {
    private static final Key<CachedValue<ConcurrentMap<String, PsiElement>>> CACHE_KEY = Key.create((String)"TypeScriptLiteralKeyUtil.getTypeForComputedPropExpression");
    private static final CachedValueProvider<ConcurrentMap<String, PsiElement>> PROVIDER = () -> CachedValueProvider.Result.create((Object)ContainerUtil.createConcurrentSoftValueMap(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});

    @Nullable
    public static JSType modifyStringLiteralTypeForTaggedLiteralType(@NotNull JSExpression rawqualifier, @NotNull JSStringLiteralTypeImpl type2, @Nullable PsiElement parent) {
        if (rawqualifier == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(0);
        }
        if (type2 == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(1);
        }
        if (parent instanceof TypeScriptEnumField) {
            return TypeScriptLiteralKeyUtil.createTaggedTypeForEnumField((PsiElement)rawqualifier, type2, (TypeScriptEnumField)parent);
        }
        if (!(parent instanceof TypeScriptStringLiteralType)) {
            return null;
        }
        return JSTaggedLiteralKeyTypeImpl.tryCreate(rawqualifier.getParent(), (TypeScriptType)parent, type2.getLiteral());
    }

    @Nullable
    private static JSTaggedLiteralKeyTypeImpl createTaggedTypeForEnumField(@NotNull PsiElement context2, @NotNull JSStringLiteralTypeImpl type2, @NotNull TypeScriptEnumField parent) {
        TypeScriptEnum owner;
        if (context2 == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(2);
        }
        if (type2 == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(4);
        }
        if ((owner = parent.getOwner()) == null) {
            return null;
        }
        String qualifiedName = owner.getQualifiedName();
        if (qualifiedName == null) {
            return null;
        }
        return new JSTaggedLiteralKeyTypeImpl(type2.getLiteral(), Collections.singleton(parent), JSTypeSourceFactory.createTypeSource(context2, true));
    }

    @Nullable
    public static JSType modifyStringLiteralTypeByContextualType(@NotNull JSExpression rawqualifier, @NotNull JSStringLiteralTypeImpl type2) {
        JSType contextualType;
        if (rawqualifier == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(5);
        }
        if (type2 == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(6);
        }
        if ((contextualType = TypeScriptLiteralKeyUtil.findContextualTypeForLiteralLocation(rawqualifier)) == null) {
            return null;
        }
        if (contextualType instanceof JSGenericParameterImpl) {
            contextualType = ((JSGenericParameterImpl)contextualType).getConstraintType();
        }
        if ((contextualType = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(contextualType, (PsiElement)rawqualifier)) instanceof JSTypeWithIncompleteSubstitution) {
            contextualType = ((JSTypeWithIncompleteSubstitution)contextualType).substituteCompletely();
        }
        LinkedHashSet<PsiElement> sourceElements = new LinkedHashSet<PsiElement>();
        ArrayList<PsiElement> typesWithAliases = new ArrayList<PsiElement>();
        String literal = type2.getLiteral();
        JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)t -> {
            if (t instanceof JSTypeKeyTypeImpl) {
                if (literal.equals(((JSTypeKeyTypeImpl)t).getLiteral())) {
                    sourceElements.addAll(((JSTypeKeyTypeImpl)t).getKeySourceElements());
                }
            } else if (t instanceof JSTaggedLiteralKeyTypeImpl) {
                Collection<PsiElement> elements = ((JSTaggedLiteralKeyTypeImpl)t).getReferencedElements();
                typesWithAliases.addAll(elements);
            } else if (t instanceof JSResolvableType) {
                JSResolvedTypeInfo typeInfo = ((JSResolvableType)t).resolveType();
                if (typeInfo.isEnumLiteral()) {
                    Collection<TypeScriptEnumField> fields = typeInfo.getDeclarationsOfType(TypeScriptEnumField.class);
                    if (fields.size() == 1) {
                        TypeScriptLiteralKeyUtil.addFromEnumField(rawqualifier, typesWithAliases, t, fields.iterator().next());
                    }
                } else if (typeInfo.isEnumWithLiteralValues()) {
                    for (TypeScriptEnum typeScriptEnum : typeInfo.getDeclarationsOfType(TypeScriptEnum.class)) {
                        for (JSField field : typeScriptEnum.getFields()) {
                            if (!(field instanceof TypeScriptEnumField)) continue;
                            TypeScriptLiteralKeyUtil.addFromEnumField(rawqualifier, typesWithAliases, t, (TypeScriptEnumField)field);
                        }
                    }
                }
            }
            return true;
        }), contextualType, false, true, true);
        if (!sourceElements.isEmpty()) {
            return JSTypeKeyTypeImpl.createKeyType(type2.getLiteral(), sourceElements, false, type2.getSource());
        }
        if (!typesWithAliases.isEmpty()) {
            return new JSTaggedLiteralKeyTypeImpl(type2.getLiteral(), typesWithAliases, type2.getSource());
        }
        return null;
    }

    private static void addFromEnumField(@NotNull JSExpression rawqualifier, List<PsiElement> referencedElements, JSType t, TypeScriptEnumField field) {
        String stringValue;
        if (rawqualifier == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(7);
        }
        if ((stringValue = field.getConstantValue().getStringValue()) == null) {
            return;
        }
        JSTaggedLiteralKeyTypeImpl taggedType = TypeScriptLiteralKeyUtil.createTaggedTypeForEnumField((PsiElement)rawqualifier, new JSStringLiteralTypeImpl(stringValue, false, t.getSource()), field);
        Collection<Object> elements = taggedType == null ? Collections.emptyList() : taggedType.getReferencedElements();
        referencedElements.addAll(elements);
    }

    @Nullable
    private static JSType findContextualTypeForLiteralLocation(@NotNull JSExpression rawqualifier) {
        PsiElement parent;
        if (rawqualifier == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(8);
        }
        if ((parent = rawqualifier.getParent()) instanceof JSParenthesizedExpression) {
            return TypeScriptLiteralKeyUtil.findContextualTypeForLiteralLocation((JSExpression)parent);
        }
        if (parent instanceof JSBinaryExpression) {
            boolean onlyRightArgAccepted;
            IElementType operationSign = ((JSBinaryExpression)parent).getOperationSign();
            boolean bl = onlyRightArgAccepted = operationSign == JSTokenTypes.ANDAND || operationSign == JSTokenTypes.COMMA;
            if (operationSign == JSTokenTypes.OROR || onlyRightArgAccepted) {
                JSExpression lOperand = ((JSBinaryExpression)parent).getLOperand();
                JSExpression rOperand = ((JSBinaryExpression)parent).getROperand();
                if (lOperand == rawqualifier && !onlyRightArgAccepted || rOperand == rawqualifier) {
                    return TypeScriptLiteralKeyUtil.findContextualTypeForLiteralLocation((JSExpression)parent);
                }
            } else if (operationSign == JSTokenTypes.EQEQ || operationSign == JSTokenTypes.EQEQEQ || operationSign == JSTokenTypes.NE || operationSign == JSTokenTypes.NEQEQ) {
                JSType type2;
                JSExpression lOperand = ((JSBinaryExpression)parent).getLOperand();
                JSExpression rOperand = ((JSBinaryExpression)parent).getROperand();
                if (lOperand == rawqualifier && rOperand != null) {
                    JSType type3 = JSResolveUtil.getExpressionJSType(rOperand);
                    if (type3 != null) {
                        return type3;
                    }
                } else if (rOperand == rawqualifier && lOperand != null && (type2 = JSResolveUtil.getExpressionJSType(lOperand)) != null) {
                    return type2;
                }
            }
            return JSDialectSpecificHandlersFactory.findExpectedType(rawqualifier, JSExpectedTypeKind.CONTEXTUAL);
        }
        if (parent instanceof TypeScriptCastExpression && ((TypeScriptCastExpression)parent).getExpression() == rawqualifier) {
            return TypeScriptLiteralKeyUtil.findContextualTypeForLiteralLocation((JSExpression)parent);
        }
        if (parent instanceof JSConditionalExpression && (((JSConditionalExpression)parent).getThenBranch() == rawqualifier || ((JSConditionalExpression)parent).getElseBranch() == rawqualifier)) {
            return TypeScriptLiteralKeyUtil.findContextualTypeForLiteralLocation((JSExpression)parent);
        }
        if (parent instanceof JSCaseClause) {
            JSSwitchStatement switchStatement = ((JSCaseClause)parent).getSwitchStatement();
            if (switchStatement == null) {
                return null;
            }
            JSExpression expression = switchStatement.getSwitchExpression();
            if (expression == null) {
                return null;
            }
            return JSResolveUtil.getExpressionJSType(expression);
        }
        return JSDialectSpecificHandlersFactory.findExpectedType(rawqualifier, JSExpectedTypeKind.CONTEXTUAL);
    }

    @Nullable
    public static JSType getTypeFromComputedNameProperty(@NotNull JSType ownerType, @NotNull JSType parameterType, @Nullable PsiElement location) {
        if (ownerType == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(9);
        }
        if (parameterType == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(10);
        }
        return (JSType)TypeScriptLiteralKeyUtil.evalForAllProperties(ownerType, location, (o, e, i) -> TypeScriptLiteralKeyUtil.getTypeForComputedNameMember(parameterType, o, e), false);
    }

    @Nullable
    public static <T> T evalForAllProperties(@NotNull JSType ownerType, @Nullable PsiElement location, @NotNull TripleFunction<? super PsiElement, ? super PsiElement, ? super Integer, ? extends T> func, boolean enumerateAllMatches) {
        if (ownerType == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(11);
        }
        if (func == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(12);
        }
        JSType finalType = (ownerType = JSTypeUtils.unwrapType(ownerType)) instanceof JSGenericTypeImpl ? JSTypeUtils.unwrapType(((JSGenericTypeImpl)ownerType).getType()) : ownerType;
        if ((finalType = finalType.substitute(location)) instanceof TypeScriptGenericThisTypeImpl) {
            finalType = finalType.substitute(location);
        }
        if (finalType instanceof JSResolvableType) {
            T t;
            JSResolvedTypeInfo resolvedTypeInfo = ((JSResolvableType)finalType).resolveType();
            JSClass jsClass = resolvedTypeInfo.getDeclarationOfType(JSClass.class);
            if (jsClass != null && (t = TypeScriptLiteralKeyUtil.addForClass(ownerType, func, enumerateAllMatches, jsClass)) != null) {
                return t;
            }
        } else if (finalType instanceof JSSimpleRecordTypeImpl) {
            T t;
            PsiElement sourceElement = finalType.getSource().getSourceElement();
            if (sourceElement instanceof JSObjectLiteralExpression) {
                for (JSProperty member : ((JSObjectLiteralExpression)sourceElement).getProperties()) {
                    Object type2 = func.fun((Object)member, (Object)ownerType.getSource().getSourceElement(), (Object)0);
                    if (enumerateAllMatches || type2 == null) continue;
                    return (T)type2;
                }
            } else if (sourceElement instanceof TypeScriptObjectType) {
                for (TypeScriptTypeMember member : ((TypeScriptObjectType)sourceElement).getTypeMembers()) {
                    Object type3 = func.fun((Object)member, (Object)ownerType.getSource().getSourceElement(), (Object)0);
                    if (enumerateAllMatches || type3 == null) continue;
                    return (T)type3;
                }
            } else if (sourceElement instanceof JSClassExpression && (t = TypeScriptLiteralKeyUtil.addForClass(ownerType, func, enumerateAllMatches, (JSClassExpression)sourceElement)) != null) {
                return t;
            }
        }
        return null;
    }

    @Nullable
    private static <T> T addForClass(@NotNull JSType ownerType, @NotNull TripleFunction<? super PsiElement, ? super PsiElement, ? super Integer, ? extends T> func, boolean enumerateAllMatches, @NotNull JSClass jsClass) {
        if (ownerType == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(13);
        }
        if (func == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(14);
        }
        if (jsClass == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(15);
        }
        Ref ref2 = Ref.create(null);
        JSClassUtils.processClassesInHierarchy(jsClass, true, (currentClass, typeSubstitutor, fromImplements, fromStaticContext, depth) -> {
            for (PsiElement psiElement : currentClass.getMembers()) {
                Object type2 = func.fun((Object)psiElement, (Object)ownerType.getSourceElement(), (Object)depth);
                if (enumerateAllMatches || type2 == null) continue;
                if (type2 instanceof JSType) {
                    type2 = JSTypeUtils.applyGenericArguments((JSType)type2, typeSubstitutor);
                }
                ref2.set(type2);
                return false;
            }
            return true;
        });
        return (T)ref2.get();
    }

    public static PsiElement resolveElementInScopeByQualifiedName(@NotNull String name, @NotNull PsiElement scopeContext) {
        if (name == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(16);
        }
        if (scopeContext == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(17);
        }
        Collection<PsiElement> results = new TypeScriptQualifiedNameResolver(scopeContext, true).resolveQualifiedName(name);
        return (PsiElement)ContainerUtil.getFirstItem(results);
    }

    private static PsiElement resolveElementInScope(@NotNull Pair<PsiElement, String> key) {
        if (key == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(18);
        }
        return (PsiElement)RecursionManager.doPreventingRecursion(key, (boolean)false, () -> TypeScriptLiteralKeyUtil.resolveElementInScopeByQualifiedName((String)key.second, (PsiElement)key.first));
    }

    @Nullable
    public static JSType getTypeForComputedPropExpression(@NotNull ES6ComputedName computedPropertyName) {
        String name;
        if (computedPropertyName == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(19);
        }
        if ((name = computedPropertyName.getExpressionAsReferenceName()) == null) {
            return null;
        }
        return TypeScriptLiteralKeyUtil.getTypeForComputedName((PsiElement)computedPropertyName, name);
    }

    @Nullable
    public static JSType getTypeForComputedName(@NotNull PsiElement context2, @NotNull String name) {
        PsiElement element;
        if (context2 == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(20);
        }
        if (name == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(21);
        }
        if ((element = TypeScriptLiteralKeyUtil.getCachedResolvedElementInScope(context2, name)) == null) {
            return null;
        }
        if (element instanceof JSLiteralExpression) {
            return JSResolveUtil.getExpressionJSType((JSExpression)element);
        }
        JSType value = TypeScriptLiteralKeyUtil.getTypeFromEnumField(element);
        if (value != null) {
            return value;
        }
        if (!(!DialectDetector.isJavaScript(context2) || element instanceof JSConstStatusOwner && ((JSConstStatusOwner)element).isConst())) {
            return JSTypeUtils.getTypeOfElement(element);
        }
        if (element instanceof JSImplicitElement) {
            return (JSType)ObjectUtils.doIfNotNull((Object)((JSImplicitElement)element).getJSType(), JSType::substitute);
        }
        return JSResolveUtil.getElementJSType(element);
    }

    public static boolean isTypeUsableAsPropertyName(@Nullable JSType type2) {
        return type2 instanceof JSStringLiteralTypeImpl || type2 instanceof JSNumberLiteralTypeImpl || type2 instanceof JSUniqueSymbolTypeImpl;
    }

    @Nullable
    private static PsiElement getCachedResolvedElementInScope(@NotNull PsiElement holder, @NotNull String name) {
        if (holder == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(22);
        }
        if (name == null) {
            TypeScriptLiteralKeyUtil.$$$reportNull$$$0(23);
        }
        ConcurrentMap cached = (ConcurrentMap)CachedValuesManager.getManager((Project)holder.getProject()).getCachedValue((UserDataHolder)holder, CACHE_KEY, PROVIDER, false);
        return cached.computeIfAbsent(name, key -> TypeScriptLiteralKeyUtil.resolveElementInScope((Pair<PsiElement, String>)Pair.create((Object)holder, (Object)key)));
    }

    @Nullable
    private static JSType getTypeFromEnumField(@Nullable PsiElement element) {
        EnumConstantValue value;
        if (element instanceof TypeScriptEnumField && (value = ((TypeScriptEnumField)element).getConstantValue()).isLiteral()) {
            JSType type2 = value.getExpandedJSType(element);
            return type2 instanceof JSBigIntLiteralTypeImpl ? null : type2;
        }
        return null;
    }

    @Contract(value="_, null, _ -> null")
    @Nullable
    public static JSType getTypeForComputedNameMember(@Nullable JSType parameterType, @Nullable PsiElement member, @Nullable PsiElement sourceElement) {
        JSType fromEnumField;
        JSResolvedTypeInfo info;
        if (!(member instanceof JSProperty) && !(member instanceof JSField)) {
            return null;
        }
        ES6ComputedName computedPropertyName = ((JSComputedPropertyNameOwner)member).getComputedPropertyName();
        if (computedPropertyName == null) {
            return null;
        }
        JSPrimitiveLiteralType<String> expressionJSType = TypeScriptLiteralKeyUtil.getTypeForComputedPropExpression(computedPropertyName);
        if (!(expressionJSType instanceof JSLiteralType)) {
            return null;
        }
        if (expressionJSType instanceof JSExoticStringLiteralType) {
            expressionJSType = ((JSExoticStringLiteralType)((Object)expressionJSType)).asSimpleLiteralType();
        }
        if (parameterType instanceof JSResolvableType && (info = ((JSResolvableType)parameterType).resolveType()).isEnumLiteral() && (fromEnumField = TypeScriptLiteralKeyUtil.getTypeFromEnumField((PsiElement)info.getDeclarationOfType(TypeScriptEnumField.class))) != null) {
            parameterType = fromEnumField;
        }
        if (!expressionJSType.isEquivalentTo(parameterType, null, false) && !((JSLiteralType)expressionJSType).copyWithAllowWidening(false).isEquivalentTo(parameterType, null, false)) {
            return null;
        }
        JSType type2 = ((JSTypeOwner)member).getJSType();
        if (type2 == null) {
            return null;
        }
        if (sourceElement instanceof JSIndexedPropertyAccessExpression) {
            JSExpression qualifier = ((JSIndexedPropertyAccessExpression)sourceElement).getQualifier();
            type2 = qualifier == null ? type2 : JSGenericTypesEvaluator.getEvaluator((PsiElement)qualifier).evaluateGenericsFromQualifier(type2, qualifier, (JSExpression)sourceElement);
        }
        return type2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawqualifier";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 16: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeContext";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computedPropertyName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptLiteralKeyUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "modifyStringLiteralTypeForTaggedLiteralType";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createTaggedTypeForEnumField";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "modifyStringLiteralTypeByContextualType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addFromEnumField";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findContextualTypeForLiteralLocation";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getTypeFromComputedNameProperty";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "evalForAllProperties";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "addForClass";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveElementInScopeByQualifiedName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveElementInScope";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "getTypeForComputedPropExpression";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "getTypeForComputedName";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "getCachedResolvedElementInScope";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

