/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.lang.html.HtmlCompatibleFile;
import com.intellij.lang.javascript.editor.JSEditorOptions;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDocCopyPastePreProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        if (!JSDocCopyPastePreProcessor.isSupportedFile(file) || !JSDocCopyPastePreProcessor.isEnabled()) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return null;
        }
        CharSequence chars = document.getImmutableCharSequence();
        StringBuilder builder2 = new StringBuilder();
        String prefix = "/**";
        String suffix = "*/";
        block0: for (int i = 0; i < startOffsets.length; ++i) {
            int start = startOffsets[i];
            int end = endOffsets[i];
            PsiElement comment = PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(start), JSDocComment.class, (boolean)false);
            if (comment == null || !comment.textContains('\n')) {
                return null;
            }
            TextRange commentRange = comment.getTextRange();
            if (!CharArrayUtil.regionMatches((CharSequence)chars, (int)commentRange.getStartOffset(), (CharSequence)prefix) || !CharArrayUtil.regionMatches((CharSequence)chars, (int)(commentRange.getEndOffset() - suffix.length()), (CharSequence)suffix)) {
                return null;
            }
            TextRange body = TextRange.create((int)(commentRange.getStartOffset() + prefix.length()), (int)(commentRange.getEndOffset() - suffix.length()));
            if (!body.containsRange(start, end)) {
                return null;
            }
            int lineIdx = 0;
            int lastLineEndOffset = DocumentUtil.getLineEndOffset((int)end, (Document)document);
            int from = start;
            while (from < end) {
                int lineEndOffset;
                int to;
                int lineStartOffset = DocumentUtil.getLineStartOffset((int)from, (Document)document);
                int indent = CharArrayUtil.shiftForward((CharSequence)chars, (int)lineStartOffset, (int)(to = Math.min(lineEndOffset = DocumentUtil.getLineEndOffset((int)from, (Document)document), end)), (String)" \t");
                if (StringUtil.isChar((CharSequence)chars, (int)indent, (char)'*')) {
                    if (StringUtil.isChar((CharSequence)chars, (int)(++indent), (char)' ')) {
                        ++indent;
                    }
                    from = Math.min(Math.max(from, indent), to);
                }
                if (indent >= to && lastLineEndOffset == lineEndOffset) continue block0;
                if (lineIdx > 0) {
                    builder2.append('\n');
                }
                builder2.append(chars, from, to);
                from = to + 1;
                ++lineIdx;
            }
        }
        return builder2.toString();
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        int firstNonWsLineOffset;
        if (!JSDocCopyPastePreProcessor.isSupportedFile(file) || !JSDocCopyPastePreProcessor.isEnabled()) {
            String string = text;
            if (string == null) {
                JSDocCopyPastePreProcessor.$$$reportNull$$$0(0);
            }
            return string;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        int start = selectionModel.getSelectionStart();
        int end = selectionModel.getSelectionEnd();
        boolean hasSelection = selectionModel.hasSelection();
        TextRange selectionRange = TextRange.create((int)start, (int)end);
        PsiElement element = file.findElementAt(start);
        JSDocComment docComment = (JSDocComment)PsiTreeUtil.getParentOfType((PsiElement)element, JSDocComment.class, (boolean)false);
        if (docComment == null || !docComment.getTextRange().contains(selectionRange)) {
            String string = text;
            if (string == null) {
                JSDocCopyPastePreProcessor.$$$reportNull$$$0(1);
            }
            return string;
        }
        Document document = editor.getDocument();
        int lineStartOffset = DocumentUtil.getLineStartOffset((int)start, (Document)document);
        CharSequence chars = document.getImmutableCharSequence();
        if (chars.charAt(firstNonWsLineOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)lineStartOffset, (String)" \t")) != '*') {
            String string = text;
            if (string == null) {
                JSDocCopyPastePreProcessor.$$$reportNull$$$0(2);
            }
            return string;
        }
        Object firstLinePrefix = "";
        if (firstNonWsLineOffset >= start) {
            if (!hasSelection || !selectionRange.contains(firstNonWsLineOffset)) {
                String string = text;
                if (string == null) {
                    JSDocCopyPastePreProcessor.$$$reportNull$$$0(3);
                }
                return string;
            }
            firstLinePrefix = chars.subSequence(start, firstNonWsLineOffset + 1).toString();
            if (!text.startsWith(" ")) {
                firstLinePrefix = (String)firstLinePrefix + " ";
            }
        } else if (!text.startsWith(" ") && firstNonWsLineOffset + 1 == start) {
            firstLinePrefix = " ";
        }
        String lineStartReplacement = "\n" + String.valueOf(chars.subSequence(lineStartOffset, firstNonWsLineOffset + 1)) + " ";
        String string = (String)firstLinePrefix + StringUtil.trimTrailing((String)text, (char)'\n').replace("\n", lineStartReplacement);
        if (string == null) {
            JSDocCopyPastePreProcessor.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static boolean isSupportedFile(@NotNull PsiFile file) {
        if (file == null) {
            JSDocCopyPastePreProcessor.$$$reportNull$$$0(5);
        }
        return file instanceof JSFile || file instanceof HtmlCompatibleFile;
    }

    private static boolean isEnabled() {
        return JSEditorOptions.getInstance().ESCAPE_DOC_ON_COPY_PASTE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/editing/JSDocCopyPastePreProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/editing/JSDocCopyPastePreProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5 -> new IllegalArgumentException(string);
        };
    }
}

