/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.typescript.TypeScriptStubElementTypes;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSFormatterUtil {
    private JSFormatterUtil() {
    }

    public static boolean startsWith(@Nullable ASTNode node, @NotNull IElementType type2) {
        if (type2 == null) {
            JSFormatterUtil.$$$reportNull$$$0(0);
        }
        if (node == null) {
            return false;
        }
        if (node.getElementType() == type2) {
            return true;
        }
        return JSFormatterUtil.startsWith(node.getFirstChildNode(), type2);
    }

    public static boolean isSameLineComment(@NotNull ASTNode node) {
        if (node == null) {
            JSFormatterUtil.$$$reportNull$$$0(1);
        }
        if (JSTokenTypes.COMMENTS.contains(node.getElementType())) {
            ASTNode prev = node.getTreePrev();
            return !(prev.getPsi() instanceof PsiWhiteSpace) || !prev.textContains('\n');
        }
        return false;
    }

    public static boolean isEnterAtNewArgument(@NotNull FormattingMode formattingMode, @Nullable ASTNode child) {
        if (formattingMode == null) {
            JSFormatterUtil.$$$reportNull$$$0(2);
        }
        if (formattingMode != FormattingMode.ADJUST_INDENT_ON_ENTER || child == null) {
            return false;
        }
        return child.getElementType() != JSTokenTypes.LPAR && (child.getElementType() != JSTokenTypes.RPAR || FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)JSTokenTypes.COMMA, (IElementType[])new IElementType[]{TokenType.ERROR_ELEMENT}));
    }

    @Nullable
    public static Wrap createSharedWrapForChildren(@NotNull ASTNode node, CommonCodeStyleSettings commonSettings, JSCodeStyleSettings dialectSettings) {
        if (node == null) {
            JSFormatterUtil.$$$reportNull$$$0(3);
        }
        return JSFormatterUtil.checkShouldWrapEveryItem(node.getElementType(), commonSettings, dialectSettings) ? Wrap.createWrap((int)4, (boolean)true) : null;
    }

    public static boolean checkShouldWrapEveryItem(IElementType nodeType, CommonCodeStyleSettings commonSettings, JSCodeStyleSettings dialectSettings) {
        return JSFormatterUtil.shouldWrapEveryItem(nodeType, JSElementTypes.BINARY_EXPRESSION, commonSettings.BINARY_OPERATION_WRAP) || JSFormatterUtil.shouldWrapEveryItem(nodeType, JSElementTypes.ARRAY_LITERAL_EXPRESSION, commonSettings.ARRAY_INITIALIZER_WRAP) || JSFormatterUtil.shouldWrapEveryItem(nodeType, JSElementTypes.PARAMETER_LISTS, commonSettings.METHOD_PARAMETERS_WRAP) || JSFormatterUtil.shouldWrapEveryItem(nodeType, JSElementTypes.FOR_STATEMENT, commonSettings.FOR_STATEMENT_WRAP) || JSFormatterUtil.shouldWrapEveryItem(nodeType, JSElementTypes.CONDITIONAL_EXPRESSION, commonSettings.TERNARY_OPERATION_WRAP) || JSFormatterUtil.shouldWrapEveryItem(nodeType, JSStubElementTypes.OBJECT_LITERAL_EXPRESSION, dialectSettings.OBJECT_LITERAL_WRAP) || JSFormatterUtil.shouldWrapEveryItem(nodeType, JSStubElementTypes.DESTRUCTURING_OBJECT, dialectSettings.OBJECT_LITERAL_WRAP) || JSFormatterUtil.shouldWrapEveryItem(nodeType, (IElementType)JSStubElementTypes.NAMED_IMPORTS, dialectSettings.IMPORTS_WRAP) || JSFormatterUtil.shouldWrapEveryItem(nodeType, (IElementType)JSStubElementTypes.EXPORT_DECLARATION, dialectSettings.IMPORTS_WRAP) || JSFormatterUtil.shouldWrapEveryItem(nodeType, JSStubElementTypes.VAR_STATEMENT, dialectSettings.VAR_DECLARATION_WRAP) || JSFormatterUtil.shouldWrapEveryItem(nodeType, JSElementTypes.EXTENDS_IMPLEMENTS_LISTS, commonSettings.EXTENDS_LIST_WRAP) || JSFormatterUtil.shouldWrapEveryItem(nodeType, TypeScriptStubElementTypes.UNION_OR_INTERSECTION_TYPE, dialectSettings.UNION_TYPES_WRAP) || JSFormatterUtil.shouldWrapEveryItem(nodeType, TypeScriptStubElementTypes.OBJECT_TYPE, dialectSettings.OBJECT_TYPES_WRAP) || JSFormatterUtil.shouldWrapEveryItem(nodeType, TypeScriptStubElementTypes.CONDITIONAL_TYPE, commonSettings.TERNARY_OPERATION_WRAP) || JSFormatterUtil.shouldWrapEveryItem(nodeType, TypeScriptStubElementTypes.ENUM_FIELD_STATEMENT, commonSettings.ENUM_CONSTANTS_WRAP) || JSFormatterUtil.shouldWrapEveryItem(nodeType, TypeScriptStubElementTypes.TYPE_PARAMETER_LIST, commonSettings.METHOD_PARAMETERS_WRAP);
    }

    public static boolean shouldWrapEveryItem(int settingsValue) {
        return (settingsValue & 4) != 0;
    }

    private static boolean shouldWrapEveryItem(IElementType nodeType, TokenSet expectedTypes, int settingsValue) {
        return expectedTypes.contains(nodeType) && JSFormatterUtil.shouldWrapEveryItem(settingsValue);
    }

    private static boolean shouldWrapEveryItem(IElementType nodeType, IElementType expectedType, int wrapType) {
        return nodeType == expectedType && JSFormatterUtil.shouldWrapEveryItem(wrapType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingMode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/formatter/JSFormatterUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "startsWith";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSameLineComment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnterAtNewArgument";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createSharedWrapForChildren";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

