/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.typings;

import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.typings.TypeScriptDefinitionsUtils;
import com.intellij.lang.javascript.library.typings.TypeScriptExternalDefinitionsContributor;
import com.intellij.lang.javascript.library.typings.TypeScriptExternalDefinitionsRegistry;
import com.intellij.lang.javascript.library.typings.TypeScriptExternalDefinitionsServiceKt;
import com.intellij.lang.javascript.library.typings.TypeScriptExternalDefinitionsServiceState;
import com.intellij.lang.javascript.library.typings.TypeScriptPackageName;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.SemVer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="TypeScriptExternalDefinitions", storages={@Storage(value="$CACHE_FILE$", roamingType=RoamingType.DISABLED)})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001%B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0012\u001a\u00020\u000bJ\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u000eJ\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000eH\u0002J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0015H\u0002J\b\u0010\u001c\u001a\u00020\u000bH\u0002J\b\u0010\u001d\u001a\u00020\u000bH\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\u0002H\u0016J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsService;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsServiceState;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "installRequests", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "usedExternalDefinitions", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/util/text/SemVer;", "pendingRootsChanged", "Ljava/util/concurrent/atomic/AtomicBoolean;", "scheduleUpdate", "getCachedExternalDefinitions", "", "Lcom/intellij/lang/javascript/library/typings/TypeScriptPackageName;", "resolveCachedExternalDefinitionForPackage", "sourcePackage", "evictInstalledDefinitionFromCache", "packageName", "cacheInstalledDefinition", "typingsPackage", "installForProject", "fireRootsChanged", "installTypeDefinitionsPackage", "", "registry", "Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsRegistry;", "getState", "loadState", "state", "Companion", "intellij.javascript.impl"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nTypeScriptExternalDefinitionsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptExternalDefinitionsService.kt\ncom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsService\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,238:1\n153#2,3:239\n1#3:242\n1863#4,2:243\n1246#4,4:246\n412#5:245\n*S KotlinDebug\n*F\n+ 1 TypeScriptExternalDefinitionsService.kt\ncom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsService\n*L\n94#1:239,3\n165#1:243,2\n217#1:246,4\n217#1:245\n*E\n"})
public final class TypeScriptExternalDefinitionsService
implements PersistentStateComponent<TypeScriptExternalDefinitionsServiceState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final MutableSharedFlow<Unit> installRequests;
    @NotNull
    private final ConcurrentHashMap<String, SemVer> usedExternalDefinitions;
    @NotNull
    private final AtomicBoolean pendingRootsChanged;

    public TypeScriptExternalDefinitionsService(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.installRequests = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        this.usedExternalDefinitions = new ConcurrentHashMap();
        this.pendingRootsChanged = new AtomicBoolean();
        SimpleMessageBusConnection connection = this.project.getMessageBus().connect(coroutineScope);
        Topic<PackageJsonFileManager.PackageJsonChangesListener> topic = PackageJsonFileManager.CHANGES_TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"CHANGES_TOPIC");
        connection.subscribe(topic, arg_0 -> TypeScriptExternalDefinitionsService._init_$lambda$0(this, arg_0));
        Topic<JSLibraryManager.JSLibraryManagerChangeListener> topic2 = JSLibraryManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"TOPIC");
        connection.subscribe(topic2, () -> TypeScriptExternalDefinitionsService._init_$lambda$1(this));
        Registry.Companion.get("typescript.external.type.definitions").addListener(new RegistryValueListener(){

            public void afterValueChanged(RegistryValue value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.fireRootsChanged();
            }
        }, coroutineScope);
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ TypeScriptExternalDefinitionsService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.collectLatest((Flow)FlowKt.debounce-HG0u8IE((Flow)((Flow)this.this$0.installRequests), (long)DurationKt.toDuration((int)3, (DurationUnit)DurationUnit.SECONDS)), (Function2)((Function2)new Function2<Unit, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ TypeScriptExternalDefinitionsService this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.this$0.installForProject();
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Unit p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void scheduleUpdate() {
        if (!TypeScriptExternalDefinitionsRegistry.Companion.isEnabled()) {
            return;
        }
        if (TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().isDebugEnabled()) {
            TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().debug("Scheduling update. Used definitions: " + this.getCachedExternalDefinitions(), new Throwable());
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.installForProject();
        } else if (!this.installRequests.tryEmit((Object)Unit.INSTANCE)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<TypeScriptPackageName> getCachedExternalDefinitions() {
        if (TypeScriptExternalDefinitionsRegistry.Companion.isEnabled()) {
            void var2_2;
            void $this$mapTo$iv;
            Map map2 = this.usedExternalDefinitions;
            Collection destination$iv = new HashSet();
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv;
                Map.Entry entry = item$iv = iterator.next();
                Collection collection = destination$iv;
                boolean bl = false;
                collection.add(new TypeScriptPackageName((String)it.getKey(), (SemVer)it.getValue(), false, 4, null));
            }
            return (Set)var2_2;
        }
        return SetsKt.emptySet();
    }

    @Nullable
    public final TypeScriptPackageName resolveCachedExternalDefinitionForPackage(@NotNull String sourcePackage) {
        TypeScriptPackageName typeScriptPackageName;
        Intrinsics.checkNotNullParameter((Object)sourcePackage, (String)"sourcePackage");
        if (!TypeScriptExternalDefinitionsRegistry.Companion.isEnabled()) {
            return null;
        }
        String packageName = TypeScriptDefinitionsUtils.getTypingsPackageName(sourcePackage);
        SemVer semVer = this.usedExternalDefinitions.get(packageName);
        if (semVer != null) {
            SemVer it = semVer;
            boolean bl = false;
            typeScriptPackageName = new TypeScriptPackageName(packageName, it, false, 4, null);
        } else {
            typeScriptPackageName = null;
        }
        return typeScriptPackageName;
    }

    private final void evictInstalledDefinitionFromCache(String packageName) {
        this.usedExternalDefinitions.remove(packageName);
    }

    private final void cacheInstalledDefinition(TypeScriptPackageName typingsPackage) {
        if (!TypeScriptDefinitionsUtils.isTypingsPackage(typingsPackage.getName())) {
            throw new IllegalStateException("Check failed.");
        }
        String string = typingsPackage.getName();
        SemVer semVer = typingsPackage.getVersion();
        Intrinsics.checkNotNull((Object)semVer);
        this.usedExternalDefinitions.put(string, semVer);
    }

    private final void installForProject() {
        if (this.project.isDisposed() || !TypeScriptExternalDefinitionsRegistry.Companion.isEnabled()) {
            return;
        }
        if (TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().isDebugEnabled()) {
            TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().debug("Install type definitions for project [" + this.project.getName() + "] started");
        }
        HashSet<String> definitions = new HashSet<String>();
        HashSet<String> changedDefinitions = new HashSet<String>();
        TypeScriptExternalDefinitionsRegistry registry = TypeScriptExternalDefinitionsRegistry.Companion.getInstance();
        for (TypeScriptExternalDefinitionsContributor contributor : TypeScriptExternalDefinitionsContributor.Companion.getEP_NAME().getExtensionList()) {
            for (TypeScriptPackageName typeDefinition : contributor.getTypeDefinitions(this.project)) {
                if (!TypeScriptDefinitionsUtils.isTypingsPackage(typeDefinition.getName()) || typeDefinition.getVersion() == null) {
                    TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().warn("Invalid type definition package contributed: " + typeDefinition);
                    continue;
                }
                if (!definitions.add(typeDefinition.getName())) continue;
                if (registry.ensureExternalDefinitionsInstalled$intellij_javascript_impl(typeDefinition)) {
                    if (this.usedExternalDefinitions.containsKey(typeDefinition.getName())) continue;
                    changedDefinitions.add(typeDefinition.getName());
                    this.cacheInstalledDefinition(typeDefinition);
                    continue;
                }
                if (!this.installTypeDefinitionsPackage(typeDefinition, registry)) continue;
                if (registry.ensureExternalDefinitionsInstalled$intellij_javascript_impl(typeDefinition)) {
                    changedDefinitions.add(typeDefinition.getName());
                    this.cacheInstalledDefinition(typeDefinition);
                    continue;
                }
                TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().warn("Installation completed but not succeeded: " + typeDefinition);
            }
        }
        Set set = this.usedExternalDefinitions.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        Set removedDefinitions = SetsKt.minus((Set)set, (Iterable)definitions);
        Iterable $this$forEach$iv = removedDefinitions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String p0 = (String)element$iv;
            boolean bl = false;
            this.evictInstalledDefinitionFromCache(p0);
        }
        if (!((Collection)changedDefinitions).isEmpty() || !((Collection)removedDefinitions).isEmpty()) {
            TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().info("Type definition roots changed: project [" + this.project.getName() + "], added/updated " + changedDefinitions + ", removed: " + removedDefinitions);
            this.fireRootsChanged();
        }
        if (TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().isDebugEnabled()) {
            TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().debug("Install type definitions for project [" + this.project.getName() + "] completed");
        }
    }

    private final void fireRootsChanged() {
        if (this.pendingRootsChanged.compareAndSet(false, true)) {
            ReadAction.run(() -> TypeScriptExternalDefinitionsService.fireRootsChanged$lambda$6(this));
        }
    }

    private final boolean installTypeDefinitionsPackage(TypeScriptPackageName typingsPackage, TypeScriptExternalDefinitionsRegistry registry) {
        try {
            ProgressIndicator progress;
            boolean installed;
            ProgressIndicator progressIndicator;
            if (TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().isDebugEnabled()) {
                TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().debug("Begin typings package installation: " + typingsPackage);
            }
            if ((progressIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator()) == null) {
                progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
            }
            boolean bl = installed = registry.installPackage(typingsPackage, this.project, progress = progressIndicator).get(2L, TimeUnit.MINUTES) != null;
            if (!installed) {
                TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().warn("Package " + typingsPackage + " is not installed");
            }
            return installed;
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            TypeScriptExternalDefinitionsServiceKt.access$getLOG$p().warn("Unable to install package " + typingsPackage, (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public TypeScriptExternalDefinitionsServiceState getState() {
        void $this$mapValuesTo$iv;
        Map map2 = this.usedExternalDefinitions;
        Map destination$iv = new HashMap();
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv = $this$mapValuesTo$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            void it$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            Map map3 = destination$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv;
            Object k = it$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            String string = ((SemVer)it.getValue()).getParsedVersion();
            map4.put(k, string);
        }
        HashMap packages = (HashMap)destination$iv;
        return packages.isEmpty() ? TypeScriptExternalDefinitionsServiceKt.access$getEMPTY_STATE$p() : new TypeScriptExternalDefinitionsServiceState(packages);
    }

    public void loadState(@NotNull TypeScriptExternalDefinitionsServiceState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        for (Map.Entry<String, String> entry : state.getPackages().entrySet()) {
            if (!(((CharSequence)entry.getValue()).length() > 0)) continue;
            this.cacheInstalledDefinition(TypeScriptPackageName.Companion.from(entry.getKey(), entry.getValue()));
        }
    }

    private static final void _init_$lambda$0(TypeScriptExternalDefinitionsService this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.scheduleUpdate();
    }

    private static final void _init_$lambda$1(TypeScriptExternalDefinitionsService this$0) {
        this$0.scheduleUpdate();
    }

    private static final Unit fireRootsChanged$lambda$6$lambda$5$lambda$4(TypeScriptExternalDefinitionsService this$0) {
        ProjectRootManagerEx.getInstanceEx((Project)this$0.project).makeRootsChange(EmptyRunnable.getInstance(), RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void fireRootsChanged$lambda$6$lambda$5(TypeScriptExternalDefinitionsService this$0) {
        try {
            ActionsKt.runWriteAction(() -> TypeScriptExternalDefinitionsService.fireRootsChanged$lambda$6$lambda$5$lambda$4(this$0));
        }
        finally {
            this$0.pendingRootsChanged.set(false);
        }
    }

    private static final void fireRootsChanged$lambda$6(TypeScriptExternalDefinitionsService this$0) {
        if (this$0.project.isDisposed()) {
            return;
        }
        DumbService.Companion.getInstance(this$0.project).runWhenSmart(() -> TypeScriptExternalDefinitionsService.fireRootsChanged$lambda$6$lambda$5(this$0));
    }

    @JvmStatic
    @NotNull
    public static final TypeScriptExternalDefinitionsService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nTypeScriptExternalDefinitionsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptExternalDefinitionsService.kt\ncom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,238:1\n31#2,2:239\n*S KotlinDebug\n*F\n+ 1 TypeScriptExternalDefinitionsService.kt\ncom/intellij/lang/javascript/library/typings/TypeScriptExternalDefinitionsService$Companion\n*L\n231#1:239,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TypeScriptExternalDefinitionsService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<TypeScriptExternalDefinitionsService> serviceClass$iv = TypeScriptExternalDefinitionsService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (TypeScriptExternalDefinitionsService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

