/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.javascript.psi.ExpectedTypeEvaluator;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexedAccessType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptStringLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSKeyofType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeKeyTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptCompilerEvaluationFacade;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptExpectedTypeEvaluator
extends ExpectedTypeEvaluator {
    public TypeScriptExpectedTypeEvaluator(PsiElement parent, JSExpectedTypeKind expectedTypeKind) {
        super(parent, expectedTypeKind);
    }

    @Override
    protected JSType fixResultForOrOrRightOp(@Nullable JSType type2, @Nullable JSExpression operand) {
        return type2 == null ? JSResolveUtil.getExpressionJSType(operand) : type2;
    }

    @Override
    public void visitTypeScriptLiteralType(@NotNull TypeScriptLiteralType node) {
        JSExpression expression;
        if (node == null) {
            TypeScriptExpectedTypeEvaluator.$$$reportNull$$$0(0);
        }
        if ((expression = node.getExpression()) != this.myElement) {
            return;
        }
        TypeScriptType type2 = TypeScriptPsiUtil.getParentTypeViaUnionsAndIntersections(node, this.myExpectedTypeKind == JSExpectedTypeKind.EXPECTED);
        PsiElement typeParent = type2.getParent();
        if (typeParent instanceof TypeScriptTypeArgumentList) {
            this.computeForTypeArgumentsListItem(type2, (TypeScriptTypeArgumentList)typeParent);
        }
        if (typeParent instanceof TypeScriptIndexedAccessType) {
            this.computeForIndexerArgument((TypeScriptIndexedAccessType)typeParent);
        }
    }

    private void computeForIndexerArgument(@NotNull TypeScriptIndexedAccessType parent) {
        TypeScriptType element;
        if (parent == null) {
            TypeScriptExpectedTypeEvaluator.$$$reportNull$$$0(1);
        }
        if ((element = parent.getOwnerTypeElement()) == null) {
            return;
        }
        JSType indexed = element.getJSType();
        HashMap<String, PsiElement> privateNames = new HashMap<String, PsiElement>();
        TypeScriptExpectedTypeEvaluator.addPrivateNames(indexed, privateNames);
        JSType operatorType = JSCompositeTypeFactory.createKeyOfType(indexed, JSTypeSourceFactory.createTypeSource((PsiElement)parent, true));
        if (privateNames.isEmpty()) {
            this.setResult(operatorType);
            return;
        }
        ArrayList<JSType> allTypes = new ArrayList<JSType>(privateNames.size() + 1);
        allTypes.add(operatorType);
        for (Map.Entry name : privateNames.entrySet()) {
            allTypes.add(JSTypeKeyTypeImpl.createKeyType((String)name.getKey(), Collections.singleton((PsiElement)name.getValue()), false, operatorType.getSource()));
        }
        this.setResult(JSCompositeTypeFactory.createUnionType(operatorType.getSource(), allTypes));
    }

    private static void addPrivateNames(@Nullable JSType expanded, @NotNull Map<String, PsiElement> privateNames) {
        block5: {
            block4: {
                if (privateNames == null) {
                    TypeScriptExpectedTypeEvaluator.$$$reportNull$$$0(2);
                }
                if (!(expanded instanceof JSResolvableType)) break block4;
                JSResolvedTypeInfo resolvedType = ((JSResolvableType)expanded).resolveType();
                for (JSClass aClass : resolvedType.getDeclarationsOfType(JSClass.class)) {
                    for (PsiElement psiElement : aClass.getMembers()) {
                        if (!(psiElement instanceof JSRecordType.PropertySignature) || ((JSRecordType.PropertySignature)psiElement).getAccessType() == JSAttributeList.AccessType.PUBLIC) continue;
                        privateNames.put(((JSRecordType.PropertySignature)psiElement).getMemberName(), psiElement);
                    }
                }
                break block5;
            }
            if (!(expanded instanceof JSIntersectionType)) break block5;
            for (JSType type2 : ((JSIntersectionType)expanded).getTypes()) {
                TypeScriptExpectedTypeEvaluator.addPrivateNames(type2, privateNames);
            }
        }
    }

    private void computeForTypeArgumentsListItem(@NotNull TypeScriptType type2, @NotNull TypeScriptTypeArgumentList typeParent) {
        Object[] typeArguments2;
        int index;
        if (type2 == null) {
            TypeScriptExpectedTypeEvaluator.$$$reportNull$$$0(3);
        }
        if (typeParent == null) {
            TypeScriptExpectedTypeEvaluator.$$$reportNull$$$0(4);
        }
        if ((index = ArrayUtil.indexOf((Object[])(typeArguments2 = typeParent.getTypeArguments()), (Object)type2)) < 0) {
            return;
        }
        JSReferenceExpression referenceExpression = TypeScriptExpectedTypeEvaluator.getReferenceForGrandParent(typeParent.getParent());
        if (referenceExpression == null) {
            return;
        }
        PsiElement element = referenceExpression.resolve();
        if (!(element instanceof TypeScriptTypeParameterListOwner)) {
            return;
        }
        TypeScriptTypeParameterList typeParams = ((TypeScriptTypeParameterListOwner)element).getTypeParameterList();
        if (typeParams == null) {
            return;
        }
        TypeScriptTypeParameter[] typeParameters2 = typeParams.getTypeParameters();
        if (typeParameters2.length <= index) {
            return;
        }
        TypeScriptTypeParameter param = typeParameters2[index];
        if (param == null) {
            return;
        }
        TypeScriptType constraint = param.getTypeConstraint();
        if (constraint == null) {
            return;
        }
        JSType cType = TypeScriptExpectedTypeEvaluator.modifyTypeForOmit(element, constraint.getJSType(), typeParent, index);
        JSTypeSubstitutor subst = !JSTypeUtils.hasForeignGenericParameter(cType) ? JSTypeSubstitutor.EMPTY : TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(typeParameters2, (List<? extends JSType>)ContainerUtil.map((Object[])typeArguments2, a -> a.getJSType()));
        this.setResult(JSTypeUtils.applyGenericArguments(cType, subst));
    }

    @Nullable
    private static JSReferenceExpression getReferenceForGrandParent(@Nullable PsiElement grandParent) {
        if (grandParent instanceof TypeScriptSingleType) {
            return ((TypeScriptSingleType)grandParent).getReferenceExpression();
        }
        if (grandParent instanceof JSReferenceListMember) {
            return (JSReferenceExpression)ObjectUtils.tryCast((Object)((JSReferenceListMember)grandParent).getExpression(), JSReferenceExpression.class);
        }
        return null;
    }

    @NotNull
    private static JSType modifyTypeForOmit(@NotNull PsiElement element, @NotNull JSType cType, @NotNull TypeScriptTypeArgumentList typeParent, int index) {
        JSTypeDeclaration firstType;
        JSType type2;
        if (element == null) {
            TypeScriptExpectedTypeEvaluator.$$$reportNull$$$0(5);
        }
        if (cType == null) {
            TypeScriptExpectedTypeEvaluator.$$$reportNull$$$0(6);
        }
        if (typeParent == null) {
            TypeScriptExpectedTypeEvaluator.$$$reportNull$$$0(7);
        }
        if (index == 1 && element instanceof TypeScriptTypeAlias && "Omit".equals(((TypeScriptTypeAlias)element).getName()) && cType instanceof JSKeyofType && JSTypeUtils.isAnyType(type2 = ((JSKeyofType)cType).getReferencedType()) && (firstType = typeParent.getTypeArguments()[0]) != null) {
            JSType jSType = JSCompositeTypeFactory.createUnionType(cType.getSource(), cType, JSCompositeTypeFactory.createKeyOfType(firstType.getJSType(), cType.getSource()));
            if (jSType == null) {
                TypeScriptExpectedTypeEvaluator.$$$reportNull$$$0(8);
            }
            return jSType;
        }
        JSType jSType = cType;
        if (jSType == null) {
            TypeScriptExpectedTypeEvaluator.$$$reportNull$$$0(9);
        }
        return jSType;
    }

    @Override
    protected void computeExpectedType() {
        JSType typeFromService2 = this.getContextualTypeFromService();
        if (typeFromService2 != null) {
            this.setResult(typeFromService2);
        } else {
            super.computeExpectedType();
        }
    }

    @Nullable
    private JSType getContextualTypeFromService() {
        if (this.myExpectedTypeKind == JSExpectedTypeKind.TYPE_CHECKING) {
            return null;
        }
        PsiElement psiElement = this.myElement;
        if (!(psiElement instanceof JSExpression)) {
            return null;
        }
        JSExpression expression = (JSExpression)psiElement;
        if (!Registry.is((String)"typescript.service.powered.contextual.types")) {
            return null;
        }
        if (this.myParent instanceof TypeScriptStringLiteralType) {
            return null;
        }
        TypeScriptCompilerEvaluationFacade instance = (TypeScriptCompilerEvaluationFacade)expression.getProject().getService(TypeScriptCompilerEvaluationFacade.class);
        if (!instance.isAnyEnabled()) {
            return null;
        }
        JSExpression originalElement = (JSExpression)CompletionUtil.getOriginalElement((PsiElement)expression);
        if (originalElement == null) {
            return null;
        }
        return instance.getContextualTypeFromService(originalElement, this.myExpectedTypeKind == JSExpectedTypeKind.EXPECTED);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "privateNames";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cType";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/TypeScriptExpectedTypeEvaluator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/TypeScriptExpectedTypeEvaluator";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "modifyTypeForOmit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptLiteralType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "computeForIndexerArgument";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addPrivateNames";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeForTypeArgumentsListItem";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "modifyTypeForOmit";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9 -> new IllegalStateException(string);
        };
    }
}

