/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import org.jetbrains.annotations.NotNull;

public final class JSBooleanLiteralTypeImpl
extends JSBooleanType
implements JSPrimitiveLiteralType<Boolean> {
    private final boolean myLiteral;
    private final boolean myAllowWidening;

    public JSBooleanLiteralTypeImpl(boolean literal, boolean allowWidening, @NotNull JSTypeSource source) {
        if (source == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(0);
        }
        super(true, source, JSTypeContext.INSTANCE);
        this.myLiteral = literal;
        this.myAllowWidening = allowWidening;
    }

    JSBooleanLiteralTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator serialized) {
        if (source == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(1);
        }
        if (serialized == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(2);
        }
        super(source, serialized);
        this.myLiteral = JSTypeSerializer.readBoolean(serialized);
        this.myAllowWidening = JSTypeSerializer.readBoolean(serialized);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(3);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeBoolean(this.myLiteral, outputStream);
        JSTypeSerializer.writeBoolean(this.myAllowWidening, outputStream);
    }

    @Override
    @NotNull
    public Boolean getLiteral() {
        Boolean bl = this.myLiteral;
        if (bl == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(4);
        }
        return bl;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(5);
        }
        if (processingContext == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(6);
        }
        if (elementType instanceof JSBooleanLiteralTypeImpl && this.isSourceStrict() && elementType.isSourceStrict() && !this.myAllowWidening) {
            return this.myLiteral == ((JSBooleanLiteralTypeImpl)elementType).myLiteral;
        }
        if (!this.myAllowWidening && elementType instanceof JSBooleanType) {
            return this.isJavaScript() || elementType.isJavaScript();
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type2, ProcessingContext processingContext, boolean allowResolve) {
        if (type2 == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(7);
        }
        return this.myLiteral == ((JSBooleanLiteralTypeImpl)type2).myLiteral && super.isEquivalentToWithSameClass(type2, processingContext, allowResolve);
    }

    @Override
    @NotNull
    protected JSBooleanLiteralTypeImpl copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(8);
        }
        return new JSBooleanLiteralTypeImpl((boolean)this.getLiteral(), this.myAllowWidening, source);
    }

    @Override
    @NotNull
    public String getPrimitiveTypeText() {
        String string = super.getPrimitiveTypeText();
        if (string == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public boolean allowWidening() {
        return this.myAllowWidening;
    }

    @Override
    @NotNull
    public JSLiteralType copyWithAllowWidening(boolean allowWidening) {
        if (this.myAllowWidening == allowWidening) {
            JSBooleanLiteralTypeImpl jSBooleanLiteralTypeImpl = this;
            if (jSBooleanLiteralTypeImpl == null) {
                JSBooleanLiteralTypeImpl.$$$reportNull$$$0(10);
            }
            return jSBooleanLiteralTypeImpl;
        }
        return new JSBooleanLiteralTypeImpl(this.myLiteral, allowWidening, this.getSource());
    }

    @Override
    @NotNull
    public String getValueAsString() {
        String string = this.getDefaultValue();
        if (string == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDefaultValue() {
        String string = Boolean.toString(this.myLiteral);
        if (string == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serialized";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSBooleanLiteralTypeImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSBooleanLiteralTypeImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteral";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimitiveTypeText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithAllowWidening";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueAsString";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

