/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractSuper;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.refactoring.BaseJSRefactoringHandler;
import com.intellij.lang.javascript.refactoring.extractSuper.JSCustomExtractInterfaceHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSExtractInterfaceHandler
extends BaseJSRefactoringHandler {
    private final BiFunction<? super JSClass, ? super JSElement, ? extends RefactoringDialog> myDialogFactory;

    public JSExtractInterfaceHandler(BiFunction<? super JSClass, ? super JSElement, ? extends RefactoringDialog> factory) {
        super(JSExtractInterfaceHandler.getRefactoringName(), JSExtractInterfaceHandler.getCannotRefactorReason());
        this.myDialogFactory = factory;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            JSExtractInterfaceHandler.$$$reportNull$$$0(0);
        }
        if (editor != null) {
            for (JSCustomExtractInterfaceHandler handler : JSCustomExtractInterfaceHandler.EP_NAME.getExtensionList()) {
                if (!handler.isAvailableOnEditorAndFile(editor, file)) continue;
                handler.invoke(editor, file);
                return;
            }
        }
        super.invoke(project, editor, file, dataContext);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            JSExtractInterfaceHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            JSExtractInterfaceHandler.$$$reportNull$$$0(2);
        }
        if (elements.length != 1) {
            return;
        }
        PsiElement element = elements[0];
        JSClass aClass = JSExtractInterfaceHandler.getClass(element);
        if (aClass instanceof TypeScriptTypeAlias) {
            JSExtractInterfaceHandler.showErrorHint(project, dataContext, JavaScriptBundle.message("interface.cannot.be.extracted.from.type.alias", new Object[0]));
        } else if (aClass instanceof TypeScriptEnum) {
            JSExtractInterfaceHandler.showErrorHint(project, dataContext, JavaScriptBundle.message("interface.cannot.be.extracted.from.enum", new Object[0]));
        } else if (aClass != null) {
            JSElement selected = element instanceof JSElement ? (JSElement)element : null;
            RefactoringDialog dialog = this.myDialogFactory.apply(aClass, selected);
            dialog.show();
        } else {
            JSExtractInterfaceHandler.showErrorHint(project, dataContext, RefactoringBundle.getCannotRefactorMessage((String)JSExtractInterfaceHandler.getCannotRefactorReason()));
        }
    }

    private static void showErrorHint(@NotNull Project project, @Nullable DataContext data2, @NlsContexts.DialogMessage @NotNull String message) {
        if (project == null) {
            JSExtractInterfaceHandler.$$$reportNull$$$0(3);
        }
        if (message == null) {
            JSExtractInterfaceHandler.$$$reportNull$$$0(4);
        }
        Editor editor = data2 != null ? (Editor)CommonDataKeys.EDITOR.getData(data2) : null;
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)JSExtractInterfaceHandler.getRefactoringName(), null);
    }

    @NlsContexts.DialogMessage
    @NotNull
    private static String getCannotRefactorReason() {
        String string = RefactoringBundle.message((String)"error.wrong.caret.position.class");
        if (string == null) {
            JSExtractInterfaceHandler.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NlsContexts.DialogTitle
    @NotNull
    public static String getRefactoringName() {
        String string = RefactoringBundle.message((String)"extract.interface.title");
        if (string == null) {
            JSExtractInterfaceHandler.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/extractSuper/JSExtractInterfaceHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractSuper/JSExtractInterfaceHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCannotRefactorReason";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefactoringName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showErrorHint";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

