/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.NewLineEraser;
import com.intellij.lang.javascript.intentions.CommentsMover;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSJoinDeclarationAndAssignmentFix
extends LocalQuickFixOnPsiElement {
    public JSJoinDeclarationAndAssignmentFix(JSVariable node, JSReferenceExpression expression) {
        super((PsiElement)node, (PsiElement)expression);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("js.join.declaration.assignment.inspection.fix", new Object[0]);
        if (string == null) {
            JSJoinDeclarationAndAssignmentFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            JSJoinDeclarationAndAssignmentFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            JSJoinDeclarationAndAssignmentFix.$$$reportNull$$$0(2);
        }
        if (file == null) {
            JSJoinDeclarationAndAssignmentFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            JSJoinDeclarationAndAssignmentFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            JSJoinDeclarationAndAssignmentFix.$$$reportNull$$$0(5);
        }
        JSVariable variable = (JSVariable)startElement;
        JSReferenceExpression expression = (JSReferenceExpression)endElement;
        JSVarStatement statement = variable.getStatement();
        assert (statement != null);
        JSVarStatement.VarKeyword keyword = statement.getVarKeyword();
        assert (keyword != null);
        PsiElement parent = expression.getParent();
        if (parent instanceof JSForInStatement) {
            JSJoinDeclarationAndAssignmentFix.transformForInLoop(variable, expression, statement, keyword, (PsiElement)expression);
            return;
        }
        assert (parent instanceof JSDefinitionExpression);
        JSAssignmentExpression assignmentExpression = (JSAssignmentExpression)ObjectUtils.tryCast((Object)parent.getParent(), JSAssignmentExpression.class);
        if (assignmentExpression == null) {
            JSForInStatement forInStatement = (JSForInStatement)ObjectUtils.tryCast((Object)parent.getParent(), JSForInStatement.class);
            if (forInStatement != null) {
                JSJoinDeclarationAndAssignmentFix.transformForInLoop(variable, expression, statement, keyword, parent);
            }
            return;
        }
        JSExpression rOperand = assignmentExpression.getROperand();
        if (rOperand == null) {
            return;
        }
        PsiElement typeElement = variable.getTypeElement();
        String typeAnno = typeElement == null ? "" : ": " + typeElement.getText();
        String newStatementText = keyword.getText() + " " + variable.getName() + typeAnno + " = " + rOperand.getText();
        PsiElement assignmentParent = assignmentExpression.getParent();
        if (assignmentParent instanceof JSForStatement) {
            PsiElement replaced = assignmentExpression.replace((PsiElement)JSPsiElementFactory.createJSStatement(newStatementText, (PsiElement)expression));
            JSJoinDeclarationAndAssignmentFix.eraseStatementFixingNewlinesAndComments(statement, replaced);
            return;
        }
        newStatementText = newStatementText + JSCodeStyleSettings.getSemicolon((PsiElement)variable);
        JSStatement newStatement = JSPsiElementFactory.createJSStatement(newStatementText, (PsiElement)expression);
        JSStatement jsStatement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)assignmentExpression, JSStatement.class);
        assert (jsStatement != null);
        JSVarStatement introducedStatement = (JSVarStatement)jsStatement.getParent().addBefore((PsiElement)newStatement, (PsiElement)jsStatement);
        if (statement.getVariables().length == 1) {
            JSJoinDeclarationAndAssignmentFix.eraseStatementFixingNewlinesAndComments(statement, (PsiElement)introducedStatement);
        } else {
            variable.delete();
        }
        if (jsStatement instanceof JSExpressionStatement && ((JSExpressionStatement)jsStatement).getExpression() == assignmentExpression) {
            JSJoinDeclarationAndAssignmentFix.eraseStatementFixingNewlinesAndComments(jsStatement, (PsiElement)introducedStatement);
        } else {
            assignmentExpression.delete();
        }
        JSJoinDeclarationAndAssignmentFix.fixTrailingWhitespaces((PsiElement)introducedStatement);
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor != null) {
            editor.getCaretModel().moveToOffset(introducedStatement.getVariables()[0].getTextOffset());
        }
    }

    private static void transformForInLoop(JSVariable variable, JSReferenceExpression expression, JSVarStatement statement, JSVarStatement.VarKeyword keyword, PsiElement parent) {
        String newStatementText = keyword.getText() + " " + variable.getName();
        PsiElement replaced = parent.replace((PsiElement)JSPsiElementFactory.createJSStatement(newStatementText, (PsiElement)expression));
        JSJoinDeclarationAndAssignmentFix.eraseStatementFixingNewlinesAndComments(statement, replaced);
    }

    private static void fixTrailingWhitespaces(PsiElement introducedStatement) {
        PsiElement prev = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)introducedStatement);
        if (prev == null) {
            PsiElement next = introducedStatement.getNextSibling();
            while (next != null) {
                next = JSJoinDeclarationAndAssignmentFix.dropIfWhitespace(next, false);
            }
        }
        while (prev != null && prev.getPrevSibling() != introducedStatement) {
            prev = JSJoinDeclarationAndAssignmentFix.dropIfWhitespace(prev, true);
        }
    }

    private static PsiElement dropIfWhitespace(PsiElement prev, boolean backwards) {
        PsiElement res;
        if (PsiUtilCore.getElementType((PsiElement)prev) != JSTokenTypes.WHITE_SPACE) {
            return backwards ? prev.getPrevSibling() : prev.getNextSibling();
        }
        PsiElement psiElement = res = backwards ? prev.getPrevSibling() : prev.getNextSibling();
        if (backwards || res != null || !prev.getText().contains("\n") && !prev.getText().contains("\r")) {
            prev.delete();
        }
        return res;
    }

    private static void eraseStatementFixingNewlinesAndComments(JSStatement statement, PsiElement introducedStatement) {
        NewLineEraser eraser = new NewLineEraser((PsiElement)statement);
        CommentsMover commentsMover = new CommentsMover(statement);
        Set<PsiElement> toMoveTo = Collections.singleton(introducedStatement);
        commentsMover.move(toMoveTo, toMoveTo);
        statement.delete();
        eraser.process();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/JSJoinDeclarationAndAssignmentFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/JSJoinDeclarationAndAssignmentFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

