/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.action;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceResultContainer;
import com.intellij.lang.javascript.service.JSLanguageServiceUpdateContext;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptServiceHolder;
import com.intellij.lang.typescript.compiler.TypeScriptToolWindowProvider;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceAnnotationResult;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLockAbsence;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class TypeScriptCompileAllAction
extends AnAction {
    public TypeScriptCompileAllAction(@Nullable @NlsActions.ActionText String text, @Nullable @NlsActions.ActionDescription String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    public TypeScriptCompileAllAction(@NotNull Supplier<String> dynamicText, @NotNull Supplier<String> dynamicDescription, @Nullable Icon icon) {
        if (dynamicText == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(0);
        }
        if (dynamicDescription == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(1);
        }
        super(dynamicText, dynamicDescription, icon);
    }

    public TypeScriptCompileAllAction() {
        this(JavaScriptBundle.message("typescript.compiler.action.compile.all", new Object[0]), JavaScriptBundle.message("typescript.compiler.action.compile.all.description", new Object[0]), JavaScriptLanguageIcons.Typescript.CompileTypeScript);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    @Nullable
    protected Consumer<ProgressIndicator> getBackgroundProcess(Project project, @Nullable DataContext context2) {
        return indicator -> this.runCompile(project, (ProgressIndicator)indicator, null);
    }

    protected void runCompile(@NotNull Project project, @NotNull ProgressIndicator indicator, VirtualFile @Nullable [] files) {
        if (project == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(3);
        }
        if (indicator == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(4);
        }
        LinkedHashSet<JSAnnotationError> infos = new LinkedHashSet<JSAnnotationError>();
        GlobalSearchScope scope2 = TypeScriptCompilerConfigUtil.getCompileScope(project);
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
        if (this.canUseOnlyConfigs(project, settings)) {
            this.processConfigs(project, indicator, infos, scope2);
            indicator.checkCanceled();
            this.logErrors(project, infos);
            return;
        }
        boolean mainOnly = settings.useMainFile();
        HashSet processedFiles = new HashSet();
        HashSet updatedServices = new HashSet();
        this.iterateFilesForCompile(project, indicator, (Processor<? super VirtualFile>)((Processor)file -> {
            TypeScriptCompilerService languageCompilerService = TypeScriptServiceHolder.getCompilerServiceForFile(project, file);
            if (languageCompilerService == null) {
                return true;
            }
            if (updatedServices.add(languageCompilerService)) {
                this.runBeforeStartingCompile(indicator, languageCompilerService);
            }
            return this.processFile(indicator, (Collection<JSAnnotationError>)infos, languageCompilerService, scope2, mainOnly, processedFiles, (VirtualFile)file);
        }), files);
        indicator.checkCanceled();
        this.logErrors(project, infos);
    }

    protected boolean canUseOnlyConfigs(@NotNull Project project, TypeScriptCompilerSettings settings) {
        if (project == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(5);
        }
        if (settings.useDeprecatedSettings()) {
            return false;
        }
        return !((Collection)ReadAction.compute(() -> this.getConfigsForProcessing(project))).isEmpty();
    }

    private boolean processFile(@NotNull ProgressIndicator indicator, @NotNull Collection<JSAnnotationError> infos, @NotNull TypeScriptCompilerService compilerService, @NotNull GlobalSearchScope scope2, boolean mainOnly, @NotNull Set<String> processedFiles, @NotNull VirtualFile file) {
        String path2;
        if (indicator == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(6);
        }
        if (infos == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(7);
        }
        if (compilerService == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(8);
        }
        if (scope2 == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(9);
        }
        if (processedFiles == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(10);
        }
        if (file == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(11);
        }
        indicator.checkCanceled();
        if (!TypeScriptLanguageServiceUtil.isTypeScriptFileType(file.getFileType()) || !((Boolean)ReadAction.compute(() -> scope2.accept(file))).booleanValue() || JSLibraryUtil.isProbableLibraryFile(file)) {
            return true;
        }
        if (!processedFiles.isEmpty() && (path2 = file.getCanonicalPath()) != null) {
            String independentName = FileUtil.toSystemIndependentName((String)path2);
            if (processedFiles.contains(independentName)) {
                if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
                    JSLanguageServiceQueue.Holder.LOGGER.debug("Action Compile: skip compile for " + file.getName());
                }
                return true;
            }
            if (mainOnly) {
                infos.add(new TypeScriptLanguageServiceAnnotationResult(JavaScriptBundle.message("typescript.compiler.action.no.compile.message", new Object[0]), path2, "warning", null, null, -1, 0, 0, 0, 0));
                if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
                    JSLanguageServiceQueue.Holder.LOGGER.debug("Action Compile: skip and warning no compile for " + file.getName());
                }
                return true;
            }
        }
        return this.compileFile(file, indicator, compilerService, infos, processedFiles);
    }

    protected void processConfigs(Project project, ProgressIndicator indicator, Collection<JSAnnotationError> infos, GlobalSearchScope scope2) {
        HashSet<TypeScriptCompilerService> updatedServices = new HashSet<TypeScriptCompilerService>();
        Collection configs = (Collection)ReadAction.compute(() -> this.getConfigsForProcessing(project));
        for (VirtualFile configFile : configs) {
            TypeScriptCompilerService service = (TypeScriptCompilerService)ReadAction.compute(() -> this.getServiceForConfigAndScope(project, scope2, configFile));
            if (service == null) continue;
            if (updatedServices.add(service)) {
                this.runBeforeStartingCompile(indicator, service);
            }
            if (this.compileConfig(indicator, service, configFile, infos)) continue;
            break;
        }
    }

    @Nullable
    private TypeScriptCompilerService getServiceForConfigAndScope(@NotNull Project project, @NotNull GlobalSearchScope scope2, @NotNull VirtualFile configFile) {
        if (project == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(12);
        }
        if (scope2 == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(13);
        }
        if (configFile == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(14);
        }
        if (!scope2.contains(configFile)) {
            return null;
        }
        return this.getServiceForConfig(project, configFile);
    }

    @NotNull
    protected @Unmodifiable Collection<VirtualFile> getConfigsForProcessing(Project project) {
        List<VirtualFile> toProcess = TypeScriptConfigService.Provider.get(project).getRootConfigFiles();
        GlobalSearchScope scope2 = TypeScriptCompilerConfigUtil.getCompileScope(project);
        List list = ContainerUtil.filter(toProcess, config -> scope2.accept(config));
        if (list == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(15);
        }
        return list;
    }

    protected void iterateFilesForCompile(Project project, ProgressIndicator indicator, Processor<? super VirtualFile> processor, VirtualFile @Nullable [] files) {
        GlobalSearchScope scope2 = TypeScriptCompilerConfigUtil.getCompileScope(project);
        ArrayList filesToIterate = new ArrayList();
        ReadAction.run(() -> {
            for (FileType type2 : TypeScriptUtil.TYPESCRIPT_FILE_TYPES) {
                filesToIterate.addAll(FileTypeIndex.getFiles((FileType)type2, (GlobalSearchScope)scope2));
            }
        });
        for (VirtualFile file : filesToIterate) {
            if (TypeScriptUtil.isUnderNodeModules(file, project) || processor.process((Object)file)) continue;
            return;
        }
    }

    protected void logErrors(@NotNull JSLanguageServiceToolWindowManager manager, @NotNull Collection<? extends JSAnnotationError> infos) {
        if (manager == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(16);
        }
        if (infos == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(17);
        }
        manager.logProjectErrors(new ArrayList<JSAnnotationError>(infos), true);
    }

    @RequiresReadLockAbsence
    protected boolean compileFile(@NotNull VirtualFile file, @NotNull ProgressIndicator indicator, @NotNull TypeScriptCompilerService service, @NotNull Collection<JSAnnotationError> infos, @NotNull Collection<String> processedFiles) {
        if (file == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(18);
        }
        if (indicator == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(19);
        }
        if (service == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(20);
        }
        if (infos == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(21);
        }
        if (processedFiles == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(22);
        }
        ThreadingAssertions.assertNoReadAccess();
        indicator.checkCanceled();
        if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
            JSLanguageServiceQueue.Holder.LOGGER.debug("Action Compile: do compile for " + file.getName());
        }
        try {
            Future<JSLanguageServiceResultContainer> compile = service.compileFile(file, true);
            if (compile != null) {
                JSLanguageServiceResultContainer container = compile.get(60L, TimeUnit.SECONDS);
                this.processCompileFileResult(container, infos, processedFiles);
            }
            return true;
        }
        catch (Exception e) {
            JSLanguageServiceQueue.Holder.LOGGER.info(e.getMessage(), (Throwable)e);
            indicator.checkCanceled();
            return false;
        }
    }

    protected void processCompileFileResult(@Nullable JSLanguageServiceResultContainer container, @NotNull Collection<JSAnnotationError> infos, @NotNull Collection<String> processedFiles) {
        if (infos == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(23);
        }
        if (processedFiles == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(24);
        }
        if (container != null) {
            infos.addAll(container.getResults());
            List<String> compiledFiles = container.getProcessedFiles();
            for (String s : compiledFiles) {
                if (StringUtil.isEmpty((String)s)) continue;
                processedFiles.add(FileUtil.toSystemIndependentName((String)s));
            }
        }
    }

    protected boolean compileConfig(ProgressIndicator indicator, TypeScriptCompilerService service, VirtualFile config, Collection<JSAnnotationError> infos) {
        indicator.checkCanceled();
        if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
            JSLanguageServiceQueue.Holder.LOGGER.debug("Action Compile: do compile for " + config.getName());
        }
        try {
            indicator.setText2(JavaScriptBundle.message("typescript.compiler.action.compile.all.compile.config", config.getPath()));
            Future<JSLanguageServiceResultContainer> compile = service.compileProject(config);
            if (compile != null) {
                JSLanguageServiceResultContainer container = compile.get(60L, TimeUnit.SECONDS);
                this.processCompileConfigResult(container, infos);
            }
            return true;
        }
        catch (Exception e) {
            JSLanguageServiceQueue.Holder.LOGGER.info(e.getMessage(), (Throwable)e);
            indicator.cancel();
            return false;
        }
    }

    protected void processCompileConfigResult(@Nullable JSLanguageServiceResultContainer container, @NotNull Collection<JSAnnotationError> infos) {
        if (infos == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(25);
        }
        if (container != null) {
            infos.addAll(container.getResults());
        }
    }

    protected void logErrors(Project project, Collection<? extends JSAnnotationError> infos) {
        JSLanguageServiceToolWindowManager manager = TypeScriptToolWindowProvider.getToolWindow(project, true);
        if (manager != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!project.isOpen()) {
                    return;
                }
                manager.init();
                this.logErrors(manager, infos);
            }, project.getDisposed());
        }
    }

    public final synchronized void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(26);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        DataContext context2 = e.getDataContext();
        this.runCompile(project, context2);
    }

    public final void runCompile(@NotNull Project project, @Nullable DataContext context2) {
        if (project == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(27);
        }
        ThreadingAssertions.assertEventDispatchThread();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        FileDocumentManager.getInstance().saveAllDocuments();
        Consumer<ProgressIndicator> background = this.getBackgroundProcess(project, context2);
        if (background == null) {
            return;
        }
        this.runBackgroundTask(project, background);
    }

    private void runBackgroundTask(@NotNull Project project, final Consumer<? super ProgressIndicator> background) {
        if (project == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(28);
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, JavaScriptBundle.message("progress.title.compiling.typescript.files", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    indicator.checkCanceled();
                    background.consume((Object)indicator);
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                finally {
                    TypeScriptCompileAllAction.this.release();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileAllAction$1", "run"));
            }
        });
    }

    protected void release() {
    }

    protected void updateServerFiles(@NotNull ProgressIndicator indicator, @NotNull TypeScriptCompilerService languageCompilerService) {
        if (indicator == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(29);
        }
        if (languageCompilerService == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(30);
        }
        JSLanguageServiceUpdateContext context2 = (JSLanguageServiceUpdateContext)ReadAction.compute(() -> languageCompilerService.createUpdateContext(null));
        indicator.checkCanceled();
        languageCompilerService.update(context2);
        indicator.checkCanceled();
    }

    protected void runBeforeStartingCompile(@NotNull ProgressIndicator indicator, @NotNull TypeScriptCompilerService languageCompilerService) {
        if (indicator == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(31);
        }
        if (languageCompilerService == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(32);
        }
        this.updateServerFiles(indicator, languageCompilerService);
        languageCompilerService.flushCommandQueue();
    }

    @Nullable
    protected TypeScriptCompilerService getServiceForConfig(@NotNull Project project, @NotNull VirtualFile configFile) {
        if (project == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(33);
        }
        if (configFile == null) {
            TypeScriptCompileAllAction.$$$reportNull$$$0(34);
        }
        Ref serviceRef = Ref.create();
        ReadAction.run(() -> {
            TypeScriptCompilerService service = TypeScriptServiceHolder.getCompilerServiceForProject(project);
            serviceRef.set((Object)service);
        });
        return (TypeScriptCompilerService)serviceRef.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicDescription";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/action/TypeScriptCompileAllAction";
                break;
            }
            case 3: 
            case 5: 
            case 12: 
            case 27: 
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: 
            case 19: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 7: 
            case 17: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerService";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 10: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedFiles";
                break;
            }
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageCompilerService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/action/TypeScriptCompileAllAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigsForProcessing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 15: {
                break;
            }
            case 3: 
            case 4: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "runCompile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canUseOnlyConfigs";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getServiceForConfigAndScope";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "logErrors";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "compileFile";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processCompileFileResult";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processCompileConfigResult";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "runBackgroundTask";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "updateServerFiles";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "runBeforeStartingCompile";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getServiceForConfig";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 15 -> new IllegalStateException(string);
        };
    }
}

