/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.dataflow;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.util.VariableAccessUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReuseOfLocalVariableJSInspection
extends JavaScriptInspection {
    @Override
    @NotNull
    @InspectionMessage
    public String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("reuse.of.local.variable.problem.descriptor", new Object[0]);
        if (string == null) {
            ReuseOfLocalVariableJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReuseOfLocalVariableVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/dataflow/ReuseOfLocalVariableJSInspection", "buildErrorString"));
    }

    private static class ReuseOfLocalVariableVisitor
    extends BaseInspectionVisitor {
        private ReuseOfLocalVariableVisitor() {
        }

        @Override
        public void visitJSAssignmentExpression(@NotNull JSAssignmentExpression assignment) {
            int i;
            if (assignment == null) {
                ReuseOfLocalVariableVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSAssignmentExpression(assignment);
            if (assignment.getROperand() == null) {
                return;
            }
            PsiElement assignmentParent = assignment.getParent();
            if (!(assignmentParent instanceof JSExpressionStatement)) {
                return;
            }
            JSExpression lhs = assignment.getLOperand();
            if (!(lhs instanceof JSDefinitionExpression)) {
                return;
            }
            JSDefinitionExpression def = (JSDefinitionExpression)lhs;
            JSExpression defExpression = def.getExpression();
            if (!(defExpression instanceof JSReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)defExpression).resolve();
            if (!(referent instanceof JSVariable)) {
                return;
            }
            JSVariable variable = (JSVariable)referent;
            if (!variable.hasInitializer()) {
                return;
            }
            IElementType tokenType = assignment.getOperationSign();
            if (!JSTokenTypes.EQ.equals(tokenType)) {
                return;
            }
            JSExpression rhs = assignment.getROperand();
            if (VariableAccessUtil.isLocalVariableUsed(variable, (PsiElement)rhs)) {
                return;
            }
            JSBlockStatement variableBlock = (JSBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, JSBlockStatement.class);
            if (variableBlock == null) {
                return;
            }
            if (ReuseOfLocalVariableVisitor.loopExistsBetween(assignment, variableBlock)) {
                return;
            }
            if (ReuseOfLocalVariableVisitor.tryExistsBetween(assignment, variableBlock)) {
                return;
            }
            PsiElement assignmentBlock = assignmentParent.getParent();
            if (assignmentBlock == null) {
                return;
            }
            if (variableBlock.equals(assignmentBlock)) {
                this.registerError((PsiElement)lhs);
                return;
            }
            JSSourceElement[] statements = variableBlock.getStatementListItems();
            PsiElement containingStatement = ReuseOfLocalVariableVisitor.getChildWhichContainsElement(variableBlock, (PsiElement)assignment);
            int statementPosition = -1;
            for (i = 0; i < statements.length; ++i) {
                if (!statements[i].equals(containingStatement)) continue;
                statementPosition = i;
                break;
            }
            if (statementPosition == -1) {
                return;
            }
            for (i = statementPosition + 1; i < statements.length; ++i) {
                if (!VariableAccessUtil.isLocalVariableUsed(variable, (PsiElement)statements[i])) continue;
                return;
            }
            this.registerError((PsiElement)lhs);
        }

        private static boolean loopExistsBetween(JSAssignmentExpression assignment, JSBlockStatement block) {
            for (JSAssignmentExpression elementToTest = assignment; elementToTest != null; elementToTest = elementToTest.getParent()) {
                if (elementToTest.equals(block)) {
                    return false;
                }
                if (!(elementToTest instanceof JSLoopStatement)) continue;
                return true;
            }
            return false;
        }

        private static boolean tryExistsBetween(JSAssignmentExpression assignment, JSBlockStatement block) {
            for (JSAssignmentExpression elementToTest = assignment; elementToTest != null; elementToTest = elementToTest.getParent()) {
                if (elementToTest.equals(block)) {
                    return false;
                }
                if (!(elementToTest instanceof JSTryStatement)) continue;
                return true;
            }
            return false;
        }

        @Nullable
        public static PsiElement getChildWhichContainsElement(@NotNull JSBlockStatement ancestor, @NotNull PsiElement descendant) {
            if (ancestor == null) {
                ReuseOfLocalVariableVisitor.$$$reportNull$$$0(1);
            }
            if (descendant == null) {
                ReuseOfLocalVariableVisitor.$$$reportNull$$$0(2);
            }
            PsiElement element = descendant;
            while (!element.equals(ancestor)) {
                descendant = element;
                if ((element = descendant.getParent()) != null) continue;
                return null;
            }
            return descendant;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assignment";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ancestor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descendant";
                    break;
                }
            }
            objectArray2[1] = "com/sixrr/inspectjs/dataflow/ReuseOfLocalVariableJSInspection$ReuseOfLocalVariableVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSAssignmentExpression";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getChildWhichContainsElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

