/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.util;

import com.intellij.execution.target.TargetEnvironment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.django.testRunner.DjangoTestsRunConfiguration;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.facet.DjangoFacetConfiguration;
import com.jetbrains.django.util.DjangoCoreUtil;
import com.jetbrains.django.util.VirtualFileUtil;
import com.jetbrains.python.run.EnvironmentController;
import com.jetbrains.python.run.PlainEnvironmentController;
import com.jetbrains.python.run.TargetEnvironmentController;
import com.jetbrains.python.run.target.HelpersAwareTargetEnvironmentRequest;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DjangoUtil
extends DjangoCoreUtil {
    private DjangoUtil() {
    }

    @Nullable
    public static VirtualFile getCustomTestSettingsFile(@NotNull Module module, @NotNull DjangoTestsRunConfiguration configuration) {
        VirtualFile projectRoot;
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            DjangoUtil.$$$reportNull$$$0(1);
        }
        if (!configuration.useCustomSettings()) {
            return null;
        }
        String settings = configuration.getSettingsFile();
        if (settings == null || settings.isEmpty()) {
            return null;
        }
        DjangoFacet facet = DjangoFacet.getInstance((Module)module);
        if (facet != null && (projectRoot = ((DjangoFacetConfiguration)facet.getConfiguration()).getProjectRootFolderFile()) != null) {
            VirtualFile file = projectRoot.findFileByRelativePath(settings);
            if (file == null) {
                file = LocalFileSystem.getInstance().findFileByPath(settings);
            }
            return file;
        }
        return null;
    }

    public static void addCustomTestSettingsModule(@NotNull Module module, @NotNull Map<String, String> envs, @NotNull DjangoTestsRunConfiguration configuration) {
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(2);
        }
        if (envs == null) {
            DjangoUtil.$$$reportNull$$$0(3);
        }
        if (configuration == null) {
            DjangoUtil.$$$reportNull$$$0(4);
        }
        DjangoUtil.addCustomTestSettingsModule(module, (EnvironmentController)new PlainEnvironmentController(envs), configuration);
    }

    public static void addCustomTestSettingsModule(@NotNull HelpersAwareTargetEnvironmentRequest request, @NotNull Module module, @NotNull Map<String, Function<TargetEnvironment, String>> envs, @NotNull DjangoTestsRunConfiguration configuration) {
        if (request == null) {
            DjangoUtil.$$$reportNull$$$0(5);
        }
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(6);
        }
        if (envs == null) {
            DjangoUtil.$$$reportNull$$$0(7);
        }
        if (configuration == null) {
            DjangoUtil.$$$reportNull$$$0(8);
        }
        DjangoUtil.addCustomTestSettingsModule(module, (EnvironmentController)new TargetEnvironmentController(envs, request), configuration);
    }

    private static void addCustomTestSettingsModule(@NotNull Module module, @NotNull EnvironmentController envs, @NotNull DjangoTestsRunConfiguration configuration) {
        VirtualFile settingsFile;
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(9);
        }
        if (envs == null) {
            DjangoUtil.$$$reportNull$$$0(10);
        }
        if (configuration == null) {
            DjangoUtil.$$$reportNull$$$0(11);
        }
        if ((settingsFile = DjangoUtil.getCustomTestSettingsFile(module, configuration)) == null) {
            settingsFile = DjangoUtil.getSettingsFile((Module)module);
        }
        DjangoUtil.addSettingsModule(module, settingsFile, envs);
    }

    public static void addDjangoSettingsToEnv(@NotNull HelpersAwareTargetEnvironmentRequest request, @NotNull Module module, @NotNull Map<String, Function<TargetEnvironment, String>> envs) {
        if (request == null) {
            DjangoUtil.$$$reportNull$$$0(12);
        }
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(13);
        }
        if (envs == null) {
            DjangoUtil.$$$reportNull$$$0(14);
        }
        DjangoUtil.addDjangoSettingsToEnv((EnvironmentController)new TargetEnvironmentController(envs, request), module, true);
    }

    public static void addDjangoSettingsToEnv(@NotNull Module module, @NotNull Map<String, String> envs) {
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(15);
        }
        if (envs == null) {
            DjangoUtil.$$$reportNull$$$0(16);
        }
        DjangoUtil.addDjangoSettingsToEnv(module, envs, true);
    }

    public static void addDjangoSettingsToEnv(@NotNull Module module, @NotNull Map<String, String> envs, boolean addManageModule) {
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(17);
        }
        if (envs == null) {
            DjangoUtil.$$$reportNull$$$0(18);
        }
        DjangoUtil.addDjangoSettingsToEnv((EnvironmentController)new PlainEnvironmentController(envs), module, addManageModule);
    }

    public static void addPyCharmManageModule(@NotNull Module module, @NotNull Map<String, String> envs) {
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(19);
        }
        if (envs == null) {
            DjangoUtil.$$$reportNull$$$0(20);
        }
        DjangoUtil.addPyCharmManageModule(module, (EnvironmentController)new PlainEnvironmentController(envs));
    }

    private static void addDjangoSettingsToEnv(@NotNull EnvironmentController envs, @NotNull Module module, boolean addManageModule) {
        if (envs == null) {
            DjangoUtil.$$$reportNull$$$0(21);
        }
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(22);
        }
        DjangoUtil.addPyCharmSettingsModule(module, envs);
        if (addManageModule) {
            DjangoUtil.addPyCharmManageModule(module, envs);
        }
    }

    private static void addPyCharmSettingsModule(@NotNull Module module, @NotNull EnvironmentController envs) {
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(23);
        }
        if (envs == null) {
            DjangoUtil.$$$reportNull$$$0(24);
        }
        VirtualFile settingsFile = DjangoUtil.getSettingsFile((Module)module);
        DjangoUtil.addSettingsModule(module, settingsFile, envs);
    }

    private static void addSettingsModule(@NotNull Module module, @Nullable VirtualFile settingsFile, @NotNull EnvironmentController envs) {
        String relativePath;
        VirtualFile manageFile;
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(25);
        }
        if (envs == null) {
            DjangoUtil.$$$reportNull$$$0(26);
        }
        if (envs.isEnvSet("DJANGO_SETTINGS_MODULE")) {
            return;
        }
        if (settingsFile == null) {
            return;
        }
        String moduleToImport = DjangoUtil.getModuleRelatedToRoot(module, settingsFile);
        if (moduleToImport == null && (manageFile = DjangoUtil.getManageFile((Module)module)) != null && (relativePath = VirtualFileUtil.getRelativePath((VirtualFile)manageFile.getParent(), (VirtualFile)settingsFile)) != null) {
            moduleToImport = FileUtilRt.getNameWithoutExtension((String)relativePath).replace('/', '.');
        }
        if (moduleToImport == null) {
            moduleToImport = DjangoUtil.getImportableModule((Module)module, (VirtualFile)settingsFile);
        }
        envs.putFixedValue("DJANGO_SETTINGS_MODULE", moduleToImport);
    }

    public static void addPyCharmManageModule(@NotNull HelpersAwareTargetEnvironmentRequest request, @NotNull Module module, @NotNull Map<String, Function<TargetEnvironment, String>> envs) {
        if (request == null) {
            DjangoUtil.$$$reportNull$$$0(27);
        }
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(28);
        }
        if (envs == null) {
            DjangoUtil.$$$reportNull$$$0(29);
        }
        DjangoUtil.addPyCharmManageModule(module, (EnvironmentController)new TargetEnvironmentController(envs, request));
    }

    private static void addPyCharmManageModule(@NotNull Module module, @NotNull EnvironmentController envs) {
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(30);
        }
        if (envs == null) {
            DjangoUtil.$$$reportNull$$$0(31);
        }
        if (envs.isEnvSet("PYCHARM_DJANGO_MANAGE_MODULE")) {
            return;
        }
        VirtualFile manageFile = DjangoUtil.getManageFile((Module)module);
        if (manageFile != null) {
            String manageModule = DjangoUtil.getModuleRelatedToRoot(module, manageFile);
            if (manageModule == null) {
                manageModule = manageFile.getNameWithoutExtension();
            }
            envs.putFixedValue("PYCHARM_DJANGO_MANAGE_MODULE", manageModule);
        }
    }

    @Nullable
    private static String getModuleRelatedToRoot(@NotNull Module module, @NotNull VirtualFile file) {
        List result;
        String projectRootString;
        if (module == null) {
            DjangoUtil.$$$reportNull$$$0(32);
        }
        if (file == null) {
            DjangoUtil.$$$reportNull$$$0(33);
        }
        if ((projectRootString = DjangoUtil.getProjectRoot((Module)module)) == null) {
            return null;
        }
        VirtualFile projectRoot = VirtualFileUtil.findFile((String)projectRootString);
        if (projectRoot == null) {
            return null;
        }
        String relativePath = VirtualFileUtil.getRelativePath((VirtualFile)projectRoot, (VirtualFile)file);
        if (relativePath != null && !(result = StringUtil.split((String)relativePath, (String)"/")).isEmpty()) {
            String nameWithoutExtension = FileUtilRt.getNameWithoutExtension((String)((String)result.get(result.size() - 1)));
            result = ContainerUtil.append(result.subList(0, result.size() - 1), (Object[])new String[]{nameWithoutExtension});
            return StringUtil.join((Collection)result, (String)".");
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 5: 
            case 12: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/django/util/DjangoUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getCustomTestSettingsFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "addCustomTestSettingsModule";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "addDjangoSettingsToEnv";
                break;
            }
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "addPyCharmManageModule";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "addPyCharmSettingsModule";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "addSettingsModule";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "getModuleRelatedToRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

