/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.qml.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.impl.JSFileImpl;
import com.intellij.lang.qml.QmlLanguageDialect;
import com.intellij.lang.qml.parsing.QmlExpressionParser;
import com.intellij.lang.qml.parsing.QmlFunctionParser;
import com.intellij.lang.qml.parsing.QmlStatementParser;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020 J\u0010\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020$H\u0016R\u0012\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\u0006\u0012\u0002\b\u00030\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\fR\u0018\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u001f\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00178VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001e\u00a8\u0006&"}, d2={"Lcom/intellij/lang/qml/parsing/QmlParser;", "Lcom/intellij/lang/ecmascript6/parsing/ES6Parser;", "builder", "Lcom/intellij/lang/PsiBuilder;", "<init>", "(Lcom/intellij/lang/PsiBuilder;)V", "defaultExpressionParser", "Lcom/intellij/lang/qml/parsing/QmlExpressionParser;", "defaultStatementParser", "Lcom/intellij/lang/qml/parsing/QmlStatementParser;", "jsExpressionParser", "getJsExpressionParser", "()Lcom/intellij/lang/qml/parsing/QmlExpressionParser;", "jsStatementParser", "getJsStatementParser", "()Lcom/intellij/lang/qml/parsing/QmlStatementParser;", "insideJsFunctionCount", "", "expressionParser", "getExpressionParser", "statementParser", "getStatementParser", "functionParser", "Lcom/intellij/lang/qml/parsing/QmlFunctionParser;", "getFunctionParser", "()Lcom/intellij/lang/qml/parsing/QmlFunctionParser;", "functionParser$delegate", "Lkotlin/Lazy;", "isInsideJsFunction", "", "()Z", "increaseInsideJSFunctionCount", "", "decreaseInsideJSFunctionCount", "fillBuilderDataFromContext", "context", "Lcom/intellij/psi/PsiElement;", "Companion", "intellij.qml.common"})
public class QmlParser
extends ES6Parser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final QmlExpressionParser<?> defaultExpressionParser;
    @NotNull
    private final QmlStatementParser<?> defaultStatementParser;
    @NotNull
    private final QmlExpressionParser<?> jsExpressionParser;
    @NotNull
    private final QmlStatementParser<?> jsStatementParser;
    private int insideJsFunctionCount;
    @NotNull
    private final Lazy functionParser$delegate;
    @NotNull
    private static final RecursionGuard<PsiFile> ourGuard;

    public QmlParser(@NotNull PsiBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        QmlLanguageDialect qmlLanguageDialect = QmlLanguageDialect.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)qmlLanguageDialect), (String)"getInstance(...)");
        super((JSLanguageDialect)qmlLanguageDialect, builder);
        this.defaultExpressionParser = new QmlExpressionParser<QmlParser>(this, true);
        this.defaultStatementParser = new QmlStatementParser<QmlParser>(this, true);
        this.jsExpressionParser = new QmlExpressionParser<QmlParser>(this, false);
        this.jsStatementParser = new QmlStatementParser<QmlParser>(this, false);
        this.functionParser$delegate = LazyKt.lazy(() -> QmlParser.functionParser_delegate$lambda$0(this));
    }

    @NotNull
    protected QmlExpressionParser<?> getJsExpressionParser() {
        return this.jsExpressionParser;
    }

    @NotNull
    protected QmlStatementParser<?> getJsStatementParser() {
        return this.jsStatementParser;
    }

    @NotNull
    public QmlExpressionParser<?> getExpressionParser() {
        return this.isInsideJsFunction() ? this.getJsExpressionParser() : this.defaultExpressionParser;
    }

    @NotNull
    public QmlStatementParser<?> getStatementParser() {
        return this.isInsideJsFunction() ? this.getJsStatementParser() : this.defaultStatementParser;
    }

    @NotNull
    public QmlFunctionParser<?> getFunctionParser() {
        Lazy lazy = this.functionParser$delegate;
        return (QmlFunctionParser)((Object)lazy.getValue());
    }

    public final boolean isInsideJsFunction() {
        return this.insideJsFunctionCount > 0;
    }

    public final void increaseInsideJSFunctionCount() {
        int n = this.insideJsFunctionCount;
        this.insideJsFunctionCount = n + 1;
    }

    public final void decreaseInsideJSFunctionCount() {
        int n = this.insideJsFunctionCount;
        this.insideJsFunctionCount = n + -1;
    }

    public void fillBuilderDataFromContext(@NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.fillBuilderDataFromContext(context);
        PsiFile origPsi = context.getContainingFile();
        if (origPsi != null && (origPsi = origPsi.getOriginalFile()) instanceof JSFileImpl && ((JSFileImpl)origPsi).getTreeElement() != null) {
            PsiElement elem;
            PsiFile finalOrigPsi = origPsi;
            for (elem = (PsiElement)ourGuard.doPreventingRecursion((Object)origPsi, false, () -> QmlParser.fillBuilderDataFromContext$lambda$1(finalOrigPsi, context)); elem != null && !(elem instanceof JSFunction) && !(elem instanceof PsiFile); elem = elem.getParent()) {
            }
            if (elem instanceof JSFunction) {
                int n = this.insideJsFunctionCount;
                this.insideJsFunctionCount = n + 1;
            }
        }
    }

    private static final QmlFunctionParser functionParser_delegate$lambda$0(QmlParser this$0) {
        return new QmlFunctionParser<QmlParser>(this$0);
    }

    private static final PsiElement fillBuilderDataFromContext$lambda$1(PsiFile $finalOrigPsi, PsiElement $context) {
        return ((JSFileImpl)$finalOrigPsi).findElementAt($context.getTextOffset());
    }

    static {
        RecursionGuard recursionGuard = RecursionManager.createGuard((String)"functionContextGuard");
        Intrinsics.checkNotNullExpressionValue((Object)recursionGuard, (String)"createGuard(...)");
        ourGuard = recursionGuard;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/lang/qml/parsing/QmlParser$Companion;", "", "<init>", "()V", "ourGuard", "Lcom/intellij/openapi/util/RecursionGuard;", "Lcom/intellij/psi/PsiFile;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.qml.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

