/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.qml.structureView;

import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.qml.psi.impl.QmlElementDeclarationImpl;
import com.intellij.lang.qml.psi.impl.QmlElementReferenceExpressionImpl;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QmlStructureItemPresentation
implements ColoredItemPresentation {
    @NotNull
    private final CachedValue<String> myPresentation;

    public QmlStructureItemPresentation(PsiElement element) {
        this.myPresentation = CachedValuesManager.getManager((Project)element.getProject()).createCachedValue(() -> {
            Object text = "";
            if (element instanceof QmlElementDeclarationImpl) {
                List<PsiElement> kindElem = Arrays.stream(element.getChildren()).filter(elem -> elem instanceof QmlElementReferenceExpressionImpl).toList();
                List<PsiElement> blockElem = Arrays.stream(element.getChildren()).filter(elem -> elem instanceof JSBlockStatement).toList();
                if (!kindElem.isEmpty() && !blockElem.isEmpty()) {
                    text = kindElem.get(0).getText();
                    List idElements = ContainerUtil.filter((Object[])blockElem.get(0).getChildren(), childElem -> childElem instanceof JSAssignmentExpression && childElem.getChildren().length > 1 && childElem.getChildren()[1].getText().equals("id"));
                    if (!idElements.isEmpty() && ((PsiElement)idElements.get(0)).getChildren().length > 2) {
                        PsiElement idValueElem = ((PsiElement)idElements.get(0)).getChildren()[2];
                        text = (String)text + ": " + idValueElem.getText();
                    }
                }
            } else {
                text = element.getText();
            }
            return CachedValueProvider.Result.create((Object)text, (Object[])new Object[]{element.getContainingFile()});
        }, false);
    }

    @Nullable
    public TextAttributesKey getTextAttributesKey() {
        return null;
    }

    @Nullable
    public String getPresentableText() {
        return (String)this.myPresentation.getValue();
    }

    @Nullable
    public Icon getIcon(boolean unused) {
        return null;
    }
}

