/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.psi;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.ecmascript6.parsing.ES6StatementParser;
import com.intellij.lang.javascript.BasicJavaScriptStubElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptParserBundle;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptPsiTypeParser;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptStatementParser;
import com.intellij.lang.javascript.flow.BasicFlowJSStubElementTypes;
import com.intellij.lang.javascript.flow.psi.FlowInJSPsiTypeParser;
import com.intellij.lang.javascript.flow.psi.FlowJSParser;
import com.intellij.lang.javascript.flow.psi.FlowJSPsiTypeParser;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructureLeaf;
import com.intellij.lang.javascript.parsing.modifiers.JSOneOfModifiersStructure;
import com.intellij.lang.javascript.parsing.modifiers.JSOrderedModifiersStructure;
import com.intellij.psi.tree.IElementType;
import java.util.EnumSet;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\tH\u0014J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0007H\u0002J\b\u0010\u0013\u001a\u00020\u0007H\u0014J\b\u0010\u0014\u001a\u00020\u0007H\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0014J\u0012\u0010\u0018\u001a\u00020\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0011H\u0014J\u0012\u0010\u001a\u001a\u00020\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0011H\u0014J\b\u0010\u001b\u001a\u00020\u0007H\u0014J \u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\fH\u0014R\u0014\u0010\u001f\u001a\u00020\u00118TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u00118TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010!\u00a8\u0006%"}, d2={"Lcom/intellij/lang/javascript/flow/psi/FlowJSStatementParser;", "Lcom/intellij/lang/ecmascript6/parsing/ES6StatementParser;", "Lcom/intellij/lang/javascript/flow/psi/FlowJSParser;", "parser", "<init>", "(Lcom/intellij/lang/javascript/flow/psi/FlowJSParser;)V", "parseInterfaceNoMarker", "", "clazz", "Lcom/intellij/lang/PsiBuilder$Marker;", "parseStatement", "parseDeclareStatement", "", "parseDialectSpecificSourceElements", "marker", "parseTypeAlias", "firstToken", "Lcom/intellij/psi/tree/IElementType;", "parseDeclareModule", "parseClassMember", "parseClassMembersSeparator", "parseClassMemberModifiers", "Ljava/util/EnumSet;", "Lcom/intellij/lang/javascript/parsing/modifiers/JSModifiersStructure$JSModifiersParseResult;", "shouldParseTypeImports", "type", "shouldParseTypeExports", "parseReferencesList", "parseES6ImportOrExportSpecifier", "isImport", "stopOnFirstError", "classElementType", "getClassElementType", "()Lcom/intellij/psi/tree/IElementType;", "classExpressionElementType", "getClassExpressionElementType", "Companion", "intellij.javascript.parser"})
public final class FlowJSStatementParser
extends ES6StatementParser<FlowJSParser> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final JSModifiersStructure DECLARE_CLASS_MEMBER_MODIFIERS;
    @NotNull
    private static final Predicate<PsiBuilder> IS_MEMBER_NAME_START;
    @NotNull
    private static final JSModifiersStructure CLASS_DECLARE_FIELD_MODIFIERS;
    @NotNull
    private static final JSModifiersStructure CLASS_MEMBER_MODIFIERS_STRUCTURE;

    public FlowJSStatementParser(@NotNull FlowJSParser parser) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        super((ES6Parser)parser);
    }

    @Override
    protected void parseInterfaceNoMarker(@NotNull PsiBuilder.Marker clazz) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        TypeScriptStatementParser.Companion.parseInterface(clazz, this, (ES6Parser)this.parser, this.builder);
    }

    @Override
    public void parseStatement() {
        IElementType firstToken = this.builder.getTokenType();
        if (firstToken == JSTokenTypes.TYPE_KEYWORD && this.isIdentifierToken(this.builder.lookAhead(1)) || firstToken == JSTokenTypes.OPAQUE_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.TYPE_KEYWORD) {
            PsiBuilder.Marker marker = this.startAttributeListOwner();
            this.parseTypeAlias(marker, firstToken);
            return;
        }
        if (firstToken == JSTokenTypes.ENUM_KEYWORD) {
            PsiBuilder.Marker marker = this.startAttributeListOwner();
            this.parseEnumNoMarker(marker);
            return;
        }
        if (this.builder.getTokenType() == JSTokenTypes.DECLARE_KEYWORD) {
            FunctionParser.MethodEmptiness functionType = (FunctionParser.MethodEmptiness)((Object)this.builder.getUserData(FunctionParser.methodsEmptinessKey));
            this.builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)FunctionParser.MethodEmptiness.ALWAYS);
            boolean parsed = this.parseDeclareStatement();
            this.builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)functionType);
            if (parsed) {
                return;
            }
        }
        super.parseStatement();
    }

    private final boolean parseDeclareStatement() {
        if (this.builder.lookAhead(1) == JSTokenTypes.MODULE_KEYWORD) {
            this.parseDeclareModule();
            this.checkForSemicolon();
            return true;
        }
        if (this.builder.lookAhead(1) == JSTokenTypes.EXPORT_KEYWORD && !StatementParser.EXPORTABLE_ELEMENTS_KEYWORDS.contains(this.builder.lookAhead(2)) && this.builder.lookAhead(2) != JSTokenTypes.INTERFACE_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker attrList = marker;
            this.builder.advanceLexer();
            attrList.done(((FlowJSParser)this.parser).getFunctionParser().getAttributeListElementType());
            PsiBuilder.Marker marker2 = attrList.precede();
            Intrinsics.checkNotNullExpressionValue((Object)marker2, (String)"precede(...)");
            PsiBuilder.Marker marker3 = marker2;
            if (this.builder.lookAhead(1) == JSTokenTypes.DEFAULT_KEYWORD && this.builder.lookAhead(2) != JSTokenTypes.FUNCTION_KEYWORD && this.builder.lookAhead(2) != JSTokenTypes.CLASS_KEYWORD) {
                this.builder.advanceLexer();
                StatementParser.LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.DEFAULT_KEYWORD);
                this.builder.advanceLexer();
                ((TypeScriptPsiTypeParser)((FlowJSParser)this.parser).getTypeParser()).parseType();
                this.forceCheckForSemicolon();
                marker3.done(BasicFlowJSStubElementTypes.DECLARE_EXPORT_DECLARATION);
                marker3.setCustomEdgeTokenBinders(JavaScriptParserBase.INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
            } else {
                this.tryParseES6ExportStatement(marker3);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean parseDialectSpecificSourceElements(@NotNull PsiBuilder.Marker marker) {
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        IElementType firstToken = this.builder.getTokenType();
        if (firstToken == JSTokenTypes.TYPE_KEYWORD || firstToken == JSTokenTypes.OPAQUE_KEYWORD) {
            this.parseTypeAlias(marker, firstToken);
            return true;
        }
        return super.parseDialectSpecificSourceElements(marker);
    }

    private final void parseTypeAlias(PsiBuilder.Marker marker, IElementType firstToken) {
        if (firstToken == JSTokenTypes.OPAQUE_KEYWORD) {
            this.builder.advanceLexer();
            if (this.builder.getTokenType() != JSTokenTypes.TYPE_KEYWORD) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.type.keyword", new Object[0]));
                marker.done(BasicJavaScriptStubElementTypes.TYPESCRIPT_TYPE_ALIAS);
                return;
            }
        }
        this.builder.putUserData(FlowJSPsiTypeParser.Companion.getOPAQUE_TYPE_KEY(), (Object)(firstToken == JSTokenTypes.OPAQUE_KEYWORD ? 1 : 0));
        TypeScriptStatementParser.Companion.parseTypeAlias(marker, this.builder, (ES6Parser)this.parser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void parseDeclareModule() {
        PsiBuilder.Marker marker = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
        PsiBuilder.Marker module = marker;
        PsiBuilder.Marker marker2 = this.builder.mark();
        Intrinsics.checkNotNullExpressionValue((Object)marker2, (String)"mark(...)");
        PsiBuilder.Marker attrList = marker2;
        StatementParser.LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.DECLARE_KEYWORD);
        this.builder.advanceLexer();
        attrList.done(((FlowJSParser)this.parser).getFunctionParser().getAttributeListElementType());
        StatementParser.LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.MODULE_KEYWORD);
        this.builder.advanceLexer();
        if (JSTokenTypes.STRING_LITERALS.contains(this.builder.getTokenType())) {
            ((FlowJSParser)this.parser).buildTokenElement(BasicJavaScriptStubElementTypes.LITERAL_EXPRESSION);
        } else if (this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.advanceLexer();
        } else {
            if (this.builder.getTokenType() == JSTokenTypes.DOT && this.builder.lookAhead(1) == JSTokenTypes.IDENTIFIER) {
                this.builder.advanceLexer();
                if (!Intrinsics.areEqual((Object)"exports", (Object)this.builder.getTokenText())) {
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.exports", new Object[0]));
                }
                this.builder.advanceLexer();
                JavaScriptParserBase.Companion.checkMatches(this.builder, JSTokenTypes.COLON, "javascript.parser.message.expected.colon");
                ((TypeScriptPsiTypeParser)((FlowJSParser)this.parser).getTypeParser()).parseType();
                module.done(BasicFlowJSStubElementTypes.FLOW_MODULE);
                module.setCustomEdgeTokenBinders(JavaScriptParserBase.INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
                return;
            }
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.name", new Object[0]));
            module.drop();
            return;
        }
        if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.lbrace", new Object[0]));
            module.drop();
            return;
        }
        this.builder.advanceLexer();
        FunctionParser.MethodEmptiness methodsMustBeEmpty = (FunctionParser.MethodEmptiness)((Object)this.builder.getUserData(FunctionParser.methodsEmptinessKey));
        Boolean forcedType = (Boolean)this.builder.getUserData(FlowJSPsiTypeParser.Companion.getFORCED_TYPE_KEY());
        try {
            this.builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)FunctionParser.MethodEmptiness.ALWAYS);
            this.builder.putUserData(FlowJSPsiTypeParser.Companion.getFORCED_TYPE_KEY(), (Object)true);
            while (this.builder.getTokenType() != JSTokenTypes.RBRACE) {
                if (this.builder.eof()) {
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.missing.rbrace", new Object[0]));
                    module.drop();
                    return;
                }
                if (this.builder.getTokenType() != JSTokenTypes.DECLARE_KEYWORD && this.builder.getTokenType() != JSTokenTypes.IMPORT_KEYWORD) {
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.declare", new Object[0]));
                }
                this.parseStatement();
            }
            this.builder.advanceLexer();
        }
        finally {
            this.builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)methodsMustBeEmpty);
            this.builder.putUserData(FlowJSPsiTypeParser.Companion.getFORCED_TYPE_KEY(), (Object)forcedType);
        }
        module.done(BasicFlowJSStubElementTypes.FLOW_MODULE);
        module.setCustomEdgeTokenBinders(JavaScriptParserBase.INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    @Override
    protected void parseClassMember() {
        if (this.builder.getUserData(FunctionParser.methodsEmptinessKey) == FunctionParser.MethodEmptiness.ALWAYS) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker classMember = marker;
            boolean lexerAdvanced = ((FlowJSParser)this.parser).parseModifiers(DECLARE_CLASS_MEMBER_MODIFIERS, true, IS_MEMBER_NAME_START).contains((Object)JSModifiersStructure.JSModifiersParseResult.LEXER_ADVANCED);
            IElementType memberStart = this.builder.getTokenType();
            if (memberStart == JSTokenTypes.LBRACKET) {
                TypeScriptPsiTypeParser.Companion.parseIndexSignatureNoMarker(classMember, this.builder, (ES6Parser)this.parser, false, false);
                this.parseClassMembersSeparator();
                return;
            }
            if (JSKeywordSets.PROPERTY_NAMES.contains(memberStart)) {
                this.builder.advanceLexer();
                lexerAdvanced = true;
                ((TypeScriptPsiTypeParser)((FlowJSParser)this.parser).getTypeParser()).parseInterfaceSimplePropertyOrFunction(classMember);
            } else if (memberStart == JSTokenTypes.LPAR || memberStart == JSTokenTypes.LT) {
                lexerAdvanced = !((FlowJSParser)this.parser).getFunctionParser().parseParameterList((boolean)false).hasErrors;
                lexerAdvanced |= this.builder.getTokenType() != JSTokenTypes.COLON || ((FlowInJSPsiTypeParser)((FlowJSParser)this.parser).getTypeParser()).tryParseType();
                classMember.done(BasicJavaScriptStubElementTypes.CALL_SIGNATURE);
            } else {
                classMember.drop();
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.declaration", new Object[0]));
            }
            if (!lexerAdvanced) {
                this.builder.advanceLexer();
            }
            this.parseClassMembersSeparator();
            return;
        }
        if (this.builder.getTokenType() == JSTokenTypes.DECLARE_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker classMember = marker;
            boolean lexerAdvanced = ((FlowJSParser)this.parser).parseModifiers(CLASS_DECLARE_FIELD_MODIFIERS, true, FlowJSStatementParser::parseClassMember$lambda$0).contains((Object)JSModifiersStructure.JSModifiersParseResult.LEXER_ADVANCED);
            if (lexerAdvanced) {
                PsiBuilder.Marker marker2 = this.builder.mark();
                Intrinsics.checkNotNullExpressionValue((Object)marker2, (String)"mark(...)");
                this.parseMemberVariable(marker2, classMember, false);
                return;
            }
            classMember.drop();
        }
        super.parseClassMember();
    }

    private final void parseClassMembersSeparator() {
        if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
            this.builder.advanceLexer();
        } else {
            this.forceCheckForSemicolon();
        }
    }

    @Override
    @NotNull
    protected EnumSet<JSModifiersStructure.JSModifiersParseResult> parseClassMemberModifiers() {
        return ((FlowJSParser)this.parser).parseModifiers(CLASS_MEMBER_MODIFIERS_STRUCTURE, false, IS_MEMBER_NAME_START);
    }

    @Override
    protected boolean shouldParseTypeImports(@Nullable IElementType type) {
        return type == JSTokenTypes.TYPE_KEYWORD || type == JSTokenTypes.TYPEOF_KEYWORD;
    }

    @Override
    protected boolean shouldParseTypeExports(@Nullable IElementType type) {
        return type == JSTokenTypes.TYPE_KEYWORD;
    }

    @Override
    protected void parseReferencesList() {
        super.parseReferencesList();
        if (this.builder.getTokenType() == JSTokenTypes.MIXINS_KEYWORD) {
            this.parseReferenceList(this.getClassExtendListElementType());
        }
    }

    @Override
    protected boolean parseES6ImportOrExportSpecifier(boolean isImport, @NotNull PsiBuilder.Marker marker, boolean stopOnFirstError) {
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        IElementType tokenType = this.builder.getTokenType();
        if ((tokenType == JSTokenTypes.TYPE_KEYWORD || tokenType == JSTokenTypes.TYPEOF_KEYWORD) && this.isIdentifierToken(this.builder.lookAhead(1))) {
            this.builder.advanceLexer();
        }
        return super.parseES6ImportOrExportSpecifier(isImport, marker, stopOnFirstError);
    }

    @Override
    @NotNull
    protected IElementType getClassElementType() {
        return BasicFlowJSStubElementTypes.FLOW_JS_CLASS;
    }

    @Override
    @NotNull
    protected IElementType getClassExpressionElementType() {
        return BasicFlowJSStubElementTypes.FLOW_JS_CLASS_EXPRESSION;
    }

    private static final boolean parseClassMember$lambda$0(PsiBuilder b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return JSKeywordSets.IDENTIFIER_NAMES.contains(b.getTokenType());
    }

    private static final boolean IS_MEMBER_NAME_START$lambda$1(PsiBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        IElementType type = builder.getTokenType();
        return type == JSTokenTypes.LBRACKET || JSKeywordSets.PROPERTY_NAMES.contains(type);
    }

    static {
        JSModifiersStructure[] jSModifiersStructureArray = new JSModifiersStructure[4];
        jSModifiersStructureArray[0] = new JSModifiersStructureLeaf(JSTokenTypes.STATIC_KEYWORD, false, 2, null);
        jSModifiersStructureArray[1] = new JSModifiersStructureLeaf(JSTokenTypes.PROTO_KEYWORD, false, 2, null);
        IElementType[] iElementTypeArray = new IElementType[]{JSTokenTypes.PLUS, JSTokenTypes.MINUS};
        jSModifiersStructureArray[2] = new JSOneOfModifiersStructure(iElementTypeArray);
        iElementTypeArray = new IElementType[]{JSTokenTypes.GET_KEYWORD, JSTokenTypes.SET_KEYWORD};
        jSModifiersStructureArray[3] = new JSOneOfModifiersStructure(iElementTypeArray);
        DECLARE_CLASS_MEMBER_MODIFIERS = new JSOrderedModifiersStructure(jSModifiersStructureArray);
        IS_MEMBER_NAME_START = FlowJSStatementParser::IS_MEMBER_NAME_START$lambda$1;
        jSModifiersStructureArray = new JSModifiersStructure[3];
        jSModifiersStructureArray[0] = new JSModifiersStructureLeaf(JSTokenTypes.DECLARE_KEYWORD, false, 2, null);
        jSModifiersStructureArray[1] = new JSModifiersStructureLeaf(JSTokenTypes.STATIC_KEYWORD, false, 2, null);
        iElementTypeArray = new IElementType[]{JSTokenTypes.PLUS, JSTokenTypes.MINUS};
        jSModifiersStructureArray[2] = new JSOneOfModifiersStructure(iElementTypeArray);
        CLASS_DECLARE_FIELD_MODIFIERS = new JSOrderedModifiersStructure(jSModifiersStructureArray);
        jSModifiersStructureArray = new JSModifiersStructure[7];
        iElementTypeArray = new IElementType[]{JSTokenTypes.PRIVATE_KEYWORD, JSTokenTypes.PUBLIC_KEYWORD};
        jSModifiersStructureArray[0] = new JSOneOfModifiersStructure(iElementTypeArray);
        jSModifiersStructureArray[1] = new JSModifiersStructureLeaf(JSTokenTypes.STATIC_KEYWORD, false, 2, null);
        jSModifiersStructureArray[2] = new JSModifiersStructureLeaf(JSTokenTypes.ACCESSOR_KEYWORD, false, 2, null);
        iElementTypeArray = new IElementType[]{JSTokenTypes.PLUS, JSTokenTypes.MINUS};
        jSModifiersStructureArray[3] = new JSOneOfModifiersStructure(iElementTypeArray);
        jSModifiersStructureArray[4] = new JSModifiersStructureLeaf(JSTokenTypes.ASYNC_KEYWORD, false, 2, null);
        iElementTypeArray = new IElementType[]{JSTokenTypes.GET_KEYWORD, JSTokenTypes.SET_KEYWORD};
        jSModifiersStructureArray[5] = new JSOneOfModifiersStructure(iElementTypeArray);
        jSModifiersStructureArray[6] = new JSModifiersStructureLeaf(JSTokenTypes.MULT, false, 2, null);
        CLASS_MEMBER_MODIFIERS_STRUCTURE = new JSOrderedModifiersStructure(jSModifiersStructureArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/lang/javascript/flow/psi/FlowJSStatementParser$Companion;", "", "<init>", "()V", "DECLARE_CLASS_MEMBER_MODIFIERS", "Lcom/intellij/lang/javascript/parsing/modifiers/JSModifiersStructure;", "IS_MEMBER_NAME_START", "Ljava/util/function/Predicate;", "Lcom/intellij/lang/PsiBuilder;", "CLASS_DECLARE_FIELD_MODIFIERS", "CLASS_MEMBER_MODIFIERS_STRUCTURE", "intellij.javascript.parser"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

