/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.ui.visualization;

import com.intellij.notebooks.ui.visualization.NotebookEditorAppearance;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.UserDataHolder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JT\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0019R\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/notebooks/ui/visualization/NotebookUtil;", "", "<init>", "()V", "notebookAppearance", "Lcom/intellij/notebooks/ui/visualization/NotebookEditorAppearance;", "Lcom/intellij/openapi/editor/Editor;", "getNotebookAppearance", "(Lcom/intellij/openapi/editor/Editor;)Lcom/intellij/notebooks/ui/visualization/NotebookEditorAppearance;", "paintNotebookCellBackgroundGutter", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "top", "", "height", "presentationModeMasking", "", "customColor", "Ljava/awt/Color;", "actionBetweenBackgroundAndStripe", "Lkotlin/Function0;", "intellij.notebooks.ui"})
public final class NotebookUtil {
    @NotNull
    public static final NotebookUtil INSTANCE = new NotebookUtil();

    private NotebookUtil() {
    }

    @NotNull
    public final NotebookEditorAppearance getNotebookAppearance(@NotNull Editor $this$notebookAppearance) {
        Intrinsics.checkNotNullParameter((Object)$this$notebookAppearance, (String)"<this>");
        Object object = NotebookEditorAppearance.Companion.getNOTEBOOK_APPEARANCE_KEY().get((UserDataHolder)$this$notebookAppearance);
        Intrinsics.checkNotNull((Object)object);
        return (NotebookEditorAppearance)object;
    }

    public final void paintNotebookCellBackgroundGutter(@NotNull EditorImpl editor, @NotNull Graphics g, @NotNull Rectangle r, int top, int height, boolean presentationModeMasking, @Nullable Color customColor, @NotNull Function0<Unit> actionBetweenBackgroundAndStripe) {
        Triple triple;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter(actionBetweenBackgroundAndStripe, (String)"actionBetweenBackgroundAndStripe");
        int diffViewOffset = 6;
        NotebookEditorAppearance appearance = this.getNotebookAppearance((Editor)editor);
        int borderWidth = appearance.getLeftBorderWidth();
        int gutterWidth = editor.getGutterComponentEx().getWidth();
        if (!presentationModeMasking) {
            Integer n = r.width - borderWidth;
            Integer n2 = borderWidth;
            Color color = customColor;
            if (color == null) {
                color = (Color)appearance.getCodeCellBackgroundColor().get();
            }
            triple = new Triple((Object)n, (Object)n2, (Object)color);
        } else {
            triple = new Triple((Object)(r.width - borderWidth - gutterWidth), (Object)gutterWidth, (Object)editor.getColorsScheme().getDefaultBackground());
        }
        Triple triple2 = triple;
        int fillX = ((Number)triple2.component1()).intValue();
        int fillWidth = ((Number)triple2.component2()).intValue();
        Color fillColor = (Color)triple2.component3();
        g.setColor(fillColor);
        if (editor.getEditorKind() == EditorKind.DIFF) {
            g.fillRect(fillX + diffViewOffset, top, fillWidth - diffViewOffset, height);
        } else {
            g.fillRect(fillX, top, fillWidth, height);
        }
        actionBetweenBackgroundAndStripe.invoke();
    }

    public static /* synthetic */ void paintNotebookCellBackgroundGutter$default(NotebookUtil notebookUtil, EditorImpl editorImpl, Graphics graphics, Rectangle rectangle, int n, int n2, boolean bl, Color color, Function0 function0, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            bl = false;
        }
        if ((n3 & 0x40) != 0) {
            color = null;
        }
        if ((n3 & 0x80) != 0) {
            function0 = NotebookUtil::paintNotebookCellBackgroundGutter$lambda$0;
        }
        notebookUtil.paintNotebookCellBackgroundGutter(editorImpl, graphics, rectangle, n, n2, bl, color, (Function0<Unit>)function0);
    }

    private static final Unit paintNotebookCellBackgroundGutter$lambda$0() {
        return Unit.INSTANCE;
    }
}

