/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui.cell.background;

import com.intellij.notebooks.ui.NotebookEditorUiUtilKt;
import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.notebooks.ui.visualization.markerRenderers.NotebookCellHighlighterRenderer;
import com.intellij.notebooks.ui.visualization.markerRenderers.NotebookLineMarkerRenderer;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.controllers.selfUpdate.common.NotebookCellSelfHighlighterController;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.cell.background.NotebookCodeCellBackgroundGutterRenderer;
import com.intellij.notebooks.visualization.ui.providers.bounds.JupyterBoundsChangeHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u0002J\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0016R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/notebooks/visualization/ui/cell/background/NotebookCellBackgroundController;", "Lcom/intellij/notebooks/visualization/controllers/selfUpdate/common/NotebookCellSelfHighlighterController;", "editorCell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "<init>", "(Lcom/intellij/notebooks/visualization/ui/EditorCell;)V", "cachedBounds", "Lkotlin/Pair;", "", "getHighlighterLayer", "getTextAttribute", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "customizeHighlighter", "", "cellHighlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "calculateBounds", "getOrCalculateBounds", "createLineMarkerRender", "Lcom/intellij/notebooks/ui/visualization/markerRenderers/NotebookLineMarkerRenderer;", "rangeHighlighter", "intellij.notebooks.visualization"})
public final class NotebookCellBackgroundController
extends NotebookCellSelfHighlighterController {
    @Nullable
    private Pair<Integer, Integer> cachedBounds;

    public NotebookCellBackgroundController(@NotNull EditorCell editorCell) {
        Intrinsics.checkNotNullParameter((Object)editorCell, (String)"editorCell");
        super(editorCell);
        NotebookEditorUiUtilKt.afterDistinctChange(NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.getEditor()).getCodeCellBackgroundColor(), (Disposable)this, arg_0 -> NotebookCellBackgroundController._init_$lambda$0(this, arg_0));
        JupyterBoundsChangeHandler jupyterBoundsChangeHandler = JupyterBoundsChangeHandler.Companion.get((Editor)this.getEditor());
        jupyterBoundsChangeHandler.subscribe((Disposable)this, () -> NotebookCellBackgroundController._init_$lambda$1(this));
    }

    @Override
    public int getHighlighterLayer() {
        return NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.getEditor()).getCellBackgroundHighlightLayer();
    }

    @Override
    @NotNull
    public TextAttributes getTextAttribute() {
        TextAttributes textAttributes = new TextAttributes();
        textAttributes.setBackgroundColor((Color)NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.getEditor()).getCodeCellBackgroundColor().get());
        return textAttributes;
    }

    @Override
    public void customizeHighlighter(@NotNull RangeHighlighterEx cellHighlighter) {
        Intrinsics.checkNotNullParameter((Object)cellHighlighter, (String)"cellHighlighter");
        cellHighlighter.setCustomRenderer((CustomHighlighterRenderer)NotebookCellHighlighterRenderer.INSTANCE);
    }

    private final Pair<Integer, Integer> calculateBounds() {
        NotebookCellLines.Interval interval = this.getEditorCell().getIntervalOrNull();
        if (interval == null) {
            return null;
        }
        NotebookCellLines.Interval interval2 = interval;
        TextRange range = interval2.getCellRange((Editor)this.getEditor());
        int top = this.getEditor().offsetToXY((int)range.getStartOffset()).y;
        int height = this.getEditor().offsetToXY((int)range.getEndOffset()).y + this.getEditor().getLineHeight() - top;
        return TuplesKt.to((Object)top, (Object)height);
    }

    @Nullable
    public final Pair<Integer, Integer> getOrCalculateBounds() {
        if (this.cachedBounds != null) {
            return this.cachedBounds;
        }
        Pair<Integer, Integer> newBounds = this.calculateBounds();
        this.cachedBounds = newBounds;
        return newBounds;
    }

    @Override
    @Nullable
    public NotebookLineMarkerRenderer createLineMarkerRender(@NotNull RangeHighlighterEx rangeHighlighter) {
        Intrinsics.checkNotNullParameter((Object)rangeHighlighter, (String)"rangeHighlighter");
        return new NotebookCodeCellBackgroundGutterRenderer(this);
    }

    private static final Unit _init_$lambda$0(NotebookCellBackgroundController this$0, Color it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.forceUpdate();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(NotebookCellBackgroundController this$0) {
        this$0.cachedBounds = null;
        return Unit.INSTANCE;
    }
}

