/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.raster;

import com.intellij.codeInsight.codeVision.ui.popup.layouter.RectangleUtilsKt;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.NotebookGraphicsConfigurationManager;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.NotebookOffScreenManager;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.raster.JcefOffScreenComponentController;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.raster.JcefOffScreenRaster;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.raster.JcefOffscreenViewPort;
import com.intellij.ui.JBColor;
import fleet.multiplatform.shims.ConcurrentHashMap;
import fleet.multiplatform.shims.ConcurrentHashMapKt;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u00018B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ&\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003J9\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150!2\u0006\u0010\"\u001a\u00020\u001c2\u000e\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020%0$2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0003\u00a2\u0006\u0002\u0010(J\u0006\u0010)\u001a\u00020*J\u0016\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u0003J&\u0010.\u001a\u00020\u00152\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u00101\u001a\u000202J\u0016\u00103\u001a\u00020*2\u0006\u0010/\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u0015J\u000e\u00105\u001a\u00020*2\u0006\u00106\u001a\u00020\u0003J\u0006\u00107\u001a\u00020*R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\u0004\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR$\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000b\"\u0004\b\u0018\u0010\u0019\u00a8\u00069"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenRaster;", "", "width", "", "height", "offscreenManager", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookOffScreenManager;", "<init>", "(IILcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookOffScreenManager;)V", "value", "getWidth", "()I", "getHeight", "Ljava/awt/Color;", "backgroundColor", "getBackgroundColor", "()Ljava/awt/Color;", "setBackgroundColor", "(Ljava/awt/Color;)V", "viewPorts", "Lfleet/multiplatform/shims/ConcurrentHashMap;", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffscreenViewPort;", "cefScrollY", "getCefScrollY", "setCefScrollY", "(I)V", "fromByteBuffer", "bytes", "Ljava/nio/ByteBuffer;", "firstPixelStart", "secondPixelStart", "offset", "updateImageFromCef", "", "buffer", "dirtyRects", "", "Ljava/awt/Rectangle;", "bufferWidth", "bufferHeight", "(Ljava/nio/ByteBuffer;[Ljava/awt/Rectangle;II)Ljava/util/Set;", "updateViewports", "", "updateViewportId", "idHashOld", "idHashNew", "addViewPort", "idHash", "top", "viewPortController", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenComponentController;", "removeViewPort", "viewPort", "changeRasterWidth", "newWidth", "updateTotalHeightIfNeeded", "PixelByteBufferReader", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJcefOffScreenRaster.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JcefOffScreenRaster.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenRaster\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,258:1\n1863#2,2:259\n1863#2,2:261\n774#2:263\n865#2,2:264\n1863#2,2:266\n1863#2,2:269\n1#3:268\n*S KotlinDebug\n*F\n+ 1 JcefOffScreenRaster.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenRaster\n*L\n44#1:259,2\n171#1:261,2\n220#1:263\n220#1:264,2\n220#1:266,2\n249#1:269,2\n*E\n"})
public final class JcefOffScreenRaster {
    @NotNull
    private final NotebookOffScreenManager offscreenManager;
    private int width;
    private int height;
    @NotNull
    private Color backgroundColor;
    @NotNull
    private final ConcurrentHashMap<Integer, JcefOffscreenViewPort> viewPorts;
    private int cefScrollY;

    public JcefOffScreenRaster(int width, int height, @NotNull NotebookOffScreenManager offscreenManager) {
        Intrinsics.checkNotNullParameter((Object)offscreenManager, (String)"offscreenManager");
        this.offscreenManager = offscreenManager;
        this.width = width;
        this.height = height;
        JBColor jBColor = JBColor.BLACK;
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"BLACK");
        this.backgroundColor = (Color)jBColor;
        this.viewPorts = ConcurrentHashMapKt.ConcurrentHashMap();
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public final void setBackgroundColor(@NotNull Color value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.backgroundColor = value;
        Iterable $this$forEach$iv = this.viewPorts.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JcefOffscreenViewPort it = (JcefOffscreenViewPort)element$iv;
            boolean bl = false;
            it.setBackgroundColor(value);
        }
    }

    public final int getCefScrollY() {
        return this.cefScrollY;
    }

    public final void setCefScrollY(int n) {
        this.cefScrollY = n;
    }

    public final int fromByteBuffer(@NotNull ByteBuffer bytes, int firstPixelStart, int secondPixelStart, int offset) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int result = switch (offset) {
            case 0 -> (bytes.get(firstPixelStart * 4 + 2) & 0xFF) << 0 | (bytes.get(firstPixelStart * 4 + 1) & 0xFF) << 8 | (bytes.get(firstPixelStart * 4) & 0xFF) << 16 | (bytes.get(secondPixelStart * 4 + 2) & 0xFF) << 24;
            case 1 -> (bytes.get(firstPixelStart * 4 + 1) & 0xFF) << 0 | (bytes.get(firstPixelStart * 4) & 0xFF) << 8 | (bytes.get(secondPixelStart * 4 + 2) & 0xFF) << 16 | (bytes.get(secondPixelStart * 4 + 1) & 0xFF) << 24;
            default -> (bytes.get(firstPixelStart * 4) & 0xFF) << 0 | (bytes.get(secondPixelStart * 4 + 2) & 0xFF) << 8 | (bytes.get(secondPixelStart * 4 + 1) & 0xFF) << 16 | (bytes.get(secondPixelStart * 4) & 0xFF) << 24;
        };
        return result;
    }

    @NotNull
    public final Set<JcefOffscreenViewPort> updateImageFromCef(@NotNull ByteBuffer buffer, @NotNull Rectangle[] dirtyRects, int bufferWidth, int bufferHeight) {
        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"com/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenRaster$updateImageFromCef$ViewportData", "", "idHash", "", "y", "height", "<init>", "(III)V", "getIdHash", "()I", "getY", "getHeight", "intellij.jupyter.core"})
        public final class ViewportData {
            private final int idHash;
            private final int y;
            private final int height;

            public ViewportData(int idHash, int y, int height) {
                this.idHash = idHash;
                this.y = y;
                this.height = height;
            }

            public final int getIdHash() {
                return this.idHash;
            }

            public final int getY() {
                return this.y;
            }

            public final int getHeight() {
                return this.height;
            }
        }
        Rectangle[] rectangleArray;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)dirtyRects, (String)"dirtyRects");
        if (bufferWidth < 2 || bufferHeight < 1) {
            return SetsKt.emptySet();
        }
        NotebookGraphicsConfigurationManager graphicsConfigurationManager = this.offscreenManager.getGraphicsConfigurationManager();
        float screenScale = graphicsConfigurationManager.getScreenScale();
        PixelByteBufferReader reader = new PixelByteBufferReader(buffer, screenScale);
        int cefViewportsCount = reader.getInt();
        int requiredPixels = (int)Math.ceil((double)((cefViewportsCount * 3 + 2) * 4) / 3.0);
        if (cefViewportsCount > this.viewPorts.size() || MathKt.roundToInt((float)((float)requiredPixels * screenScale)) >= bufferWidth * bufferHeight) {
            return SetsKt.emptySet();
        }
        int cefRealScrollY = reader.getInt();
        if (this.cefScrollY == cefRealScrollY) {
            rectangleArray = dirtyRects;
        } else {
            Rectangle[] rectangleArray2 = new Rectangle[]{new Rectangle(0, 0, bufferWidth, bufferHeight)};
            rectangleArray = rectangleArray2;
        }
        Rectangle[] correctedDirtyRects = rectangleArray;
        this.cefScrollY = cefRealScrollY;
        List cefViewports = new ArrayList();
        int n = 0;
        while (n < cefViewportsCount) {
            int it = n++;
            boolean bl = false;
            cefViewports.add(new ViewportData(reader.getInt(), reader.getInt(), reader.getInt()));
        }
        boolean boundsChanged = false;
        Set affectedPorts = new LinkedHashSet();
        IntBuffer source = buffer.order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        for (Rectangle dirtyRect : correctedDirtyRects) {
            Iterable $this$forEach$iv = cefViewports;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DataBufferInt dest;
                Rectangle viewportBounds;
                Rectangle viewportScaledBounds;
                Rectangle intersectionRect;
                JcefOffscreenViewPort viewPort;
                ViewportData cefViewport = (ViewportData)element$iv;
                boolean bl = false;
                if ((JcefOffscreenViewPort)this.viewPorts.get((Object)cefViewport.getIdHash()) == null) continue;
                if (viewPort.getBounds().y != cefViewport.getY() || viewPort.getBounds().height != cefViewport.getHeight()) {
                    viewPort.setBounds(new Rectangle(viewPort.getBounds().x, cefViewport.getY(), viewPort.getBounds().width, cefViewport.getHeight()));
                    boundsChanged = true;
                }
                if ((intersectionRect = dirtyRect.intersection(viewportScaledBounds = graphicsConfigurationManager.scaleUpRect(viewportBounds = new Rectangle(viewPort.getBounds().x, viewPort.getBounds().y - this.cefScrollY, viewPort.getBounds().width, viewPort.getBounds().height)))).isEmpty()) continue;
                ((Collection)affectedPorts).add(viewPort);
                BufferedImage destBuffer = viewPort.getOrCreateBuffer();
                WritableRaster writableRaster = destBuffer.getRaster();
                DataBuffer dataBuffer = writableRaster != null ? writableRaster.getDataBuffer() : null;
                if ((dataBuffer instanceof DataBufferInt ? (DataBufferInt)dataBuffer : null) == null) continue;
                dest = dest;
                int n2 = intersectionRect.y;
                int n3 = intersectionRect.y + intersectionRect.height;
                int n4 = 0;
                while (n2 < n3) {
                    int index = n4++;
                    int y = n2++;
                    int sourceOffset = y * bufferWidth + intersectionRect.x;
                    int targetOffset = (index + intersectionRect.y - viewportScaledBounds.y) * viewportScaledBounds.width + intersectionRect.x;
                    source.position(sourceOffset).get(dest.getData(), targetOffset, intersectionRect.width);
                }
                if (!intersectionRect.contains(0, 0)) continue;
                int pixelOffset = -viewportScaledBounds.y;
                int pixelSize = MathKt.roundToInt((float)screenScale);
                if (pixelSize >= destBuffer.getWidth() || pixelOffset + pixelSize >= destBuffer.getHeight()) continue;
                int n5 = MathKt.roundToInt((float)((float)requiredPixels * screenScale));
                for (int i = 0; i < n5; ++i) {
                    int n6 = pixelOffset + pixelSize;
                    for (int j = pixelOffset; j < n6; ++j) {
                        destBuffer.setRGB(i, j, this.backgroundColor.getRGB());
                    }
                }
            }
        }
        if (boundsChanged) {
            this.updateTotalHeightIfNeeded();
        }
        return affectedPorts;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateViewports() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.viewPorts.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JcefOffscreenViewPort it = (JcefOffscreenViewPort)element$iv$iv;
            boolean bl = false;
            if (!it.hasBuffer()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JcefOffscreenViewPort it = (JcefOffscreenViewPort)element$iv;
            boolean bl = false;
            it.getOrCreateBuffer();
        }
    }

    public final void updateViewportId(int idHashOld, int idHashNew) {
        if (idHashOld == idHashNew) {
            return;
        }
        JcefOffscreenViewPort res = (JcefOffscreenViewPort)this.viewPorts.remove((Object)idHashOld);
        if (res != null) {
            Integer n = idHashNew;
            ((Map)this.viewPorts).put(n, res);
        }
    }

    @NotNull
    public final JcefOffscreenViewPort addViewPort(int idHash, int top, int height, @NotNull JcefOffScreenComponentController viewPortController) {
        Intrinsics.checkNotNullParameter((Object)viewPortController, (String)"viewPortController");
        JcefOffscreenViewPort result = new JcefOffscreenViewPort(new Rectangle(0, top, this.width, height), viewPortController, this.offscreenManager.getGraphicsConfigurationManager());
        result.setBackgroundColor(this.backgroundColor);
        Integer n = idHash;
        ((Map)this.viewPorts).put(n, result);
        this.updateTotalHeightIfNeeded();
        return result;
    }

    public final void removeViewPort(int idHash, @NotNull JcefOffscreenViewPort viewPort) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)viewPort, (String)"viewPort");
        boolean bl2 = bl = this.viewPorts.remove((Object)idHash) != null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "View port " + viewPort + " doesn't exist";
            throw new AssertionError((Object)string);
        }
        this.updateTotalHeightIfNeeded();
    }

    public final void changeRasterWidth(int newWidth) {
        boolean bl;
        if (newWidth == this.width) {
            return;
        }
        boolean bl2 = bl = newWidth > 0;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-JcefOffScreenRaster$changeRasterWidth$22 = false;
            String $i$a$-assert-JcefOffScreenRaster$changeRasterWidth$22 = newWidth + " <= 0";
            throw new AssertionError((Object)$i$a$-assert-JcefOffScreenRaster$changeRasterWidth$22);
        }
        Iterable $this$forEach$iv = this.viewPorts.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JcefOffscreenViewPort it = (JcefOffscreenViewPort)element$iv;
            boolean bl3 = false;
            it.setBounds(new Rectangle(it.getBounds().x, it.getBounds().y, newWidth, it.getBounds().height));
        }
        this.width = newWidth;
    }

    public final void updateTotalHeightIfNeeded() {
        Comparable comparable;
        Iterator iterator = ((Iterable)this.viewPorts.values()).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            JcefOffscreenViewPort it = (JcefOffscreenViewPort)iterator.next();
            boolean bl = false;
            Comparable comparable2 = Integer.valueOf(RectangleUtilsKt.getBottom((Rectangle)it.getBounds()));
            while (iterator.hasNext()) {
                JcefOffscreenViewPort it2 = (JcefOffscreenViewPort)iterator.next();
                $i$a$-maxOfOrNull-JcefOffScreenRaster$updateTotalHeightIfNeeded$requiredHeight$1 = false;
                Comparable comparable3 = Integer.valueOf(RectangleUtilsKt.getBottom((Rectangle)it2.getBounds()));
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = (Integer)comparable;
        if (n == null) {
            return;
        }
        int requiredHeight = n;
        if (this.height == requiredHeight) {
            return;
        }
        this.height = requiredHeight;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenRaster$PixelByteBufferReader;", "", "buffer", "Ljava/nio/ByteBuffer;", "screenScale", "", "<init>", "(Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenRaster;Ljava/nio/ByteBuffer;F)V", "offset", "", "pixelIndex", "getInt", "intellij.jupyter.core"})
    public final class PixelByteBufferReader {
        @NotNull
        private final ByteBuffer buffer;
        private final float screenScale;
        private int offset;
        private int pixelIndex;

        public PixelByteBufferReader(ByteBuffer buffer, float screenScale) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            this.buffer = buffer;
            this.screenScale = screenScale;
        }

        public final int getInt() {
            int result = JcefOffScreenRaster.this.fromByteBuffer(this.buffer, MathKt.roundToInt((float)((float)this.pixelIndex * this.screenScale)), MathKt.roundToInt((float)((float)(this.pixelIndex + 1) * this.screenScale)), this.offset);
            int n = this.offset;
            this.offset = n + 1;
            n = this.pixelIndex;
            this.pixelIndex = n + 1;
            if (this.offset > 2) {
                this.offset = 0;
                n = this.pixelIndex;
                this.pixelIndex = n + 1;
            }
            return result;
        }
    }
}

