/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.nbformat;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.JupyterJsonKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterAttachments;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCellBaseKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCellBuilder;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCellIdGenerator;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterListenersKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterMetadata;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterMetadataAwareBase;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookBase;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookSchema;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutputs;
import com.intellij.jupyter.core.jupyter.nbformat.metadata.ExecutionTimeMetadata;
import com.intellij.jupyter.core.jupyter.nbformat.schema.JupyterNotebookCellSchema;
import com.intellij.lang.Language;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001gB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010S\u001a\u00020V2\u0006\u0010W\u001a\u00020.2\u0006\u0010\u0011\u001a\u00020XH\u0016J\u0010\u0010Y\u001a\u00020V2\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0018\u0010Z\u001a\u00020\u00102\u0006\u0010W\u001a\u00020.2\u0006\u0010\u0011\u001a\u00020XH\u0002J\u0018\u0010[\u001a\u00020V2\u0006\u0010W\u001a\u00020.2\u0006\u0010\u0011\u001a\u00020XH\u0002J\u0010\u0010\\\u001a\u00020V2\u0006\u0010]\u001a\u00020^H\u0002J\u0016\u0010_\u001a\u00020V2\f\u0010`\u001a\b\u0012\u0004\u0012\u00020V0aH\u0002J\b\u0010b\u001a\u00020VH\u0002J\u0013\u0010c\u001a\u00020\u00102\b\u0010d\u001a\u0004\u0018\u00010eH\u0096\u0002J\b\u0010f\u001a\u00020!H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R(\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\u0011\u001a\u0004\u0018\u00010\u00188V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR(\u0010\u001e\u001a\u0004\u0018\u00010\u00182\b\u0010\u0011\u001a\u0004\u0018\u00010\u00188V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR(\u0010\"\u001a\u0004\u0018\u00010!2\b\u0010\u0011\u001a\u0004\u0018\u00010!8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R$\u0010'\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00108V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R$\u0010+\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00108V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010(\"\u0004\b-\u0010*R$\u0010/\u001a\u00020.2\u0006\u0010\u0011\u001a\u00020.8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b0\u00101\"\u0004\b2\u00103R(\u00105\u001a\u0004\u0018\u0001042\b\u0010\u0011\u001a\u0004\u0018\u0001048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u0014\u0010:\u001a\u00020;8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R4\u0010?\u001a\n\u0018\u00010.j\u0004\u0018\u0001`>2\u000e\u0010\u0011\u001a\n\u0018\u00010.j\u0004\u0018\u0001`>8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b@\u00101\"\u0004\bA\u00103R\u0014\u0010B\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010\fR$\u0010D\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00108V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bE\u0010(\"\u0004\bF\u0010*R$\u0010G\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00108V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bH\u0010(\"\u0004\bI\u0010*R\u0014\u0010J\u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010LR\u0016\u0010M\u001a\u0004\u0018\u00010!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bN\u0010$R$\u0010P\u001a\u00020O2\u0006\u0010\u0011\u001a\u00020O@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010R\"\u0004\bS\u0010TR\u000e\u0010U\u001a\u00020OX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006h"}, d2={"Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCellBase;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterMetadataAwareBase;", "jupyterNotebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookBase;", "json", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "schema", "Lcom/intellij/jupyter/core/jupyter/nbformat/schema/JupyterNotebookCellSchema;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookBase;Lcom/fasterxml/jackson/databind/node/ObjectNode;Lcom/intellij/jupyter/core/jupyter/nbformat/schema/JupyterNotebookCellSchema;)V", "getJson$intellij_jupyter_core", "()Lcom/fasterxml/jackson/databind/node/ObjectNode;", "getSchema", "()Lcom/intellij/jupyter/core/jupyter/nbformat/schema/JupyterNotebookCellSchema;", "notifyOnChange", "", "value", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;", "cellType", "getCellType", "()Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;", "setCellType", "(Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;)V", "Ljava/time/ZonedDateTime;", "executionStartTime", "getExecutionStartTime", "()Ljava/time/ZonedDateTime;", "setExecutionStartTime", "(Ljava/time/ZonedDateTime;)V", "executionEndTime", "getExecutionEndTime", "setExecutionEndTime", "", "executionCount", "getExecutionCount", "()Ljava/lang/Integer;", "setExecutionCount", "(Ljava/lang/Integer;)V", "isExecuting", "()Z", "setExecuting", "(Z)V", "collapsed", "getCollapsed", "setCollapsed", "", "source", "getSource", "()Ljava/lang/String;", "setSource", "(Ljava/lang/String;)V", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterOutputs;", "outputs", "getOutputs", "()Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterOutputs;", "setOutputs", "(Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterOutputs;)V", "attachments", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterAttachments;", "getAttachments", "()Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterAttachments;", "Lcom/intellij/jupyter/core/jupyter/nbformat/CellId;", "id", "getId", "setId", "content", "getContent", "sourceHidden", "getSourceHidden", "setSourceHidden", "outputsHidden", "getOutputsHidden", "setOutputsHidden", "level", "getLevel", "()I", "index", "getIndex", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterMetadata;", "metadata", "getMetadata", "()Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterMetadata;", "setMetadata", "(Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterMetadata;)V", "jupyterMetadata", "", "key", "Lcom/fasterxml/jackson/databind/JsonNode;", "setAllMetadataFrom", "isTrivialNameToFilter", "cleanUpNameField", "storeExecutionTime", "executionTimeMetadata", "Lcom/intellij/jupyter/core/jupyter/nbformat/metadata/ExecutionTimeMetadata;", "runWithNotification", "runnable", "Lkotlin/Function0;", "notifyIfNecessary", "equals", "other", "", "hashCode", "JupyterCellBuilderBase", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterCellBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterCellBase.kt\ncom/intellij/jupyter/core/jupyter/nbformat/JupyterCellBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,269:1\n360#2,7:270\n1#3:277\n*S KotlinDebug\n*F\n+ 1 JupyterCellBase.kt\ncom/intellij/jupyter/core/jupyter/nbformat/JupyterCellBase\n*L\n143#1:270,7\n*E\n"})
public final class JupyterCellBase
extends JupyterMetadataAwareBase
implements JupyterCell {
    @NotNull
    private final JupyterNotebookBase jupyterNotebook;
    @NotNull
    private final ObjectNode json;
    @NotNull
    private final JupyterNotebookCellSchema schema;
    private boolean notifyOnChange;
    @NotNull
    private JupyterMetadata metadata;
    @NotNull
    private final JupyterMetadata jupyterMetadata;

    public JupyterCellBase(@NotNull JupyterNotebookBase jupyterNotebook, @NotNull ObjectNode json, @NotNull JupyterNotebookCellSchema schema) {
        Intrinsics.checkNotNullParameter((Object)jupyterNotebook, (String)"jupyterNotebook");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        this.jupyterNotebook = jupyterNotebook;
        this.json = json;
        this.schema = schema;
        this.notifyOnChange = true;
        this.getSchema().revalidateCell(this.json);
        this.metadata = this.getSchema().getCellMetadata(this.json);
        this.jupyterMetadata = this.getMetadata().getOrCreateObject("jupyter");
    }

    @NotNull
    public final ObjectNode getJson$intellij_jupyter_core() {
        return this.json;
    }

    @Override
    @NotNull
    public JupyterNotebookCellSchema getSchema() {
        return this.schema;
    }

    @Override
    @NotNull
    public JupyterCellType getCellType() {
        JupyterCellType jupyterCellType;
        try {
            jupyterCellType = this.getSchema().getCellType(this.json);
        }
        catch (Exception exception) {
            jupyterCellType = JupyterCellType.UNDEFINED;
        }
        return jupyterCellType;
    }

    @Override
    public void setCellType(@NotNull JupyterCellType value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value == this.getCellType()) {
            return;
        }
        this.runWithNotification((Function0<Unit>)((Function0)() -> JupyterCellBase._set_cellType_$lambda$0(this, value)));
    }

    @Override
    @Nullable
    public ZonedDateTime getExecutionStartTime() {
        String string = ExecutionTimeMetadata.Companion.createExecutionMetadata(this.getMetadata("ExecuteTime")).getStartTime();
        if (string == null) {
            return null;
        }
        String executionTimeMetadata = string;
        return ExecutionTimeMetadata.Companion.parseExecutionMetadata(executionTimeMetadata);
    }

    @Override
    public void setExecutionStartTime(@Nullable ZonedDateTime value) {
        String executionTimeStart = ExecutionTimeMetadata.Companion.formattingExecutionTime(value);
        this.storeExecutionTime(new ExecutionTimeMetadata(executionTimeStart, null, 2, null));
    }

    @Override
    @Nullable
    public ZonedDateTime getExecutionEndTime() {
        String string = ExecutionTimeMetadata.Companion.createExecutionMetadata(this.getMetadata("ExecuteTime")).getEndTime();
        if (string == null) {
            return null;
        }
        String executionTimeMetadata = string;
        return ExecutionTimeMetadata.Companion.parseExecutionMetadata(executionTimeMetadata);
    }

    @Override
    public void setExecutionEndTime(@Nullable ZonedDateTime value) {
        String executionTimeEnd = ExecutionTimeMetadata.Companion.formattingExecutionTime(value);
        JsonNode jsonNode = this.getMetadata("ExecuteTime");
        if (jsonNode == null) {
            return;
        }
        JsonNode metadata = jsonNode;
        ExecutionTimeMetadata executionTimeMetadata = ExecutionTimeMetadata.Companion.createExecutionMetadata((JsonNode)((ObjectNode)metadata));
        executionTimeMetadata.setEndTime(executionTimeEnd);
        this.storeExecutionTime(executionTimeMetadata);
    }

    @Override
    @Nullable
    public Integer getExecutionCount() {
        return ((CharSequence)this.getSchema().getSource(this.json)).length() == 0 ? null : this.getSchema().getExecutionCount(this.json);
    }

    @Override
    public void setExecutionCount(@Nullable Integer value) {
        if (this.getSchema().setExecutionCount(this.json, value)) {
            this.notifyIfNecessary();
        }
    }

    @Override
    public boolean isExecuting() {
        return this.jupyterMetadata.getBoolean("is_executing");
    }

    @Override
    public void setExecuting(boolean value) {
        if (this.jupyterMetadata.setBoolean("is_executing", value)) {
            this.notifyIfNecessary();
        }
    }

    @Override
    public boolean getCollapsed() {
        return this.getSchema().getCollapsed(this.json);
    }

    @Override
    public void setCollapsed(boolean value) {
        if (this.getSchema().setCollapsed(this.json, value)) {
            this.notifyIfNecessary();
        }
    }

    @Override
    @NotNull
    public String getSource() {
        return this.getSchema().getSource(this.json);
    }

    @Override
    public void setSource(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (this.getSchema().setSource(this.json, value)) {
            this.notifyIfNecessary();
        }
    }

    @Override
    @Nullable
    public JupyterOutputs getOutputs() {
        return this.getSchema().getOutput(this.json);
    }

    @Override
    public void setOutputs(@Nullable JupyterOutputs value) {
        this.runWithNotification((Function0<Unit>)((Function0)() -> JupyterCellBase._set_outputs_$lambda$1(this, value)));
    }

    @Override
    @NotNull
    public JupyterAttachments getAttachments() {
        return this.getSchema().getAttachments(this.json);
    }

    @Override
    @Nullable
    public String getId() {
        return this.getSchema().getCellId(this.json);
    }

    @Override
    public void setId(@Nullable String value) {
        this.getSchema().setCellId(this.json, value);
    }

    @Override
    @NotNull
    protected ObjectNode getContent() {
        return this.json;
    }

    @Override
    public boolean getSourceHidden() {
        return this.jupyterMetadata.getBoolean("source_hidden");
    }

    @Override
    public void setSourceHidden(boolean value) {
        if (this.jupyterMetadata.setBoolean("source_hidden", value)) {
            this.notifyIfNecessary();
        }
    }

    @Override
    public boolean getOutputsHidden() {
        return this.jupyterMetadata.getBoolean("outputs_hidden");
    }

    @Override
    public void setOutputsHidden(boolean value) {
        if (this.jupyterMetadata.setBoolean("outputs_hidden", value)) {
            this.notifyIfNecessary();
        }
    }

    @Override
    public int getLevel() {
        return this.getSchema().getLevel(this.json);
    }

    @Override
    @Nullable
    public Integer getIndex() {
        int n;
        block2: {
            List<JupyterCell> $this$indexOfFirst$iv = this.jupyterNotebook.computeCells();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<JupyterCell> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                JupyterCell item$iv;
                JupyterCell it = item$iv = iterator.next();
                boolean bl = false;
                JupyterCellBase jupyterCellBase = it instanceof JupyterCellBase ? (JupyterCellBase)it : null;
                if (Intrinsics.areEqual((Object)(jupyterCellBase != null ? jupyterCellBase.json : null), (Object)this.json)) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        Integer n2 = n;
        int it = ((Number)n2).intValue();
        boolean bl = false;
        return it != -1 ? n2 : null;
    }

    @Override
    @NotNull
    public JupyterMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(@NotNull JupyterMetadata value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.runWithNotification((Function0<Unit>)((Function0)() -> JupyterCellBase._set_metadata_$lambda$4(this, value)));
    }

    @Override
    public void setMetadata(@NotNull String key, @NotNull JsonNode value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (this.isTrivialNameToFilter(key, value)) {
            this.cleanUpNameField(key, value);
            return;
        }
        if (!Intrinsics.areEqual((Object)this.getMetadata(key), (Object)value)) {
            this.runWithNotification((Function0<Unit>)((Function0)() -> JupyterCellBase.setMetadata$lambda$5(this, key, value)));
        }
    }

    @Override
    public void setAllMetadataFrom(@NotNull ObjectNode value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.runWithNotification((Function0<Unit>)((Function0)() -> JupyterCellBase.setAllMetadataFrom$lambda$6(this, value)));
    }

    private final boolean isTrivialNameToFilter(String key, JsonNode value) {
        return Intrinsics.areEqual((Object)key, (Object)"name") && Intrinsics.areEqual(JupyterCellBaseKt.access$getCellNames$p().get(this.getCellType()), (Object)value.asText());
    }

    private final void cleanUpNameField(String key, JsonNode value) {
        if (Intrinsics.areEqual((Object)this.getMetadata(key), (Object)value)) {
            super.removeMetadata(key);
        }
    }

    private final void storeExecutionTime(ExecutionTimeMetadata executionTimeMetadata) {
        if (executionTimeMetadata.getStartTime() == null) {
            this.removeMetadata("ExecuteTime");
        } else {
            JsonNode jsonNode = JupyterJsonKt.getJackson().valueToTree((Object)executionTimeMetadata);
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"valueToTree(...)");
            this.setMetadata("ExecuteTime", jsonNode);
        }
    }

    private final void runWithNotification(Function0<Unit> runnable) {
        runnable.invoke();
        this.notifyIfNecessary();
    }

    private final void notifyIfNecessary() {
        if (this.notifyOnChange) {
            JupyterListenersKt.notifyNotebookChanged(this.jupyterNotebook);
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.jupyter.core.jupyter.nbformat.JupyterCellBase");
        JupyterCellBase cfr_ignored_0 = (JupyterCellBase)other;
        if (!Intrinsics.areEqual((Object)this.jupyterNotebook, (Object)((JupyterCellBase)other).jupyterNotebook)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.json, (Object)((JupyterCellBase)other).json)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getSchema(), (Object)((JupyterCellBase)other).getSchema())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getMetadata(), (Object)((JupyterCellBase)other).getMetadata())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.jupyterMetadata, (Object)((JupyterCellBase)other).jupyterMetadata);
    }

    public int hashCode() {
        int result = this.jupyterNotebook.hashCode();
        result = 31 * result + this.json.hashCode();
        result = 31 * result + this.getSchema().hashCode();
        result = 31 * result + this.getMetadata().hashCode();
        result = 31 * result + this.jupyterMetadata.hashCode();
        return result;
    }

    private static final Unit _set_cellType_$lambda$0(JupyterCellBase this$0, JupyterCellType $value) {
        this$0.getSchema().setCellType(this$0.json, $value);
        this$0.getSchema().revalidateCell(this$0.json);
        return Unit.INSTANCE;
    }

    private static final Unit _set_outputs_$lambda$1(JupyterCellBase this$0, JupyterOutputs $value) {
        this$0.getSchema().setOutput(this$0.json, $value);
        return Unit.INSTANCE;
    }

    private static final Unit _set_metadata_$lambda$4(JupyterCellBase this$0, JupyterMetadata $value) {
        this$0.getSchema().setCellMetadata(this$0.json, $value);
        return Unit.INSTANCE;
    }

    private static final Unit setMetadata$lambda$5(JupyterCellBase this$0, String $key, JsonNode $value) {
        super.setMetadata($key, $value);
        return Unit.INSTANCE;
    }

    private static final Unit setAllMetadataFrom$lambda$6(JupyterCellBase this$0, ObjectNode $value) {
        super.setAllMetadataFrom($value);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u0010\b\u0002\u0010\u000e\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u0011H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001e\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\"\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\n\u001a\u00020\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010\f\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\"\u0010\u000e\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010(\"\u0004\b,\u0010*R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCellBase$JupyterCellBuilderBase;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCellBuilder;", "notebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookBase;", "cellType", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;", "language", "Lcom/intellij/lang/Language;", "executionCount", "", "collapsed", "", "source", "", "id", "Lcom/intellij/jupyter/core/jupyter/nbformat/CellId;", "schema", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookSchema;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookBase;Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;Lcom/intellij/lang/Language;Ljava/lang/Integer;ZLjava/lang/String;Ljava/lang/String;Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookSchema;)V", "getNotebook", "()Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookBase;", "getCellType", "()Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;", "setCellType", "(Lorg/jetbrains/plugins/notebooks/psi/jupyter/nbformat/JupyterCellType;)V", "getLanguage", "()Lcom/intellij/lang/Language;", "setLanguage", "(Lcom/intellij/lang/Language;)V", "getExecutionCount", "()Ljava/lang/Integer;", "setExecutionCount", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getCollapsed", "()Z", "setCollapsed", "(Z)V", "getSource", "()Ljava/lang/String;", "setSource", "(Ljava/lang/String;)V", "getId", "setId", "isCompatible", "notebookSchema", "build", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "json", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "intellij.jupyter.core"})
    public static final class JupyterCellBuilderBase
    implements JupyterCellBuilder {
        @NotNull
        private final JupyterNotebookBase notebook;
        @NotNull
        private JupyterCellType cellType;
        @Nullable
        private Language language;
        @Nullable
        private Integer executionCount;
        private boolean collapsed;
        @NotNull
        private String source;
        @Nullable
        private String id;
        @NotNull
        private final JupyterNotebookSchema schema;

        public JupyterCellBuilderBase(@NotNull JupyterNotebookBase notebook, @NotNull JupyterCellType cellType, @Nullable Language language, @Nullable Integer executionCount, boolean collapsed, @NotNull String source, @Nullable String id, @NotNull JupyterNotebookSchema schema) {
            Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
            Intrinsics.checkNotNullParameter((Object)cellType, (String)"cellType");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this.notebook = notebook;
            this.cellType = cellType;
            this.language = language;
            this.executionCount = executionCount;
            this.collapsed = collapsed;
            this.source = source;
            this.id = id;
            this.schema = schema;
        }

        public /* synthetic */ JupyterCellBuilderBase(JupyterNotebookBase jupyterNotebookBase, JupyterCellType jupyterCellType, Language language, Integer n, boolean bl, String string, String string2, JupyterNotebookSchema jupyterNotebookSchema, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                jupyterCellType = JupyterCellType.RAW;
            }
            if ((n2 & 4) != 0) {
                language = null;
            }
            if ((n2 & 8) != 0) {
                n = null;
            }
            if ((n2 & 0x10) != 0) {
                bl = false;
            }
            if ((n2 & 0x20) != 0) {
                string = "";
            }
            if ((n2 & 0x40) != 0) {
                string2 = null;
            }
            this(jupyterNotebookBase, jupyterCellType, language, n, bl, string, string2, jupyterNotebookSchema);
        }

        @NotNull
        public final JupyterNotebookBase getNotebook() {
            return this.notebook;
        }

        @Override
        @NotNull
        public JupyterCellType getCellType() {
            return this.cellType;
        }

        @Override
        public void setCellType(@NotNull JupyterCellType jupyterCellType) {
            Intrinsics.checkNotNullParameter((Object)jupyterCellType, (String)"<set-?>");
            this.cellType = jupyterCellType;
        }

        @Override
        @Nullable
        public Language getLanguage() {
            return this.language;
        }

        @Override
        public void setLanguage(@Nullable Language language) {
            this.language = language;
        }

        @Override
        @Nullable
        public Integer getExecutionCount() {
            return this.executionCount;
        }

        @Override
        public void setExecutionCount(@Nullable Integer n) {
            this.executionCount = n;
        }

        @Override
        public boolean getCollapsed() {
            return this.collapsed;
        }

        @Override
        public void setCollapsed(boolean bl) {
            this.collapsed = bl;
        }

        @Override
        @NotNull
        public String getSource() {
            return this.source;
        }

        @Override
        public void setSource(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.source = string;
        }

        @Override
        @Nullable
        public String getId() {
            return this.id;
        }

        @Override
        public void setId(@Nullable String string) {
            this.id = string;
        }

        @Override
        public boolean isCompatible(@NotNull JupyterNotebookSchema notebookSchema) {
            Intrinsics.checkNotNullParameter((Object)notebookSchema, (String)"notebookSchema");
            return true;
        }

        @Override
        @NotNull
        public JupyterCell build(@NotNull ObjectNode json) {
            JupyterCellBase jupyterCellBase;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            JupyterCellBase cell = jupyterCellBase = new JupyterCellBase(this.notebook, json, this.schema.getCellSchema());
            boolean bl = false;
            cell.notifyOnChange = false;
            cell.setCellType(this.getCellType());
            cell.setSource(this.getSource());
            cell.setCollapsed(this.getCollapsed());
            String string = this.getId();
            if (string == null) {
                string = JupyterCellIdGenerator.INSTANCE.makeRandom();
            }
            cell.setId(string);
            cell.notifyOnChange = true;
            return jupyterCellBase;
        }
    }
}

