/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.columns;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumn;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnReference;
import org.jetbrains.kotlinx.dataframe.columns.ColumnResolutionContext;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPath;
import org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001d\u0010\u000b\u001a\u00028\u00002\u000e\u0010\f\u001a\n\u0012\u0002\b\u00030\rj\u0002`\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001f\u0010\u0010\u001a\u0004\u0018\u00018\u00002\u000e\u0010\f\u001a\n\u0012\u0002\b\u00030\rj\u0002`\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u0018\u0010\u0013\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/columns/RenamedColumnReference;", "C", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;", "source", "name", "", "(Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getSource", "()Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;", "getValue", "row", "Lorg/jetbrains/kotlinx/dataframe/DataRow;", "Lorg/jetbrains/kotlinx/dataframe/AnyRow;", "(Lorg/jetbrains/kotlinx/dataframe/DataRow;)Ljava/lang/Object;", "getValueOrNull", "rename", "newName", "resolveSingle", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnWithPath;", "context", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnResolutionContext;", "core"})
@SourceDebugExtension(value={"SMAP\nRenamedColumnReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenamedColumnReference.kt\norg/jetbrains/kotlinx/dataframe/impl/columns/RenamedColumnReference\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,22:1\n1#2:23\n*E\n"})
public final class RenamedColumnReference<C>
implements ColumnReference<C> {
    @NotNull
    private final ColumnReference<C> source;
    @NotNull
    private final String name;

    public RenamedColumnReference(@NotNull ColumnReference<? extends C> source, @NotNull String name) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.source = source;
        this.name = name;
    }

    @NotNull
    public final ColumnReference<C> getSource() {
        return this.source;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public ColumnWithPath<C> resolveSingle(@NotNull ColumnResolutionContext context) {
        ColumnWithPath columnWithPath;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ColumnWithPath<C> columnWithPath2 = this.source.resolveSingle(context);
        if (columnWithPath2 != null) {
            ColumnWithPath<C> it = columnWithPath2;
            boolean bl = false;
            columnWithPath = UtilsKt.addPath((BaseColumn)it.getData().rename(this.name), it.getPath());
        } else {
            columnWithPath = null;
        }
        return columnWithPath;
    }

    @Override
    @NotNull
    public String name() {
        return this.name;
    }

    @Override
    @NotNull
    public RenamedColumnReference<C> rename(@NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        return new RenamedColumnReference<C>(this.source, newName);
    }

    @Override
    public C getValue(@NotNull DataRow<?> row) {
        Intrinsics.checkNotNullParameter(row, (String)"row");
        return this.source.getValue(row);
    }

    @Override
    @Nullable
    public C getValueOrNull(@NotNull DataRow<?> row) {
        Intrinsics.checkNotNullParameter(row, (String)"row");
        return this.source.getValueOrNull(row);
    }

    @Override
    @NotNull
    public ColumnReference<C> getValue(@Nullable Object thisRef, @NotNull KProperty<?> property) {
        return ColumnReference.DefaultImpls.getValue(this, thisRef, property);
    }

    @Override
    @NotNull
    public ColumnPath path() {
        return ColumnReference.DefaultImpls.path(this);
    }

    @Override
    @NotNull
    public List<ColumnWithPath<C>> resolve(@NotNull ColumnResolutionContext context) {
        return ColumnReference.DefaultImpls.resolve(this, context);
    }
}

