/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.config;

import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.psi.HttpClientExecutionBlock;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestBlock;
import com.intellij.httpClient.http.request.psi.HttpRunBlock;
import com.intellij.httpClient.http.request.run.config.HttpRequestExecutionConfig;
import com.intellij.httpClient.http.request.run.config.HttpRequestRuntimeConfigurationProducer;
import com.intellij.httpClient.http.request.run.config.HttpSingleRequestRuntimeConfigurationProducer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpSingleExecutionConfig
implements HttpRequestExecutionConfig {
    private final SmartPsiElementPointer<HttpClientExecutionBlock> myExecutionBlock;
    private final boolean myShowInformationAboutRequest;

    public HttpSingleExecutionConfig(@NotNull HttpClientExecutionBlock block) {
        if (block == null) {
            HttpSingleExecutionConfig.$$$reportNull$$$0(0);
        }
        this(block, true);
    }

    public HttpSingleExecutionConfig(@NotNull HttpClientExecutionBlock block, boolean showInformationAboutRequest) {
        if (block == null) {
            HttpSingleExecutionConfig.$$$reportNull$$$0(1);
        }
        this.myExecutionBlock = SmartPointerManager.createPointer((PsiElement)block);
        this.myShowInformationAboutRequest = showInformationAboutRequest;
    }

    @Override
    @NotNull
    public List<HttpClientExecutionBlock> getExecutionBlocks() {
        List list2 = ContainerUtil.packNullables((Object[])new HttpClientExecutionBlock[]{(HttpClientExecutionBlock)this.myExecutionBlock.getElement()});
        if (list2 == null) {
            HttpSingleExecutionConfig.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    private HttpClientExecutionBlock getExecutionBlock() {
        HttpClientExecutionBlock element = (HttpClientExecutionBlock)this.myExecutionBlock.getElement();
        if (element == null) {
            throw new HttpRequestExecutionConfig.InvalidConfigException("Request is absent");
        }
        HttpClientExecutionBlock httpClientExecutionBlock = element;
        if (httpClientExecutionBlock == null) {
            HttpSingleExecutionConfig.$$$reportNull$$$0(3);
        }
        return httpClientExecutionBlock;
    }

    @Nullable
    private HttpRequest getRequest() {
        HttpClientExecutionBlock block = this.getExecutionBlock();
        if (block instanceof HttpRequestBlock) {
            return ((HttpRequestBlock)block).getRequest();
        }
        return null;
    }

    @Nullable
    private HttpRunBlock getRun() {
        HttpClientExecutionBlock block = this.getExecutionBlock();
        if (block instanceof HttpRunBlock) {
            return (HttpRunBlock)block;
        }
        return null;
    }

    @Override
    @NotNull
    public PsiFile getContext() {
        PsiFile psiFile = this.getExecutionBlock().getContainingFile();
        if (psiFile == null) {
            HttpSingleExecutionConfig.$$$reportNull$$$0(4);
        }
        return psiFile;
    }

    @Override
    @NotNull
    public String getName(@NotNull HttpRequestVariableSubstitutor substitutor2) {
        HttpRequest request;
        if (substitutor2 == null) {
            HttpSingleExecutionConfig.$$$reportNull$$$0(5);
        }
        if ((request = this.getRequest()) != null) {
            String string = StringUtil.notNullize((String)request.getHttpUrl(substitutor2));
            if (string == null) {
                HttpSingleExecutionConfig.$$$reportNull$$$0(6);
            }
            return string;
        }
        HttpRunBlock run2 = this.getRun();
        String string = StringUtil.notNullize((String)run2.getText());
        if (string == null) {
            HttpSingleExecutionConfig.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public String getActionDescription(@NotNull @Nls String actionName, @Nullable String env) {
        if (actionName == null) {
            HttpSingleExecutionConfig.$$$reportNull$$$0(8);
        }
        if (StringUtil.isEmpty((String)env)) {
            HttpRequest request = this.getRequest();
            if (request != null) {
                String string = actionName + " " + StringUtil.notNullize((String)request.getHttpHost(HttpRequestVariableSubstitutor.empty()));
                if (string == null) {
                    HttpSingleExecutionConfig.$$$reportNull$$$0(9);
                }
                return string;
            }
            HttpRunBlock run2 = this.getRun();
            if (run2 != null) {
                String string = actionName + " " + StringUtil.notNullize((String)run2.getName());
                if (string == null) {
                    HttpSingleExecutionConfig.$$$reportNull$$$0(10);
                }
                return string;
            }
        }
        String string = RestClientBundle.message("rest.client.request.execute.with.environment", actionName, env);
        if (string == null) {
            HttpSingleExecutionConfig.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @NotNull
    public HttpRequestRuntimeConfigurationProducer getRuntimeConfigurationProducer() {
        HttpRequestRuntimeConfigurationProducer httpRequestRuntimeConfigurationProducer = (HttpRequestRuntimeConfigurationProducer)RunConfigurationProducer.getInstance(HttpSingleRequestRuntimeConfigurationProducer.class);
        if (httpRequestRuntimeConfigurationProducer == null) {
            HttpSingleExecutionConfig.$$$reportNull$$$0(12);
        }
        return httpRequestRuntimeConfigurationProducer;
    }

    @Override
    public boolean isShowInformationAboutRequest() {
        return this.myShowInformationAboutRequest;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 7, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/run/config/HttpSingleExecutionConfig";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/run/config/HttpSingleExecutionConfig";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutionBlocks";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutionBlock";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionDescription";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimeConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getActionDescription";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6, 7, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

