/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.temporal.JSTemporalBuiltinOperation;
import com.oracle.truffle.js.builtins.temporal.TemporalPlainDatePrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.EnumerableOwnPropertyNamesNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.temporal.CreateTimeZoneMethodsRecordNode;
import com.oracle.truffle.js.nodes.temporal.TemporalAddDateNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarDateFromFieldsNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarFieldsNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarGetterNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.TemporalMonthDayFromFieldsNode;
import com.oracle.truffle.js.nodes.temporal.TemporalRoundDurationNode;
import com.oracle.truffle.js.nodes.temporal.TemporalYearMonthFromFieldsNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalDateNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalDurationNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalTimeNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalTimeZoneNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstantObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainMonthDayObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonthObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalTimeZoneObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeZoneMethodsRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.EnumSet;
import java.util.List;

public class TemporalPlainDatePrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<TemporalPlainDatePrototype> {
    public static final JSBuiltinsContainer BUILTINS = new TemporalPlainDatePrototypeBuiltins();

    protected TemporalPlainDatePrototypeBuiltins() {
        super(JSTemporalPlainDate.PROTOTYPE_NAME, TemporalPlainDatePrototype.class);
    }

    @Override
    protected Object createNode(JSContext context2, JSBuiltin builtin, boolean construct, boolean newTarget, TemporalPlainDatePrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateGetterNodeGen.create(context2, builtin, builtinEnum, TemporalPlainDatePrototypeBuiltins.args().withThis().createArgumentNodes(context2));
            }
            case 16: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateAddSubNodeGen.create(context2, builtin, 1, TemporalPlainDatePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context2));
            }
            case 17: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateAddSubNodeGen.create(context2, builtin, -1, TemporalPlainDatePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context2));
            }
            case 18: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateWithNodeGen.create(context2, builtin, TemporalPlainDatePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context2));
            }
            case 19: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateWithCalendarNodeGen.create(context2, builtin, TemporalPlainDatePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 20: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateUntilSinceNodeGen.create(context2, builtin, 1, TemporalPlainDatePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context2));
            }
            case 21: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateUntilSinceNodeGen.create(context2, builtin, -1, TemporalPlainDatePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context2));
            }
            case 22: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateEqualsNodeGen.create(context2, builtin, TemporalPlainDatePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 23: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateToPlainDateTimeNodeGen.create(context2, builtin, TemporalPlainDatePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 13: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateToPlainYearMonthNodeGen.create(context2, builtin, TemporalPlainDatePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 14: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateToPlainMonthDayNodeGen.create(context2, builtin, TemporalPlainDatePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 24: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateToZonedDateTimeNodeGen.create(context2, builtin, TemporalPlainDatePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 15: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateGetISOFieldsNodeGen.create(context2, builtin, TemporalPlainDatePrototypeBuiltins.args().withThis().createArgumentNodes(context2));
            }
            case 25: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateToStringNodeGen.create(context2, builtin, TemporalPlainDatePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context2));
            }
            case 26: 
            case 27: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateToLocaleStringNodeGen.create(context2, builtin, TemporalPlainDatePrototypeBuiltins.args().withThis().createArgumentNodes(context2));
            }
            case 28: {
                return TemporalPlainDatePrototypeBuiltinsFactory.JSTemporalPlainDateValueOfNodeGen.create(context2, builtin, TemporalPlainDatePrototypeBuiltins.args().withThis().createArgumentNodes(context2));
            }
        }
        return null;
    }

    public static enum TemporalPlainDatePrototype implements BuiltinEnum<TemporalPlainDatePrototype>
    {
        calendar(0),
        year(0),
        month(0),
        monthCode(0),
        day(0),
        dayOfYear(0),
        dayOfWeek(0),
        weekOfYear(0),
        daysInWeek(0),
        daysInMonth(0),
        daysInYear(0),
        monthsInYear(0),
        inLeapYear(0),
        toPlainYearMonth(0),
        toPlainMonthDay(0),
        getISOFields(0),
        add(1),
        subtract(1),
        with(1),
        withCalendar(1),
        until(1),
        since(1),
        equals(1),
        toPlainDateTime(0),
        toZonedDateTime(1),
        toString(0),
        toLocaleString(0),
        toJSON(0),
        valueOf(0);

        private final int length;

        private TemporalPlainDatePrototype(int length2) {
            this.length = length2;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return EnumSet.of(calendar, new TemporalPlainDatePrototype[]{year, month, monthCode, day, dayOfYear, dayOfWeek, weekOfYear, daysInWeek, daysInMonth, daysInYear, monthsInYear, inLeapYear}).contains(this);
        }
    }

    public static abstract class JSTemporalPlainDateGetterNode
    extends JSBuiltinNode {
        protected final TemporalPlainDatePrototype property;

        protected JSTemporalPlainDateGetterNode(JSContext context2, JSBuiltin builtin, TemporalPlainDatePrototype property) {
            super(context2, builtin);
            this.property = property;
        }

        @Specialization
        protected final Object dateGetter(JSTemporalPlainDateObject temporalDT, @Cached TemporalCalendarGetterNode calendarGetterNode) {
            switch (this.property.ordinal()) {
                case 0: {
                    return temporalDT.getCalendar();
                }
                case 1: {
                    return TemporalUtil.calendarYear(calendarGetterNode, temporalDT.getCalendar(), temporalDT);
                }
                case 2: {
                    return TemporalUtil.calendarMonth(calendarGetterNode, temporalDT.getCalendar(), temporalDT);
                }
                case 4: {
                    return TemporalUtil.calendarDay(calendarGetterNode, temporalDT.getCalendar(), temporalDT);
                }
                case 6: {
                    return TemporalUtil.calendarDayOfWeek(calendarGetterNode, temporalDT.getCalendar(), temporalDT);
                }
                case 5: {
                    return TemporalUtil.calendarDayOfYear(calendarGetterNode, temporalDT.getCalendar(), temporalDT);
                }
                case 3: {
                    return TemporalUtil.calendarMonthCode(calendarGetterNode, temporalDT.getCalendar(), temporalDT);
                }
                case 7: {
                    return TemporalUtil.calendarWeekOfYear(calendarGetterNode, temporalDT.getCalendar(), temporalDT);
                }
                case 8: {
                    return TemporalUtil.calendarDaysInWeek(calendarGetterNode, temporalDT.getCalendar(), temporalDT);
                }
                case 9: {
                    return TemporalUtil.calendarDaysInMonth(calendarGetterNode, temporalDT.getCalendar(), temporalDT);
                }
                case 10: {
                    return TemporalUtil.calendarDaysInYear(calendarGetterNode, temporalDT.getCalendar(), temporalDT);
                }
                case 11: {
                    return TemporalUtil.calendarMonthsInYear(calendarGetterNode, temporalDT.getCalendar(), temporalDT);
                }
                case 12: {
                    return TemporalUtil.calendarInLeapYear(calendarGetterNode, temporalDT.getCalendar(), temporalDT);
                }
            }
            throw Errors.shouldNotReachHere();
        }

        @Specialization(guards={"!isJSTemporalPlainDate(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
    }

    public static abstract class JSTemporalPlainDateAddSubNode
    extends JSTemporalBuiltinOperation {
        private final int sign;
        @Node.Child
        private GetMethodNode getMethodDateAddNode;

        protected JSTemporalPlainDateAddSubNode(JSContext context2, JSBuiltin builtin, int sign) {
            super(context2, builtin);
            this.sign = sign;
            this.getMethodDateAddNode = GetMethodNode.create(context2, TemporalConstants.DATE_ADD);
        }

        @Specialization
        protected final JSTemporalPlainDateObject addDate(JSTemporalPlainDateObject date, Object temporalDurationLike, Object optParam, @Cached ToTemporalDurationNode toTemporalDurationNode, @Cached TemporalAddDateNode addDateNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSTemporalDurationObject duration = toTemporalDurationNode.execute(temporalDurationLike);
            JSDynamicObject options = this.getOptionsObject(optParam, this, errorBranch, optionUndefined);
            JSRealm realm = this.getRealm();
            if (this.sign < 0) {
                duration = JSTemporalDuration.createNegatedTemporalDuration(this.getContext(), realm, duration);
            }
            JSDynamicObject calendar = date.getCalendar();
            CalendarMethodsRecord calendarRec = CalendarMethodsRecord.forDateAdd(calendar, this.getMethodDateAddNode.executeWithTarget(calendar));
            return addDateNode.execute(calendarRec, date, duration, options);
        }

        @Specialization(guards={"!isJSTemporalPlainDate(thisObj)"})
        protected static JSTemporalPlainDateObject invalidReceiver(Object thisObj, Object temporalDurationLike, Object optParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
    }

    public static abstract class JSTemporalPlainDateWith
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateWith(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected final JSTemporalPlainDateObject with(JSTemporalPlainDateObject temporalDate, Object temporalDateLike, Object optParam, @Cached(value="createKeys(getContext())") EnumerableOwnPropertyNamesNode namesNode, @Cached TemporalCalendarFieldsNode calendarFieldsNode, @Cached TemporalCalendarDateFromFieldsNode dateFromFieldsNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            if (!this.isObject(temporalDateLike)) {
                errorBranch.enter(this);
                throw Errors.createTypeError("Object expected");
            }
            JSDynamicObject temporalDateLikeObject = TemporalUtil.toJSDynamicObject(temporalDateLike, this, errorBranch);
            TemporalUtil.rejectTemporalCalendarType(temporalDateLikeObject, this, errorBranch);
            Object calendarProperty = JSObject.get(temporalDateLikeObject, TemporalConstants.CALENDAR);
            if (calendarProperty != Undefined.instance) {
                errorBranch.enter(this);
                throw TemporalErrors.createTypeErrorUnexpectedCalendar();
            }
            Object timeZoneProperty = JSObject.get(temporalDateLikeObject, TemporalConstants.TIME_ZONE);
            if (timeZoneProperty != Undefined.instance) {
                errorBranch.enter(this);
                throw TemporalErrors.createTypeErrorUnexpectedTimeZone();
            }
            JSDynamicObject calendar = temporalDate.getCalendar();
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendar, TemporalUtil.listDMMCY);
            JSObject partialDate = TemporalUtil.preparePartialTemporalFields(this.getContext(), temporalDateLikeObject, fieldNames);
            JSDynamicObject options = this.getOptionsObject(optParam, this, errorBranch, optionUndefined);
            JSDynamicObject fields = TemporalUtil.prepareTemporalFields(this.getContext(), temporalDate, fieldNames, TemporalUtil.listEmpty);
            fields = TemporalUtil.calendarMergeFields(this.getContext(), this.getRealm(), calendar, fields, partialDate, namesNode, this, errorBranch);
            fields = TemporalUtil.prepareTemporalFields(this.getContext(), fields, fieldNames, TemporalUtil.listEmpty);
            return dateFromFieldsNode.execute(calendar, fields, options);
        }

        @Specialization(guards={"!isJSTemporalPlainDate(thisObj)"})
        protected static JSTemporalPlainDateObject invalidReceiver(Object thisObj, Object temporalDateLike, Object optParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
    }

    public static abstract class JSTemporalPlainDateWithCalendar
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateWithCalendar(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected final JSTemporalPlainDateObject withCalendar(JSTemporalPlainDateObject date, Object calendarParam, @Cached ToTemporalCalendarNode toTemporalCalendar, @Cached InlinedBranchProfile errorBranch) {
            JSDynamicObject calendar = toTemporalCalendar.execute(calendarParam);
            return JSTemporalPlainDate.create(this.getContext(), this.getRealm(), date.getYear(), date.getMonth(), date.getDay(), calendar, this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalPlainDate(thisObj)"})
        protected static JSTemporalPlainDateObject invalidReceiver(Object thisObj, Object calendarParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
    }

    public static abstract class JSTemporalPlainDateUntilSinceNode
    extends JSTemporalBuiltinOperation {
        private final int sign;
        @Node.Child
        private GetMethodNode getMethodDateAddNode;
        @Node.Child
        private GetMethodNode getMethodDateUntilNode;

        protected JSTemporalPlainDateUntilSinceNode(JSContext context2, JSBuiltin builtin, int sign) {
            super(context2, builtin);
            this.sign = sign;
            this.getMethodDateAddNode = GetMethodNode.create(context2, TemporalConstants.DATE_ADD);
            this.getMethodDateUntilNode = GetMethodNode.create(context2, TemporalConstants.DATE_UNTIL);
        }

        @Specialization
        protected JSTemporalDurationObject differenceTemporalPlainDate(JSTemporalPlainDateObject temporalDate, Object otherObj, Object optionsParam, @Cached JSToNumberNode toNumber, @Cached(value="createKeys(getContext())") EnumerableOwnPropertyNamesNode namesNode, @Cached ToTemporalDateNode toTemporalDate, @Cached JSToStringNode toStringNode, @Cached TruffleString.EqualNode equalNode, @Cached TemporalRoundDurationNode roundDurationNode, @Cached TemporalGetOptionNode getOptionNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSTemporalPlainDateObject other = toTemporalDate.execute(otherObj);
            JSDynamicObject calendar = temporalDate.getCalendar();
            if (!TemporalUtil.calendarEquals(calendar, other.getCalendar(), toStringNode)) {
                errorBranch.enter(this);
                throw TemporalErrors.createRangeErrorIdenticalCalendarExpected();
            }
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            List<TruffleString> disallowedUnits = TemporalUtil.listTime;
            TemporalUtil.Unit smallestUnit = JSTemporalPlainDateUntilSinceNode.toSmallestTemporalUnit(options, disallowedUnits, TemporalConstants.DAY, equalNode, getOptionNode, this, errorBranch);
            TemporalUtil.Unit defaultLargestUnit = TemporalUtil.largerOfTwoTemporalUnits(TemporalUtil.Unit.DAY, smallestUnit);
            TemporalUtil.Unit largestUnit = JSTemporalPlainDateUntilSinceNode.toLargestTemporalUnit(options, disallowedUnits, TemporalConstants.AUTO, defaultLargestUnit, equalNode, getOptionNode, this, errorBranch);
            TemporalUtil.validateTemporalUnitRange(largestUnit, smallestUnit);
            TemporalUtil.RoundingMode roundingMode = JSTemporalPlainDateUntilSinceNode.toTemporalRoundingMode(options, TemporalConstants.TRUNC, equalNode, getOptionNode);
            if (this.sign == -1) {
                roundingMode = TemporalUtil.negateTemporalRoundingMode(roundingMode);
            }
            double roundingIncrement = TemporalUtil.toTemporalRoundingIncrement(options, null, false, this.isObjectNode, toNumber);
            Object dateAdd = this.getMethodDateAddNode.executeWithTarget(calendar);
            Object dateUntil = this.getMethodDateUntilNode.executeWithTarget(calendar);
            CalendarMethodsRecord calendarRec = CalendarMethodsRecord.forDateAddDateUntil(calendar, dateAdd, dateUntil);
            JSDynamicObject untilOptions = TemporalUtil.mergeLargestUnitOption(this.getContext(), namesNode, options, largestUnit);
            JSTemporalDurationObject result2 = TemporalUtil.calendarDateUntil(calendarRec, temporalDate, other, untilOptions);
            if (smallestUnit != TemporalUtil.Unit.DAY || roundingIncrement != 1.0) {
                JSTemporalDurationRecord result22 = roundDurationNode.execute(result2.getYears(), result2.getMonths(), result2.getWeeks(), result2.getDays(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, (long)roundingIncrement, smallestUnit, roundingMode, temporalDate, calendarRec);
                return JSTemporalDuration.createTemporalDuration(this.getContext(), this.getRealm(), (double)this.sign * result22.getYears(), (double)this.sign * result22.getMonths(), (double)this.sign * result22.getWeeks(), (double)this.sign * result22.getDays(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this, errorBranch);
            }
            return JSTemporalDuration.createTemporalDuration(this.getContext(), this.getRealm(), (double)this.sign * result2.getYears(), (double)this.sign * result2.getMonths(), (double)this.sign * result2.getWeeks(), (double)this.sign * result2.getDays(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalPlainDate(thisObj)"})
        protected static JSTemporalDurationObject invalidReceiver(Object thisObj, Object otherObj, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
    }

    public static abstract class JSTemporalPlainDateEquals
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateEquals(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected static boolean equals(JSTemporalPlainDateObject temporalDate, Object otherParam, @Cached ToTemporalDateNode toTemporalDate, @Cached JSToStringNode toStringNode) {
            JSTemporalPlainDateObject other = toTemporalDate.execute(otherParam);
            if (temporalDate.getYear() != other.getYear()) {
                return false;
            }
            if (temporalDate.getMonth() != other.getMonth()) {
                return false;
            }
            if (temporalDate.getDay() != other.getDay()) {
                return false;
            }
            return TemporalUtil.calendarEquals(temporalDate.getCalendar(), other.getCalendar(), toStringNode);
        }

        @Specialization(guards={"!isJSTemporalPlainDate(thisObj)"})
        protected static boolean invalidReceiver(Object thisObj, Object otherParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
    }

    public static abstract class JSTemporalPlainDateToPlainDateTime
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateToPlainDateTime(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected final JSTemporalPlainDateTimeObject toPlainDateTime(JSTemporalPlainDateObject date, Object temporalTimeObj, @Cached ToTemporalTimeNode toTemporalTime, @Cached InlinedBranchProfile errorBranch) {
            if (temporalTimeObj == Undefined.instance) {
                return JSTemporalPlainDateTime.create(this.getContext(), this.getRealm(), date.getYear(), date.getMonth(), date.getDay(), 0, 0, 0, 0, 0, 0, date.getCalendar(), this, errorBranch);
            }
            JSTemporalPlainTimeObject time = toTemporalTime.execute(temporalTimeObj, null);
            return JSTemporalPlainDateTime.create(this.getContext(), this.getRealm(), date.getYear(), date.getMonth(), date.getDay(), time.getHour(), time.getMinute(), time.getSecond(), time.getMillisecond(), time.getMicrosecond(), time.getNanosecond(), date.getCalendar(), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalPlainDate(thisObj)"})
        protected static JSTemporalPlainDateTimeObject invalidReceiver(Object thisObj, Object temporalTimeObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
    }

    public static abstract class JSTemporalPlainDateToPlainYearMonth
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateToPlainYearMonth(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected final JSTemporalPlainYearMonthObject toPlainYearMonth(JSTemporalPlainDateObject date, @Cached TemporalYearMonthFromFieldsNode yearMonthFromFieldsNode, @Cached TemporalCalendarFieldsNode calendarFieldsNode) {
            JSDynamicObject calendar = date.getCalendar();
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendar, TemporalUtil.listMCY);
            JSObject fields = TemporalUtil.prepareTemporalFields(this.getContext(), date, fieldNames, TemporalUtil.listEmpty);
            return yearMonthFromFieldsNode.execute(calendar, fields, Undefined.instance);
        }

        @Specialization(guards={"!isJSTemporalPlainDate(thisObj)"})
        protected static JSTemporalPlainYearMonthObject invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
    }

    public static abstract class JSTemporalPlainDateToPlainMonthDay
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateToPlainMonthDay(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected final JSTemporalPlainMonthDayObject toPlainMonthDay(JSTemporalPlainDateObject date, @Cached TemporalMonthDayFromFieldsNode monthDayFromFieldsNode, @Cached TemporalCalendarFieldsNode calendarFieldsNode) {
            JSDynamicObject calendar = date.getCalendar();
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendar, TemporalUtil.listDMC);
            JSObject fields = TemporalUtil.prepareTemporalFields(this.getContext(), date, fieldNames, TemporalUtil.listEmpty);
            return monthDayFromFieldsNode.execute(calendar, fields, Undefined.instance);
        }

        @Specialization(guards={"!isJSTemporalPlainDate(thisObj)"})
        protected static JSTemporalPlainMonthDayObject invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
    }

    public static abstract class JSTemporalPlainDateToZonedDateTimeNode
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateToZonedDateTimeNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected final JSTemporalZonedDateTimeObject toZonedDateTime(JSTemporalPlainDateObject td, Object item, @Cached InlinedConditionProfile timeZoneIsUndefined, @Cached InlinedConditionProfile timeIsUndefined, @Cached ToTemporalTimeNode toTemporalTime, @Cached ToTemporalTimeZoneNode toTemporalTimeZone, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord, @Cached InlinedBranchProfile errorBranch) {
            JSTemporalPlainDateTimeObject temporalDateTime;
            Object temporalTime;
            JSTemporalTimeZoneObject timeZone;
            if (this.isObject(item)) {
                JSDynamicObject itemObj = TemporalUtil.toJSDynamicObject(item, this, errorBranch);
                Object timeZoneLike = JSObject.get(itemObj, TemporalConstants.TIME_ZONE);
                if (timeZoneIsUndefined.profile(this, timeZoneLike == Undefined.instance)) {
                    timeZone = (JSTemporalTimeZoneObject)toTemporalTimeZone.execute(item);
                    temporalTime = Undefined.instance;
                } else {
                    timeZone = (JSTemporalTimeZoneObject)toTemporalTimeZone.execute(timeZoneLike);
                    temporalTime = JSObject.get(itemObj, TemporalConstants.PLAIN_TIME);
                }
            } else {
                timeZone = (JSTemporalTimeZoneObject)toTemporalTimeZone.execute(item);
                temporalTime = Undefined.instance;
            }
            JSRealm realm = this.getRealm();
            if (timeIsUndefined.profile(this, temporalTime == Undefined.instance)) {
                temporalDateTime = JSTemporalPlainDateTime.create(this.getContext(), realm, td.getYear(), td.getMonth(), td.getDay(), 0, 0, 0, 0, 0, 0, td.getCalendar(), this, errorBranch);
            } else {
                JSTemporalPlainTimeObject tt = toTemporalTime.execute(temporalTime, null);
                temporalDateTime = JSTemporalPlainDateTime.create(this.getContext(), realm, td.getYear(), td.getMonth(), td.getDay(), tt.getHour(), tt.getMinute(), tt.getSecond(), tt.getMillisecond(), tt.getMicrosecond(), tt.getNanosecond(), td.getCalendar(), this, errorBranch);
            }
            TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeFull(timeZone);
            JSTemporalInstantObject instant = TemporalUtil.builtinTimeZoneGetInstantFor(this.getContext(), realm, timeZoneRec, temporalDateTime, TemporalUtil.Disambiguation.COMPATIBLE);
            return JSTemporalZonedDateTime.create(this.getContext(), realm, instant.getNanoseconds(), timeZone, td.getCalendar());
        }

        @Specialization(guards={"!isJSTemporalPlainDate(thisObj)"})
        protected static JSTemporalZonedDateTimeObject invalidReceiver(Object thisObj, Object item) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
    }

    public static abstract class JSTemporalPlainDateGetISOFields
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateGetISOFields(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected final JSObject getISOFields(JSTemporalPlainDateObject dt) {
            JSObject obj = JSOrdinary.create(this.getContext(), this.getRealm());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.CALENDAR, dt.getCalendar());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_DAY, dt.getDay());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_MONTH, dt.getMonth());
            TemporalUtil.createDataPropertyOrThrow(this.getContext(), obj, TemporalConstants.ISO_YEAR, dt.getYear());
            return obj;
        }

        @Specialization(guards={"!isJSTemporalPlainDate(thisObj)"})
        protected static JSObject invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
    }

    public static abstract class JSTemporalPlainDateToString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateToString(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected TruffleString toString(JSTemporalPlainDateObject date, Object optionsParam, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            TemporalUtil.ShowCalendar showCalendar = TemporalUtil.toShowCalendarOption(options, getOptionNode, equalNode);
            return JSTemporalPlainDate.temporalDateToString(date, showCalendar);
        }

        @Specialization(guards={"!isJSTemporalPlainDate(thisObj)"})
        protected static TruffleString invalidReceiver(Object thisObj, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
    }

    public static abstract class JSTemporalPlainDateToLocaleString
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateToLocaleString(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected static TruffleString toLocaleString(JSTemporalPlainDateObject date) {
            return JSTemporalPlainDate.temporalDateToString(date, TemporalUtil.ShowCalendar.AUTO);
        }

        @Specialization(guards={"!isJSTemporalPlainDate(thisObj)"})
        protected static TruffleString invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalPlainDateExpected();
        }
    }

    public static abstract class JSTemporalPlainDateValueOf
    extends JSTemporalBuiltinOperation {
        protected JSTemporalPlainDateValueOf(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected static Object valueOf(Object thisObj) {
            throw Errors.createTypeError("Not supported.");
        }
    }
}

