/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.GetIteratorUnaryNode;
import com.oracle.truffle.js.nodes.access.IteratorGetNextValueNode;
import com.oracle.truffle.js.nodes.access.JSConstantNode;
import com.oracle.truffle.js.nodes.function.SpreadArgumentNodeGen;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.util.SimpleArrayList;
import java.util.Set;

public abstract class SpreadArgumentNode
extends JavaScriptNode {
    @Node.Child
    private GetIteratorUnaryNode getIteratorNode;
    @Node.Child
    private IteratorGetNextValueNode iteratorStepNode;
    private final JSContext context;

    protected SpreadArgumentNode(JSContext context2, GetIteratorUnaryNode getIteratorNode) {
        this.context = context2;
        this.getIteratorNode = getIteratorNode;
        this.iteratorStepNode = IteratorGetNextValueNode.create(context2, null, JSConstantNode.create(null), false);
    }

    @Override
    public boolean isInstrumentable() {
        return false;
    }

    public static SpreadArgumentNode create(JSContext context2, GetIteratorUnaryNode getIteratorNode) {
        return SpreadArgumentNodeGen.create(context2, getIteratorNode);
    }

    public final Object[] execute(VirtualFrame frame) {
        SimpleArrayList<Object> argList = new SimpleArrayList<Object>();
        this.executeToList(frame, argList);
        return argList.toArray();
    }

    @Override
    public final boolean executeBoolean(VirtualFrame frame) throws UnexpectedResultException {
        return super.executeBoolean(frame);
    }

    @Override
    public final double executeDouble(VirtualFrame frame) throws UnexpectedResultException {
        return super.executeDouble(frame);
    }

    @Override
    public final int executeInt(VirtualFrame frame) throws UnexpectedResultException {
        return super.executeInt(frame);
    }

    @Override
    public final long executeLong(VirtualFrame frame) throws UnexpectedResultException {
        return super.executeLong(frame);
    }

    @Override
    public final void executeVoid(VirtualFrame frame) {
        super.executeVoid(frame);
    }

    public abstract void executeToList(VirtualFrame var1, SimpleArrayList<Object> var2);

    @Specialization
    protected final void doSpread(VirtualFrame frame, SimpleArrayList<Object> argList, @Cached InlinedBranchProfile growBranch, @Cached InlinedBranchProfile errorBranch) {
        Object nextArg;
        IteratorRecord iteratorRecord = this.getIteratorNode.execute(frame);
        while ((nextArg = this.iteratorStepNode.execute(frame, iteratorRecord)) != null) {
            if ((long)argList.size() >= this.context.getFunctionArgumentsLimit()) {
                errorBranch.enter(this);
                throw Errors.createRangeError("spreaded function argument count exceeds limit");
            }
            argList.add(nextArg, this, growBranch);
        }
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return SpreadArgumentNode.create(this.context, SpreadArgumentNode.cloneUninitialized(this.getIteratorNode, materializedTags));
    }
}

