/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.devcontainers.feautures;

import com.intellij.docker.agent.devcontainers.feautures.DevcontainerDataExchangeProxy;
import com.intellij.docker.agent.i18n.DockerAgentBundle;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"extractTar", "", "input", "Ljava/io/InputStream;", "targetPath", "", "proxy", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerDataExchangeProxy;", "intellij.clouds.docker.agent"})
public final class DevcontainerFeatureUtilsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void extractTar(@NotNull InputStream input, @NotNull String targetPath, @NotNull DevcontainerDataExchangeProxy proxy) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Path normalizedTargetPath = Path.of(targetPath, new String[0]).normalize();
        Closeable closeable = (Closeable)new TarArchiveInputStream(input);
        Throwable throwable = null;
        try {
            TarArchiveEntry tarArchiveEntry;
            TarArchiveInputStream tarStream = (TarArchiveInputStream)closeable;
            boolean bl = false;
            TarArchiveEntry entry = null;
            do {
                if (tarStream.getNextEntry() != null) {
                    TarArchiveEntry tarArchiveEntry2;
                    TarArchiveEntry $this$extractTar_u24lambda_u241_u24lambda_u240 = tarArchiveEntry2;
                    boolean bl2 = false;
                    Object[] objectArray = new String[]{$this$extractTar_u24lambda_u241_u24lambda_u240.getName()};
                    Path targetFilePath = Path.of(targetPath, (String[])objectArray).normalize();
                    if (targetFilePath.startsWith(normalizedTargetPath)) {
                        if ($this$extractTar_u24lambda_u241_u24lambda_u240.isDirectory()) {
                            objectArray = new Object[]{targetFilePath};
                            proxy.getPrinter().printInfo(DockerAgentBundle.Companion.message("devcontainer.features.extract.tar.creating.directory", objectArray));
                            v0 = Files.createDirectories(targetFilePath, new FileAttribute[0]);
                        } else {
                            objectArray = new Object[]{targetFilePath};
                            proxy.getPrinter().printInfo(DockerAgentBundle.Companion.message("devcontainer.features.extract.tar.writing.file", objectArray));
                            objectArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                            v0 = Files.copy((InputStream)tarStream, targetFilePath, (CopyOption[])objectArray);
                        }
                    } else {
                        objectArray = new Object[]{targetFilePath};
                        proxy.getPrinter().printError(DockerAgentBundle.Companion.message("devcontainer.features.extract.tar.error.skip", objectArray));
                        v0 = Unit.INSTANCE;
                    }
                    tarArchiveEntry = tarArchiveEntry2;
                    continue;
                }
                tarArchiveEntry = null;
            } while ((entry = tarArchiveEntry) != null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

