/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.compose;

import com.intellij.docker.agent.compose.beans.RestartPolicy;
import com.intellij.docker.compose.service.DockerComposeServiceClient;
import com.intellij.docker.compose.service.commands.ComposeServiceRunCmd;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u001aB\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u000e\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004\u001a\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0004H\u0002\u001a\\\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "ROOT_USER", "", "ROOT_USER_ID", "getServiceUID", "dockerRuntime", "Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime;", "composeFilePaths", "", "Ljava/nio/file/Path;", "envs", "", "serviceName", "projectName", "extractServiceUID", "processOutput", "Lcom/intellij/execution/process/ProcessOutput;", "isLong", "", "changeOwnershipOfVolume", "", "user", "volumeName", "containerPath", "intellij.clouds.docker.remoteRun"})
@JvmName(name="DockerComposeServiceUtil")
@SourceDebugExtension(value={"SMAP\nDockerComposeServiceUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerComposeServiceUtil.kt\ncom/intellij/docker/remote/compose/DockerComposeServiceUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,107:1\n1557#2:108\n1628#2,3:109\n1557#2:135\n1628#2,3:136\n108#3:112\n80#3,22:113\n*S KotlinDebug\n*F\n+ 1 DockerComposeServiceUtil.kt\ncom/intellij/docker/remote/compose/DockerComposeServiceUtil\n*L\n42#1:108\n42#1:109,3\n94#1:135\n94#1:136,3\n60#1:112\n60#1:113,22\n*E\n"})
public final class DockerComposeServiceUtil {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String ROOT_USER = "root";
    @NotNull
    public static final String ROOT_USER_ID = "0";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getServiceUID(@NotNull RemoteDockerRuntime dockerRuntime, @NotNull List<? extends Path> composeFilePaths, @NotNull Map<String, String> envs, @NotNull String serviceName, @Nullable String projectName) throws ExecutionException, IOException {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)dockerRuntime, (String)"dockerRuntime");
        Intrinsics.checkNotNullParameter(composeFilePaths, (String)"composeFilePaths");
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        DockerComposeServiceClient dockerComposeServiceClient = DockerComposeServiceClient.getInstance(dockerRuntime);
        Intrinsics.checkNotNullExpressionValue((Object)dockerComposeServiceClient, (String)"getInstance(...)");
        DockerComposeServiceClient serviceClient = dockerComposeServiceClient;
        String[] stringArray = (String[])composeFilePaths;
        ComposeServiceRunCmd composeServiceRunCmd = serviceClient.runServiceCmd();
        boolean $i$f$map = false;
        void var10_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toString());
        }
        stringArray = new String[]{"id", "-u"};
        Object t = ((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)composeServiceRunCmd.withConfigurationPath((List)destination$iv$iv)).withEnvs(envs)).withRemove(true).withServiceName(serviceName)).withProjectName(projectName)).withCommand(stringArray);
        Intrinsics.checkNotNullExpressionValue(t, (String)"withCommand(...)");
        ComposeServiceRunCmd runServiceCmd = (ComposeServiceRunCmd)t;
        ProcessOutput processOutput2 = new CapturingProcessRunner((BaseProcessHandler)runServiceCmd.execute()).runProcess();
        Intrinsics.checkNotNullExpressionValue((Object)processOutput2, (String)"runProcess(...)");
        ProcessOutput processOutput3 = processOutput2;
        return DockerComposeServiceUtil.extractServiceUID(processOutput3);
    }

    private static final String extractServiceUID(ProcessOutput processOutput2) {
        if (processOutput2.checkSuccess(LOG)) {
            String lastLine;
            String string = processOutput2.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
            String $this$trim$iv = string;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String stdout = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            String string2 = (String)SequencesKt.lastOrNull((Sequence)StringsKt.lineSequence((CharSequence)stdout));
            String string3 = lastLine = string2 != null ? ((Object)StringsKt.trim((CharSequence)string2)).toString() : null;
            if (lastLine != null) {
                if (DockerComposeServiceUtil.isLong(lastLine)) {
                    return lastLine;
                }
                LOG.debug("The last line of Docker Compose stdout does not contain effective user ID: " + lastLine);
            } else {
                LOG.debug("Docker Compose stdout of the command to get effective user ID is empty");
            }
        }
        return ROOT_USER_ID;
    }

    private static final boolean isLong(String $this$isLong) {
        return StringsKt.toLongOrNull((String)$this$isLong) != null;
    }

    /*
     * WARNING - void declaration
     */
    public static final void changeOwnershipOfVolume(@NotNull RemoteDockerRuntime dockerRuntime, @NotNull List<? extends Path> composeFilePaths, @Nullable Map<String, String> envs, @NotNull String serviceName, @NotNull String user2, @NotNull String volumeName, @NotNull String containerPath, @Nullable String projectName) throws ExecutionException, IOException {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)dockerRuntime, (String)"dockerRuntime");
        Intrinsics.checkNotNullParameter(composeFilePaths, (String)"composeFilePaths");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)user2, (String)"user");
        Intrinsics.checkNotNullParameter((Object)volumeName, (String)"volumeName");
        Intrinsics.checkNotNullParameter((Object)containerPath, (String)"containerPath");
        VolumesBuilder volumesBuilder = VolumesBuilder.builder();
        Intrinsics.checkNotNullExpressionValue((Object)volumesBuilder, (String)"builder(...)");
        VolumesBuilder volumesBinds = volumesBuilder;
        volumesBinds.addBoundVolume(containerPath, volumeName);
        DockerComposeServiceClient dockerComposeServiceClient = DockerComposeServiceClient.getInstance(dockerRuntime);
        Intrinsics.checkNotNullExpressionValue((Object)dockerComposeServiceClient, (String)"getInstance(...)");
        DockerComposeServiceClient serviceClient = dockerComposeServiceClient;
        String[] stringArray = (String[])composeFilePaths;
        ComposeServiceRunCmd composeServiceRunCmd = serviceClient.runServiceCmd();
        boolean $i$f$map = false;
        void var14_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toString());
        }
        stringArray = new String[]{"chown", "-R", user2, containerPath};
        Object t = ((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)composeServiceRunCmd.withConfigurationPath((List)destination$iv$iv)).withEnvs(envs)).withUser(ROOT_USER)).withRemove(true).withServiceName(serviceName)).withProjectName(projectName)).withCommand(stringArray)).withVolumes(volumesBinds.build())).withRestartPolicy(RestartPolicy.noRestart());
        Intrinsics.checkNotNullExpressionValue(t, (String)"withRestartPolicy(...)");
        ComposeServiceRunCmd runServiceCmd = (ComposeServiceRunCmd)t;
        ProcessOutput processOutput2 = new CapturingProcessRunner((BaseProcessHandler)runServiceCmd.execute()).runProcess();
        Intrinsics.checkNotNullExpressionValue((Object)processOutput2, (String)"runProcess(...)");
        ProcessOutput serviceOutput = processOutput2;
        if (!serviceOutput.checkSuccess(LOG)) {
            throw new ExecutionException(DockerBundle.message("DockerCompose.failed.to.change.ownership.of.docker.volume", new Object[0]));
        }
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.intellij.docker.remote.compose.DockerComposeServices");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

