/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.flamegraph;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.profiler.ui.MainCallTreeDataComponent;
import com.intellij.profiler.ui.flamegraph.FlameGraphNode;
import com.intellij.profiler.ui.flamegraph.FlameGraphPanel;
import com.intellij.profiler.ui.flamegraph.FlameGraphTooltip;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.Alarm;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000s\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u0019\b&\u0018\u0000 /*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0002./B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010 \u001a\u0004\u0018\u00010\u00122\u0006\u0010!\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\"J\u001c\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000(J\u0010\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020&H\u0002J\r\u0010+\u001a\u00070\f\u00a2\u0006\u0002\b,H\u0002J\u0006\u0010-\u001a\u00020$R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0016\u0010\u001b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/profiler/ui/flamegraph/FlameGraphTooltip;", "T", "", "panel", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;", "<init>", "(Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;)V", "getPanel", "()Lcom/intellij/profiler/ui/flamegraph/FlameGraphPanel;", "tooltipComponent", "Lcom/intellij/ui/components/panels/NonOpaquePanel;", "popup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "verticalMargin", "", "bottomLine", "lastComponent", "Lkotlin/Pair;", "Ljavax/swing/JComponent;", "newNodeEncounteredTime", "", "delayMillis", "delayMillisRegistryValue", "Lcom/intellij/openapi/util/registry/RegistryValue;", "showTooltipWhenIdle", "com/intellij/profiler/ui/flamegraph/FlameGraphTooltip$showTooltipWhenIdle$1", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphTooltip$showTooltipWhenIdle$1;", "showTooltipWhenIdleRequest", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphTooltip$ShowTooltipWhenIdleRequest;", "fastMovementRegistryValue", "isIdleState", "", "createComponent", "content", "(Ljava/lang/Object;)Ljavax/swing/JComponent;", "show", "", "mouseCursor", "Ljava/awt/Point;", "node", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphNode;", "updatePosition", "point", "createPopup", "Lorg/jetbrains/annotations/NotNull;", "hide", "ShowTooltipWhenIdleRequest", "Companion", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nFlameGraphTooltip.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlameGraphTooltip.kt\ncom/intellij/profiler/ui/flamegraph/FlameGraphTooltip\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,197:1\n1#2:198\n*E\n"})
public abstract class FlameGraphTooltip<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FlameGraphPanel<T> panel;
    @NotNull
    private final NonOpaquePanel tooltipComponent;
    @Nullable
    private JBPopup popup;
    private final int verticalMargin;
    private final int bottomLine;
    @Nullable
    private Pair<? extends T, ? extends JComponent> lastComponent;
    private long newNodeEncounteredTime;
    private int delayMillis;
    @NotNull
    private final RegistryValue delayMillisRegistryValue;
    @NotNull
    private final showTooltipWhenIdle.1 showTooltipWhenIdle;
    @Nullable
    private ShowTooltipWhenIdleRequest<T> showTooltipWhenIdleRequest;
    @NotNull
    private final RegistryValue fastMovementRegistryValue;
    private boolean isIdleState;
    private static final int HORIZONTAL_SPACING = 11;

    /*
     * WARNING - void declaration
     */
    public FlameGraphTooltip(@NotNull FlameGraphPanel<T> panel2) {
        void $this$tooltipComponent_u24lambda_u240;
        Object object;
        Intrinsics.checkNotNullParameter(panel2, (String)"panel");
        this.panel = panel2;
        NonOpaquePanel nonOpaquePanel = object = new NonOpaquePanel();
        FlameGraphTooltip flameGraphTooltip = this;
        boolean bl = false;
        $this$tooltipComponent_u24lambda_u240.setBorder((Border)JBUI.Borders.empty((int)8, (int)12));
        flameGraphTooltip.tooltipComponent = object;
        this.verticalMargin = 3 * this.panel.getRowHeight() / 2;
        this.bottomLine = 5 * this.panel.getRowHeight();
        this.delayMillisRegistryValue = RegistryManager.Companion.getInstance().get("idea.profiler.flamegraph.tooltip.delay.millis");
        object = this.panel;
        this.showTooltipWhenIdle = new Alarm(object){

            public void addRequest(Runnable request, int delayMillis) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                this.cancelAllRequests();
                super.addRequest(request, delayMillis);
            }
        };
        this.fastMovementRegistryValue = RegistryManager.Companion.getInstance().get("idea.profiler.flamegraph.tooltip.fast.movement.millis");
        this.isIdleState = true;
        this.delayMillis = this.delayMillisRegistryValue.asInteger();
        this.delayMillisRegistryValue.addListener(new RegistryValueListener(){

            public void afterValueChanged(RegistryValue value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                delayMillis = value.asInteger();
            }
        }, (Disposable)this.panel);
        this.panel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                this.hide();
            }
        });
    }

    @NotNull
    public final FlameGraphPanel<T> getPanel() {
        return this.panel;
    }

    @Nullable
    public abstract JComponent createComponent(@NotNull T var1);

    /*
     * WARNING - void declaration
     */
    public final void show(@NotNull Point mouseCursor, @NotNull FlameGraphNode<T> node) {
        JBPopup jBPopup;
        Intrinsics.checkNotNullParameter((Object)mouseCursor, (String)"mouseCursor");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Window window = ComponentUtil.getWindow((Component)((Component)((Object)this.panel)));
        if (!(window != null ? window.isFocused() : false)) {
            return;
        }
        long currentTime = 0L;
        if (this.delayMillis > 0) {
            currentTime = System.currentTimeMillis();
        }
        boolean shouldShow = true;
        T content = node.getContent();
        Pair<? extends T, ? extends JComponent> lastComponent = this.lastComponent;
        JComponent newComponent = null;
        if (lastComponent == null || lastComponent.getFirst() != content) {
            Object object;
            JComponent jComponent = this.createComponent(content);
            if (jComponent == null) {
                return;
            }
            newComponent = jComponent;
            int delay = this.delayMillis;
            if (delay > 0) {
                if (this.isIdleState) {
                    void request;
                    shouldShow = false;
                    object = new ShowTooltipWhenIdleRequest<T>(this, node, mouseCursor);
                    jBPopup = object;
                    FlameGraphTooltip flameGraphTooltip = this;
                    boolean bl = false;
                    this.showTooltipWhenIdle.addRequest(() -> FlameGraphTooltip.show$lambda$2$lambda$1((ShowTooltipWhenIdleRequest)request), delay);
                    flameGraphTooltip.showTooltipWhenIdleRequest = object;
                } else if (currentTime - this.newNodeEncounteredTime <= (long)this.fastMovementRegistryValue.asInteger()) {
                    this.hide();
                    shouldShow = false;
                }
            }
            this.newNodeEncounteredTime = currentTime;
            NonOpaquePanel $this$show_u24lambda_u243 = object = this.tooltipComponent;
            boolean bl = false;
            $this$show_u24lambda_u243.removeAll();
            $this$show_u24lambda_u243.add((Component)newComponent);
            $this$show_u24lambda_u243.revalidate();
            this.lastComponent = TuplesKt.to(node.getContent(), (Object)newComponent);
        } else if (this.isIdleState && currentTime - this.newNodeEncounteredTime < (long)this.delayMillis) {
            ShowTooltipWhenIdleRequest<T> showTooltipWhenIdleRequest = this.showTooltipWhenIdleRequest;
            if (showTooltipWhenIdleRequest != null) {
                showTooltipWhenIdleRequest.setMouseCursor(mouseCursor);
            }
            shouldShow = false;
        }
        if (!shouldShow) {
            return;
        }
        this.isIdleState = false;
        this.updatePosition(mouseCursor);
        JBPopup jBPopup2 = this.popup;
        if (jBPopup2 == null) {
            JBPopup it = jBPopup = this.createPopup();
            boolean bl = false;
            this.popup = it;
            jBPopup2 = jBPopup;
        }
        JBPopup popup = jBPopup2;
        popup.setSize(this.tooltipComponent.getPreferredSize());
        if (!popup.isVisible()) {
            popup.show(RelativePoint.fromScreen((Point)mouseCursor));
        } else {
            popup.setLocation(mouseCursor);
        }
    }

    private final void updatePosition(Point point) {
        int width = this.tooltipComponent.getPreferredSize().width;
        point.x += 11;
        int panelRightX = this.panel.getVisibleRect().x + this.panel.getVisibleRect().width;
        if (point.x + width > panelRightX) {
            int maxAllowedWidth;
            MainCallTreeDataComponent mainCallTreeDataComponent = (MainCallTreeDataComponent)ComponentUtil.getParentOfType(MainCallTreeDataComponent.class, (Component)((Component)((Object)this.panel)));
            int n = maxAllowedWidth = mainCallTreeDataComponent != null ? mainCallTreeDataComponent.getWidth() : this.panel.getWidth();
            if (width <= maxAllowedWidth) {
                point.x = panelRightX - width;
            }
        }
        point.y = point.y - this.panel.getVisibleRect().y + this.bottomLine > this.panel.getVisibleRect().height ? (point.y -= this.verticalMargin + this.tooltipComponent.getPreferredSize().height) : (point.y += this.verticalMargin);
        SwingUtilities.convertPointToScreen(point, (Component)((Object)this.panel));
    }

    private final JBPopup createPopup() {
        JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.tooltipComponent, null).setCancelOnClickOutside(false).setCancelOnWindowDeactivation(true).setCancelOnOtherWindowOpen(true).setCancelCallback(() -> FlameGraphTooltip.createPopup$lambda$5(this)).setShowShadow(true).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        return jBPopup;
    }

    public final void hide() {
        JBPopup jBPopup = this.popup;
        if (jBPopup != null) {
            jBPopup.cancel();
        }
        this.popup = null;
        this.isIdleState = true;
        this.lastComponent = null;
        this.showTooltipWhenIdleRequest = null;
        this.showTooltipWhenIdle.cancelAllRequests();
    }

    private static final void show$lambda$2$lambda$1(ShowTooltipWhenIdleRequest $tmp0) {
        ((Function0)$tmp0).invoke();
    }

    private static final Boolean createPopup$lambda$5(FlameGraphTooltip this$0) {
        this$0.popup = null;
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/profiler/ui/flamegraph/FlameGraphTooltip$Companion;", "", "<init>", "()V", "HORIZONTAL_SPACING", "", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003B+\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0015\u001a\u00020\u0004H\u0096\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lcom/intellij/profiler/ui/flamegraph/FlameGraphTooltip$ShowTooltipWhenIdleRequest;", "T", "", "Lkotlin/Function0;", "", "tooltip", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphTooltip;", "node", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphNode;", "mouseCursor", "Ljava/awt/Point;", "<init>", "(Lcom/intellij/profiler/ui/flamegraph/FlameGraphTooltip;Lcom/intellij/profiler/ui/flamegraph/FlameGraphNode;Ljava/awt/Point;)V", "getTooltip", "()Lcom/intellij/profiler/ui/flamegraph/FlameGraphTooltip;", "getNode", "()Lcom/intellij/profiler/ui/flamegraph/FlameGraphNode;", "getMouseCursor", "()Ljava/awt/Point;", "setMouseCursor", "(Ljava/awt/Point;)V", "invoke", "intellij.profiler.common"})
    private static final class ShowTooltipWhenIdleRequest<T>
    implements Function0<Unit> {
        @NotNull
        private final FlameGraphTooltip<T> tooltip;
        @NotNull
        private final FlameGraphNode<T> node;
        @NotNull
        private Point mouseCursor;

        public ShowTooltipWhenIdleRequest(@NotNull FlameGraphTooltip<T> tooltip, @NotNull FlameGraphNode<T> node, @NotNull Point mouseCursor) {
            Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
            Intrinsics.checkNotNullParameter(node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)mouseCursor, (String)"mouseCursor");
            this.tooltip = tooltip;
            this.node = node;
            this.mouseCursor = mouseCursor;
        }

        @NotNull
        public final FlameGraphTooltip<T> getTooltip() {
            return this.tooltip;
        }

        @NotNull
        public final FlameGraphNode<T> getNode() {
            return this.node;
        }

        @NotNull
        public final Point getMouseCursor() {
            return this.mouseCursor;
        }

        public final void setMouseCursor(@NotNull Point point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"<set-?>");
            this.mouseCursor = point;
        }

        public void invoke() {
            ((FlameGraphTooltip)this.tooltip).isIdleState = false;
            this.tooltip.show(this.mouseCursor, this.node);
        }
    }
}

