/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.config.ui;

import com.intellij.configurationStore.JbXmlOutputter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actionsOnSave.ActionsOnSaveConfigurable;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.scopeChooser.ScopeChooserUtils;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.watcher.BackgroundTaskBundle;
import com.intellij.plugins.watcher.config.BackgroundTaskConsumer;
import com.intellij.plugins.watcher.config.ui.NewWatcherDialog;
import com.intellij.plugins.watcher.config.ui.WatcherInfo;
import com.intellij.plugins.watcher.model.ApplicationTasksOptions;
import com.intellij.plugins.watcher.model.ProjectTasksOptions;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.plugins.watcher.model.TasksPersistentComponent;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBComboBoxLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.editors.JBComboBoxTableCellEditorComponent;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.TableView;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WatchersPanel {
    private final Project myProject;
    private final boolean myDefaultProject;
    private final JComponent myComponent;
    private final TableView<WatcherInfo> myTable;
    private final AnActionButton myAddActionButton;
    private boolean myShowingTemplatesPopup;

    public WatchersPanel(@NotNull Project project) {
        if (project == null) {
            WatchersPanel.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myDefaultProject = this.myProject.isDefault();
        this.myTable = new TableView(new ListTableModel(new ColumnInfo[]{WatchersPanel.createEnabledColumn(), this.crateNameColumn(), this.createLevelColumn()}));
        this.myTable.getEmptyText().setText(BackgroundTaskBundle.message("settings.no.watchers.configured", new Object[0]));
        this.myTable.setSelectionMode(2);
        this.myTable.setShowGrid(false);
        this.myTable.setRowHeight(this.myTable.getRowHeight() + JBUIScale.scale((int)4));
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                int row;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((row = WatchersPanel.this.myTable.rowAtPoint(e.getPoint())) < 0) {
                    return false;
                }
                WatchersPanel.editWatcher(WatchersPanel.this.myProject, (WatcherInfo)WatchersPanel.this.myTable.getRow(row), () -> WatchersPanel.this.myTable.repaint());
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/plugins/watcher/config/ui/WatchersPanel$1", "onDoubleClick"));
            }
        }.installOn(this.myTable);
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator(this.myTable).setAddAction(button -> this.showTemplatesPopup((AnActionButton)button, null, true)).setAddIcon(LayeredIcon.ADD_WITH_DROPDOWN).setEditAction(button -> {
            List selected = this.myTable.getSelectedObjects();
            if (selected.size() == 1) {
                WatchersPanel.editWatcher(this.myProject, (WatcherInfo)selected.get(0), () -> this.myTable.repaint());
            }
        }).addExtraAction((AnAction)new CopyAction()).addExtraAction((AnAction)new ImportWatchersAction()).addExtraAction((AnAction)new ExportWatchersAction());
        JPanel tablePanel = toolbarDecorator.createPanel();
        this.myAddActionButton = toolbarDecorator.getActionsPanel().getAnActionButton(CommonActionsPanel.Buttons.ADD);
        JLabel commentComponent = ComponentPanelBuilder.createCommentComponent((String)BackgroundTaskBundle.message("settings.page.comment", new Object[0]), (boolean)true, (int)-1, (boolean)true);
        BorderLayoutPanel panelWithComment = JBUI.Panels.simplePanel((Component)tablePanel).addToBottom((Component)commentComponent);
        this.myComponent = this.myDefaultProject ? panelWithComment : JBUI.Panels.simplePanel((int)0, (int)4).addToCenter((Component)panelWithComment).addToBottom((Component)ActionsOnSaveConfigurable.createGoToActionsOnSavePageLink());
    }

    public static void editWatcher(@NotNull Project project, @NotNull WatcherInfo info, @NotNull Runnable uiUpdaterOnOk) {
        NewWatcherDialog dialog;
        TaskOptions watcher;
        if (project == null) {
            WatchersPanel.$$$reportNull$$$0(1);
        }
        if (info == null) {
            WatchersPanel.$$$reportNull$$$0(2);
        }
        if (uiUpdaterOnOk == null) {
            WatchersPanel.$$$reportNull$$$0(3);
        }
        if ((watcher = info.getWatcher()) == null) {
            watcher = new TaskOptions();
            watcher.setName(info.getWatcherName());
        }
        if ((dialog = new NewWatcherDialog(project, watcher, BackgroundTaskBundle.message("dialog.title.edit.file.watcher", new Object[0]))).showAndGet()) {
            info.setWatcher(dialog.getTaskOptions());
            info.setWatcherName(info.getWatcher().getName());
            uiUpdaterOnOk.run();
        }
    }

    private static ColumnInfo<WatcherInfo, Boolean> createEnabledColumn() {
        return new ColumnInfo<WatcherInfo, Boolean>(BackgroundTaskBundle.message("settings.file.watchers.column.enabled", new Object[0])){

            public Boolean valueOf(WatcherInfo info) {
                return info.getEnabled();
            }

            public int getWidth(JTable table) {
                return JBUIScale.scale((int)66);
            }

            public Class<?> getColumnClass() {
                return Boolean.class;
            }

            public boolean isCellEditable(WatcherInfo info) {
                return info.getWatcher() != null;
            }

            public void setValue(WatcherInfo info, Boolean value) {
                info.setEnabled(value);
            }
        };
    }

    private ColumnInfo<WatcherInfo, String> crateNameColumn() {
        return new ColumnInfo<WatcherInfo, String>(BackgroundTaskBundle.message("settings.file.watchers.column.name", new Object[0])){

            public String valueOf(WatcherInfo info) {
                GlobalSearchScope scope;
                if (info.getWatcher() == null) {
                    return "<html><font color='#" + ColorUtil.toHex((Color)JBColor.RED) + "'>" + info.getWatcherName() + " [not found]</font></html>";
                }
                if (!WatchersPanel.this.myDefaultProject && (scope = ScopeChooserUtils.findScopeByName((Project)WatchersPanel.this.myProject, (String)info.getWatcher().getScopeName())) == GlobalSearchScope.EMPTY_SCOPE) {
                    return new HtmlBuilder().append(info.getWatcherName()).append(" ").append((HtmlChunk)HtmlChunk.tag((String)"font").attr("color", "#" + ColorUtil.toHex((Color)JBColor.RED)).addText(BackgroundTaskBundle.message("unknown.scope.tail.hint.in.watchers.list", new Object[0]))).wrapWith("html").toString();
                }
                return info.getWatcherName();
            }
        };
    }

    private ColumnInfo<WatcherInfo, WatcherInfo.WatcherLevel> createLevelColumn() {
        return new ColumnInfo<WatcherInfo, WatcherInfo.WatcherLevel>(BackgroundTaskBundle.message("settings.file.watchers.column.level", new Object[0])){
            private final DefaultTableCellRenderer myRenderer;
            private final AbstractTableCellEditor myEditor;
            {
                this.myRenderer = new DefaultTableCellRenderer(){
                    private final JBComboBoxLabel myComboLabel = new JBComboBoxLabel();

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        this.myComboLabel.setText(((WatcherInfo.WatcherLevel)((Object)value)).getDisplayName());
                        this.myComboLabel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                        this.myComboLabel.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
                        if (isSelected) {
                            this.myComboLabel.setSelectionIcon();
                        } else {
                            this.myComboLabel.setRegularIcon();
                        }
                        if (!table.isCellEditable(row, column)) {
                            this.myComboLabel.setForeground(UIUtil.getLabelDisabledForeground());
                            this.myComboLabel.setIcon(null);
                        }
                        return this.myComboLabel;
                    }
                };
                this.myEditor = new AbstractTableCellEditor(){
                    private final JBComboBoxTableCellEditorComponent myComponent = new JBComboBoxTableCellEditorComponent();
                    {
                        this.myComponent.setOptions(new Object[]{WatcherInfo.WatcherLevel.Project, WatcherInfo.WatcherLevel.Global});
                        this.myComponent.setToString(o -> o instanceof WatcherInfo.WatcherLevel ? ((WatcherInfo.WatcherLevel)((Object)((Object)o))).getDisplayName() : o.toString());
                        this.myComponent.setWide(true);
                    }

                    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                        this.myComponent.setCell(table, row, column);
                        this.myComponent.setDefaultValue(value);
                        return this.myComponent;
                    }

                    public Object getCellEditorValue() {
                        return this.myComponent.getEditorValue();
                    }
                };
            }

            public WatcherInfo.WatcherLevel valueOf(WatcherInfo info) {
                return info.getLevel();
            }

            public int getWidth(JTable table) {
                return JBUIScale.scale((int)70);
            }

            public boolean isCellEditable(WatcherInfo info) {
                return !WatchersPanel.this.myDefaultProject && info.getWatcher() != null;
            }

            public TableCellRenderer getRenderer(WatcherInfo info) {
                return WatchersPanel.this.myDefaultProject ? super.getRenderer((Object)info) : this.myRenderer;
            }

            public TableCellEditor getEditor(WatcherInfo info) {
                return this.myEditor;
            }

            public void setValue(WatcherInfo info, WatcherInfo.WatcherLevel value) {
                info.setLevel(value);
            }
        };
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public void showTemplatesPopup(@NotNull String templateName) {
        if (templateName == null) {
            WatchersPanel.$$$reportNull$$$0(4);
        }
        this.showTemplatesPopup(this.myAddActionButton, templateName, false);
    }

    private void editOptionsAndAdd(TaskOptions options) {
        NewWatcherDialog dialog = new NewWatcherDialog(this.myProject, options, BackgroundTaskBundle.message("dialog.title.new.file.watcher", new Object[0]));
        if (dialog.showAndGet()) {
            TaskOptions watcher = dialog.getTaskOptions();
            WatcherInfo.WatcherLevel level = this.myDefaultProject ? WatcherInfo.WatcherLevel.Global : WatcherInfo.WatcherLevel.Project;
            WatcherInfo item = new WatcherInfo(!this.myDefaultProject, watcher, watcher.getName(), level);
            this.myTable.getListTableModel().addRow((Object)item);
            this.myTable.setSelection(Collections.singletonList(item));
        }
    }

    private void showTemplatesPopup(@NotNull AnActionButton button, @Nullable String preselectedTemplateName, boolean focusPopup) {
        if (button == null) {
            WatchersPanel.$$$reportNull$$$0(5);
        }
        if (this.myShowingTemplatesPopup) {
            return;
        }
        Ref initialSelection = Ref.create();
        ArrayList<Pair> optionsList = new ArrayList<Pair>(ContainerUtil.map((Collection)BackgroundTaskConsumer.EP_NAME.getExtensionList(), consumer -> {
            TaskOptions template = consumer.getOptionsTemplate();
            Pair pair = Pair.create((Object)template, (Object)consumer);
            if (template.getName().equals(preselectedTemplateName)) {
                initialSelection.set((Object)pair);
            }
            return pair;
        }));
        TaskOptions emptyOptions = new TaskOptions();
        emptyOptions.setTrackOnlyRoot(false);
        optionsList.sort((o1, o2) -> StringUtil.compare((String)((TaskOptions)o1.getFirst()).getName(), (String)((TaskOptions)o2.getFirst()).getName(), (boolean)true));
        optionsList.add(0, Pair.create((Object)emptyOptions, null));
        JBList list = new JBList(optionsList);
        list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                Pair pair = (Pair)value;
                String description = ((TaskOptions)pair.getFirst()).getDescription();
                this.setText(WatchersPanel.extractName((Pair<TaskOptions, BackgroundTaskConsumer>)pair));
                if (!StringUtil.isEmpty((String)description)) {
                    this.setToolTipText(description);
                }
                this.setBorder(JBUI.Borders.empty((int)3));
                this.setIcon(((TaskOptions)pair.getFirst()).getFileType().getIcon());
                return result;
            }
        });
        JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle(BackgroundTaskBundle.message("popup.title.choose.template", new Object[0])).setMovable(true).setResizable(false).setRequestFocus(focusPopup).setItemChosenCallback(() -> this.lambda$showTemplatesPopup$5((JList)list)).setFilteringEnabled(o -> WatchersPanel.extractName((Pair<TaskOptions, BackgroundTaskConsumer>)((Pair)o))).setSelectedValue((Object)((Pair)initialSelection.get()), true).createPopup();
        popup.addListener(new JBPopupListener(){

            public void beforeShown(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    6.$$$reportNull$$$0(0);
                }
                WatchersPanel.this.myShowingTemplatesPopup = true;
            }

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    6.$$$reportNull$$$0(1);
                }
                WatchersPanel.this.myShowingTemplatesPopup = false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/plugins/watcher/config/ui/WatchersPanel$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeShown";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        RelativePoint preferredPopupPoint = button.getPreferredPopupPoint();
        popup.show(preferredPopupPoint);
    }

    @Nls
    private static String extractName(Pair<TaskOptions, BackgroundTaskConsumer> pair) {
        String name = ((TaskOptions)pair.getFirst()).getName();
        return StringUtil.isEmpty((String)name) ? BackgroundTaskBundle.message("custom.file.watcher.name.placeholder", new Object[0]) : name;
    }

    public void selectTaskByName(@NotNull String taskOptionsName) {
        if (taskOptionsName == null) {
            WatchersPanel.$$$reportNull$$$0(6);
        }
        this.myTable.setSelection((Collection)ContainerUtil.findAll((Collection)this.myTable.getItems(), info -> info.getWatcher() != null && taskOptionsName.equals(info.getWatcherName())));
    }

    public void reset() {
        this.reset(WatchersPanel.getStoredState(this.myProject));
    }

    public void reset(@NotNull List<WatcherInfo> watcherInfos) {
        if (watcherInfos == null) {
            WatchersPanel.$$$reportNull$$$0(7);
        }
        this.myTable.getListTableModel().setItems(watcherInfos);
    }

    public boolean isModified() {
        return !this.myTable.getItems().equals(WatchersPanel.getStoredState(this.myProject));
    }

    public void apply() {
        List globalWatchers = ContainerUtil.mapNotNull((Collection)this.myTable.getItems(), info -> info.getLevel() == WatcherInfo.WatcherLevel.Global ? info.getWatcher() : null);
        ApplicationTasksOptions.getInstance().setGlobalWatchers(globalWatchers);
        if (!this.myDefaultProject) {
            List projectLevelTasks = ContainerUtil.mapNotNull((Collection)this.myTable.getItems(), info -> info.getLevel() == WatcherInfo.WatcherLevel.Project ? Pair.create((Object)info.getWatcher(), (Object)info.getEnabled()) : null);
            ProjectTasksOptions.getInstance(this.myProject).setTasks(projectLevelTasks);
        }
        List enabledGlobalWatchers = ContainerUtil.mapNotNull((Collection)this.myTable.getItems(), info -> info.getLevel() == WatcherInfo.WatcherLevel.Global && info.getEnabled() ? info.getWatcherName() : null);
        ProjectTasksOptions.getInstance(this.myProject).setEnabledGlobalWatcherNames(enabledGlobalWatchers);
        this.reset();
    }

    public List<WatcherInfo> getCurrentWatcherInfos() {
        return this.myTable.getItems();
    }

    @NotNull
    public static List<WatcherInfo> getStoredState(@NotNull Project project) {
        if (project == null) {
            WatchersPanel.$$$reportNull$$$0(8);
        }
        ArrayList<WatcherInfo> items = new ArrayList<WatcherInfo>();
        if (!project.isDefault()) {
            for (Pair<TaskOptions, Boolean> pair : ProjectTasksOptions.getInstance(project).getTasks()) {
                TaskOptions watcher = ((TaskOptions)pair.first).createCopy();
                items.add(new WatcherInfo((Boolean)pair.second, watcher, watcher.getName(), WatcherInfo.WatcherLevel.Project));
            }
        }
        HashSet<String> enabledGlobalWatcherNames = new HashSet<String>(ProjectTasksOptions.getInstance(project).getEnabledGlobalWatcherNames());
        for (TaskOptions watcher : ApplicationTasksOptions.getInstance().getGlobalWatchers()) {
            boolean enabled = enabledGlobalWatcherNames.remove(watcher.getName());
            items.add(new WatcherInfo(enabled, watcher.createCopy(), watcher.getName(), WatcherInfo.WatcherLevel.Global));
        }
        for (String name : enabledGlobalWatcherNames) {
            items.add(new WatcherInfo(true, null, name, WatcherInfo.WatcherLevel.Global));
        }
        ArrayList<WatcherInfo> arrayList = items;
        if (arrayList == null) {
            WatchersPanel.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    private static String getDefaultExportFilePath() {
        String string = SystemProperties.getUserHome() + "/watchers.xml";
        if (string == null) {
            WatchersPanel.$$$reportNull$$$0(10);
        }
        return string;
    }

    private /* synthetic */ void lambda$showTemplatesPopup$5(JList list) {
        Pair pair = (Pair)list.getSelectedValue();
        if (pair == null) {
            return;
        }
        TaskOptions options = (TaskOptions)pair.getFirst();
        @Nullable BackgroundTaskConsumer consumer = (BackgroundTaskConsumer)pair.getSecond();
        if (consumer != null) {
            TaskOptions lastOptions = ApplicationTasksOptions.getInstance().getLastEditedWatcherWithName(options.getName());
            consumer.additionalConfiguration(this.myProject, null, options);
            consumer.configureWithLastOptions(options, lastOptions);
        }
        this.editOptionsAndAdd(options);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiUpdaterOnOk";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskOptionsName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watcherInfos";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/watcher/config/ui/WatchersPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/watcher/config/ui/WatchersPanel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStoredState";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultExportFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "editWatcher";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showTemplatesPopup";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "selectTaskByName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getStoredState";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10 -> new IllegalStateException(string);
        };
    }

    private class CopyAction
    extends AnAction {
        CopyAction() {
            super(BackgroundTaskBundle.messagePointer("button.create.file.watcher.copy", new Object[0]), AllIcons.Actions.Copy);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                CopyAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyAction.$$$reportNull$$$0(1);
            }
            List selected = WatchersPanel.this.myTable.getSelectedObjects();
            e.getPresentation().setEnabled(selected.size() == 1 && ((WatcherInfo)selected.get(0)).getWatcher() != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List selected;
            if (e == null) {
                CopyAction.$$$reportNull$$$0(2);
            }
            if ((selected = WatchersPanel.this.myTable.getSelectedObjects()).size() != 1) {
                return;
            }
            TaskOptions watcher = ((WatcherInfo)selected.get(0)).getWatcher();
            if (watcher != null) {
                TaskOptions copy = watcher.createCopy();
                copy.setName(copy.getName() + " Copy");
                WatchersPanel.this.editOptionsAndAdd(copy);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/plugins/watcher/config/ui/WatchersPanel$CopyAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/plugins/watcher/config/ui/WatchersPanel$CopyAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private final class ImportWatchersAction
    extends AnAction {
        private ImportWatchersAction() {
            super(BackgroundTaskBundle.messagePointer("button.import.file.watcher", new Object[0]), PlatformIcons.IMPORT_ICON);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ImportWatchersAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ImportWatchersAction.$$$reportNull$$$0(1);
            }
            FileChooserDescriptor chooserDescriptor = FileChooserDescriptorFactory.createSingleFileDescriptor((FileType)StdFileTypes.XML);
            chooserDescriptor.setHideIgnored(false);
            chooserDescriptor.setTitle(BackgroundTaskBundle.message("watcher.import.choose.file", new Object[0]));
            VirtualFile toSelect = LocalFileSystem.getInstance().findFileByPath(WatchersPanel.getDefaultExportFilePath());
            if (toSelect == null) {
                toSelect = LocalFileSystem.getInstance().findFileByPath(PathUtil.getParentPath((String)WatchersPanel.getDefaultExportFilePath()));
            }
            FileChooser.chooseFile((FileChooserDescriptor)chooserDescriptor, (Project)WatchersPanel.this.myProject, (VirtualFile)toSelect, file -> {
                file.refresh(false, false);
                try {
                    Element rootElement = JDOMUtil.load((InputStream)file.getInputStream());
                    List currentItems = WatchersPanel.this.myTable.getItems();
                    List<Pair<TaskOptions, Boolean>> taskOptionsToImport = TasksPersistentComponent.loadFileWatcherList(rootElement);
                    if (taskOptionsToImport.isEmpty()) {
                        Messages.showInfoMessage((String)BackgroundTaskBundle.message("watcher.import.empty", new Object[0]), (String)BackgroundTaskBundle.message("settings.file.watchers.import.file.watchers.title", new Object[0]));
                        return;
                    }
                    for (Pair<TaskOptions, Boolean> pair : taskOptionsToImport) {
                        TaskOptions options = (TaskOptions)pair.getFirst();
                        int indexOfExisting = ContainerUtil.indexOf((List)currentItems, info -> info.getWatcher() != null && info.getWatcherName().equals(options.getName()));
                        if (indexOfExisting >= 0) {
                            if (!MessageDialogBuilder.yesNo((String)BackgroundTaskBundle.message("watcher.import", new Object[0]), (String)BackgroundTaskBundle.message("watcher.import.replace", options.getName())).ask(WatchersPanel.this.myProject)) continue;
                            WatchersPanel.this.myTable.getListTableModel().removeRow(indexOfExisting);
                        }
                        boolean enabled = !WatchersPanel.this.myDefaultProject;
                        WatcherInfo.WatcherLevel level = WatchersPanel.this.myDefaultProject ? WatcherInfo.WatcherLevel.Global : WatcherInfo.WatcherLevel.Project;
                        WatchersPanel.this.myTable.getListTableModel().addRow((Object)new WatcherInfo(enabled, options, options.getName(), level));
                    }
                }
                catch (IOException | JDOMException ex) {
                    Messages.showErrorDialog((String)ex.getMessage(), (String)BackgroundTaskBundle.message("settings.file.watchers.error", new Object[0]));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/plugins/watcher/config/ui/WatchersPanel$ImportWatchersAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/plugins/watcher/config/ui/WatchersPanel$ImportWatchersAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    private final class ExportWatchersAction
    extends AnAction {
        private ExportWatchersAction() {
            super(BackgroundTaskBundle.messagePointer("button.export.file.watcher", new Object[0]), PlatformIcons.EXPORT_ICON);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ExportWatchersAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ExportWatchersAction.$$$reportNull$$$0(1);
            }
            ChooseOptionsToExportDialog dialog = new ChooseOptionsToExportDialog();
            dialog.show();
            List<TaskOptions> elements = dialog.getMarkedElements();
            if (!dialog.isOK() || elements.isEmpty()) {
                return;
            }
            Element root = TasksPersistentComponent.createElement(elements);
            try {
                File exportFile = dialog.getExportFile();
                if (exportFile.exists() && !((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)BackgroundTaskBundle.message("watcher.export", new Object[0]), (String)BackgroundTaskBundle.message("watcher.export.overwrite.file", new Object[0])).icon(null)).ask(WatchersPanel.this.myProject)) {
                    return;
                }
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(exportFile), StandardCharsets.UTF_8));){
                    JbXmlOutputter.Companion.collapseMacrosAndWrite(root, (ComponentManager)WatchersPanel.this.myProject, (Writer)writer);
                }
                LocalFileSystem.getInstance().refreshIoFiles(Collections.singletonList(exportFile), true, false, null);
            }
            catch (IOException ex) {
                Messages.showErrorDialog((String)ex.getMessage(), (String)BackgroundTaskBundle.message("settings.file.watchers.error", new Object[0]));
                return;
            }
            Messages.showInfoMessage((String)BackgroundTaskBundle.message("watcher.export.successfully", new Object[0]), (String)BackgroundTaskBundle.message("settings.file.watchers.info", new Object[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/plugins/watcher/config/ui/WatchersPanel$ExportWatchersAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/plugins/watcher/config/ui/WatchersPanel$ExportWatchersAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }

        public class ChooseOptionsToExportDialog
        extends DialogWrapper {
            private final ElementsChooser<TaskOptions> myChooser;
            private final FieldPanel myFieldPanel;

            protected ChooseOptionsToExportDialog() {
                super(WatchersPanel.this.myProject);
                List taskOptions = ContainerUtil.mapNotNull((Collection)WatchersPanel.this.myTable.getItems(), info -> info.getWatcher());
                this.myChooser = new ElementsChooser<TaskOptions>(taskOptions, true){

                    protected String getItemText(@NotNull TaskOptions value) {
                        if (value == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return value.getName();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/plugins/watcher/config/ui/WatchersPanel$ExportWatchersAction$ChooseOptionsToExportDialog$1", "getItemText"));
                    }
                };
                this.myChooser.setColorUnmarkedElements(false);
                this.myFieldPanel = new FieldPanel(BackgroundTaskBundle.message("label.export.watchers.to", new Object[0]), null, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FileChooserDescriptor chooserDescriptor = FileChooserDescriptorFactory.createSingleLocalFileDescriptor();
                        chooserDescriptor.setDescription(BackgroundTaskBundle.message("watcher.export.choose.file.description", new Object[0]));
                        chooserDescriptor.setHideIgnored(false);
                        chooserDescriptor.setTitle(BackgroundTaskBundle.message("watcher.choose.file.or.dir", new Object[0]));
                        FileChooser.chooseFile((FileChooserDescriptor)chooserDescriptor, (Project)WatchersPanel.this.myProject, null, file -> {
                            Object path = file.getPath();
                            if (file.isDirectory()) {
                                path = (String)path + "/watchers.xml";
                            }
                            ChooseOptionsToExportDialog.this.myFieldPanel.setText(FileUtil.toSystemDependentName((String)path));
                        });
                    }
                }, null);
                this.myFieldPanel.setText(FileUtil.toSystemDependentName((String)WatchersPanel.getDefaultExportFilePath()));
                this.setTitle(BackgroundTaskBundle.message("watcher.export", new Object[0]));
                this.setOKButtonText(BackgroundTaskBundle.message("button.save.exported.file.watchers", new Object[0]));
                this.init();
            }

            @Nullable
            protected JComponent createCenterPanel() {
                return this.myChooser;
            }

            @Nullable
            protected JComponent createNorthPanel() {
                return this.myFieldPanel;
            }

            public List<TaskOptions> getMarkedElements() {
                return this.myChooser.getMarkedElements();
            }

            public File getExportFile() {
                return new File(FileUtil.toSystemDependentName((String)this.myFieldPanel.getText()));
            }
        }
    }
}

