/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.google.common.collect.Sets;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.ast.PyAstStringLiteralExpression;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagerImpl;
import com.jetbrains.python.packaging.PyPackageRequirementsSettings;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementParser;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.remote.PyCredentialsContribution;
import com.jetbrains.python.run.PythonInterpreterTargetEnvironmentFactory;
import com.jetbrains.python.sdk.CredentialsTypeExChecker;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.conda.CondaEnvSdkFlavor;
import com.jetbrains.python.target.PyTargetAwareAdditionalData;
import com.jetbrains.python.target.targetWithVfs.TargetWithMappedLocalVfs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyPackageUtil {
    public static final String SETUPTOOLS = "setuptools";
    public static final String PIP = "pip";
    public static final String DISTRIBUTE = "distribute";
    private static final Logger LOG = Logger.getInstance(PyPackageUtil.class);
    @NotNull
    private static final String REQUIRES = "requires";
    @NotNull
    private static final String INSTALL_REQUIRES = "install_requires";
    private static final String @NotNull [] SETUP_PY_REQUIRES_KWARGS_NAMES = new String[]{"requires", "install_requires", "setup_requires", "tests_require"};
    @NotNull
    private static final String DEPENDENCY_LINKS = "dependency_links";

    private PyPackageUtil() {
    }

    public static boolean hasSetupPy(@NotNull Module module) {
        if (module == null) {
            PyPackageUtil.$$$reportNull$$$0(0);
        }
        return PyPackageUtil.findSetupPy(module) != null;
    }

    @Nullable
    public static PyFile findSetupPy(@NotNull Module module) {
        if (module == null) {
            PyPackageUtil.$$$reportNull$$$0(1);
        }
        for (VirtualFile root : PyUtil.getSourceRoots(module)) {
            PsiFile file;
            VirtualFile child = root.findChild("setup.py");
            if (child == null || !((file = (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)module.getProject()).findFile(child))) instanceof PyFile)) continue;
            return (PyFile)file;
        }
        return null;
    }

    public static boolean hasRequirementsTxt(@NotNull Module module) {
        if (module == null) {
            PyPackageUtil.$$$reportNull$$$0(2);
        }
        return PyPackageUtil.findRequirementsTxt(module) != null;
    }

    @Nullable
    public static VirtualFile findRequirementsTxt(@NotNull Module module) {
        String requirementsPath;
        if (module == null) {
            PyPackageUtil.$$$reportNull$$$0(3);
        }
        if (!(requirementsPath = PyPackageRequirementsSettings.getInstance(module).getRequirementsPath()).isEmpty()) {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(requirementsPath);
            if (file != null) {
                return file;
            }
            ModuleRootManager manager = ModuleRootManager.getInstance((Module)module);
            for (VirtualFile root : manager.getContentRoots()) {
                VirtualFile fileInRoot = root.findFileByRelativePath(requirementsPath);
                if (fileInRoot == null) continue;
                return fileInRoot;
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement findSetupPyInstallRequires(@Nullable PyCallExpression setupCall) {
        if (setupCall == null) {
            return null;
        }
        return StreamEx.of((Object[])new String[]{REQUIRES, INSTALL_REQUIRES}).map(setupCall::getKeywordArgument).map(PyPackageUtil::resolveValue).findFirst(Objects::nonNull).orElse(null);
    }

    @Nullable
    public static List<PyRequirement> findSetupPyRequires(@NotNull Module module) {
        PyCallExpression setupCall;
        if (module == null) {
            PyPackageUtil.$$$reportNull$$$0(4);
        }
        if ((setupCall = PyPackageUtil.findSetupCall(module)) == null) {
            return null;
        }
        List<PyRequirement> requirementsFromRequires = PyPackageUtil.getSetupPyRequiresFromArguments(setupCall, SETUP_PY_REQUIRES_KWARGS_NAMES);
        List<PyRequirement> requirementsFromLinks = PyPackageUtil.getSetupPyRequiresFromArguments(setupCall, DEPENDENCY_LINKS);
        return PyPackageUtil.mergeSetupPyRequirements(requirementsFromRequires, requirementsFromLinks);
    }

    @Nullable
    public static Map<String, List<PyRequirement>> findSetupPyExtrasRequire(@NotNull Module module) {
        PyCallExpression setupCall;
        if (module == null) {
            PyPackageUtil.$$$reportNull$$$0(5);
        }
        if ((setupCall = PyPackageUtil.findSetupCall(module)) == null) {
            return null;
        }
        PyDictLiteralExpression extrasRequire = PyUtil.as(PyPackageUtil.resolveValue(setupCall.getKeywordArgument("extras_require")), PyDictLiteralExpression.class);
        if (extrasRequire == null) {
            return null;
        }
        HashMap<String, List<PyRequirement>> result2 = new HashMap<String, List<PyRequirement>>();
        for (PyKeyValueExpression extraRequires : extrasRequire.getElements()) {
            Pair<String, List<PyRequirement>> extraResult = PyPackageUtil.getExtraRequires(extraRequires.getKey(), extraRequires.getValue());
            if (extraResult == null) continue;
            result2.put((String)extraResult.first, (List)extraResult.second);
        }
        return result2;
    }

    @Nullable
    private static Pair<String, List<PyRequirement>> getExtraRequires(@NotNull PyExpression extra, @Nullable PyExpression requires) {
        List<String> requiresValue;
        if (extra == null) {
            PyPackageUtil.$$$reportNull$$$0(6);
        }
        if (extra instanceof PyStringLiteralExpression && (requiresValue = PyPackageUtil.resolveRequiresValue(requires)) != null) {
            return Pair.createNonNull((Object)((PyStringLiteralExpression)extra).getStringValue(), PyRequirementParser.fromText(StringUtil.join(requiresValue, (String)"\n")));
        }
        return null;
    }

    @NotNull
    private static List<PyRequirement> getSetupPyRequiresFromArguments(@NotNull PyCallExpression setupCall, String ... argumentNames) {
        if (setupCall == null) {
            PyPackageUtil.$$$reportNull$$$0(7);
        }
        if (argumentNames == null) {
            PyPackageUtil.$$$reportNull$$$0(8);
        }
        List<PyRequirement> list = PyRequirementParser.fromText(StreamEx.of((Object[])argumentNames).map(setupCall::getKeywordArgument).flatCollection(PyPackageUtil::resolveRequiresValue).joining((CharSequence)"\n"));
        if (list == null) {
            PyPackageUtil.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    private static List<PyRequirement> mergeSetupPyRequirements(@NotNull List<PyRequirement> requirementsFromRequires, @NotNull List<PyRequirement> requirementsFromLinks) {
        if (requirementsFromRequires == null) {
            PyPackageUtil.$$$reportNull$$$0(10);
        }
        if (requirementsFromLinks == null) {
            PyPackageUtil.$$$reportNull$$$0(11);
        }
        if (!requirementsFromLinks.isEmpty()) {
            Map nameToRequirements = requirementsFromRequires.stream().collect(Collectors.groupingBy(PyRequirement::getName, LinkedHashMap::new, Collectors.toList()));
            for (PyRequirement requirementFromLinks : requirementsFromLinks) {
                nameToRequirements.replace(requirementFromLinks.getName(), Collections.singletonList(requirementFromLinks));
            }
            List list = nameToRequirements.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(ArrayList::new));
            if (list == null) {
                PyPackageUtil.$$$reportNull$$$0(12);
            }
            return list;
        }
        List<PyRequirement> list = requirementsFromRequires;
        if (list == null) {
            PyPackageUtil.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Nullable
    private static PsiElement resolveValue(@Nullable PyExpression expression) {
        PyExpression elementToAnalyze = PyPsiUtils.flattenParens(expression);
        if (elementToAnalyze instanceof PyReferenceExpression) {
            TypeEvalContext context = TypeEvalContext.deepCodeInsight(elementToAnalyze.getProject());
            PyResolveContext resolveContext = PyResolveContext.defaultContext(context);
            return StreamEx.of(((PyReferenceExpression)elementToAnalyze).multiFollowAssignmentsChain(resolveContext)).map(ResolveResult::getElement).findFirst(Objects::nonNull).map(e -> e instanceof PyExpression ? PyPsiUtils.flattenParens((PyExpression)e) : e).orElse(null);
        }
        return elementToAnalyze;
    }

    @Nullable
    private static List<String> resolveRequiresValue(@Nullable PyExpression expression) {
        PsiElement elementToAnalyze = PyPackageUtil.resolveValue(expression);
        if (elementToAnalyze instanceof PyStringLiteralExpression) {
            return Collections.singletonList(((PyStringLiteralExpression)elementToAnalyze).getStringValue());
        }
        if (elementToAnalyze instanceof PyListLiteralExpression || elementToAnalyze instanceof PyTupleExpression) {
            return StreamEx.of((Object[])((PySequenceExpression)elementToAnalyze).getElements()).map(PyPackageUtil::resolveValue).select(PyStringLiteralExpression.class).map(PyAstStringLiteralExpression::getStringValue).toList();
        }
        return null;
    }

    @NotNull
    public static List<String> getPackageNames(@NotNull Module module) {
        if (module == null) {
            PyPackageUtil.$$$reportNull$$$0(14);
        }
        ArrayList<String> packageNames = new ArrayList<String>();
        Project project = module.getProject();
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
        if (roots.length == 0) {
            roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        }
        for (VirtualFile root : roots) {
            PyPackageUtil.collectPackageNames(project, root, packageNames);
        }
        ArrayList<String> arrayList = packageNames;
        if (arrayList == null) {
            PyPackageUtil.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    public static String requirementsToString(@NotNull List<? extends PyRequirement> requirements) {
        if (requirements == null) {
            PyPackageUtil.$$$reportNull$$$0(16);
        }
        String string = StringUtil.join(requirements, requirement -> String.format("'%s'", requirement.getPresentableText()), (String)", ");
        if (string == null) {
            PyPackageUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Nullable
    private static PyCallExpression findSetupCall(@NotNull PyFile file) {
        if (file == null) {
            PyPackageUtil.$$$reportNull$$$0(18);
        }
        final Ref result2 = new Ref(null);
        file.acceptChildren(new PyRecursiveElementVisitor(){

            @Override
            public void visitPyCallExpression(@NotNull PyCallExpression node) {
                PyExpression callee;
                String name2;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ("setup".equals(name2 = PyUtil.getReadableRepr((PsiElement)(callee = node.getCallee()), true))) {
                    result2.set((Object)node);
                }
            }

            @Override
            public void visitPyElement(@NotNull PyElement node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!(node instanceof ScopeOwner)) {
                    super.visitPyElement(node);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/jetbrains/python/packaging/PyPackageUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return (PyCallExpression)result2.get();
    }

    @Nullable
    public static PyCallExpression findSetupCall(@NotNull Module module) {
        if (module == null) {
            PyPackageUtil.$$$reportNull$$$0(19);
        }
        return Optional.ofNullable(PyPackageUtil.findSetupPy(module)).map(PyPackageUtil::findSetupCall).orElse(null);
    }

    private static void collectPackageNames(@NotNull Project project, final @NotNull VirtualFile root, final @NotNull List<String> results) {
        if (project == null) {
            PyPackageUtil.$$$reportNull$$$0(20);
        }
        if (root == null) {
            PyPackageUtil.$$$reportNull$$$0(21);
        }
        if (results == null) {
            PyPackageUtil.$$$reportNull$$$0(22);
        }
        final ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (file.equals(root)) {
                    return true;
                }
                if (!fileIndex.isExcluded(file) && file.isDirectory() && file.findChild("__init__.py") != null) {
                    results.add(VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'.'));
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/packaging/PyPackageUtil$2", "visitFile"));
            }
        });
    }

    public static boolean packageManagementEnabled(@Nullable Sdk sdk2, boolean newUi, boolean calledFromInspection) {
        PythonSdkAdditionalData data;
        if (sdk2 == null) {
            return false;
        }
        PythonSdkAdditionalData pythonSdkAdditionalData = data = calledFromInspection ? (PythonSdkAdditionalData)ObjectUtils.tryCast((Object)sdk2.getSdkAdditionalData(), PythonSdkAdditionalData.class) : PySdkExtKt.getOrCreateAdditionalData(sdk2);
        if (!newUi && data != null && data.getFlavor() instanceof CondaEnvSdkFlavor && PySdkExtKt.getTargetEnvConfiguration(sdk2) != null) {
            LOG.warn("Remote Conda package manager is disabled");
            return false;
        }
        Boolean supported = PythonInterpreterTargetEnvironmentFactory.isPackageManagementSupported(sdk2);
        if (supported != null) {
            return supported;
        }
        if (!PythonSdkUtil.isRemote(sdk2)) {
            return true;
        }
        return new CredentialsTypeExChecker(){

            @Override
            protected boolean checkLanguageContribution(PyCredentialsContribution languageContribution) {
                return languageContribution.isPackageManagementEnabled();
            }
        }.check(sdk2);
    }

    @NotNull
    public static List<PyPackage> refreshAndGetPackagesModally(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PyPackageUtil.$$$reportNull$$$0(23);
        }
        Application app = ApplicationManager.getApplication();
        assert (!app.isWriteAccessAllowed()) : "This method can't be called on WriteAction because refreshAndGetPackages would be called on AWT thread in this case (see runProcessWithProgressSynchronously) and may lead to freeze";
        Ref packagesRef = Ref.create();
        Throwable callStacktrace = new Throwable();
        LOG.debug("Showing modal progress for collecting installed packages", new Throwable());
        PyUtil.runWithProgress(null, PyBundle.message("sdk.scanning.installed.packages", new Object[0]), true, false, (Consumer<? super ProgressIndicator>)((Consumer)indicator -> {
            if (PythonSdkUtil.isDisposed(sdk2)) {
                packagesRef.set(Collections.emptyList());
                return;
            }
            indicator.setIndeterminate(true);
            try {
                PyPackageManager manager = PyPackageManager.getInstance(sdk2);
                packagesRef.set(manager.refreshAndGetPackages(false));
            }
            catch (ExecutionException e) {
                packagesRef.set(Collections.emptyList());
                e.initCause(callStacktrace);
                LOG.warn((Throwable)e);
            }
        }));
        List list = (List)packagesRef.get();
        if (list == null) {
            PyPackageUtil.$$$reportNull$$$0(24);
        }
        return list;
    }

    public static boolean updatePackagesSynchronouslyWithGuard(@NotNull PyPackageManager manager, @NotNull AtomicBoolean isUpdating) {
        if (manager == null) {
            PyPackageUtil.$$$reportNull$$$0(25);
        }
        if (isUpdating == null) {
            PyPackageUtil.$$$reportNull$$$0(26);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        if (!isUpdating.compareAndSet(false, true)) {
            return false;
        }
        try {
            if (manager instanceof PyPackageManagerImpl) {
                LOG.info("Refreshing installed packages for SDK " + PyPackageManager.getSdk(manager).getHomePath());
            }
            manager.refreshAndGetPackages(true);
        }
        catch (ExecutionException executionException) {
        }
        finally {
            isUpdating.set(false);
        }
        return true;
    }

    public static boolean hasManagement(@NotNull List<PyPackage> packages2) {
        if (packages2 == null) {
            PyPackageUtil.$$$reportNull$$$0(27);
        }
        return PyPsiPackageUtil.findPackage(packages2, SETUPTOOLS) != null || PyPsiPackageUtil.findPackage(packages2, DISTRIBUTE) != null || PyPsiPackageUtil.findPackage(packages2, PIP) != null;
    }

    @Nullable
    public static List<PyRequirement> getRequirementsFromTxt(@NotNull Module module) {
        VirtualFile requirementsTxt;
        if (module == null) {
            PyPackageUtil.$$$reportNull$$$0(28);
        }
        if ((requirementsTxt = PyPackageUtil.findRequirementsTxt(module)) != null) {
            return PyRequirementParser.fromFile(requirementsTxt);
        }
        return null;
    }

    public static void addRequirementToTxtOrSetupPy(@NotNull Module module, @NotNull String requirementName, @NotNull LanguageLevel languageLevel) {
        VirtualFile requirementsTxt;
        if (module == null) {
            PyPackageUtil.$$$reportNull$$$0(29);
        }
        if (requirementName == null) {
            PyPackageUtil.$$$reportNull$$$0(30);
        }
        if (languageLevel == null) {
            PyPackageUtil.$$$reportNull$$$0(31);
        }
        if ((requirementsTxt = PyPackageUtil.findRequirementsTxt(module)) != null && requirementsTxt.isWritable()) {
            Document document = FileDocumentManager.getInstance().getDocument(requirementsTxt);
            if (document != null) {
                document.insertString(0, (CharSequence)(requirementName + "\n"));
            }
            return;
        }
        PyFile setupPy = PyPackageUtil.findSetupPy(module);
        if (setupPy == null) {
            return;
        }
        PyCallExpression setupCall = PyPackageUtil.findSetupCall(setupPy);
        if (setupCall == null) {
            return;
        }
        PsiElement installRequires = PyPackageUtil.findSetupPyInstallRequires(setupCall);
        if (installRequires != null) {
            PyPackageUtil.addRequirementToInstallRequires(installRequires, requirementName, languageLevel);
        } else {
            PyArgumentList argumentList = setupCall.getArgumentList();
            PyKeywordArgument requiresArg = PyPackageUtil.generateRequiresKwarg(setupPy, requirementName, languageLevel);
            if (argumentList != null && requiresArg != null) {
                argumentList.addArgument(requiresArg);
            }
        }
    }

    private static void addRequirementToInstallRequires(@NotNull PsiElement installRequires, @NotNull String requirementName, @NotNull LanguageLevel languageLevel) {
        if (installRequires == null) {
            PyPackageUtil.$$$reportNull$$$0(32);
        }
        if (requirementName == null) {
            PyPackageUtil.$$$reportNull$$$0(33);
        }
        if (languageLevel == null) {
            PyPackageUtil.$$$reportNull$$$0(34);
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(installRequires.getProject());
        PyExpression newRequirement = generator.createExpressionFromText(languageLevel, "'" + requirementName + "'");
        if (installRequires instanceof PyListLiteralExpression) {
            installRequires.add((PsiElement)newRequirement);
        } else if (installRequires instanceof PyTupleExpression) {
            String newInstallRequiresText = StreamEx.of((Object[])((PyTupleExpression)installRequires).getElements()).append((Object)newRequirement).map(PsiElement::getText).joining((CharSequence)",", (CharSequence)"(", (CharSequence)")");
            PyExpression expression = generator.createExpressionFromText(languageLevel, newInstallRequiresText);
            Optional.ofNullable(PyUtil.as(expression, PyParenthesizedExpression.class)).map(PyParenthesizedExpression::getContainedExpression).map(e -> PyUtil.as(e, PyTupleExpression.class)).ifPresent(e -> installRequires.replace((PsiElement)e));
        } else if (installRequires instanceof PyStringLiteralExpression) {
            PyListLiteralExpression newInstallRequires = generator.createListLiteral();
            newInstallRequires.add(installRequires);
            newInstallRequires.add((PsiElement)newRequirement);
            installRequires.replace((PsiElement)newInstallRequires);
        }
    }

    @Nullable
    private static PyKeywordArgument generateRequiresKwarg(@NotNull PyFile setupPy, @NotNull String requirementName, @NotNull LanguageLevel languageLevel) {
        if (setupPy == null) {
            PyPackageUtil.$$$reportNull$$$0(35);
        }
        if (requirementName == null) {
            PyPackageUtil.$$$reportNull$$$0(36);
        }
        if (languageLevel == null) {
            PyPackageUtil.$$$reportNull$$$0(37);
        }
        String keyword = PyPsiUtils.containsImport(setupPy, SETUPTOOLS) ? INSTALL_REQUIRES : REQUIRES;
        String text = String.format("foo(%s=['%s'])", keyword, requirementName);
        PyExpression generated = PyElementGenerator.getInstance(setupPy.getProject()).createExpressionFromText(languageLevel, text);
        if (generated instanceof PyCallExpression) {
            PyCallExpression callExpression = (PyCallExpression)generated;
            return Stream.of(callExpression.getArguments()).filter(PyKeywordArgument.class::isInstance).map(PyKeywordArgument.class::cast).filter(kwarg -> keyword.equals(kwarg.getKeyword())).findFirst().orElse(null);
        }
        return null;
    }

    public static void runOnChangeUnderInterpreterPaths(final @NotNull Sdk sdk2, @NotNull Disposable parentDisposable, final @NotNull Runnable runnable) {
        if (sdk2 == null) {
            PyPackageUtil.$$$reportNull$$$0(38);
        }
        if (parentDisposable == null) {
            PyPackageUtil.$$$reportNull$$$0(39);
        }
        if (runnable == null) {
            PyPackageUtil.$$$reportNull$$$0(40);
        }
        final Application app = ApplicationManager.getApplication();
        VirtualFileManager.getInstance().addAsyncFileListener(new AsyncFileListener(){

            @Nullable
            public AsyncFileListener.ChangeApplier prepareChange(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (sdk2 instanceof Disposable && Disposer.isDisposed((Disposable)((Disposable)sdk2))) {
                    throw new AlreadyDisposedException("SDK " + String.valueOf(sdk2) + " (" + String.valueOf(sdk2.getClass()) + ") is already disposed");
                }
                Set<VirtualFile> roots = PyPackageUtil.getPackagingAwareSdkRoots(sdk2);
                if (roots.isEmpty()) {
                    return null;
                }
                for (VFileEvent vFileEvent : events) {
                    if (vFileEvent instanceof VFileContentChangeEvent || vFileEvent instanceof VFilePropertyChangeEvent) continue;
                    VirtualFile parent = null;
                    if (vFileEvent instanceof VFileCreateEvent) {
                        parent = ((VFileCreateEvent)vFileEvent).getParent();
                    } else {
                        VirtualFile file = vFileEvent.getFile();
                        if (file != null) {
                            parent = file.getParent();
                        }
                    }
                    if (parent == null || !roots.contains(parent)) continue;
                    InterpreterChangeEvents.LOG.debug("Interpreter change in " + String.valueOf(parent) + " indicated by " + String.valueOf(vFileEvent) + " (all events: " + String.valueOf(events) + ")");
                    app.executeOnPooledThread(runnable);
                    break;
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/jetbrains/python/packaging/PyPackageUtil$4", "prepareChange"));
            }
        }, parentDisposable);
    }

    @NotNull
    private static Set<VirtualFile> getPackagingAwareSdkRoots(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PyPackageUtil.$$$reportNull$$$0(41);
        }
        HashSet result2 = Sets.newHashSet((Object[])sdk2.getRootProvider().getFiles(OrderRootType.CLASSES));
        PyTargetAwareAdditionalData targetAdditionalData = PySdkExtKt.getTargetAdditionalData(sdk2);
        if (targetAdditionalData != null) {
            for (Map.Entry<VirtualFile, VirtualFile> remoteSourceToVfs : PyPackageUtil.getRemoteSourceToVfsMapping(targetAdditionalData).entrySet()) {
                if (!result2.contains(remoteSourceToVfs.getKey())) continue;
                result2.add(remoteSourceToVfs.getValue());
            }
        }
        String skeletonsPath = PythonSdkUtil.getSkeletonsPath(PathManager.getSystemPath(), sdk2.getHomePath());
        VirtualFile skeletonsRoot = LocalFileSystem.getInstance().findFileByPath(skeletonsPath);
        result2.removeIf(vf -> vf.equals(skeletonsRoot) || vf.equals(PyUserSkeletonsUtil.getUserSkeletonsDirectory()) || PyTypeShed.INSTANCE.isInside((VirtualFile)vf));
        HashSet hashSet = result2;
        if (hashSet == null) {
            PyPackageUtil.$$$reportNull$$$0(42);
        }
        return hashSet;
    }

    @NotNull
    private static @NotNull Map<@NotNull VirtualFile, @NotNull VirtualFile> getRemoteSourceToVfsMapping(@NotNull PyTargetAwareAdditionalData additionalData) {
        TargetEnvironmentConfiguration configuration;
        if (additionalData == null) {
            PyPackageUtil.$$$reportNull$$$0(43);
        }
        if ((configuration = additionalData.getTargetEnvironmentConfiguration()) == null) {
            Map<VirtualFile, VirtualFile> map2 = Collections.emptyMap();
            if (map2 == null) {
                PyPackageUtil.$$$reportNull$$$0(44);
            }
            return map2;
        }
        TargetWithMappedLocalVfs vfsMapper = PythonInterpreterTargetEnvironmentFactory.getTargetWithMappedLocalVfs(configuration);
        if (vfsMapper == null) {
            Map<VirtualFile, VirtualFile> map3 = Collections.emptyMap();
            if (map3 == null) {
                PyPackageUtil.$$$reportNull$$$0(45);
            }
            return map3;
        }
        LocalFileSystem vfs = LocalFileSystem.getInstance();
        HashMap<VirtualFile, VirtualFile> result2 = new HashMap<VirtualFile, VirtualFile>();
        for (Pair remoteSourceAndVfs : ContainerUtil.map((Collection)additionalData.getPathMappings().getPathMappings(), m -> Pair.create((Object)vfs.findFileByPath(m.getLocalRoot()), (Object)vfsMapper.getVfsFromTargetPath(m.getRemoteRoot())))) {
            VirtualFile remoteSourceDir = (VirtualFile)remoteSourceAndVfs.first;
            VirtualFile vfsDir = (VirtualFile)remoteSourceAndVfs.second;
            if (remoteSourceDir == null || vfsDir == null) continue;
            result2.put(remoteSourceDir, vfsDir);
        }
        HashMap<VirtualFile, VirtualFile> hashMap = result2;
        if (hashMap == null) {
            PyPackageUtil.$$$reportNull$$$0(46);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 12, 13, 15, 17, 24, 42, 44, 45, 46 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extra";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setupCall";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentNames";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 24: 
            case 42: 
            case 44: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyPackageUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirementsFromRequires";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirementsFromLinks";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirements";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 23: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isUpdating";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 30: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirementName";
                break;
            }
            case 31: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installRequires";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setupPy";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyPackageUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSetupPyRequiresFromArguments";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeSetupPyRequirements";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageNames";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "requirementsToString";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshAndGetPackagesModally";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagingAwareSdkRoots";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteSourceToVfsMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasSetupPy";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findSetupPy";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasRequirementsTxt";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findRequirementsTxt";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findSetupPyRequires";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findSetupPyExtrasRequire";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getExtraRequires";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSetupPyRequiresFromArguments";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 24: 
            case 42: 
            case 44: 
            case 45: 
            case 46: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "mergeSetupPyRequirements";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPackageNames";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "requirementsToString";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findSetupCall";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "collectPackageNames";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndGetPackagesModally";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "updatePackagesSynchronouslyWithGuard";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "hasManagement";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getRequirementsFromTxt";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addRequirementToTxtOrSetupPy";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addRequirementToInstallRequires";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "generateRequiresKwarg";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "runOnChangeUnderInterpreterPaths";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getPackagingAwareSdkRoots";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteSourceToVfsMapping";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 12, 13, 15, 17, 24, 42, 44, 45, 46 -> new IllegalStateException(string);
        };
    }

    private static class InterpreterChangeEvents {
        private static final Logger LOG = Logger.getInstance(InterpreterChangeEvents.class);

        private InterpreterChangeEvents() {
        }
    }
}

