/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public interface Cardinality
extends Comparable<Cardinality> {
    public static final Cardinality EMPTY = new Cardinality(){

        @Override
        public int compareTo(@NotNull Cardinality o) {
            if (o == null) {
                1.$$$reportNull$$$0(0);
            }
            return o == this ? 0 : -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/data/types/domain/Cardinality$1", "compareTo"));
        }
    };

    public static class FractionCardinality
    implements Cardinality {
        private final int myMax;

        public FractionCardinality(int max) {
            this.myMax = max;
        }

        @Override
        public int compareTo(@NotNull Cardinality o) {
            if (o == null) {
                FractionCardinality.$$$reportNull$$$0(0);
            }
            return o == EMPTY ? 1 : (!(o instanceof FractionCardinality) ? -1 : Integer.compare(this.myMax, ((FractionCardinality)o).myMax));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/data/types/domain/Cardinality$FractionCardinality", "compareTo"));
        }
    }

    public static class ScalableCardinality
    implements Cardinality {
        public static final int INFINITY = Integer.MAX_VALUE;
        private final int myPrecision;

        public ScalableCardinality(int precision) {
            this.myPrecision = precision;
        }

        @Override
        public int compareTo(@NotNull Cardinality o) {
            if (o == null) {
                ScalableCardinality.$$$reportNull$$$0(0);
            }
            return o instanceof TextCardinality ? -1 : (o instanceof ElementsCardinality ? 0 : (o instanceof MinMaxCardinality ? -o.compareTo(this) : (o instanceof ScalableCardinality ? this.compareWithScalable((ScalableCardinality)o) : 1)));
        }

        private int compareWithScalable(@NotNull ScalableCardinality cardinality) {
            if (cardinality == null) {
                ScalableCardinality.$$$reportNull$$$0(1);
            }
            return this.myPrecision - cardinality.myPrecision;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cardinality";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/data/types/domain/Cardinality$ScalableCardinality";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareWithScalable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MinMaxCardinality
    implements Cardinality {
        private final double myMin;
        private final double myMax;
        private final boolean myFloating;

        public MinMaxCardinality(double min, double max, boolean floating) {
            this.myMin = min;
            this.myMax = max;
            this.myFloating = floating;
        }

        @Override
        public int compareTo(@NotNull Cardinality o) {
            if (o == null) {
                MinMaxCardinality.$$$reportNull$$$0(0);
            }
            return o instanceof TextCardinality ? -1 : (o instanceof ElementsCardinality ? 0 : (o instanceof ScalableCardinality ? this.compareWithScalable() : (o instanceof MinMaxCardinality ? this.compareWithMinMax((MinMaxCardinality)o) : 1)));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MinMaxCardinality that = (MinMaxCardinality)o;
            return Double.compare(that.myMin, this.myMin) == 0 && Double.compare(that.myMax, this.myMax) == 0 && this.myFloating == that.myFloating;
        }

        public int hashCode() {
            return Objects.hash(this.myMin, this.myMax, this.myFloating);
        }

        private int compareWithScalable() {
            return this.myFloating ? 1 : -1;
        }

        private int compareWithMinMax(@NotNull MinMaxCardinality cardinality) {
            if (cardinality == null) {
                MinMaxCardinality.$$$reportNull$$$0(1);
            }
            return Double.compare(this.myMax - this.myMin, cardinality.myMax - cardinality.myMin);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cardinality";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/data/types/domain/Cardinality$MinMaxCardinality";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareWithMinMax";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ElementsCardinality
    implements Cardinality {
        private final long myMax;

        public ElementsCardinality(long max) {
            this.myMax = max;
        }

        @Override
        public int compareTo(@NotNull Cardinality o) {
            if (o == null) {
                ElementsCardinality.$$$reportNull$$$0(0);
            }
            return o instanceof MinMaxCardinality || o instanceof ScalableCardinality ? 0 : (o instanceof TextCardinality ? -1 : (o instanceof ElementsCardinality ? Long.compare(this.myMax, ((ElementsCardinality)o).myMax) : 1));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/data/types/domain/Cardinality$ElementsCardinality", "compareTo"));
        }
    }

    public static class TextCardinality
    implements Cardinality {
        private final long myMax;

        public TextCardinality(long max) {
            this.myMax = max;
        }

        @Override
        public int compareTo(@NotNull Cardinality o) {
            if (o == null) {
                TextCardinality.$$$reportNull$$$0(0);
            }
            return o instanceof TextCardinality ? Long.compare(this.myMax, ((TextCardinality)o).myMax) : 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/data/types/domain/Cardinality$TextCardinality", "compareTo"));
        }
    }
}

