/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.connection.statements;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.audit.AdvancedAuditService;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ExecutionResult;
import com.intellij.database.dataSource.connection.statements.IndexedOutParameter;
import com.intellij.database.dataSource.connection.statements.OutParameter;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactory;
import com.intellij.database.dataSource.connection.statements.SmartStatementMark;
import com.intellij.database.dataSource.connection.statements.SmartStatementsUtil;
import com.intellij.database.dataSource.connection.statements.StagedException;
import com.intellij.database.dataSource.connection.statements.StatementHolder;
import com.intellij.database.dataSource.connection.statements.UniversalResultsProducerKt;
import com.intellij.database.remote.jdbc.RemoteCallableStatement;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.util.DbImplUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\b:;<=>?@AB5\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0016\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0!H\u0016J!\u0010\"\u001a\u0002H#\"\u0004\b\u0001\u0010#2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H#0!H\u0016\u00a2\u0006\u0002\u0010$J!\u0010%\u001a\u0002H&\"\u0004\b\u0001\u0010&2\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H&0\u001bH\u0016\u00a2\u0006\u0002\u0010(J\u0012\u0010%\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020\u0016H\u0016J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020\u001fH\u0016J\b\u0010.\u001a\u00020/H\u0002J\b\u00100\u001a\u00020/H\u0002J\b\u00101\u001a\u00020\u001fH\u0002J\b\u00102\u001a\u00020\u001fH\u0002J\b\u00103\u001a\u00020\u001fH\u0002J\u0010\u00104\u001a\u00020\u001f2\u0006\u00105\u001a\u00020\u0011H\u0002J\b\u00106\u001a\u00020,H\u0002J\b\u00107\u001a\u00020,H\u0002J\b\u00108\u001a\u00020,H\u0002J\b\u00109\u001a\u00020,H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer;", "T", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "Lcom/intellij/database/dataSource/connection/statements/ClosableResultsProducer;", "statement", "Lcom/intellij/database/dataSource/connection/statements/StatementHolder$CloseableRef;", "mark", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "configuration", "Lcom/intellij/database/dataSource/connection/statements/Configuration;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "result", "Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;", "<init>", "(Lcom/intellij/database/dataSource/connection/statements/StatementHolder$CloseableRef;Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;Lcom/intellij/database/dataSource/connection/statements/Configuration;Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;)V", "currentResults", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Results;", "referencedResultsList", "", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$ReferencedResults;", "currentSubQueryIndex", "", "currentResultSetIndex", "updateCount", "parameters", "", "Lcom/intellij/database/dataSource/connection/statements/OutParameter;", "source", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Source;", "processRemaining", "", "processor", "Lcom/intellij/database/dataSource/connection/statements/ResultsProducer$Processor;", "processCurrent", "R", "(Lcom/intellij/database/dataSource/connection/statements/ResultsProducer$Processor;)Ljava/lang/Object;", "getParameterValue", "V", "parameter", "(Lcom/intellij/database/dataSource/connection/statements/OutParameter;)Ljava/lang/Object;", "", "index", "advance", "", "close", "advanceContentAndSource", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Verdict;", "advanceCurrentSourceContent", "closeAllResults", "closeAllReferencedResults", "closeCurrentResults", "closeResults", "results", "hasUpdateCount", "hasResults", "hasParameterResults", "requestedResultsReached", "Verdict", "Source", "ResultSource", "StatementSource", "ParametersSource", "Results", "RootResults", "ReferencedResults", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nUniversalResultsProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UniversalResultsProducer.kt\ncom/intellij/database/dataSource/connection/statements/UniversalResultsProducer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,302:1\n1#2:303\n1755#3,3:304\n*S KotlinDebug\n*F\n+ 1 UniversalResultsProducer.kt\ncom/intellij/database/dataSource/connection/statements/UniversalResultsProducer\n*L\n173#1:304,3\n*E\n"})
public final class UniversalResultsProducer<T extends RemoteStatement>
implements ClosableResultsProducer {
    @NotNull
    private final StatementHolder.CloseableRef<T> statement;
    @NotNull
    private final SmartStatementMark mark;
    @NotNull
    private final Configuration configuration;
    @NotNull
    private final DatabaseConnectionCore connection;
    @Nullable
    private Results currentResults;
    @NotNull
    private final List<ReferencedResults> referencedResultsList;
    private int currentSubQueryIndex;
    private int currentResultSetIndex;
    private int updateCount;
    @NotNull
    private List<? extends OutParameter<?>> parameters;
    @NotNull
    private Source source;

    public UniversalResultsProducer(@NotNull StatementHolder.CloseableRef<T> statement2, @NotNull SmartStatementMark mark2, @NotNull Configuration configuration, @NotNull DatabaseConnectionCore connection2, @NotNull ExecutionResult result2) {
        Intrinsics.checkNotNullParameter(statement2, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)mark2, (String)"mark");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this.statement = statement2;
        this.mark = mark2;
        this.configuration = configuration;
        this.connection = connection2;
        this.referencedResultsList = new ArrayList();
        this.updateCount = -1;
        this.parameters = result2.getOutParameters();
        this.source = new ResultSource(result2, (RemoteStatement)this.statement.getValue());
    }

    @Override
    public void processRemaining(@NotNull ResultsProducer.Processor<Unit> processor2) {
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        if (this.hasParameterResults()) {
            ++this.currentSubQueryIndex;
            ++this.currentResultSetIndex;
            processor2.parameterResults(this.parameters, this.currentSubQueryIndex, this.currentResultSetIndex, arg_0 -> UniversalResultsProducer.processRemaining$lambda$0(this, arg_0));
        }
        while (this.advance()) {
            this.processCurrent((ResultsProducer.Processor)new ResultsProducer.Processor<Unit>(processor2){
                final /* synthetic */ ResultsProducer.Processor<Unit> $processor;
                {
                    this.$processor = $processor;
                }

                public void results(RemoteResultSet resultSet, int subQueryIndex, int resultSetIndex, ResultsProducer.ReferenceInfo referenceInfo, Function2<? super RemoteResultSet, ? super ResultsProducer.ReferenceInfo, Unit> referenceConsumer) {
                    Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
                    Intrinsics.checkNotNullParameter(referenceConsumer, (String)"referenceConsumer");
                    this.$processor.results(resultSet, subQueryIndex, resultSetIndex, referenceInfo, referenceConsumer);
                }

                public void parameterResults(List<? extends OutParameter<?>> parameters, int subQueryIndex, int resultSetIndex, Function1<? super OutParameter<?>, ? extends Object> retriever) {
                    Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
                    Intrinsics.checkNotNullParameter(retriever, (String)"retriever");
                    this.$processor.parameterResults(parameters, subQueryIndex, resultSetIndex, retriever);
                }

                public void updateCount(int count) {
                    this.$processor.updateCount(count);
                }
            });
        }
    }

    public <R> R processCurrent(@NotNull ResultsProducer.Processor<R> processor2) {
        R r;
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        if (this.hasResults()) {
            Results results2 = this.currentResults;
            Intrinsics.checkNotNull((Object)results2);
            Results it = results2;
            boolean bl = false;
            ReferencedResults referencedResults = it instanceof ReferencedResults ? (ReferencedResults)it : null;
            ResultsProducer.ReferenceInfo currentReferenceInfo = referencedResults != null ? referencedResults.getReferenceInfo() : null;
            r = processor2.results(it.getResultSet(), this.currentSubQueryIndex, this.currentResultSetIndex, currentReferenceInfo, (Function2<RemoteResultSet, ResultsProducer.ReferenceInfo, Unit>)((Function2)(arg_0, arg_1) -> UniversalResultsProducer.processCurrent$lambda$2$lambda$1(this, it, arg_0, arg_1)));
        } else if (this.hasUpdateCount()) {
            r = processor2.updateCount(this.updateCount);
        } else {
            throw new IllegalStateException("Please, call advance before processCurrent() and make sure that results exits");
        }
        return r;
    }

    public <V> V getParameterValue(@NotNull OutParameter<V> parameter) {
        Intrinsics.checkNotNullParameter(parameter, (String)"parameter");
        T stmt = this.statement.getValue();
        if (stmt instanceof RemoteCallableStatement) {
            return parameter.retrieve((RemoteCallableStatement)stmt);
        }
        throw new AssertionError((Object)("The statement class is " + stmt.getClass().getSimpleName() + " when expected CallableStatement"));
    }

    @Override
    @Nullable
    public Object getParameterValue(int index) {
        Object v0;
        block2: {
            Iterable iterable = this.parameters;
            for (Object t : iterable) {
                OutParameter it = (OutParameter)t;
                boolean bl = false;
                if (!(it instanceof IndexedOutParameter && ((IndexedOutParameter)it).getIndex() == index)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        OutParameter outParameter = v0;
        if (outParameter == null) {
            return null;
        }
        OutParameter parameter = outParameter;
        return this.getParameterValue((OutParameter<V>)parameter);
    }

    @Override
    public boolean advance() throws StagedException {
        Verdict state = this.advanceContentAndSource();
        while (state == Verdict.CONTINUE) {
            state = this.advanceContentAndSource();
        }
        return state == Verdict.STOP_ON_RESULT;
    }

    @Override
    public void close() {
        this.connection.getAuditService().getWarningsListener().printStatementWarnings((RemoteStatement)this.statement.getValue(), this.mark);
        this.closeAllResults();
        this.connection.getAuditService().resultsProcessed(this.mark);
        DbImplUtilCore.closeSafe(this.statement);
    }

    private final Verdict advanceContentAndSource() {
        Verdict state = this.advanceCurrentSourceContent();
        this.source = this.source.advance(this.hasResults() || this.hasUpdateCount());
        return state;
    }

    private final Verdict advanceCurrentSourceContent() {
        int n;
        this.closeCurrentResults();
        this.updateCount = -1;
        if (!((Collection)this.referencedResultsList).isEmpty()) {
            this.currentResults = (Results)CollectionsKt.removeFirst(this.referencedResultsList);
        } else if (this.source.hasMoreResultSets()) {
            n = this.currentSubQueryIndex;
            this.currentSubQueryIndex = n + 1;
            RemoteResultSet remoteResultSet = (RemoteResultSet)SmartStatementsUtil.runReportingAndGet(this.connection, StagedException.Stage.GET_RESULT_SET, this.mark, () -> UniversalResultsProducer.advanceCurrentSourceContent$lambda$4(this));
            if (remoteResultSet != null) {
                RemoteResultSet it = remoteResultSet;
                boolean bl = false;
                this.currentResults = new RootResults(it);
            }
        }
        if (this.currentResults != null) {
            n = this.currentResultSetIndex;
            this.currentResultSetIndex = n + 1;
            AdvancedAuditService advancedAuditService = this.connection.getAuditService();
            Results results2 = this.currentResults;
            Intrinsics.checkNotNull((Object)results2);
            advancedAuditService.resultsOpened(results2.getResultSet(), this.mark);
            n = this.currentResultSetIndex;
            int n2 = SmartStatementFactory.Companion.getMaxResults();
            boolean bl = 1 <= n2 ? n2 < n : false;
            if (bl) {
                AdvancedAuditService advancedAuditService2 = this.connection.getAuditService();
                Object[] objectArray = new Object[]{SmartStatementFactory.Companion.getMaxResults()};
                String string = DatabaseBundle.message("notification.content.maximum.number.result.sets.per.query.reached", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                advancedAuditService2.message(string, this.mark);
                return Verdict.CONTINUE;
            }
            if (!this.requestedResultsReached()) {
                AdvancedAuditService advancedAuditService3 = this.connection.getAuditService();
                String string = DatabaseBundle.message("notification.content.skipping.result.set", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                advancedAuditService3.message(string, this.mark);
                return Verdict.CONTINUE;
            }
        } else {
            this.updateCount = ((Number)SmartStatementsUtil.runReportingAndGet(this.connection, StagedException.Stage.GET_UPDATE_COUNT, this.mark, () -> UniversalResultsProducer.advanceCurrentSourceContent$lambda$6(this))).intValue();
            if (this.hasUpdateCount()) {
                this.connection.getAuditService().updateCount(this.updateCount, this.mark);
            } else {
                return this.source.noResultsVerdict();
            }
        }
        return Verdict.STOP_ON_RESULT;
    }

    private final void closeAllResults() {
        this.closeAllReferencedResults();
        this.closeCurrentResults();
    }

    private final void closeAllReferencedResults() {
        for (ReferencedResults referencedResults : CollectionsKt.asReversedMutable(this.referencedResultsList)) {
            this.closeResults(referencedResults);
        }
        this.referencedResultsList.clear();
    }

    private final void closeCurrentResults() {
        Results results2 = this.currentResults;
        if (results2 != null) {
            Results it = results2;
            boolean bl = false;
            this.closeResults(it);
        }
        this.currentResults = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeResults(Results results2) {
        AutoCloseable autoCloseable = results2;
        Throwable throwable = null;
        try {
            Results it = (Results)autoCloseable;
            boolean bl = false;
            this.connection.getAuditService().beforeResultsClosing(it.getResultSet(), this.mark);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final boolean hasUpdateCount() {
        return this.updateCount != -1;
    }

    private final boolean hasResults() {
        return this.currentResults != null;
    }

    private final boolean hasParameterResults() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.parameters;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    OutParameter it = (OutParameter)element$iv;
                    boolean bl2 = false;
                    if (!(!UniversalResultsProducerKt.access$isResultSet(it))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean requestedResultsReached() {
        if (this.configuration.getResultsIndex() == null) return true;
        if (this.configuration.getResultsIndex() <= 0) return true;
        Integer n = this.configuration.getResultsIndex();
        int n2 = this.currentResultSetIndex;
        if (n == null) return false;
        if (n != n2) return false;
        return true;
    }

    private static final Object processRemaining$lambda$0(UniversalResultsProducer this$0, OutParameter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getParameterValue((OutParameter<V>)it);
    }

    private static final Unit processCurrent$lambda$2$lambda$1(UniversalResultsProducer this$0, Results $it, RemoteResultSet resultSet, ResultsProducer.ReferenceInfo referenceInfo) {
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        Intrinsics.checkNotNullParameter((Object)referenceInfo, (String)"referenceInfo");
        this$0.referencedResultsList.add(new ReferencedResults(resultSet, $it, referenceInfo));
        return Unit.INSTANCE;
    }

    private static final RemoteResultSet advanceCurrentSourceContent$lambda$4(UniversalResultsProducer this$0) {
        return this$0.source.getResultSet();
    }

    private static final int advanceCurrentSourceContent$lambda$6(UniversalResultsProducer this$0) {
        return this$0.source.getUpdateCount();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\r\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016J\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\fH\u0002J\b\u0010\u0016\u001a\u00020\nH\u0002J\u0012\u0010\u0017\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$ParametersSource;", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Source;", "statement", "Lcom/intellij/database/remote/jdbc/RemoteCallableStatement;", "params", "", "Lcom/intellij/database/dataSource/connection/statements/OutParameter;", "<init>", "(Lcom/intellij/database/remote/jdbc/RemoteCallableStatement;Ljava/util/List;)V", "currentIdx", "", "currentResults", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "getResultSet", "hasMoreResultSets", "", "getUpdateCount", "advance", "hasSomething", "noResultsVerdict", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Verdict;", "nextResultSet", "nextResultsIndex", "remaining", "intellij.database.core.impl"})
    @SourceDebugExtension(value={"SMAP\nUniversalResultsProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UniversalResultsProducer.kt\ncom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$ParametersSource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,302:1\n360#2,7:303\n*S KotlinDebug\n*F\n+ 1 UniversalResultsProducer.kt\ncom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$ParametersSource\n*L\n252#1:303,7\n*E\n"})
    private static final class ParametersSource
    implements Source {
        @NotNull
        private final RemoteCallableStatement statement;
        @NotNull
        private final List<OutParameter<?>> params;
        private int currentIdx;
        @Nullable
        private RemoteResultSet currentResults;

        public ParametersSource(@NotNull RemoteCallableStatement statement2, @NotNull List<? extends OutParameter<?>> params) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            Intrinsics.checkNotNullParameter(params, (String)"params");
            this.statement = statement2;
            this.params = params;
        }

        @Override
        @Nullable
        public RemoteResultSet getResultSet() {
            this.currentResults = this.nextResultSet();
            return this.currentResults;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasMoreResultSets() {
            boolean bl;
            RemoteResultSet results2 = this.currentResults;
            try {
                bl = this.nextResultsIndex() != -1;
            }
            finally {
                if (results2 != null) {
                    JdbcNativeUtil.performSafe(() -> ((RemoteResultSet)results2).close());
                }
            }
            return bl;
        }

        @Override
        public int getUpdateCount() {
            return -1;
        }

        @Override
        @NotNull
        public Source advance(boolean hasSomething) {
            return this;
        }

        @Override
        @NotNull
        public Verdict noResultsVerdict() {
            return Verdict.FINISH;
        }

        private final RemoteResultSet nextResultSet() {
            RemoteResultSet remoteResultSet;
            int index = this.nextResultsIndex();
            List<OutParameter<?>> remaining = this.remaining();
            int n = this.currentIdx = index == -1 ? this.params.size() : index + this.currentIdx + 1;
            if (index == -1) {
                remoteResultSet = null;
            } else {
                OutParameter<?> outParameter = remaining.get(index);
                CallableStatementData.SimpleOutParameter simpleOutParameter = outParameter instanceof CallableStatementData.SimpleOutParameter ? (CallableStatementData.SimpleOutParameter)outParameter : null;
                Object object = simpleOutParameter != null ? UniversalResultsProducerKt.access$retrieveResultSet(simpleOutParameter, (RemoteStatement)this.statement) : null;
                remoteResultSet = object instanceof RemoteResultSet ? (RemoteResultSet)object : null;
            }
            return remoteResultSet;
        }

        private final int nextResultsIndex() {
            int n;
            block2: {
                List<OutParameter<?>> $this$indexOfFirst$iv = this.remaining();
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<OutParameter<?>> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    OutParameter<?> item$iv;
                    OutParameter<?> it = item$iv = iterator.next();
                    boolean bl = false;
                    if (UniversalResultsProducerKt.access$isResultSet(it)) {
                        n = index$iv;
                        break block2;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            return n;
        }

        private final List<OutParameter<?>> remaining() {
            return this.currentIdx < this.params.size() ? this.params.subList(this.currentIdx, this.params.size()) : CollectionsKt.emptyList();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$ReferencedResults;", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Results;", "resultSet", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "referencingResults", "referenceInfo", "Lcom/intellij/database/dataSource/connection/statements/ResultsProducer$ReferenceInfo;", "<init>", "(Lcom/intellij/database/remote/jdbc/RemoteResultSet;Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Results;Lcom/intellij/database/dataSource/connection/statements/ResultsProducer$ReferenceInfo;)V", "getReferenceInfo", "()Lcom/intellij/database/dataSource/connection/statements/ResultsProducer$ReferenceInfo;", "close", "", "intellij.database.core.impl"})
    private static final class ReferencedResults
    extends Results {
        @NotNull
        private final Results referencingResults;
        @NotNull
        private final ResultsProducer.ReferenceInfo referenceInfo;

        public ReferencedResults(@NotNull RemoteResultSet resultSet, @NotNull Results referencingResults, @NotNull ResultsProducer.ReferenceInfo referenceInfo) {
            Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
            Intrinsics.checkNotNullParameter((Object)referencingResults, (String)"referencingResults");
            Intrinsics.checkNotNullParameter((Object)referenceInfo, (String)"referenceInfo");
            super(resultSet, 0, 2, null);
            this.referencingResults = referencingResults;
            this.referenceInfo = referenceInfo;
            Results results2 = this.referencingResults;
            results2.setDependencyCounter(results2.getDependencyCounter() + 1);
            results2.getDependencyCounter();
        }

        @NotNull
        public final ResultsProducer.ReferenceInfo getReferenceInfo() {
            return this.referenceInfo;
        }

        @Override
        public void close() {
            super.close();
            if (!this.getCanBeClosed()) {
                return;
            }
            JdbcNativeUtil.performSafe(() -> ((RemoteResultSet)this.getResultSet()).close());
            Results results2 = this.referencingResults;
            results2.setDependencyCounter(results2.getDependencyCounter() + -1);
            results2.getDependencyCounter();
            this.referencingResults.close();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$ResultSource;", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Source;", "executionResult", "Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;", "statement", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "<init>", "(Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;Lcom/intellij/database/remote/jdbc/RemoteStatement;)V", "hasMoreResultSets", "", "getResultSet", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "getUpdateCount", "", "advance", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$StatementSource;", "hasSomething", "noResultsVerdict", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Verdict;", "intellij.database.core.impl"})
    private static final class ResultSource
    implements Source {
        @NotNull
        private final ExecutionResult executionResult;
        @NotNull
        private final RemoteStatement statement;

        public ResultSource(@NotNull ExecutionResult executionResult, @NotNull RemoteStatement statement2) {
            Intrinsics.checkNotNullParameter((Object)executionResult, (String)"executionResult");
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            this.executionResult = executionResult;
            this.statement = statement2;
        }

        @Override
        public boolean hasMoreResultSets() {
            return this.executionResult.hasResultSet();
        }

        @Override
        @Nullable
        public RemoteResultSet getResultSet() {
            return this.executionResult.getResultSet();
        }

        @Override
        public int getUpdateCount() {
            return this.executionResult.getUpdateCount();
        }

        @Override
        @NotNull
        public StatementSource advance(boolean hasSomething) {
            return new StatementSource(this.statement, this.executionResult);
        }

        @Override
        @NotNull
        public Verdict noResultsVerdict() {
            return Verdict.CONTINUE;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00060\u0001j\u0002`\u0002B\u001b\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00108DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011\u0082\u0001\u0002\u0018\u0019\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Results;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "resultSet", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "dependencyCounter", "", "<init>", "(Lcom/intellij/database/remote/jdbc/RemoteResultSet;I)V", "getResultSet", "()Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "getDependencyCounter", "()I", "setDependencyCounter", "(I)V", "isClosed", "", "()Z", "setClosed", "(Z)V", "close", "", "canBeClosed", "getCanBeClosed", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$ReferencedResults;", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$RootResults;", "intellij.database.core.impl"})
    public static abstract class Results
    implements AutoCloseable {
        @NotNull
        private final RemoteResultSet resultSet;
        private int dependencyCounter;
        private boolean isClosed;

        private Results(RemoteResultSet resultSet, int dependencyCounter) {
            this.resultSet = resultSet;
            this.dependencyCounter = dependencyCounter;
        }

        public /* synthetic */ Results(RemoteResultSet remoteResultSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            this(remoteResultSet, n, null);
        }

        @NotNull
        public final RemoteResultSet getResultSet() {
            return this.resultSet;
        }

        public final int getDependencyCounter() {
            return this.dependencyCounter;
        }

        public final void setDependencyCounter(int n) {
            this.dependencyCounter = n;
        }

        protected final boolean isClosed() {
            return this.isClosed;
        }

        protected final void setClosed(boolean bl) {
            this.isClosed = bl;
        }

        @Override
        public void close() {
            if (!this.getCanBeClosed()) {
                return;
            }
            this.isClosed = true;
        }

        protected final boolean getCanBeClosed() {
            return !this.isClosed && this.dependencyCounter == 0;
        }

        public /* synthetic */ Results(RemoteResultSet resultSet, int dependencyCounter, DefaultConstructorMarker $constructor_marker) {
            this(resultSet, dependencyCounter);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$RootResults;", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Results;", "resultSet", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "<init>", "(Lcom/intellij/database/remote/jdbc/RemoteResultSet;)V", "intellij.database.core.impl"})
    private static final class RootResults
    extends Results {
        public RootResults(@NotNull RemoteResultSet resultSet) {
            Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
            super(resultSet, 0, 2, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H&J\b\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0007H&J\b\u0010\n\u001a\u00020\u000bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Source;", "", "getResultSet", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "getUpdateCount", "", "hasMoreResultSets", "", "advance", "hasSomething", "noResultsVerdict", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Verdict;", "intellij.database.core.impl"})
    private static interface Source {
        @Nullable
        public RemoteResultSet getResultSet();

        public int getUpdateCount();

        public boolean hasMoreResultSets();

        @NotNull
        public Source advance(boolean var1);

        @NotNull
        public Verdict noResultsVerdict();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\tH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$StatementSource;", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Source;", "statement", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "executionResult", "Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;", "<init>", "(Lcom/intellij/database/remote/jdbc/RemoteStatement;Lcom/intellij/database/dataSource/connection/statements/ExecutionResult;)V", "hasMoreResultSets", "", "getResultSet", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "getUpdateCount", "", "advance", "hasSomething", "noResultsVerdict", "Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Verdict;", "shouldCheckOutParameters", "intellij.database.core.impl"})
    private static final class StatementSource
    implements Source {
        @NotNull
        private final RemoteStatement statement;
        @NotNull
        private final ExecutionResult executionResult;

        public StatementSource(@NotNull RemoteStatement statement2, @NotNull ExecutionResult executionResult) {
            Intrinsics.checkNotNullParameter((Object)statement2, (String)"statement");
            Intrinsics.checkNotNullParameter((Object)executionResult, (String)"executionResult");
            this.statement = statement2;
            this.executionResult = executionResult;
        }

        @Override
        public boolean hasMoreResultSets() {
            return this.statement.getMoreResults();
        }

        @Override
        @Nullable
        public RemoteResultSet getResultSet() {
            return this.statement.getResultSet();
        }

        @Override
        public int getUpdateCount() {
            return this.statement.getUpdateCount();
        }

        @Override
        @NotNull
        public Source advance(boolean hasSomething) {
            Source source;
            if (hasSomething || !this.shouldCheckOutParameters()) {
                source = this;
            } else {
                RemoteStatement remoteStatement = this.statement;
                Intrinsics.checkNotNull((Object)remoteStatement, (String)"null cannot be cast to non-null type com.intellij.database.remote.jdbc.RemoteCallableStatement");
                source = new ParametersSource((RemoteCallableStatement)remoteStatement, this.executionResult.getOutParameters());
            }
            return source;
        }

        @Override
        @NotNull
        public Verdict noResultsVerdict() {
            return this.shouldCheckOutParameters() ? Verdict.CONTINUE : Verdict.FINISH;
        }

        private final boolean shouldCheckOutParameters() {
            return this.statement instanceof RemoteCallableStatement && !((Collection)this.executionResult.getOutParameters()).isEmpty();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dataSource/connection/statements/UniversalResultsProducer$Verdict;", "", "<init>", "(Ljava/lang/String;I)V", "CONTINUE", "STOP_ON_RESULT", "FINISH", "intellij.database.core.impl"})
    private static final class Verdict
    extends Enum<Verdict> {
        public static final /* enum */ Verdict CONTINUE = new Verdict();
        public static final /* enum */ Verdict STOP_ON_RESULT = new Verdict();
        public static final /* enum */ Verdict FINISH = new Verdict();
        private static final /* synthetic */ Verdict[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Verdict[] values() {
            return (Verdict[])$VALUES.clone();
        }

        public static Verdict valueOf(String value) {
            return Enum.valueOf(Verdict.class, value);
        }

        @NotNull
        public static EnumEntries<Verdict> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = verdictArray = new Verdict[]{Verdict.CONTINUE, Verdict.STOP_ON_RESULT, Verdict.FINISH};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

