/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.debugger;

import com.intellij.database.debugger.SqlVariable;
import com.intellij.database.debugger.SqlVariableKindKt;
import com.intellij.database.debugger.SqlVariableKt;
import com.intellij.database.debugger.SqlVariableValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\t\u0018\u0000 \u001f2\u00020\u0001:\u0006\u001f !\"#$B\u0019\u0012\u0010\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u0014\u001a\u00060\fR\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J'\u0010\u001a\u001a\u00020\u00172\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u00060\fR\u00020\u00000\u001c2\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001dJ\u001e\u0010\u001e\u001a\u00020\u00172\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u000fj\u0002`\u0011R\u001b\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00040\u0003j\u0002`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\f\u0012\b\u0012\u00060\fR\u00020\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\f\u0012\b\u0012\u00060\fR\u00020\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u000fj\u0002`\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/database/debugger/SqlVariablesViewModel;", "", "variables", "", "Lcom/intellij/database/debugger/SqlVariable;", "Lcom/intellij/database/debugger/SqlVariables;", "<init>", "(Ljava/util/List;)V", "getVariables", "()Ljava/util/List;", "topPresenters", "", "Lcom/intellij/database/debugger/SqlVariablesViewModel$ValuePresenter;", "allPresenters", "values", "", "Lcom/intellij/database/debugger/SqlVariableValue;", "Lcom/intellij/database/debugger/SqlVariableValues;", "lock", "Ljava/lang/Object;", "makePresenter", "variable", "applyTopPresenters", "", "compositeNode", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "applyPresenters", "presenters", "", "applyPresenters$intellij_database_impl", "update", "Companion", "ValuePresenter", "ScalarPresenter", "RecordPresenter", "AssignedXValuePresentation", "NotAssignedXValuePresentation", "intellij.database.impl"})
public final class SqlVariablesViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<SqlVariable> variables;
    @NotNull
    private final Collection<ValuePresenter> topPresenters;
    @NotNull
    private final Collection<ValuePresenter> allPresenters;
    @NotNull
    private Map<SqlVariable, SqlVariableValue> values;
    @NotNull
    private final Object lock;
    @NotNull
    private static final Logger log;

    public SqlVariablesViewModel(@NotNull List<SqlVariable> variables) {
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        this.variables = variables;
        this.topPresenters = new ArrayList(this.variables.size());
        this.allPresenters = new ArrayList(this.variables.size());
        this.values = SqlVariableKt.getNO_VALUES();
        this.lock = new Object();
        for (SqlVariable variable : this.variables) {
            ValuePresenter presenter = this.makePresenter(variable);
            this.topPresenters.add(presenter);
        }
    }

    @NotNull
    public final List<SqlVariable> getVariables() {
        return this.variables;
    }

    private final ValuePresenter makePresenter(SqlVariable variable) {
        List<SqlVariable> fields = variable.getFields();
        Collection collection = fields;
        ValuePresenter presenter = !(collection == null || collection.isEmpty()) ? (ValuePresenter)new RecordPresenter(variable) : (ValuePresenter)new ScalarPresenter(variable);
        this.allPresenters.add(presenter);
        return presenter;
    }

    public final void applyTopPresenters(@NotNull XCompositeNode compositeNode) {
        Intrinsics.checkNotNullParameter((Object)compositeNode, (String)"compositeNode");
        this.applyPresenters$intellij_database_impl(this.topPresenters, compositeNode);
    }

    public final void applyPresenters$intellij_database_impl(@NotNull Collection<? extends ValuePresenter> presenters, @NotNull XCompositeNode compositeNode) {
        Intrinsics.checkNotNullParameter(presenters, (String)"presenters");
        Intrinsics.checkNotNullParameter((Object)compositeNode, (String)"compositeNode");
        XValueChildrenList container = new XValueChildrenList(presenters.size());
        for (ValuePresenter valuePresenter : presenters) {
            container.add((XNamedValue)valuePresenter);
        }
        compositeNode.addChildren(container, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void update(@NotNull Map<SqlVariable, SqlVariableValue> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.values = values;
            for (ValuePresenter presenter : this.allPresenters) {
                presenter.updatePresentation$intellij_database_impl();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    static {
        Logger logger2 = Logger.getInstance(SqlVariablesViewModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        log = logger2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\n\u001a\u00020\u0003H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/debugger/SqlVariablesViewModel$AssignedXValuePresentation;", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation;", "theType", "", "theValue", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getTheType", "()Ljava/lang/String;", "getTheValue", "getType", "renderValue", "", "renderer", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation$XValueTextRenderer;", "intellij.database.impl"})
    private static final class AssignedXValuePresentation
    extends XValuePresentation {
        @NotNull
        private final String theType;
        @NotNull
        private final String theValue;

        public AssignedXValuePresentation(@NotNull String theType, @NotNull String theValue) {
            Intrinsics.checkNotNullParameter((Object)theType, (String)"theType");
            Intrinsics.checkNotNullParameter((Object)theValue, (String)"theValue");
            this.theType = theType;
            this.theValue = theValue;
        }

        @NotNull
        public final String getTheType() {
            return this.theType;
        }

        @NotNull
        public final String getTheValue() {
            return this.theValue;
        }

        @NotNull
        public String getType() {
            return this.theType;
        }

        public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer2) {
            Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
            renderer2.renderValue(this.theValue);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/database/debugger/SqlVariablesViewModel$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0003H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/database/debugger/SqlVariablesViewModel$NotAssignedXValuePresentation;", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation;", "theType", "", "<init>", "(Ljava/lang/String;)V", "getTheType", "()Ljava/lang/String;", "getType", "renderValue", "", "renderer", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation$XValueTextRenderer;", "intellij.database.impl"})
    private static final class NotAssignedXValuePresentation
    extends XValuePresentation {
        @NotNull
        private final String theType;

        public NotAssignedXValuePresentation(@NotNull String theType) {
            Intrinsics.checkNotNullParameter((Object)theType, (String)"theType");
            this.theType = theType;
        }

        @NotNull
        public final String getTheType() {
            return this.theType;
        }

        @NotNull
        public String getType() {
            return this.theType;
        }

        public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer2) {
            Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
            renderer2.renderComment("not assigned");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\r\u0010\r\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b\u000eR\u0018\u0010\u0007\u001a\f\u0012\b\u0012\u00060\u0001R\u00020\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/debugger/SqlVariablesViewModel$RecordPresenter;", "Lcom/intellij/database/debugger/SqlVariablesViewModel$ValuePresenter;", "Lcom/intellij/database/debugger/SqlVariablesViewModel;", "variable", "Lcom/intellij/database/debugger/SqlVariable;", "<init>", "(Lcom/intellij/database/debugger/SqlVariablesViewModel;Lcom/intellij/database/debugger/SqlVariable;)V", "innerPresenters", "", "computeChildren", "", "compositeNode", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "updatePresentation", "updatePresentation$intellij_database_impl", "intellij.database.impl"})
    public final class RecordPresenter
    extends ValuePresenter {
        @NotNull
        private final Collection<ValuePresenter> innerPresenters;

        public RecordPresenter(SqlVariable variable) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            super(variable);
            List<SqlVariable> list = variable.getFields();
            this.innerPresenters = new ArrayList(list != null ? list.size() : 0);
            List<SqlVariable> list2 = variable.getFields();
            if (list2 == null) {
                throw new IllegalStateException("No fields in variable " + variable);
            }
            List<SqlVariable> fields = list2;
            for (SqlVariable f : fields) {
                ValuePresenter presenter = SqlVariablesViewModel.this.makePresenter(f);
                this.innerPresenters.add(presenter);
            }
        }

        public void computeChildren(@NotNull XCompositeNode compositeNode) {
            Intrinsics.checkNotNullParameter((Object)compositeNode, (String)"compositeNode");
            SqlVariablesViewModel.this.applyPresenters$intellij_database_impl(this.innerPresenters, compositeNode);
        }

        @Override
        public void updatePresentation$intellij_database_impl() {
            StringBuilder b = new StringBuilder();
            boolean was = false;
            List<SqlVariable> list = this.getVariable().getFields();
            Intrinsics.checkNotNull(list);
            for (SqlVariable f : list) {
                if (((CharSequence)b).length() > 0) {
                    b.append(", ");
                }
                SqlVariableValue v = (SqlVariableValue)SqlVariablesViewModel.this.values.get(f);
                if (v == null || v.getValue() == SqlVariableKt.getNOT_ASSIGNED()) {
                    b.append("not assigned");
                    continue;
                }
                b.append(v.getValue());
                was = true;
            }
            String string = this.getVariable().getDasType().getSpecification();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSpecification(...)");
            String typeSpec = string;
            this.setApplicablePresentation(typeSpec, was ? b.toString() : null, !((Collection)this.getVariable().getFields()).isEmpty());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0007\u001a\u00020\bH\u0010\u00a2\u0006\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/intellij/database/debugger/SqlVariablesViewModel$ScalarPresenter;", "Lcom/intellij/database/debugger/SqlVariablesViewModel$ValuePresenter;", "Lcom/intellij/database/debugger/SqlVariablesViewModel;", "variable", "Lcom/intellij/database/debugger/SqlVariable;", "<init>", "(Lcom/intellij/database/debugger/SqlVariablesViewModel;Lcom/intellij/database/debugger/SqlVariable;)V", "updatePresentation", "", "updatePresentation$intellij_database_impl", "intellij.database.impl"})
    public final class ScalarPresenter
    extends ValuePresenter {
        public ScalarPresenter(SqlVariable variable) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            super(variable);
        }

        @Override
        public void updatePresentation$intellij_database_impl() {
            SqlVariableValue v = (SqlVariableValue)SqlVariablesViewModel.this.values.get(this.getVariable());
            String s = v == null || v.getValue() == SqlVariableKt.getNOT_ASSIGNED() ? null : v.getValue();
            String string = this.getVariable().getDasType().getSpecification();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSpecification(...)");
            this.setApplicablePresentation(string, s, false);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00a6\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\r\u0010\u000f\u001a\u00020\u000bH \u00a2\u0006\u0002\b\u0010J$\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/debugger/SqlVariablesViewModel$ValuePresenter;", "Lcom/intellij/xdebugger/frame/XNamedValue;", "variable", "Lcom/intellij/database/debugger/SqlVariable;", "<init>", "(Lcom/intellij/database/debugger/SqlVariablesViewModel;Lcom/intellij/database/debugger/SqlVariable;)V", "getVariable", "()Lcom/intellij/database/debugger/SqlVariable;", "presentationNode", "Lcom/intellij/xdebugger/frame/XValueNode;", "computePresentation", "", "node", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "updatePresentation", "updatePresentation$intellij_database_impl", "setApplicablePresentation", "typeSpec", "", "value", "hasChildren", "", "intellij.database.impl"})
    public abstract class ValuePresenter
    extends XNamedValue {
        @NotNull
        private final SqlVariable variable;
        @Nullable
        private XValueNode presentationNode;

        public ValuePresenter(SqlVariable variable) {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            super(variable.getName());
            this.variable = variable;
        }

        @NotNull
        public final SqlVariable getVariable() {
            return this.variable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            Object object = SqlVariablesViewModel.this.lock;
            synchronized (object) {
                boolean bl = false;
                this.presentationNode = node;
                try {
                    this.updatePresentation$intellij_database_impl();
                }
                catch (Exception e) {
                    Companion.getLog().error("Failed to update variable " + this.variable + " presentation: " + e.getMessage(), (Throwable)e);
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        public abstract void updatePresentation$intellij_database_impl();

        protected final void setApplicablePresentation(@NotNull String typeSpec, @Nullable String value, boolean hasChildren) {
            Intrinsics.checkNotNullParameter((Object)typeSpec, (String)"typeSpec");
            XValueNode xValueNode = this.presentationNode;
            if (xValueNode == null) {
                return;
            }
            XValueNode pn = xValueNode;
            Icon icon = SqlVariableKindKt.getIcon(this.variable.getKind());
            if (value != null) {
                pn.setPresentation(icon, (XValuePresentation)new AssignedXValuePresentation(typeSpec, value), hasChildren);
            } else {
                pn.setPresentation(icon, (XValuePresentation)new NotAssignedXValuePresentation(typeSpec), hasChildren);
            }
        }

        public static /* synthetic */ void setApplicablePresentation$default(ValuePresenter valuePresenter, String string, String string2, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setApplicablePresentation");
            }
            if ((n & 4) != 0) {
                bl = false;
            }
            valuePresenter.setApplicablePresentation(string, string2, bl);
        }
    }
}

