/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base;

import com.intellij.database.dialects.base.DocumentDvStructureExtensionKt;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.families.Family;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u001a \u0010\u0000\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0004H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u001a(\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002\u001a \u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002H\u0002\u001a\"\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0012\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a8\u0006\u0015"}, d2={"fetchTopNodes", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/model/basic/BasicElement;", "family", "Lcom/intellij/database/model/families/Family;", "isSimpleElement", "", "element", "isSimpleElementName", "name", "", "fetchChildren", "node", "Lcom/intellij/database/model/basic/BasicNode;", "countChildren", "", "isParent", "parent", "child", "getParent", "getPresentableName", "intellij.database.dialects.base"})
@SourceDebugExtension(value={"SMAP\nDocumentDvStructureExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentDvStructureExtension.kt\ncom/intellij/database/dialects/base/DocumentDvStructureExtensionKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1179#2,2:88\n1782#3,4:90\n*S KotlinDebug\n*F\n+ 1 DocumentDvStructureExtension.kt\ncom/intellij/database/dialects/base/DocumentDvStructureExtensionKt\n*L\n53#1:88,2\n70#1:90,4\n*E\n"})
public final class DocumentDvStructureExtensionKt {
    private static final JBIterable<? extends BasicElement> fetchTopNodes(Family<? extends BasicElement> family) {
        JBIterable jBIterable = family.jbi().filter(arg_0 -> DocumentDvStructureExtensionKt.fetchTopNodes$lambda$0(fetchTopNodes.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return jBIterable;
    }

    private static final boolean isSimpleElement(BasicElement element) {
        String string = element.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return DocumentDvStructureExtensionKt.isSimpleElementName(string);
    }

    private static final boolean isSimpleElementName(String name2) {
        boolean escape = false;
        CharSequence $this$forEach$iv = name2;
        boolean $i$f$forEach = false;
        for (int j = 0; j < $this$forEach$iv.length(); ++j) {
            char element$iv;
            char c2 = element$iv = $this$forEach$iv.charAt(j);
            boolean bl = false;
            switch (c2) {
                case '\\': {
                    escape = !escape;
                    break;
                }
                case '.': {
                    if (escape) {
                        escape = false;
                        break;
                    }
                    return false;
                }
            }
        }
        return true;
    }

    private static final JBIterable<? extends BasicElement> fetchChildren(Family<? extends BasicElement> family, BasicNode node) {
        BasicElement basicElement = node instanceof BasicElement ? (BasicElement)node : null;
        if (basicElement == null) {
            JBIterable jBIterable = JBIterable.empty();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
            return jBIterable;
        }
        BasicElement element = basicElement;
        JBIterable jBIterable = family.jbi().filter(arg_0 -> DocumentDvStructureExtensionKt.fetchChildren$lambda$2(new Function1(element){
            final /* synthetic */ BasicElement $element;
            {
                this.$element = $element;
            }

            public final Boolean invoke(BasicElement it) {
                Intrinsics.checkNotNull((Object)it);
                return DocumentDvStructureExtensionKt.access$isParent(this.$element, it);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return jBIterable;
    }

    private static final int countChildren(Family<? extends BasicElement> family, BasicNode node) {
        int n;
        BasicElement basicElement = node instanceof BasicElement ? (BasicElement)node : null;
        if (basicElement == null) {
            return 0;
        }
        BasicElement element = basicElement;
        JBIterable<? extends BasicElement> jBIterable = family.jbi();
        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"jbi(...)");
        Iterable $this$count$iv = (Iterable)jBIterable;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                BasicElement it = (BasicElement)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!DocumentDvStructureExtensionKt.isParent(element, it) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isParent(BasicElement parent, BasicElement child) {
        String string = child.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String childName = string;
        if (!StringsKt.startsWith$default((String)childName, (String)(parent + "."), (boolean)false, (int)2, null)) return false;
        String string2 = childName.substring(parent.getName().length() + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        if (!DocumentDvStructureExtensionKt.isSimpleElementName(string2)) return false;
        return true;
    }

    private static final BasicElement getParent(Family<? extends BasicElement> family, BasicNode node) {
        BasicElement basicElement = node instanceof BasicElement ? (BasicElement)node : null;
        if (basicElement == null) {
            return null;
        }
        BasicElement element = basicElement;
        if (DocumentDvStructureExtensionKt.isSimpleElement(element)) {
            return null;
        }
        return family.find(arg_0 -> DocumentDvStructureExtensionKt.getParent$lambda$4(new Function1(element){
            final /* synthetic */ BasicElement $element;
            {
                this.$element = $element;
            }

            public final Boolean invoke(BasicElement it) {
                Intrinsics.checkNotNull((Object)it);
                return DocumentDvStructureExtensionKt.access$isParent(it, this.$element);
            }
        }, arg_0));
    }

    private static final String getPresentableName(BasicElement element) {
        return element.getName();
    }

    private static final boolean fetchTopNodes$lambda$0(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean fetchChildren$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean getParent$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$isSimpleElement(BasicElement element) {
        return DocumentDvStructureExtensionKt.isSimpleElement(element);
    }

    public static final /* synthetic */ JBIterable access$fetchTopNodes(Family family) {
        return DocumentDvStructureExtensionKt.fetchTopNodes(family);
    }

    public static final /* synthetic */ JBIterable access$fetchChildren(Family family, BasicNode node) {
        return DocumentDvStructureExtensionKt.fetchChildren(family, node);
    }

    public static final /* synthetic */ int access$countChildren(Family family, BasicNode node) {
        return DocumentDvStructureExtensionKt.countChildren(family, node);
    }

    public static final /* synthetic */ BasicElement access$getParent(Family family, BasicNode node) {
        return DocumentDvStructureExtensionKt.getParent(family, node);
    }

    public static final /* synthetic */ String access$getPresentableName(BasicElement element) {
        return DocumentDvStructureExtensionKt.getPresentableName(element);
    }

    public static final /* synthetic */ boolean access$isParent(BasicElement parent, BasicElement child) {
        return DocumentDvStructureExtensionKt.isParent(parent, child);
    }
}

