/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.vertica;

import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DbConversionPoints;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.PgNumber2Domain;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.data.types.domain.TextLikeDomain;
import com.intellij.database.data.types.domain.UnknownDomain;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.util.Version;
import com.intellij.database.util.VersionRange;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public final class VertDomains
extends BaseDomainRegistry {
    private static final VersionRange VERT_9 = VersionRange.after(Version.of(9));
    private static final int MAX_FRACTION = 6;
    private static final double MAX_REAL = 1.0E37;
    private static final double MIN_REAL = -1.0E37;
    private static final double MIN_DOUBLE = -1.0E307;
    private static final double MAX_DOUBLE = 1.0E308;
    private static final int MAX_CHAR = 65000;
    private static final int MAX_LONG_VARBINARY = 32000000;
    private static final int MAX_PRECISION = 1024;

    public VertDomains() {
        this.add(new PgNumber2Domain("numeric", ConversionPoint.BIG_DECIMAL, 1024, 1024, true));
        this.add(new PgNumber2Domain("decimal", ConversionPoint.BIG_DECIMAL, 1024, 1024, true));
        this.add(new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9).withAliases("int4"));
        this.add(new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0).withAliases("int2"));
        this.add(new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18).withAliases("int8"));
        this.add(new FloatDomain("double precision", ConversionPoint.DOUBLE_PRECISION, -1.0E307, 1.0E308));
        this.add(new FloatDomain("float8", ConversionPoint.DOUBLE_PRECISION, -1.0E307, 1.0E308));
        this.add(new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, -1.0E37, 1.0E37));
        this.add(new FloatDomain("float4", ConversionPoint.SINGLE_PRECISION, -1.0E37, 1.0E37));
        this.add(new SimpleDomain("date", ConversionPoint.DATE));
        this.add(new TextDomain("bpchar", ConversionPoint.CHAR, 65000L, 1L, true, false){

            @Override
            public boolean isSuitable(@NotNull ColumnDescriptor descriptor2) {
                if (descriptor2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return !(descriptor2 instanceof DataConsumer.Column) && super.isSuitable(descriptor2);
            }

            @Override
            @NotNull
            public Compatibility getCompatibility(@NotNull Domain domain) {
                if (domain == null) {
                    1.$$$reportNull$$$0(1);
                }
                Compatibility compatibility = StringUtil.equalsIgnoreCase((CharSequence)this.simpleName(), (CharSequence)domain.simpleName()) ? super.getCompatibility(domain) : Compatibility.incompatible();
                if (compatibility == null) {
                    1.$$$reportNull$$$0(2);
                }
                return compatibility;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "domain";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/dialects/vertica/VertDomains$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/dialects/vertica/VertDomains$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCompatibility";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isSuitable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getCompatibility";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }.withOperationSupport(OperationSupport.SUPPORTS_FTS));
        this.add(new TextDomain("char", ConversionPoint.CHAR, 65000L, 1L, true, false){

            @Override
            public boolean isSuitable(@NotNull ColumnDescriptor descriptor2) {
                if (descriptor2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (descriptor2 instanceof DataConsumer.Column) {
                    return StringUtil.equalsIgnoreCase((CharSequence)"bpchar", (CharSequence)descriptor2.getTypeName()) || super.isSuitable(descriptor2);
                }
                return super.isSuitable(descriptor2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/dialects/vertica/VertDomains$2", "isSuitable"));
            }
        }.withAliases("character").withOperationSupport(OperationSupport.SUPPORTS_FTS));
        this.add(new TextDomain("varchar", ConversionPoint.VARCHAR, 65000L, -1L, true, true).withAliases("character varying").withOperationSupport(OperationSupport.SUPPORTS_FTS));
        this.add(new BooleanDomain("boolean", ConversionPoint.BOOLEAN).withAliases("bool"));
        this.add(new BinaryDomain("binary", ConversionPoint.BINARY, 65000L, -1L, true, false).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new BinaryDomain("varbinary", ConversionPoint.VARBINARY, 65000L, -1L, true, true).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new BinaryDomain("long varbinary", ConversionPoint.VARBINARY, 32000000L, -1L, true, true));
        this.add(new BinaryDomain("bytea", ConversionPoint.BLOB, Integer.MAX_VALUE).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new BinaryDomain("raw", ConversionPoint.BLOB, Integer.MAX_VALUE).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new TextDomain("long varchar", ConversionPoint.VARCHAR, 32000000L, -1L, true, true).withOperationSupport(OperationSupport.SUPPORTS_EQUALS));
        this.add(new MyZonedDomain(new FractionDomain("timetz", DbConversionPoints.TIME_WITH_TIMEZONE, 6, 6, true), "TIME"));
        this.add(new MyZonedDomain(new FractionDomain("timestamptz", DbConversionPoints.TIMESTAMP_WITH_TIMEZONE, 6, 6, true), "timestamp"));
        this.add(new FractionDomain("time", ConversionPoint.TIME, 6, 6, true));
        this.add(new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, 6, 6, true));
        this.add(new MyTextLikeDomain("interval day to second", ConversionPoint.INTERVAL).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new MyTextLikeDomain("interval year to month", ConversionPoint.INTERVAL).withOperationSupport(OperationSupport.SUPPORTS_NOTHING));
        this.add(new MyTextLikeDomain("geometry", ConversionPoint.GEOMETRY));
        this.add(new MyTextLikeDomain("geography", ConversionPoint.GEOGRAPHY));
        this.add(new FloatDomain("float", ConversionPoint.DOUBLE_PRECISION, -1.0E307, 1.0E308));
        this.add(new IntegerDomain("int", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new IntegerDomain("tinyint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new UnknownDomain("interval"));
        this.add(new MyTextLikeDomain("uuid", ConversionPoint.UUID_TEXT).withVersionRange(VERT_9));
    }

    protected static class MyZonedDomain
    extends FractionDomain {
        private final String myPrefix;

        public MyZonedDomain(@NotNull FractionDomain domain, @NotNull String prefix) {
            if (domain == null) {
                MyZonedDomain.$$$reportNull$$$0(0);
            }
            if (prefix == null) {
                MyZonedDomain.$$$reportNull$$$0(1);
            }
            super(domain.simpleName(), domain.getPoint(), domain.getMax(), domain.getDefaultValue(), domain.isNarrowable());
            this.myPrefix = prefix;
        }

        @Override
        @NotNull
        public Domain narrow(@NotNull Domain domain) {
            if (domain == null) {
                MyZonedDomain.$$$reportNull$$$0(2);
            }
            return new MyZonedDomain((FractionDomain)super.narrow(domain), this.myPrefix);
        }

        @Override
        @NotNull
        public Domain narrow(@NotNull SizeProvider provider) {
            if (provider == null) {
                MyZonedDomain.$$$reportNull$$$0(3);
            }
            return new MyZonedDomain((FractionDomain)super.narrow(provider), this.myPrefix);
        }

        @Override
        @NotNull
        public String name() {
            Object object = this.shouldParametrize() ? StringUtil.toUpperCase((String)this.myPrefix) + "(" + this.getMax() + ") WITH TIME ZONE" : super.name();
            if (object == null) {
                MyZonedDomain.$$$reportNull$$$0(4);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "domain";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/vertica/VertDomains$MyZonedDomain";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/vertica/VertDomains$MyZonedDomain";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "narrow";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    protected static class MyTextLikeDomain
    extends TextLikeDomain {
        public MyTextLikeDomain(@NotNull String name2, @NotNull ConversionPoint descriptor2) {
            if (name2 == null) {
                MyTextLikeDomain.$$$reportNull$$$0(0);
            }
            if (descriptor2 == null) {
                MyTextLikeDomain.$$$reportNull$$$0(1);
            }
            super(name2, descriptor2);
        }

        @Override
        @NotNull
        public Compatibility getCompatibility(@NotNull Domain domain) {
            if (domain == null) {
                MyTextLikeDomain.$$$reportNull$$$0(2);
            }
            Compatibility compatibility = domain instanceof MyTextLikeDomain ? (StringUtil.equals((CharSequence)this.simpleName(), (CharSequence)domain.simpleName()) ? Compatibility.full(this.cardinality(), domain.getLogicType(), this.getLogicType()) : Compatibility.incompatible()) : super.getCompatibility(domain);
            if (compatibility == null) {
                MyTextLikeDomain.$$$reportNull$$$0(3);
            }
            return compatibility;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "domain";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/vertica/VertDomains$MyTextLikeDomain";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/vertica/VertDomains$MyTextLikeDomain";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompatibility";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getCompatibility";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

