/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.DatabaseObjectFormatterConfig;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.remote.jdbc.helpers.MongoJdbcHelper;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.FactoryWithDomainSupport;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.FormatterImpl;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.database.run.ui.grid.editors.GridCellEditorsUtil;
import com.intellij.database.run.ui.grid.editors.UnparsedValueWithDomain;
import com.intellij.database.run.ui.grid.editors.ValueParserWrapper;
import com.intellij.openapi.util.text.StringUtil;
import java.text.ParsePosition;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MongoKeyEditorFactory
extends FormatBasedGridCellEditorFactory
implements FactoryWithDomainSupport {
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column2) {
        if (grid == null) {
            MongoKeyEditorFactory.$$$reportNull$$$0(0);
        }
        if (row == null) {
            MongoKeyEditorFactory.$$$reportNull$$$0(1);
        }
        if (column2 == null) {
            MongoKeyEditorFactory.$$$reportNull$$$0(2);
        }
        if (!DataGridUtil.getDbms(grid).is(Dbms.MONGO)) {
            return 0;
        }
        String typeName = GridCellEditorsUtil.guessTypeNameForEditing((CoreGrid<GridRow, GridColumn>)grid, row, column2);
        return MongoKeyEditorFactory.getSuitability(typeName);
    }

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull Domain domain) {
        if (grid == null) {
            MongoKeyEditorFactory.$$$reportNull$$$0(3);
        }
        if (domain == null) {
            MongoKeyEditorFactory.$$$reportNull$$$0(4);
        }
        return MongoKeyEditorFactory.getSuitability(domain.simpleName());
    }

    private static int getSuitability(@Nullable String typeName) {
        return StringUtil.equalsIgnoreCase((CharSequence)"MinKey", (CharSequence)typeName) || StringUtil.equalsIgnoreCase((CharSequence)"MaxKey", (CharSequence)typeName) ? 10 : 0;
    }

    @Override
    @NotNull
    public GridCellEditorFactory.ValueParser getValueParser(@NotNull DataGrid grid, @NotNull Domain domain) {
        if (grid == null) {
            MongoKeyEditorFactory.$$$reportNull$$$0(5);
        }
        if (domain == null) {
            MongoKeyEditorFactory.$$$reportNull$$$0(6);
        }
        return new ValueParserWrapper((Formatter)MongoKeyEditorFactory.createFormat(null, null), true, GridCellEditorHelper.get((CoreGrid)grid).getDefaultNullValue((CoreGrid)grid, null), (text2, e) -> UnparsedValueWithDomain.create(text2, domain, e));
    }

    @NotNull
    protected Formatter getFormatInner(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> rowIdx, @NotNull ModelIndex<GridColumn> columnIdx) {
        if (grid == null) {
            MongoKeyEditorFactory.$$$reportNull$$$0(7);
        }
        if (rowIdx == null) {
            MongoKeyEditorFactory.$$$reportNull$$$0(8);
        }
        if (columnIdx == null) {
            MongoKeyEditorFactory.$$$reportNull$$$0(9);
        }
        GridModel model = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        FormatterImpl formatterImpl = MongoKeyEditorFactory.createFormat(grid.getObjectFormatter(), (GridColumn)model.getColumn(columnIdx));
        if (formatterImpl == null) {
            MongoKeyEditorFactory.$$$reportNull$$$0(10);
        }
        return formatterImpl;
    }

    private static FormatterImpl createFormat(final @Nullable ObjectFormatter formatter, final @Nullable GridColumn column2) {
        return new FormatterImpl(){

            public MongoJdbcHelper.MongoValue parse(@NotNull String value, ParsePosition position) {
                String text2;
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (StringUtil.equalsIgnoreCase((CharSequence)"MinKey()", (CharSequence)(text2 = value.trim())) || StringUtil.equalsIgnoreCase((CharSequence)"new MinKey()", (CharSequence)text2)) {
                    position.setIndex(value.length());
                    return MongoJdbcHelper.MongoMinKeyValue.INSTANCE;
                }
                if (StringUtil.equalsIgnoreCase((CharSequence)"MaxKey()", (CharSequence)text2) || StringUtil.equalsIgnoreCase((CharSequence)"new MaxKey()", (CharSequence)text2)) {
                    position.setIndex(value.length());
                    return MongoJdbcHelper.MongoMaxKeyValue.INSTANCE;
                }
                position.setErrorIndex(0);
                return null;
            }

            public String format(Object value) {
                return formatter == null ? String.valueOf(value) : formatter.objectToString(value, column2, (ObjectFormatterConfig)new DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig());
            }

            @Nls
            @NotNull
            protected String getErrorMessage() {
                String string = DatabaseBundle.message("expected.minkey.maxkey.construction", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/ui/grid/editors/MongoKeyEditorFactory$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/ui/grid/editors/MongoKeyEditorFactory$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getErrorMessage";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "parse";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/MongoKeyEditorFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/MongoKeyEditorFactory";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormatInner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuitability";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getValueParser";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFormatInner";
                break;
            }
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }
}

