/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.settings;

import com.intellij.ui.table.JBTable;
import com.intellij.util.ArrayUtil;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a(\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00030\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"MIN_TABLE_HEIGHT", "", "initTable", "", "table", "Lcom/intellij/ui/table/JBTable;", "editLastRow", "doRemoveRows", "removeRow", "Lkotlin/Function2;", "Ljavax/swing/table/TableModel;", "intellij.database.impl"})
public final class TableUtilsKt {
    public static final int MIN_TABLE_HEIGHT = 150;

    public static final void initTable(@NotNull JBTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        table.setShowGrid(false);
        table.registerKeyboardAction(arg_0 -> TableUtilsKt.initTable$lambda$0(table, arg_0), KeyStroke.getKeyStroke(10, 0), 0);
    }

    public static final void editLastRow(@NotNull JBTable table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        int count = table.getRowCount() - 1;
        table.revalidate();
        table.repaint();
        table.getSelectionModel().setSelectionInterval(count, count);
        table.scrollRectToVisible(table.getCellRect(count, 0, true));
        table.editCellAt(count, 0);
    }

    public static final void doRemoveRows(@NotNull JBTable table, @NotNull Function2<? super TableModel, ? super Integer, Unit> removeRow) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter(removeRow, (String)"removeRow");
        if (table.isEditing()) {
            return;
        }
        int[] rows = table.getSelectedRows();
        Intrinsics.checkNotNull((Object)rows);
        ArraysKt.sortDescending((int[])rows);
        if (rows.length == 0) {
            return;
        }
        int n = rows.length;
        for (int j = 0; j < n; ++j) {
            int row = rows[j];
            TableModel tableModel = table.getModel();
            Intrinsics.checkNotNullExpressionValue((Object)tableModel, (String)"getModel(...)");
            removeRow.invoke((Object)tableModel, (Object)row);
        }
        table.revalidate();
        table.repaint();
        int min = ArrayUtil.min((int[])rows);
        if (min < 1) {
            ++min;
        }
        table.getSelectionModel().setSelectionInterval(min - 1, min - 1);
    }

    private static final void initTable$lambda$0(JBTable $table, ActionEvent it) {
        int row = $table.getSelectedRow();
        int column2 = $table.getSelectedColumn();
        if (row >= 0 && column2 >= 0) {
            $table.editCellAt(row, column2);
        }
    }
}

