/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.util.Arrays;
import org.locationtech.jts.algorithm.Area;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceComparator;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.PrecisionModel;

public class Polygon
extends Geometry
implements Polygonal {
    private static final long serialVersionUID = -3494792200821764533L;
    protected LinearRing shell = null;
    protected LinearRing[] holes;

    public Polygon(LinearRing shell, PrecisionModel precisionModel, int SRID) {
        this(shell, new LinearRing[0], new GeometryFactory(precisionModel, SRID));
    }

    public Polygon(LinearRing shell, LinearRing[] holes, PrecisionModel precisionModel, int SRID) {
        this(shell, holes, new GeometryFactory(precisionModel, SRID));
    }

    public Polygon(LinearRing shell, LinearRing[] holes, GeometryFactory factory) {
        super(factory);
        if (shell == null) {
            shell = this.getFactory().createLinearRing();
        }
        if (holes == null) {
            holes = new LinearRing[]{};
        }
        if (Polygon.hasNullElements(holes)) {
            throw new IllegalArgumentException("holes must not contain null elements");
        }
        if (shell.isEmpty() && Polygon.hasNonEmptyElements(holes)) {
            throw new IllegalArgumentException("shell is empty but holes are not");
        }
        this.shell = shell;
        this.holes = holes;
    }

    @Override
    public Coordinate getCoordinate() {
        return this.shell.getCoordinate();
    }

    @Override
    public Coordinate[] getCoordinates() {
        if (this.isEmpty()) {
            return new Coordinate[0];
        }
        Coordinate[] coordinates = new Coordinate[this.getNumPoints()];
        int k = -1;
        Coordinate[] shellCoordinates = this.shell.getCoordinates();
        for (int x = 0; x < shellCoordinates.length; ++x) {
            coordinates[++k] = shellCoordinates[x];
        }
        for (int i2 = 0; i2 < this.holes.length; ++i2) {
            Coordinate[] childCoordinates = this.holes[i2].getCoordinates();
            for (int j = 0; j < childCoordinates.length; ++j) {
                coordinates[++k] = childCoordinates[j];
            }
        }
        return coordinates;
    }

    @Override
    public int getNumPoints() {
        int numPoints = this.shell.getNumPoints();
        for (int i2 = 0; i2 < this.holes.length; ++i2) {
            numPoints += this.holes[i2].getNumPoints();
        }
        return numPoints;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public int getBoundaryDimension() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return this.shell.isEmpty();
    }

    @Override
    public boolean isRectangle() {
        if (this.getNumInteriorRing() != 0) {
            return false;
        }
        if (this.shell == null) {
            return false;
        }
        if (this.shell.getNumPoints() != 5) {
            return false;
        }
        CoordinateSequence seq = this.shell.getCoordinateSequence();
        Envelope env = this.getEnvelopeInternal();
        for (int i2 = 0; i2 < 5; ++i2) {
            double x = seq.getX(i2);
            if (x != env.getMinX() && x != env.getMaxX()) {
                return false;
            }
            double y = seq.getY(i2);
            if (y == env.getMinY() || y == env.getMaxY()) continue;
            return false;
        }
        double prevX = seq.getX(0);
        double prevY = seq.getY(0);
        for (int i3 = 1; i3 <= 4; ++i3) {
            boolean yChanged;
            double x = seq.getX(i3);
            double y = seq.getY(i3);
            boolean xChanged = x != prevX;
            boolean bl = yChanged = y != prevY;
            if (xChanged == yChanged) {
                return false;
            }
            prevX = x;
            prevY = y;
        }
        return true;
    }

    public LinearRing getExteriorRing() {
        return this.shell;
    }

    public int getNumInteriorRing() {
        return this.holes.length;
    }

    public LinearRing getInteriorRingN(int n) {
        return this.holes[n];
    }

    @Override
    public String getGeometryType() {
        return "Polygon";
    }

    @Override
    public double getArea() {
        double area = 0.0;
        area += Area.ofRing(this.shell.getCoordinateSequence());
        for (int i2 = 0; i2 < this.holes.length; ++i2) {
            area -= Area.ofRing(this.holes[i2].getCoordinateSequence());
        }
        return area;
    }

    @Override
    public double getLength() {
        double len = 0.0;
        len += this.shell.getLength();
        for (int i2 = 0; i2 < this.holes.length; ++i2) {
            len += this.holes[i2].getLength();
        }
        return len;
    }

    @Override
    public Geometry getBoundary() {
        if (this.isEmpty()) {
            return this.getFactory().createMultiLineString();
        }
        LineString[] rings = new LinearRing[this.holes.length + 1];
        rings[0] = this.shell;
        for (int i2 = 0; i2 < this.holes.length; ++i2) {
            rings[i2 + 1] = this.holes[i2];
        }
        if (rings.length <= 1) {
            return this.getFactory().createLinearRing(rings[0].getCoordinateSequence());
        }
        return this.getFactory().createMultiLineString(rings);
    }

    @Override
    protected Envelope computeEnvelopeInternal() {
        return this.shell.getEnvelopeInternal();
    }

    @Override
    public boolean equalsExact(Geometry other, double tolerance) {
        if (!this.isEquivalentClass(other)) {
            return false;
        }
        Polygon otherPolygon = (Polygon)other;
        LinearRing thisShell = this.shell;
        LinearRing otherPolygonShell = otherPolygon.shell;
        if (!((Geometry)thisShell).equalsExact(otherPolygonShell, tolerance)) {
            return false;
        }
        if (this.holes.length != otherPolygon.holes.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.holes.length; ++i2) {
            if (((Geometry)this.holes[i2]).equalsExact(otherPolygon.holes[i2], tolerance)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void apply(CoordinateFilter filter) {
        this.shell.apply(filter);
        for (int i2 = 0; i2 < this.holes.length; ++i2) {
            this.holes[i2].apply(filter);
        }
    }

    @Override
    public void apply(CoordinateSequenceFilter filter) {
        this.shell.apply(filter);
        if (!filter.isDone()) {
            for (int i2 = 0; i2 < this.holes.length; ++i2) {
                this.holes[i2].apply(filter);
                if (filter.isDone()) break;
            }
        }
        if (filter.isGeometryChanged()) {
            this.geometryChanged();
        }
    }

    @Override
    public void apply(GeometryFilter filter) {
        filter.filter(this);
    }

    @Override
    public void apply(GeometryComponentFilter filter) {
        filter.filter(this);
        this.shell.apply(filter);
        for (int i2 = 0; i2 < this.holes.length; ++i2) {
            this.holes[i2].apply(filter);
        }
    }

    @Override
    public Object clone() {
        return this.copy();
    }

    @Override
    protected Polygon copyInternal() {
        LinearRing shellCopy = (LinearRing)this.shell.copy();
        LinearRing[] holeCopies = new LinearRing[this.holes.length];
        for (int i2 = 0; i2 < this.holes.length; ++i2) {
            holeCopies[i2] = (LinearRing)this.holes[i2].copy();
        }
        return new Polygon(shellCopy, holeCopies, this.factory);
    }

    @Override
    public Geometry convexHull() {
        return this.getExteriorRing().convexHull();
    }

    @Override
    public void normalize() {
        this.shell = this.normalized(this.shell, true);
        for (int i2 = 0; i2 < this.holes.length; ++i2) {
            this.holes[i2] = this.normalized(this.holes[i2], false);
        }
        Arrays.sort(this.holes);
    }

    @Override
    protected int compareToSameClass(Object o) {
        int i2;
        Polygon poly = (Polygon)o;
        LinearRing thisShell = this.shell;
        LinearRing otherShell = poly.shell;
        int shellComp = thisShell.compareToSameClass(otherShell);
        if (shellComp != 0) {
            return shellComp;
        }
        int nHole1 = this.getNumInteriorRing();
        int nHole2 = ((Polygon)o).getNumInteriorRing();
        for (i2 = 0; i2 < nHole1 && i2 < nHole2; ++i2) {
            LinearRing otherHole;
            LinearRing thisHole = this.getInteriorRingN(i2);
            int holeComp = thisHole.compareToSameClass(otherHole = poly.getInteriorRingN(i2));
            if (holeComp == 0) continue;
            return holeComp;
        }
        if (i2 < nHole1) {
            return 1;
        }
        if (i2 < nHole2) {
            return -1;
        }
        return 0;
    }

    @Override
    protected int compareToSameClass(Object o, CoordinateSequenceComparator comp) {
        int i2;
        Polygon poly = (Polygon)o;
        LinearRing thisShell = this.shell;
        LinearRing otherShell = poly.shell;
        int shellComp = thisShell.compareToSameClass(otherShell, comp);
        if (shellComp != 0) {
            return shellComp;
        }
        int nHole1 = this.getNumInteriorRing();
        int nHole2 = poly.getNumInteriorRing();
        for (i2 = 0; i2 < nHole1 && i2 < nHole2; ++i2) {
            LinearRing otherHole;
            LinearRing thisHole = this.getInteriorRingN(i2);
            int holeComp = thisHole.compareToSameClass(otherHole = poly.getInteriorRingN(i2), comp);
            if (holeComp == 0) continue;
            return holeComp;
        }
        if (i2 < nHole1) {
            return 1;
        }
        if (i2 < nHole2) {
            return -1;
        }
        return 0;
    }

    @Override
    protected int getTypeCode() {
        return 5;
    }

    private LinearRing normalized(LinearRing ring, boolean clockwise) {
        LinearRing res2 = (LinearRing)ring.copy();
        this.normalize(res2, clockwise);
        return res2;
    }

    private void normalize(LinearRing ring, boolean clockwise) {
        if (ring.isEmpty()) {
            return;
        }
        CoordinateSequence seq = ring.getCoordinateSequence();
        int minCoordinateIndex = CoordinateSequences.minCoordinateIndex(seq, 0, seq.size() - 2);
        CoordinateSequences.scroll(seq, minCoordinateIndex, true);
        if (Orientation.isCCW(seq) == clockwise) {
            CoordinateSequences.reverse(seq);
        }
    }

    @Override
    public Polygon reverse() {
        return (Polygon)super.reverse();
    }

    @Override
    protected Polygon reverseInternal() {
        LinearRing shell = this.getExteriorRing().reverse();
        LinearRing[] holes = new LinearRing[this.getNumInteriorRing()];
        for (int i2 = 0; i2 < holes.length; ++i2) {
            holes[i2] = this.getInteriorRingN(i2).reverse();
        }
        return this.getFactory().createPolygon(shell, holes);
    }
}

