/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jinja.template.parsing.parser;

import com.intellij.jinja.Jinja2Bundle;
import com.intellij.jinja.template.parsing.DjangoTemplateTokenTypes;
import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class Parsing {
    protected PsiBuilder myPsiBuilder;

    protected Parsing(PsiBuilder psiBuilder) {
        this.myPsiBuilder = psiBuilder;
    }

    public void createTokenElement(IElementType type) {
        PsiBuilder.Marker marker = this.mark();
        this.advance();
        marker.done(type);
    }

    protected void consumeErrorToken(@NotNull @NlsContexts.ParsingError String msg) {
        if (msg == null) {
            Parsing.$$$reportNull$$$0(0);
        }
        this.error(msg);
        this.advance();
    }

    protected void errorToken(@NotNull @NlsContexts.ParsingError String msg) {
        if (msg == null) {
            Parsing.$$$reportNull$$$0(1);
        }
        PsiBuilder.Marker err = this.mark();
        this.advance();
        err.error(msg);
    }

    public boolean hasTokenType(TokenSet tokenSet) {
        return tokenSet.contains(this.myPsiBuilder.getTokenType());
    }

    public boolean hasTokenTypeSequence(IElementType ... types) {
        for (int i = 0; i < types.length; ++i) {
            if (this.myPsiBuilder.lookAhead(i) == types[i]) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public boolean hasTokenType(IElementType type, IElementType ... types) {
        IElementType tokenType = this.myPsiBuilder.getTokenType();
        if (tokenType == type) {
            return true;
        }
        for (IElementType t : types) {
            if (tokenType != t) continue;
            return true;
        }
        return false;
    }

    public boolean hasTokenText(String text) {
        return text.equals(this.myPsiBuilder.getTokenText());
    }

    public PsiBuilder.Marker mark() {
        return this.myPsiBuilder.mark();
    }

    protected boolean eof() {
        return this.myPsiBuilder.eof();
    }

    public void advance() {
        if (this.myPsiBuilder.getTokenType() == DjangoTemplateTokenTypes.DJANGO_UNCLOSED_VERBATIM) {
            this.myPsiBuilder.advanceLexer();
            this.error(Jinja2Bundle.message("django.parsing.error.verbatim.block.without.endverbatim", new Object[0]));
        }
        if (this.myPsiBuilder.getTokenType() == DjangoTemplateTokenTypes.DJANGO_UNCLOSED_BLOCK_COMMENT) {
            this.myPsiBuilder.advanceLexer();
            this.error(Jinja2Bundle.message("django.parsing.error.block.comment.without.endcomment", new Object[0]));
        }
        this.myPsiBuilder.advanceLexer();
    }

    public void error(@NotNull @NlsContexts.ParsingError String message) {
        if (message == null) {
            Parsing.$$$reportNull$$$0(2);
        }
        this.myPsiBuilder.error(message);
    }

    public void errorAdvance(@NotNull @NlsContexts.ParsingError String message) {
        if (message == null) {
            Parsing.$$$reportNull$$$0(3);
        }
        PsiBuilder.Marker keyword = this.myPsiBuilder.mark();
        this.advance();
        keyword.error(message);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jinja/template/parsing/parser/Parsing";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "consumeErrorToken";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "errorToken";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "errorAdvance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

