/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.huggingFace.cacheManager;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.python.packaging.PyPackageInstallUtils;
import com.jetbrains.python.packaging.common.PythonPackageManagementListener;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\tH\u0002J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\b\u0010\r\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/python/huggingFace/cacheManager/HfCachePackageManagementListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "showToolWindow", "", "hideToolWindow", "getToolwindow", "Lcom/intellij/openapi/wm/ToolWindow;", "dispose", "Companion", "intellij.python.huggingFace"})
public final class HfCachePackageManagementListener
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private MessageBusConnection connection;
    @NotNull
    public static final String TOOL_WINDOW_ID = "HfCacheToolWindow";
    @NotNull
    public static final String HF_HUB_PACKAGE = "huggingface-hub";

    public HfCachePackageManagementListener(@NotNull Project project) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
            MessageBusConnection messageBusConnection = this.connection = ApplicationManager.getApplication().getMessageBus().connect();
            if (messageBusConnection == null) break block0;
            messageBusConnection.subscribe(PythonPackageManager.Companion.getPACKAGE_MANAGEMENT_TOPIC(), (Object)new PythonPackageManagementListener(){

                public void packagesChanged(Sdk sdk) {
                    Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
                    if (!Registry.Companion.is("hugging.face.cache.management", false)) {
                        return;
                    }
                    Version hfVersion = PyPackageInstallUtils.INSTANCE.getPackageVersion(project, sdk, HfCachePackageManagementListener.HF_HUB_PACKAGE);
                    if (hfVersion == null) {
                        this.hideToolWindow();
                    } else {
                        this.showToolWindow();
                    }
                }
            });
        }
    }

    private final void showToolWindow() {
        ApplicationManager.getApplication().invokeLater(() -> HfCachePackageManagementListener.showToolWindow$lambda$0(this));
    }

    private final void hideToolWindow() {
        ApplicationManager.getApplication().invokeLater(() -> HfCachePackageManagementListener.hideToolWindow$lambda$1(this));
    }

    private final ToolWindow getToolwindow() {
        return ToolWindowManager.Companion.getInstance(this.project).getToolWindow(TOOL_WINDOW_ID);
    }

    public void dispose() {
        block0: {
            MessageBusConnection messageBusConnection = this.connection;
            if (messageBusConnection == null) break block0;
            messageBusConnection.disconnect();
        }
    }

    private static final void showToolWindow$lambda$0(HfCachePackageManagementListener this$0) {
        block0: {
            ToolWindow toolWindow = this$0.getToolwindow();
            if (toolWindow == null) break block0;
            toolWindow.setAvailable(true);
        }
    }

    private static final void hideToolWindow$lambda$1(HfCachePackageManagementListener this$0) {
        block0: {
            ToolWindow toolWindow = this$0.getToolwindow();
            if (toolWindow == null) break block0;
            toolWindow.setAvailable(false);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/python/huggingFace/cacheManager/HfCachePackageManagementListener$Companion;", "", "<init>", "()V", "TOOL_WINDOW_ID", "", "HF_HUB_PACKAGE", "intellij.python.huggingFace"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

