/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.api;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.scientific.py.tables.api.PyDevdID;
import com.intellij.scientific.py.tables.commands.DSTableCommands;
import com.intellij.scientific.tables.api.DescribeTableCommand;
import com.intellij.scientific.tables.api.ImageLoadCommand;
import com.intellij.scientific.tables.api.ImageStartLoadCommand;
import com.intellij.scientific.tables.api.InfoTableCommand;
import com.intellij.scientific.tables.api.SliceTableCommand;
import com.intellij.scientific.tables.api.TableCommand;
import com.intellij.scientific.tables.api.TableCommandCodeProvider;
import com.intellij.scientific.tables.api.VisualizationDataTableCommand;
import com.jetbrains.python.PythonHelpersLocator;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u000eH\u0002J\r\u0010\u000f\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0010H\u0002J%\u0010\u0011\u001a\u00020\u00072\u001b\u0010\u0012\u001a\u0017\u0012\b\u0012\u00060\u0014j\u0002`\u0015\u0012\u0004\u0012\u00020\u00160\u0013\u00a2\u0006\u0002\b\u0017H\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/scientific/py/tables/api/PythonTableCommandCodeProvider;", "Lcom/intellij/scientific/tables/api/TableCommandCodeProvider;", "pydevdId", "Lcom/intellij/scientific/py/tables/api/PyDevdID;", "<init>", "(Lcom/intellij/scientific/py/tables/api/PyDevdID;)V", "definitions", "", "getCommandCode", "tableCommand", "Lcom/intellij/scientific/tables/api/TableCommand;", "getSliceCommandCode", "Lcom/intellij/scientific/tables/api/SliceTableCommand;", "getInfoCommandCode", "Lcom/intellij/scientific/tables/api/InfoTableCommand;", "getDefinitions", "Lorg/jetbrains/annotations/NotNull;", "withPreamble", "body", "Lkotlin/Function1;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "", "Lkotlin/ExtensionFunctionType;", "intellij.scientific.py.tables"})
public class PythonTableCommandCodeProvider
implements TableCommandCodeProvider {
    @NotNull
    private final PyDevdID pydevdId;
    @NotNull
    private final String definitions;

    public PythonTableCommandCodeProvider(@NotNull PyDevdID pydevdId) {
        Intrinsics.checkNotNullParameter((Object)((Object)pydevdId), (String)"pydevdId");
        this.pydevdId = pydevdId;
        this.definitions = this.getDefinitions();
    }

    @NotNull
    public String getCommandCode(@NotNull TableCommand tableCommand) {
        String string;
        Intrinsics.checkNotNullParameter((Object)tableCommand, (String)"tableCommand");
        TableCommand tableCommand2 = tableCommand;
        if (tableCommand2 instanceof DescribeTableCommand || tableCommand2 instanceof VisualizationDataTableCommand || tableCommand2 instanceof ImageLoadCommand || tableCommand2 instanceof ImageStartLoadCommand) {
            throw new NotImplementedError(null, 1, null);
        }
        if (tableCommand2 instanceof InfoTableCommand) {
            string = this.getInfoCommandCode((InfoTableCommand)tableCommand);
        } else if (tableCommand2 instanceof SliceTableCommand) {
            string = this.getSliceCommandCode((SliceTableCommand)tableCommand);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final String getSliceCommandCode(SliceTableCommand tableCommand) {
        SliceTableCommand $this$getSliceCommandCode_u24lambda_u241 = tableCommand;
        boolean bl = false;
        String command = tableCommand.getUseCsvSerialization() ? "display_data_csv(initCommandResult, " + $this$getSliceCommandCode_u24lambda_u241.getStartRow() + ", " + $this$getSliceCommandCode_u24lambda_u241.getEndRow() + ")" : "display_data_html(initCommandResult, " + $this$getSliceCommandCode_u24lambda_u241.getStartRow() + ", " + $this$getSliceCommandCode_u24lambda_u241.getEndRow() + ")";
        return DSTableCommands.INSTANCE.commandTemplate($this$getSliceCommandCode_u24lambda_u241.getTableVariable(), this.withPreamble((Function1<? super StringBuilder, Unit>)((Function1)arg_0 -> PythonTableCommandCodeProvider.getSliceCommandCode$lambda$1$lambda$0(command, arg_0))));
    }

    private final String getInfoCommandCode(InfoTableCommand tableCommand) {
        return DSTableCommands.INSTANCE.commandTemplate(tableCommand.getTableVariable(), this.withPreamble((Function1<? super StringBuilder, Unit>)((Function1)PythonTableCommandCodeProvider::getInfoCommandCode$lambda$2)));
    }

    private final String getDefinitions() {
        String string = FileUtil.loadFile((File)new File(PythonHelpersLocator.Companion.findPathStringInHelpers("pydev/_pydevd_bundle/tables/pydevd_" + this.pydevdId.getFileName() + ".py")));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadFile(...)");
        return string;
    }

    @NotNull
    protected final String withPreamble(@NotNull Function1<? super StringBuilder, Unit> body) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(body, (String)"body");
        StringBuilder $this$withPreamble_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$withPreamble_u24lambda_u243.append(this.definitions).append('\n');
        body.invoke((Object)$this$withPreamble_u24lambda_u243);
        return stringBuilder.toString();
    }

    private static final Unit getSliceCommandCode$lambda$1$lambda$0(String $command, StringBuilder $this$withPreamble) {
        Intrinsics.checkNotNullParameter((Object)$this$withPreamble, (String)"$this$withPreamble");
        $this$withPreamble.append($command);
        return Unit.INSTANCE;
    }

    private static final Unit getInfoCommandCode$lambda$2(StringBuilder $this$withPreamble) {
        Intrinsics.checkNotNullParameter((Object)$this$withPreamble, (String)"$this$withPreamble");
        $this$withPreamble.append(DSTableCommands.INSTANCE.getInfoCommands());
        return Unit.INSTANCE;
    }
}

