/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.svggen;

import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import org.jetbrains.relocated.apache.batik.svggen.DOMTreeManager;
import org.jetbrains.relocated.apache.batik.svggen.ErrorConstants;
import org.jetbrains.relocated.apache.batik.svggen.GenericImageHandler;
import org.jetbrains.relocated.apache.batik.svggen.ImageHandler;
import org.jetbrains.relocated.apache.batik.svggen.SVGGeneratorContext;
import org.jetbrains.relocated.apache.batik.svggen.SVGSyntax;
import org.w3c.dom.Element;

public class SimpleImageHandler
implements GenericImageHandler,
SVGSyntax,
ErrorConstants {
    static final String XLINK_NAMESPACE_URI = "http://www.w3.org/1999/xlink";
    protected ImageHandler imageHandler;

    public SimpleImageHandler(ImageHandler imageHandler) {
        if (imageHandler == null) {
            throw new IllegalArgumentException();
        }
        this.imageHandler = imageHandler;
    }

    @Override
    public void setDOMTreeManager(DOMTreeManager domTreeManager) {
    }

    @Override
    public Element createElement(SVGGeneratorContext generatorContext) {
        Element imageElement = generatorContext.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "image");
        return imageElement;
    }

    @Override
    public AffineTransform handleImage(Image image, Element imageElement, int x2, int y2, int width2, int height, SVGGeneratorContext generatorContext) {
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        if (imageWidth == 0 || imageHeight == 0 || width2 == 0 || height == 0) {
            this.handleEmptyImage(imageElement);
        } else {
            this.imageHandler.handleImage(image, imageElement, generatorContext);
            this.setImageAttributes(imageElement, x2, y2, width2, height, generatorContext);
        }
        return null;
    }

    @Override
    public AffineTransform handleImage(RenderedImage image, Element imageElement, int x2, int y2, int width2, int height, SVGGeneratorContext generatorContext) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        if (imageWidth == 0 || imageHeight == 0 || width2 == 0 || height == 0) {
            this.handleEmptyImage(imageElement);
        } else {
            this.imageHandler.handleImage(image, imageElement, generatorContext);
            this.setImageAttributes(imageElement, x2, y2, width2, height, generatorContext);
        }
        return null;
    }

    @Override
    public AffineTransform handleImage(RenderableImage image, Element imageElement, double x2, double y2, double width2, double height, SVGGeneratorContext generatorContext) {
        double imageWidth = image.getWidth();
        double imageHeight = image.getHeight();
        if (imageWidth == 0.0 || imageHeight == 0.0 || width2 == 0.0 || height == 0.0) {
            this.handleEmptyImage(imageElement);
        } else {
            this.imageHandler.handleImage(image, imageElement, generatorContext);
            this.setImageAttributes(imageElement, x2, y2, width2, height, generatorContext);
        }
        return null;
    }

    protected void setImageAttributes(Element imageElement, double x2, double y2, double width2, double height, SVGGeneratorContext generatorContext) {
        imageElement.setAttributeNS(null, "x", generatorContext.doubleString(x2));
        imageElement.setAttributeNS(null, "y", generatorContext.doubleString(y2));
        imageElement.setAttributeNS(null, "width", generatorContext.doubleString(width2));
        imageElement.setAttributeNS(null, "height", generatorContext.doubleString(height));
        imageElement.setAttributeNS(null, "preserveAspectRatio", "none");
    }

    protected void handleEmptyImage(Element imageElement) {
        imageElement.setAttributeNS(XLINK_NAMESPACE_URI, "xlink:href", "");
        imageElement.setAttributeNS(null, "width", "0");
        imageElement.setAttributeNS(null, "height", "0");
    }
}

