/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.javascript.liveEdit.protocol.HotSwapScriptManager;
import com.intellij.javascript.liveEdit.protocol.ScriptLiveChangeResult;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptDebuggerUrls;
import org.jetbrains.debugger.ScriptManagerBaseEx;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.FunctionValue;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.LoadedScriptsStatistics;
import org.jetbrains.wip.ScriptUtilsKt;
import org.jetbrains.wip.WipAsyncCallFrame;
import org.jetbrains.wip.WipCallFrame;
import org.jetbrains.wip.WipFunction;
import org.jetbrains.wip.WipScript;
import org.jetbrains.wip.WipScriptManager;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.debugger.CallFrameValue;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.debugger.GetScriptSourceResult;
import org.jetbrains.wip.protocol.debugger.ScriptParsedEventData;
import org.jetbrains.wip.protocol.debugger.SetScriptSourceResult;
import org.jetbrains.wip.protocol.runtime.ExecutionContextDestroyedEventData;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 '2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001'B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\r\u001a\u00020\u0002H\u0014J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0011H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0007J\u0010\u0010 \u001a\u00020!2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020!2\u0006\u0010#\u001a\u00020&R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/wip/WipScriptManager;", "Lorg/jetbrains/debugger/ScriptManagerBaseEx;", "Lorg/jetbrains/wip/WipScript;", "Lcom/intellij/javascript/liveEdit/protocol/HotSwapScriptManager;", "vm", "Lorg/jetbrains/wip/WipVm;", "<init>", "(Lorg/jetbrains/wip/WipVm;)V", "numberOfLoadedScripts", "Ljava/util/concurrent/atomic/AtomicInteger;", "numberOfScriptsWithSourceMaps", "containsScript", "", "script", "Lorg/jetbrains/debugger/Script;", "loadScriptSource", "Lorg/jetbrains/concurrency/Promise;", "", "setSourceOnRemote", "Lcom/intellij/javascript/liveEdit/protocol/ScriptLiveChangeResult;", "newSource", "", "getScript", "function", "Lorg/jetbrains/debugger/values/FunctionValue;", "frame", "Lorg/jetbrains/debugger/CallFrame;", "rawUrlToOurUrl", "Lcom/intellij/util/Url;", "rawUrl", "reportScriptStats", "Lorg/jetbrains/wip/LoadedScriptsStatistics;", "recordScriptParsedEvent", "", "scriptParsed", "data", "Lorg/jetbrains/wip/protocol/debugger/ScriptParsedEventData;", "executionContextDestroyed", "Lorg/jetbrains/wip/protocol/runtime/ExecutionContextDestroyedEventData;", "Companion", "intellij.javascript.wip.backend"})
public final class WipScriptManager
extends ScriptManagerBaseEx<WipScript>
implements HotSwapScriptManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WipVm vm;
    @NotNull
    private final AtomicInteger numberOfLoadedScripts;
    @NotNull
    private final AtomicInteger numberOfScriptsWithSourceMaps;
    @NotNull
    private static final Key<Integer> LAST_SET_SOURCE_HASHCODE_KEY = new Key("js.debugger.last.set.source.hashcode");
    @NotNull
    private static final Companion.UNCHANGED_STATUS.1 UNCHANGED_STATUS = new ScriptLiveChangeResult(){
        private final ScriptLiveChangeResult.ChangeStatus status;
        private final String statusExplanation;
        {
            this.status = ScriptLiveChangeResult.ChangeStatus.UNCHANGED;
        }

        public ScriptLiveChangeResult.ChangeStatus getStatus() {
            return this.status;
        }

        public String getStatusExplanation() {
            return this.statusExplanation;
        }

        public void doRecommended() {
        }
    };

    public WipScriptManager(@NotNull WipVm vm) {
        Intrinsics.checkNotNullParameter((Object)((Object)vm), (String)"vm");
        this.vm = vm;
        this.numberOfLoadedScripts = new AtomicInteger();
        this.numberOfScriptsWithSourceMaps = new AtomicInteger();
    }

    public boolean containsScript(@NotNull Script script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        return script instanceof WipScript && this.getIdToScript().containsKey(((WipScript)script).getId());
    }

    @NotNull
    protected Promise<String> loadScriptSource(@NotNull WipScript script) {
        Intrinsics.checkNotNullParameter((Object)((Object)script), (String)"script");
        Promise promise = this.vm.getCommandProcessor().send((Request)DebuggerKt.GetScriptSource(script.getId())).then(arg_0 -> WipScriptManager.loadScriptSource$lambda$1(WipScriptManager::loadScriptSource$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return promise;
    }

    @NotNull
    public Promise<ScriptLiveChangeResult> setSourceOnRemote(@NotNull Script script, @NotNull CharSequence newSource) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)newSource, (String)"newSource");
        Integer prevSourceHashCode = (Integer)script.getUserData(LAST_SET_SOURCE_HASHCODE_KEY);
        int newSourceHashCode = StringUtil.stringHashCode((CharSequence)newSource);
        Integer n = prevSourceHashCode;
        int n2 = newSourceHashCode;
        if (n != null && n == n2) {
            return Promises.resolvedPromise((Object)UNCHANGED_STATUS);
        }
        boolean replaced = script.replace(LAST_SET_SOURCE_HASHCODE_KEY, (Object)prevSourceHashCode, (Object)newSourceHashCode);
        if (!replaced) {
            return Promises.resolvedPromise((Object)UNCHANGED_STATUS);
        }
        Promise promise = this.vm.getCommandProcessor().send((Request)DebuggerKt.SetScriptSource$default(((WipScript)script).getId(), newSource, false, null, 8, null)).then(arg_0 -> WipScriptManager.setSourceOnRemote$lambda$3(arg_0 -> WipScriptManager.setSourceOnRemote$lambda$2(this, script, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return promise;
    }

    @NotNull
    public Promise<Script> getScript(@NotNull FunctionValue function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Promise promise = function.resolve().then(arg_0 -> WipScriptManager.getScript$lambda$5(arg_0 -> WipScriptManager.getScript$lambda$4(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return promise;
    }

    @Nullable
    public Script getScript(@NotNull CallFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        WipScriptManager scriptManager = null;
        String scriptId = null;
        CallFrame callFrame = frame;
        if (callFrame instanceof WipCallFrame) {
            scriptManager = this;
            String string = ((WipCallFrame)frame).getScriptId();
            Intrinsics.checkNotNull((Object)string);
            scriptId = string;
        } else if (callFrame instanceof WipAsyncCallFrame) {
            scriptManager = this;
            scriptId = ((WipAsyncCallFrame)frame).getScriptId();
        } else {
            return null;
        }
        return (Script)scriptManager.findScriptById(scriptId);
    }

    @NotNull
    public Url rawUrlToOurUrl(@NotNull String rawUrl) {
        Url parsedUrl;
        Url url;
        Url tabUrl;
        Intrinsics.checkNotNullParameter((Object)rawUrl, (String)"rawUrl");
        if (StringsKt.startsWith$default((String)rawUrl, (String)"extensions::", (boolean)false, (int)2, null)) {
            return Urls.newUnparsable((String)rawUrl);
        }
        if (StringsKt.startsWith$default((String)rawUrl, (String)"dart:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)rawUrl, (String)"package:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)rawUrl, (String)"node:", (boolean)false, (int)2, null)) {
            return Urls.newFromIdea((CharSequence)rawUrl);
        }
        Url url2 = ScriptDebuggerUrls.parse((String)rawUrl, (boolean)true);
        if (url2 != null) {
            return url2;
        }
        Url url3 = tabUrl = this.vm.getCurrentUrl();
        CharSequence charSequence = url3 != null ? url3.getAuthority() : null;
        if (charSequence == null || charSequence.length() == 0) {
            return Urls.newUnparsable((String)rawUrl);
        }
        Url url4 = tabUrl;
        Intrinsics.checkNotNull((Object)url4);
        String string = url4.trimParameters().toExternalForm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toExternalForm(...)");
        String documentUrl = string;
        int lastSlash = StringsKt.lastIndexOf$default((CharSequence)documentUrl, (char)'/', (int)0, (boolean)false, (int)6, null);
        String absoluteUrl = null;
        if (lastSlash == -1) {
            absoluteUrl = documentUrl + "/" + rawUrl;
        } else {
            String string2 = documentUrl.substring(0, lastSlash + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            absoluteUrl = string2 + rawUrl;
        }
        if ((url = (parsedUrl = Urls.parseEncoded((String)absoluteUrl))) == null) {
            url = Urls.newUnparsable((String)rawUrl);
        }
        return url;
    }

    @ApiStatus.Internal
    @NotNull
    public final LoadedScriptsStatistics reportScriptStats() {
        return new LoadedScriptsStatistics(this.numberOfLoadedScripts.get(), this.numberOfScriptsWithSourceMaps.get());
    }

    private final void recordScriptParsedEvent(Script script) {
        if (!ScriptUtilsKt.isSpecialUrl(script.getUrl()) && !ScriptUtilsKt.isInternalScriptUrl(script.getUrl())) {
            this.numberOfLoadedScripts.incrementAndGet();
            CharSequence charSequence = script.getSourceMapUrl();
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) || script.getUrl().isInLocalFileSystem()) {
                this.numberOfScriptsWithSourceMaps.incrementAndGet();
            }
        }
    }

    @NotNull
    public final Script scriptParsed(@NotNull ScriptParsedEventData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String id = data.scriptId();
        Url url = ((CharSequence)data.url()).length() == 0 ? Urls.newUri((String)"vm", (String)id) : this.rawUrlToOurUrl(data.url());
        WipScript script = new WipScript(id, data.getExecutionContextId(), Script.Type.NORMAL, url, data.getStartLine(), data.getStartColumn(), data.getEndLine(), this.vm, data.getLength(), data.getHasSourceURL(), data.getSourceMapURL());
        WipScript existingScript = this.getIdToScript().putIfAbsent(id, script);
        if (existingScript != null) {
            return (Script)existingScript;
        }
        this.recordScriptParsedEvent((Script)script);
        if (!(url.getScheme() == null && StringsKt.startsWith$default((String)data.url(), (String)"extensions::", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)data.url(), (CharSequence)".hot-update.js", (boolean)false, (int)2, null))) {
            this.vm.getDebugListener().scriptAdded((Vm)this.vm, (Script)script);
        }
        return (Script)script;
    }

    public final void executionContextDestroyed(@NotNull ExecutionContextDestroyedEventData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Iterator iterator = ((Map)this.getIdToScript()).entrySet().iterator();
        while (iterator.hasNext()) {
            WipScript wipScript = (WipScript)((Object)iterator.next().getValue());
            if (wipScript.getExecutionContextId() != data.getExecutionContextId()) continue;
            iterator.remove();
        }
    }

    private static final String loadScriptSource$lambda$0(GetScriptSourceResult it) {
        return it.scriptSource();
    }

    private static final String loadScriptSource$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final ScriptLiveChangeResult setSourceOnRemote$lambda$2(WipScriptManager this$0, Script $script, SetScriptSourceResult it) {
        List<CallFrameValue> callFrames = it.getCallFrames();
        Collection collection = callFrames;
        if (!(collection == null || collection.isEmpty())) {
            this$0.vm.getSuspendContextManager().updateStackTrace(callFrames, it.getAsyncStackTrace());
        }
        this$0.vm.getDebugListener().scriptContentChanged($script);
        return UNCHANGED_STATUS;
    }

    private static final ScriptLiveChangeResult setSourceOnRemote$lambda$3(Function1 $tmp0, Object p0) {
        return (ScriptLiveChangeResult)$tmp0.invoke(p0);
    }

    private static final Script getScript$lambda$4(WipScriptManager this$0, FunctionValue it) {
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.wip.WipFunction");
        return (Script)this$0.findScriptById(((WipFunction)it).getScriptId());
    }

    private static final Script getScript$lambda$5(Function1 $tmp0, Object p0) {
        return (Script)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\b\u0003*\u0001\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/wip/WipScriptManager$Companion;", "", "<init>", "()V", "LAST_SET_SOURCE_HASHCODE_KEY", "Lcom/intellij/openapi/util/Key;", "", "UNCHANGED_STATUS", "org/jetbrains/wip/WipScriptManager$Companion$UNCHANGED_STATUS$1", "Lorg/jetbrains/wip/WipScriptManager$Companion$UNCHANGED_STATUS$1;", "intellij.javascript.wip.backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

