/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.psi.reference;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0003H\u0002J\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0003J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0003J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0003J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0003J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/editorconfig/language/psi/reference/EditorConfigVirtualFileDescriptor;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "cachedChildMappings", "", "", "cachedParentMappings", "distanceToChild", "child", "distanceToParent", "parent", "isChildOf", "", "isParentOf", "isStrictParentOf", "isStrictChildOf", "calculateDistanceBetween", "parentFile", "initialFile", "intellij.editorconfig"})
public final class EditorConfigVirtualFileDescriptor {
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final Map<VirtualFile, Integer> cachedChildMappings;
    @NotNull
    private final Map<VirtualFile, Integer> cachedParentMappings;

    public EditorConfigVirtualFileDescriptor(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.cachedChildMappings = new LinkedHashMap();
        this.cachedParentMappings = new LinkedHashMap();
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    private final int distanceToChild(VirtualFile child) {
        Integer cached = this.cachedChildMappings.get(child);
        if (cached != null) {
            return cached;
        }
        int distance = this.calculateDistanceBetween(this.file, child);
        Integer n = distance;
        this.cachedChildMappings.put(child, n);
        return distance;
    }

    public final int distanceToParent(@NotNull VirtualFile parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Integer cached = this.cachedParentMappings.get(parent);
        if (cached != null) {
            return cached;
        }
        int distance = this.calculateDistanceBetween(parent, this.file);
        Integer n = distance;
        this.cachedParentMappings.put(parent, n);
        return distance;
    }

    public final boolean isChildOf(@NotNull VirtualFile parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return this.distanceToParent(parent) >= 0;
    }

    public final boolean isParentOf(@NotNull VirtualFile child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        return this.distanceToChild(child) >= 0;
    }

    public final boolean isStrictParentOf(@NotNull VirtualFile child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        return this.distanceToChild(child) > 0;
    }

    public final boolean isStrictChildOf(@NotNull VirtualFile parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return this.distanceToParent(parent) > 0;
    }

    private final int calculateDistanceBetween(VirtualFile parentFile, VirtualFile initialFile) {
        int result2 = 0;
        VirtualFile targetFolder = parentFile.getParent();
        for (VirtualFile currentFolder = initialFile.getParent(); currentFolder != null; currentFolder = currentFolder.getParent()) {
            if (Intrinsics.areEqual((Object)currentFolder, (Object)targetFolder)) {
                return result2;
            }
            ++result2;
        }
        return -1;
    }
}

