/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.preferences;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.TextMateScopeComparatorCore;
import org.jetbrains.plugins.textmate.language.preferences.ShellVariablesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.ShellVariablesRegistryImpl;
import org.jetbrains.plugins.textmate.language.preferences.TextMateShellVariable;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigher;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u001c\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/textmate/language/preferences/ShellVariablesRegistryImpl;", "Lorg/jetbrains/plugins/textmate/language/preferences/ShellVariablesRegistry;", "weigher", "Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorWeigher;", "<init>", "(Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorWeigher;)V", "myVariables", "", "", "Lkotlinx/collections/immutable/PersistentList;", "Lorg/jetbrains/plugins/textmate/language/preferences/TextMateShellVariable;", "addVariable", "", "variable", "getVariableValue", "name", "scope", "Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateScope;", "clear", "intellij.textmate.core"})
public final class ShellVariablesRegistryImpl
implements ShellVariablesRegistry {
    @NotNull
    private final TextMateSelectorWeigher weigher;
    @NotNull
    private final Map<String, PersistentList<TextMateShellVariable>> myVariables;

    public ShellVariablesRegistryImpl(@NotNull TextMateSelectorWeigher weigher) {
        Intrinsics.checkNotNullParameter((Object)weigher, (String)"weigher");
        this.weigher = weigher;
        this.myVariables = new ConcurrentHashMap();
    }

    public final void addVariable(@NotNull TextMateShellVariable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        if (((CharSequence)variable.getName()).length() > 0) {
            this.myVariables.compute(variable.getName(), (arg_0, arg_1) -> ShellVariablesRegistryImpl.addVariable$lambda$1((arg_0, arg_1) -> ShellVariablesRegistryImpl.addVariable$lambda$0(variable, arg_0, arg_1), arg_0, arg_1));
        }
    }

    @Override
    @Nullable
    public TextMateShellVariable getVariableValue(@NotNull String name, @Nullable TextMateScope scope) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (scope == null) {
            return null;
        }
        PersistentList<TextMateShellVariable> variables = this.myVariables.get(name);
        if (variables == null) {
            return null;
        }
        return (TextMateShellVariable)new TextMateScopeComparatorCore(this.weigher, scope, (Function1)getVariableValue.1.INSTANCE).max((Collection)variables);
    }

    public final void clear() {
        this.myVariables.clear();
    }

    private static final PersistentList addVariable$lambda$0(TextMateShellVariable $variable, String k, PersistentList v) {
        PersistentList persistentList = v;
        if (persistentList == null || (persistentList = persistentList.add((Object)$variable)) == null) {
            Object[] objectArray = new TextMateShellVariable[]{$variable};
            persistentList = ExtensionsKt.persistentListOf((Object[])objectArray);
        }
        return persistentList;
    }

    private static final PersistentList addVariable$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (PersistentList)$tmp0.invoke(p0, p1);
    }
}

