/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.jcodings.Encoding;
import org.jcodings.IntHolder;
import org.joni.Config;
import org.joni.Matcher;
import org.joni.Regex;

final class Search {
    static final Forward SLOW_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "EXACT_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex2 = matcher.regex;
            Encoding enc = regex2.enc;
            byte[] target = regex2.exact;
            int targetP = regex2.exactP;
            int targetEnd = regex2.exactEnd;
            int end = textEnd;
            if ((end -= targetEnd - targetP - 1) > textRange) {
                end = textRange;
            }
            for (int s = textP; s < end; s += enc.length(text, s, textEnd)) {
                int t;
                if (text[s] != target[targetP]) continue;
                int p = s + 1;
                for (t = targetP + 1; t < targetEnd && target[t] == text[p++]; ++t) {
                }
                if (t != targetEnd) continue;
                return s;
            }
            return -1;
        }
    };
    static final Backward SLOW_BACKWARD = new Backward(){

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex2 = matcher.regex;
            Encoding enc = regex2.enc;
            byte[] target = regex2.exact;
            int targetP = regex2.exactP;
            int targetEnd = regex2.exactEnd;
            int s = textEnd;
            int n = s = (s -= targetEnd - targetP) > textStart ? textStart : enc.leftAdjustCharHead(text, adjustText, s, textEnd);
            while (s >= textP) {
                if (text[s] == target[targetP]) {
                    int t;
                    int p = s + 1;
                    for (t = targetP + 1; t < targetEnd && target[t] == text[p++]; ++t) {
                    }
                    if (t == targetEnd) {
                        return s;
                    }
                }
                s = enc.prevCharHead(text, adjustText, s, textEnd);
            }
            return -1;
        }
    };
    static final Forward SLOW_SB_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "EXACT_SB_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex2 = matcher.regex;
            byte[] target = regex2.exact;
            int targetP = regex2.exactP;
            int targetEnd = regex2.exactEnd;
            int end = textEnd;
            if ((end -= targetEnd - targetP - 1) > textRange) {
                end = textRange;
            }
            for (int s = textP; s < end; ++s) {
                int t;
                if (text[s] != target[targetP]) continue;
                int p = s + 1;
                for (t = targetP + 1; t < targetEnd && target[t] == text[p++]; ++t) {
                }
                if (t != targetEnd) continue;
                return s;
            }
            return -1;
        }
    };
    static final Backward SLOW_SB_BACKWARD = new Backward(){

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex2 = matcher.regex;
            byte[] target = regex2.exact;
            int targetP = regex2.exactP;
            int targetEnd = regex2.exactEnd;
            int s = textEnd;
            if ((s -= targetEnd - targetP) > textStart) {
                s = textStart;
            }
            while (s >= textP) {
                if (text[s] == target[targetP]) {
                    int t;
                    int p = s + 1;
                    for (t = targetP + 1; t < targetEnd && target[t] == text[p++]; ++t) {
                    }
                    if (t == targetEnd) {
                        return s;
                    }
                }
                --s;
            }
            return -1;
        }
    };
    static final Forward SLOW_IC_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "EXACT_IC_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex2 = matcher.regex;
            Encoding enc = regex2.enc;
            byte[] target = regex2.exact;
            int targetP = regex2.exactP;
            int targetEnd = regex2.exactEnd;
            int end = textEnd;
            if ((end -= targetEnd - targetP - 1) > textRange) {
                end = textRange;
            }
            byte[] buf = matcher.icbuf();
            for (int s = textP; s < end; s += enc.length(text, s, textEnd)) {
                if (!Search.lowerCaseMatch(target, targetP, targetEnd, text, s, textEnd, enc, buf, regex2.caseFoldFlag)) continue;
                return s;
            }
            return -1;
        }
    };
    static final Backward SLOW_IC_BACKWARD = new Backward(){

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex2 = matcher.regex;
            Encoding enc = regex2.enc;
            byte[] target = regex2.exact;
            int targetP = regex2.exactP;
            int targetEnd = regex2.exactEnd;
            int s = textEnd;
            s = (s -= targetEnd - targetP) > textStart ? textStart : enc.leftAdjustCharHead(text, adjustText, s, textEnd);
            byte[] buf = matcher.icbuf();
            while (s >= textP) {
                if (Search.lowerCaseMatch(target, targetP, targetEnd, text, s, textEnd, enc, buf, regex2.caseFoldFlag)) {
                    return s;
                }
                s = enc.prevCharHead(text, adjustText, s, textEnd);
            }
            return -1;
        }
    };
    static final Forward SLOW_IC_SB_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "EXACT_IC_SB_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex2 = matcher.regex;
            byte[] toLowerTable = regex2.enc.toLowerCaseTable();
            byte[] target = regex2.exact;
            int targetP = regex2.exactP;
            int targetEnd = regex2.exactEnd;
            int end = textEnd;
            if ((end -= targetEnd - targetP - 1) > textRange) {
                end = textRange;
            }
            for (int s = textP; s < end; ++s) {
                int t;
                if (target[targetP] != toLowerTable[text[s] & 0xFF]) continue;
                int p = s + 1;
                for (t = targetP + 1; t < targetEnd && target[t] == toLowerTable[text[p++] & 0xFF]; ++t) {
                }
                if (t != targetEnd) continue;
                return s;
            }
            return -1;
        }
    };
    static final Backward SLOW_IC_SB_BACKWARD = new Backward(){

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex2 = matcher.regex;
            byte[] toLowerTable = regex2.enc.toLowerCaseTable();
            byte[] target = regex2.exact;
            int targetP = regex2.exactP;
            int targetEnd = regex2.exactEnd;
            int s = textEnd;
            if ((s -= targetEnd - targetP) > textStart) {
                s = textStart;
            }
            while (s >= textP) {
                if (target[targetP] == toLowerTable[text[s] & 0xFF]) {
                    int t;
                    int p = s + 1;
                    for (t = targetP + 1; t < targetEnd && target[t] == toLowerTable[text[p++] & 0xFF]; ++t) {
                    }
                    if (t == targetEnd) {
                        return s;
                    }
                }
                --s;
            }
            return -1;
        }
    };
    static final Forward BM_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "EXACT_BM_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            int p;
            int s;
            int end;
            Regex regex2 = matcher.regex;
            byte[] target = regex2.exact;
            int targetP = regex2.exactP;
            int targetEnd = regex2.exactEnd;
            int tail = targetEnd - 1;
            if (Config.USE_SUNDAY_QUICK_SEARCH) {
                int tlen1 = tail - targetP;
                end = textRange + tlen1;
                s = textP + tlen1;
            } else {
                end = textRange + (targetEnd - targetP) - 1;
                s = textP + (targetEnd - targetP) - 1;
            }
            if (end > textEnd) {
                end = textEnd;
            }
            if (Config.USE_BYTE_MAP || regex2.intMap == null) {
                while (s < end) {
                    p = s;
                    int t = tail;
                    while (text[p] == target[t]) {
                        if (t == targetP) {
                            return p;
                        }
                        --p;
                        --t;
                    }
                    if (!Config.USE_SUNDAY_QUICK_SEARCH || s + 1 < end) {
                        s += regex2.map[text[Config.USE_SUNDAY_QUICK_SEARCH ? s + 1 : s] & 0xFF];
                        continue;
                    }
                    break;
                }
            } else {
                while (s < end) {
                    p = s;
                    int t = tail;
                    while (text[p] == target[t]) {
                        if (t == targetP) {
                            return p;
                        }
                        --p;
                        --t;
                    }
                    if (!Config.USE_SUNDAY_QUICK_SEARCH || s + 1 < end) {
                        s += regex2.intMap[text[Config.USE_SUNDAY_QUICK_SEARCH ? s + 1 : s] & 0xFF];
                        continue;
                    }
                    break;
                }
            }
            return -1;
        }
    };
    static final Backward BM_BACKWARD = new Backward(){
        private static final int BM_BACKWARD_SEARCH_LENGTH_THRESHOLD = 100;

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            if (Config.USE_INT_MAP_BACKWARD) {
                int s;
                Regex regex2 = matcher.regex;
                Encoding enc = regex2.enc;
                byte[] target = regex2.exact;
                int targetP = regex2.exactP;
                int targetEnd = regex2.exactEnd;
                if (regex2.intMapBackward == null) {
                    if (s_ - range_ < 100) {
                        return SLOW_BACKWARD.search(matcher, text, textP, adjustText, textEnd, textStart, s_, range_);
                    }
                    this.setBmBackwardSkip(regex2, target, targetP, targetEnd);
                }
                int n = s = textStart < (s = textEnd - (targetEnd - targetP)) ? textStart : enc.leftAdjustCharHead(text, adjustText, s, textEnd);
                while (s >= textP) {
                    int t;
                    int p = s;
                    for (t = targetP; t < targetEnd && text[p] == target[t]; ++t) {
                        ++p;
                    }
                    if (t == targetEnd) {
                        return s;
                    }
                    s -= regex2.intMapBackward[text[s] & 0xFF];
                    s = enc.leftAdjustCharHead(text, adjustText, s, textEnd);
                }
                return -1;
            }
            return SLOW_BACKWARD.search(matcher, text, textP, adjustText, textEnd, textStart, s_, range_);
        }

        private void setBmBackwardSkip(Regex regex2, byte[] bytes, int p, int end) {
            int i;
            int[] skip;
            if (regex2.intMapBackward == null) {
                regex2.intMapBackward = skip = new int[Config.CHAR_TABLE_SIZE];
            } else {
                skip = regex2.intMapBackward;
            }
            int len = end - p;
            for (i = 0; i < Config.CHAR_TABLE_SIZE; ++i) {
                skip[i] = len;
            }
            for (i = len - 1; i > 0; --i) {
                skip[bytes[i] & 0xFF] = i;
            }
        }
    };
    static final Forward BM_IC_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "EXACT_BM_IC_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            int s;
            int end;
            Regex regex2 = matcher.regex;
            Encoding enc = regex2.enc;
            byte[] buf = matcher.icbuf();
            byte[] target = regex2.exact;
            int targetP = regex2.exactP;
            int targetEnd = regex2.exactEnd;
            int tail = targetEnd - 1;
            int tlen1 = tail - targetP;
            if (Config.USE_SUNDAY_QUICK_SEARCH) {
                end = textRange + tlen1;
                s = textP + tlen1;
            } else {
                end = textRange + (targetEnd - targetP) - 1;
                s = textP + (targetEnd - targetP) - 1;
            }
            if (end > textEnd) {
                end = textEnd;
            }
            if (Config.USE_BYTE_MAP || regex2.intMap == null) {
                while (s < end) {
                    int p;
                    int n = p = Config.USE_SUNDAY_QUICK_SEARCH ? s - tlen1 : s - (targetEnd - targetP) + 1;
                    if (Search.lowerCaseMatch(target, targetP, targetEnd, text, p, s + 1, enc, buf, regex2.caseFoldFlag)) {
                        return p;
                    }
                    if (!Config.USE_SUNDAY_QUICK_SEARCH || s + 1 < end) {
                        s += regex2.map[text[Config.USE_SUNDAY_QUICK_SEARCH ? s + 1 : s] & 0xFF];
                        continue;
                    }
                    break;
                }
            } else {
                while (s < end) {
                    int p;
                    int n = p = Config.USE_SUNDAY_QUICK_SEARCH ? s - tlen1 : s - (targetEnd - targetP) + 1;
                    if (Search.lowerCaseMatch(target, targetP, targetEnd, text, p, s + 1, enc, buf, regex2.caseFoldFlag)) {
                        return p;
                    }
                    if (!Config.USE_SUNDAY_QUICK_SEARCH || s + 1 < end) {
                        s += regex2.intMap[text[Config.USE_SUNDAY_QUICK_SEARCH ? s + 1 : s] & 0xFF];
                        continue;
                    }
                    break;
                }
            }
            return -1;
        }
    };
    static final Forward BM_NOT_REV_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "EXACT_BM_NOT_REV_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex2 = matcher.regex;
            Encoding enc = regex2.enc;
            byte[] target = regex2.exact;
            int end = textRange;
            int targetEnd = regex2.exactEnd;
            int tail = targetEnd - 1;
            int targetP = regex2.exactP;
            int tlen1 = tail - targetP;
            if (end + tlen1 > textEnd) {
                end = textEnd - tlen1;
            }
            int s = textP;
            if (Config.USE_BYTE_MAP || regex2.intMap == null) {
                while (s < end) {
                    int se;
                    int p = se = s + tlen1;
                    int t = tail;
                    while (text[p] == target[t]) {
                        if (t == targetP) {
                            return s;
                        }
                        --p;
                        --t;
                    }
                    if (!Config.USE_SUNDAY_QUICK_SEARCH || s + 1 < end) {
                        byte skip = regex2.map[text[Config.USE_SUNDAY_QUICK_SEARCH ? se + 1 : se] & 0xFF];
                        t = s;
                        while ((s += enc.length(text, s, textEnd)) - t < skip && s < end) {
                        }
                        continue;
                    }
                    break;
                }
            } else {
                while (s < end) {
                    int se;
                    int p = se = s + tlen1;
                    int t = tail;
                    while (text[p] == target[t]) {
                        if (t == targetP) {
                            return s;
                        }
                        --p;
                        --t;
                    }
                    if (!Config.USE_SUNDAY_QUICK_SEARCH || s + 1 < end) {
                        int skip = regex2.intMap[text[Config.USE_SUNDAY_QUICK_SEARCH ? se + 1 : se] & 0xFF];
                        t = s;
                        while ((s += enc.length(text, s, textEnd)) - t < skip && s < end) {
                        }
                        continue;
                    }
                    break;
                }
            }
            return -1;
        }
    };
    static final Forward BM_NOT_REV_IC_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "EXACT_BM_NOT_REV_IC_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex2 = matcher.regex;
            Encoding enc = regex2.enc;
            byte[] buf = matcher.icbuf();
            byte[] target = regex2.exact;
            int end = textRange;
            int targetEnd = regex2.exactEnd;
            int tail = targetEnd - 1;
            int targetP = regex2.exactP;
            int tlen1 = tail - targetP;
            if (end + tlen1 > textEnd) {
                end = textEnd - tlen1;
            }
            int s = textP;
            if (Config.USE_BYTE_MAP || regex2.intMap == null) {
                while (s < end) {
                    int se = s + tlen1;
                    if (Search.lowerCaseMatch(target, targetP, targetEnd, text, s, se + 1, enc, buf, regex2.caseFoldFlag)) {
                        return s;
                    }
                    if (!Config.USE_SUNDAY_QUICK_SEARCH || s + 1 < end) {
                        byte skip = regex2.map[text[Config.USE_SUNDAY_QUICK_SEARCH ? se + 1 : se] & 0xFF];
                        int t = s;
                        while ((s += enc.length(text, s, textEnd)) - t < skip && s < end) {
                        }
                        continue;
                    }
                    break;
                }
            } else {
                while (s < end) {
                    int se = s + tlen1;
                    if (Search.lowerCaseMatch(target, targetP, targetEnd, text, s, se + 1, enc, buf, regex2.caseFoldFlag)) {
                        return s;
                    }
                    if (!Config.USE_SUNDAY_QUICK_SEARCH || s + 1 < end) {
                        int skip = regex2.intMap[text[Config.USE_SUNDAY_QUICK_SEARCH ? se + 1 : se] & 0xFF];
                        int t = s;
                        while ((s += enc.length(text, s, textEnd)) - t < skip && s < end) {
                        }
                        continue;
                    }
                    break;
                }
            }
            return -1;
        }
    };
    static final Forward MAP_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "MAP_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex2 = matcher.regex;
            Encoding enc = regex2.enc;
            byte[] map = regex2.map;
            for (int s = textP; s < textRange; s += enc.length(text, s, textEnd)) {
                if (map[text[s] & 0xFF] == 0) continue;
                return s;
            }
            return -1;
        }
    };
    static final Backward MAP_BACKWARD = new Backward(){

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex2 = matcher.regex;
            Encoding enc = regex2.enc;
            byte[] map = regex2.map;
            int s = textStart;
            if (s >= textEnd) {
                s = textEnd - 1;
            }
            while (s >= textP) {
                if (map[text[s] & 0xFF] != 0) {
                    return s;
                }
                s = enc.prevCharHead(text, adjustText, s, textEnd);
            }
            return -1;
        }
    };
    static final Forward MAP_SB_FORWARD = new Forward(){

        @Override
        final String getName() {
            return "MAP_SB_FORWARD";
        }

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex2 = matcher.regex;
            byte[] map = regex2.map;
            for (int s = textP; s < textRange; ++s) {
                if (map[text[s] & 0xFF] == 0) continue;
                return s;
            }
            return -1;
        }
    };
    static final Backward MAP_SB_BACKWARD = new Backward(){

        @Override
        final int search(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex2 = matcher.regex;
            byte[] map = regex2.map;
            int s = textStart;
            if (s >= textEnd) {
                s = textEnd - 1;
            }
            while (s >= textP) {
                if (map[text[s] & 0xFF] != 0) {
                    return s;
                }
                --s;
            }
            return -1;
        }
    };

    Search() {
    }

    private static boolean lowerCaseMatch(byte[] t, int tP, int tEnd, byte[] bytes, int p, int end, Encoding enc, byte[] buf, int caseFoldFlag) {
        IntHolder holder = new IntHolder();
        holder.value = p;
        while (tP < tEnd) {
            int lowlen = enc.mbcCaseFold(caseFoldFlag, bytes, holder, end, buf);
            if (lowlen == 1) {
                if (t[tP++] == buf[0]) continue;
                return false;
            }
            int q = 0;
            while (lowlen > 0) {
                if (t[tP++] != buf[q++]) {
                    return false;
                }
                --lowlen;
            }
        }
        return true;
    }

    static abstract class Backward {
        Backward() {
        }

        abstract int search(Matcher var1, byte[] var2, int var3, int var4, int var5, int var6, int var7, int var8);
    }

    static abstract class Forward {
        Forward() {
        }

        abstract String getName();

        abstract int search(Matcher var1, byte[] var2, int var3, int var4, int var5);
    }
}

